/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;

public class MathMatrix
extends MathValue {
    protected Number[][] realValues = null;
    protected int rows = 0;
    protected int columns = 0;

    public MathMatrix() {
        int n;
        this.rows = n = 3;
        this.columns = n;
        this.realValues = new Number[n][n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                this.realValues[n2][n3] = new Double(0.0);
                ++n3;
            }
            ++n2;
        }
    }

    public MathMatrix(double[][] dArray) {
        this.rows = dArray.length;
        int n = 0;
        while (n < this.rows) {
            if (dArray[n].length > this.columns) {
                this.columns = dArray[n].length;
            }
            ++n;
        }
        this.realValues = new Number[this.rows][this.columns];
        int n2 = 0;
        while (n2 < this.rows) {
            int n3 = 0;
            while (n3 < dArray[n2].length) {
                this.realValues[n2][n3] = new Double(dArray[n2][n3]);
                ++n3;
            }
            if (dArray[n2].length < this.columns) {
                int n4 = dArray[n2].length;
                while (n4 < this.columns) {
                    this.realValues[n2][n4] = new Double(0.0);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public MathMatrix(int[][] nArray) {
        this.rows = nArray.length;
        int n = 0;
        while (n < this.rows) {
            if (nArray[n].length > this.columns) {
                this.columns = nArray[n].length;
            }
            ++n;
        }
        this.realValues = new Number[this.rows][this.columns];
        int n2 = 0;
        while (n2 < this.rows) {
            int n3 = 0;
            while (n3 < nArray[n2].length) {
                this.realValues[n2][n3] = new Integer(nArray[n2][n3]);
                ++n3;
            }
            if (nArray[n2].length < this.columns) {
                int n4 = nArray[n2].length;
                while (n4 < this.columns) {
                    this.realValues[n2][n4] = new Integer(0);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public MathMatrix(Number[][] numberArray) {
        this.rows = numberArray.length;
        int n = 0;
        while (n < this.rows) {
            if (numberArray[n].length > this.columns) {
                this.columns = numberArray[n].length;
            }
            ++n;
        }
        this.realValues = new Number[this.rows][this.columns];
        int n2 = 0;
        while (n2 < this.rows) {
            int n3 = 0;
            while (n3 < numberArray[n2].length) {
                this.realValues[n2][n3] = this.cloneNumber(numberArray[n2][n3]);
                ++n3;
            }
            if (numberArray[n2].length < this.columns) {
                int n4 = numberArray[n2].length;
                while (n4 < this.columns) {
                    this.realValues[n2][n4] = new Integer(0);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public Number numberValue() {
        throw new UnsupportedOperationException("Can't return a matrix as a scalar");
    }

    public Number[] vectorValue() {
        throw new UnsupportedOperationException("Can't return a matrix as a vector");
    }

    public Number[][] matrixValue() {
        return this.realValues;
    }

    public Expression getValueAt(int n, int n2) {
        if (n < 0 || n >= this.rows) {
            throw new ArrayIndexOutOfBoundsException("MathMatrix index " + n + " is out of range [0.." + (this.rows - 1) + "]");
        }
        if (n2 < 0 || n2 >= this.columns) {
            throw new ArrayIndexOutOfBoundsException("MathMatrix index " + n2 + " is out of range [0.." + (this.columns - 1) + "]");
        }
        return new MathScalar(this.realValues[n][n2]);
    }

    public void setValueAt(int n, int n2, Number number) {
        if (n < 0 || n >= this.rows) {
            throw new ArrayIndexOutOfBoundsException("MathMatrix index " + n + " is out of range [0.." + (this.rows - 1) + "]");
        }
        if (n2 < 0 || n2 >= this.columns) {
            throw new ArrayIndexOutOfBoundsException("MathMatrix index " + n2 + " is out of range [0.." + (this.columns - 1) + "]");
        }
        this.realValues[n][n2] = this.cloneNumber(number);
    }

    private Number cloneNumber(Number number) {
        if (number instanceof Integer) {
            return new Integer(number.intValue());
        }
        return new Double(number.doubleValue());
    }

    public String toString() {
        int n = 0;
        int[] nArray = new int[this.rows];
        String string = "                         ";
        StringBuffer[] stringBufferArray = new StringBuffer[this.rows];
        int n2 = 0;
        while (n2 < this.rows) {
            stringBufferArray[n2] = new StringBuffer();
            ++n2;
        }
        int n3 = this.columns - 1;
        while (n3 >= 0) {
            n2 = 0;
            while (n2 < this.rows) {
                stringBufferArray[n2].insert(0, this.realValues[n2][n3].toString());
                nArray[n2] = stringBufferArray[n2].length();
                if (nArray[n2] > n) {
                    n = nArray[n2];
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.rows) {
                int n4 = n - nArray[n2] + 1;
                stringBufferArray[n2].insert(0, string.substring(0, n4));
                ++n2;
            }
            --n3;
        }
        n2 = 0;
        while (n2 < this.rows) {
            stringBufferArray[n2].insert(0, "|");
            stringBufferArray[n2].append(" |\n");
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer("--");
        while (stringBuffer.length() + string.length() < n + 2) {
            stringBuffer.append(string);
        }
        stringBuffer.append(string.substring(0, n + 2 - stringBuffer.length()));
        stringBuffer.append("--");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(stringBuffer);
        stringBuffer2.append("\n");
        n2 = 0;
        while (n2 < this.rows) {
            stringBuffer2.append(stringBufferArray[n2]);
            ++n2;
        }
        stringBuffer2.append(stringBuffer);
        return stringBuffer2.toString();
    }
}

