/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.calendar.CalendarComponent;
import com.klg.jclass.util.calendar.JCCalendar;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class MonthPopdown
extends JComboBox
implements CalendarComponent,
JCValueListener,
ItemListener {
    protected Locale locale = null;
    protected JCValueModel calendarModel;
    protected int selectedMonth = 0;
    protected String[] months = null;
    protected boolean userSetMonths = false;
    protected JCListenerList actionListeners = null;
    protected boolean ignoreChange = false;

    public MonthPopdown(JCValueModel jCValueModel, Locale locale) {
        this(jCValueModel, locale, null);
    }

    public MonthPopdown(JCValueModel jCValueModel, Locale locale, String[] stringArray) {
        this.months = stringArray;
        if (this.months != null) {
            this.userSetMonths = true;
        }
        this.setLocale(locale);
        this.setCalendarModel(jCValueModel);
        this.addItemListener(this);
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.locale == locale) {
            return;
        }
        this.firePropertyChange("locale", this.locale, locale);
        this.locale = locale;
        if (!this.userSetMonths) {
            this.months = JCCalendar.getMonths(this.locale, false);
        }
        this.setModel(new DefaultComboBoxModel<String>(this.months));
        this.repaint();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setCalendarModel(JCValueModel jCValueModel) {
        if (this.calendarModel != null) {
            this.calendarModel.removeValueListener(this);
        }
        this.calendarModel = jCValueModel;
        this.valueChanged(null);
        this.calendarModel.addValueListener(this);
        this.repaint();
    }

    public JCValueModel getCalendarModel() {
        return this.calendarModel;
    }

    public void setSpecialDates(JCCalendar jCCalendar) {
    }

    public JCCalendar getSpecialDates(JCCalendar jCCalendar) {
        return this.getSpecialDates();
    }

    public JCCalendar getSpecialDates() {
        return null;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.add(this.actionListeners, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.remove(this.actionListeners, actionListener);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.ignoreChange) {
            return;
        }
        this.ignoreChange = true;
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.getModel();
        this.selectedMonth = defaultComboBoxModel.getIndexOf(this.getModel().getSelectedItem());
        Calendar calendar = JCCalendar.copyCalendar((Calendar)this.calendarModel.getValue());
        calendar.set(2, this.selectedMonth);
        this.calendarModel.setValue(calendar);
        int n = ((Calendar)this.calendarModel.getValue()).get(2);
        if (n != this.selectedMonth) {
            this.setSelectedIndex(n);
            this.selectedMonth = n;
        }
        this.ignoreChange = false;
    }

    public void valueChanging(JCValueEvent jCValueEvent) {
    }

    public void valueChanged(JCValueEvent jCValueEvent) {
        if (this.ignoreChange) {
            return;
        }
        this.ignoreChange = true;
        this.setSelectedIndex(((Calendar)this.calendarModel.getValue()).get(2));
        this.ignoreChange = false;
    }
}

