/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.calendar.SpecialDate;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;

public class JCCalendar {
    protected Vector specialDates = new Vector(0);
    protected static final byte[][] daytable = new byte[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};

    public static boolean isLeapYear(int n) {
        boolean bl = false;
        if (n % 100 == 0) {
            if (n % 400 == 0) {
                bl = true;
            }
        } else if (n % 4 == 0) {
            bl = true;
        }
        return bl;
    }

    public static int dayOfWeek(int n, int n2, int n3) {
        if (n2 == 0 || n2 == 1) {
            --n3;
        }
        int n4 = n3 % 100;
        int n5 = n3 / 100;
        int n6 = (n2 + 10) % 12 + 1;
        int n7 = (int)((double)n + Math.floor(2.6 * (double)n6 - 0.2) - (double)(2 * n5) + (double)n4 + Math.floor(n4 / 4) + Math.floor(n5 / 4)) % 7;
        n7 = (n7 + 7) % 7;
        return n7;
    }

    public static int daysInMonth(int n, int n2) {
        int n3 = JCCalendar.isLeapYear(n2) ? 1 : 0;
        return daytable[n3][n];
    }

    protected static String[] processArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] != null && stringArray[n2].length() > 0) {
                ++n;
            }
            ++n2;
        }
        String[] stringArray2 = new String[n];
        n = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3] != null && stringArray[n3].length() > 0) {
                stringArray2[n] = stringArray[n3];
                ++n;
            }
            ++n3;
        }
        return stringArray2;
    }

    public static String[] getDays(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        return JCCalendar.processArray(dateFormatSymbols.getShortWeekdays());
    }

    public static String[] getMonths(Locale locale, boolean bl) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        String[] stringArray = null;
        stringArray = bl ? dateFormatSymbols.getShortMonths() : dateFormatSymbols.getMonths();
        return JCCalendar.processArray(stringArray);
    }

    public void addSpecialDate(SpecialDate specialDate) {
        this.specialDates.add(specialDate);
    }

    public void removeSpecialDate(SpecialDate specialDate) {
        this.specialDates.remove(specialDate);
    }

    public boolean isSpecialDate(int n, int n2, int n3, int n4) {
        return this.isInSpecialDateList(n, n2, n3, n4) >= 0;
    }

    public boolean isSpecialDate(Calendar calendar) {
        return this.isSpecialDate(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(4));
    }

    protected int isInSpecialDateList(int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < this.specialDates.size()) {
            SpecialDate specialDate = (SpecialDate)this.specialDates.elementAt(n5);
            if (specialDate.isSpecialDate(n, n2, n3, n4)) {
                return n5;
            }
            ++n5;
        }
        return -1;
    }

    public static Calendar copyCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return (Calendar)calendar.clone();
    }

    public static Calendar convertObjectToCalendar(Object object, Locale locale) {
        if (object instanceof Calendar) {
            return (Calendar)object;
        }
        if (object instanceof Date) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            Calendar calendar = Calendar.getInstance(locale);
            calendar.setTime((Date)object);
            return calendar;
        }
        return null;
    }

    public static Object convertCalendarToObject(Calendar calendar, Class clazz) {
        if (calendar == null || clazz == null) {
            return null;
        }
        String string = clazz.getName();
        long l = calendar.getTime().getTime();
        if (string.equals("java.util.Date")) {
            return new Date(l);
        }
        if (string.equals("java.sql.Time")) {
            return new Time(l);
        }
        if (string.equals("java.sql.Timestamp")) {
            return new Timestamp(l);
        }
        if (string.equals("java.sql.Date")) {
            return new java.sql.Date(l);
        }
        if (string.equals("java.util.Calendar") || string.equals("java.util.GregorianCalendar")) {
            return calendar;
        }
        return null;
    }

    public class MonthWeekDayOfWeek
    implements SpecialDate {
        public int month;
        public int week;
        public int day_of_week;

        public MonthWeekDayOfWeek(int n, int n2, int n3) {
            this.month = n;
            this.week = n2;
            this.day_of_week = n3;
        }

        public boolean isSpecialDate(int n, int n2, int n3, int n4) {
            int n5 = JCCalendar.dayOfWeek(n3, n2, n);
            return this.month == n2 && this.day_of_week == n5 && this.week == n4;
        }
    }

    public static class MonthDayOfMonth
    implements SpecialDate {
        public int month;
        public int day_of_month;

        public MonthDayOfMonth(int n, int n2) {
            this.month = n;
            this.day_of_month = n2;
        }

        public boolean isSpecialDate(int n, int n2, int n3, int n4) {
            return this.month == n2 && this.day_of_month == n3;
        }
    }

    public static class DayOfWeek
    implements SpecialDate {
        public int day_of_week;

        public DayOfWeek(int n) {
            if (n < 0 || n > 6) {
                throw new IllegalArgumentException("invalid value for dayOfWeek");
            }
            this.day_of_week = n;
        }

        public boolean isSpecialDate(int n, int n2, int n3, int n4) {
            int n5 = JCCalendar.dayOfWeek(n3, n2, n);
            return this.day_of_week == n5;
        }
    }

    public static class DateMonthYear
    implements SpecialDate {
        public int year;
        public int month;
        public int date;

        public DateMonthYear(int n, int n2, int n3) {
            this.year = n3;
            this.month = n2;
            this.date = n;
        }

        public DateMonthYear(Calendar calendar) {
            this(calendar.get(5), calendar.get(2), calendar.get(1));
        }

        public DateMonthYear(Date date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            this.year = calendar.get(1);
            this.month = calendar.get(2);
            this.date = calendar.get(5);
        }

        public boolean isSpecialDate(int n, int n2, int n3, int n4) {
            return this.year == n && this.month == n2 && this.date == n3;
        }
    }
}

