/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.calendar.CalendarComponent;
import com.klg.jclass.util.calendar.JCCalendar;
import com.klg.jclass.util.value.CalendarValueModel;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.JPanel;

public class CalendarContainer
extends JPanel
implements CalendarComponent,
ContainerListener,
ActionListener {
    protected boolean initialized = true;
    protected JCValueModel model;
    protected JCCalendar specialDates;
    protected Locale locale;
    protected JCListenerList actionListeners = null;
    protected Font userFont = null;

    public CalendarContainer() {
        this.setLocale(Locale.getDefault());
        this.addContainerListener(this);
    }

    public void setCalendarModel(JCValueModel jCValueModel) {
        if (this.model == jCValueModel) {
            return;
        }
        this.firePropertyChange("calendarmodel", this.model, jCValueModel);
        this.model = jCValueModel;
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof CalendarComponent) {
                ((CalendarComponent)((Object)componentArray[n])).setCalendarModel(jCValueModel);
            }
            ++n;
        }
    }

    public JCValueModel getCalendarModel() {
        return this.model;
    }

    public void setSpecialDates(JCCalendar jCCalendar) {
        if (this.specialDates == jCCalendar) {
            return;
        }
        this.firePropertyChange("specialdates", this.specialDates, jCCalendar);
        this.specialDates = jCCalendar;
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof CalendarComponent) {
                ((CalendarComponent)((Object)componentArray[n])).setSpecialDates(jCCalendar);
            }
            ++n;
        }
    }

    public void setLocale(Locale locale) {
        if (this.locale == locale) {
            return;
        }
        if (locale == null) {
            throw new IllegalArgumentException("null is an invalid value for locale");
        }
        this.firePropertyChange("locale", this.locale, locale);
        this.locale = locale;
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof CalendarComponent) {
                componentArray[n].setLocale(locale);
            }
            ++n;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.userFont = font;
        if (this.initialized) {
            Component[] componentArray = this.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof CalendarComponent) {
                    componentArray[n].setFont(font);
                }
                ++n;
            }
        }
    }

    public Font getUserFont() {
        return this.userFont;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.add(this.actionListeners, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.remove(this.actionListeners, actionListener);
    }

    public void componentAdded(ContainerEvent containerEvent) {
        if (containerEvent.getChild() instanceof CalendarComponent) {
            CalendarComponent calendarComponent = (CalendarComponent)((Object)containerEvent.getChild());
            calendarComponent.setLocale(this.locale);
            calendarComponent.addActionListener(this);
            if (this.model == null) {
                this.model = new CalendarValueModel(Calendar.getInstance(this.locale));
            }
            calendarComponent.setCalendarModel(this.model);
            calendarComponent.setSpecialDates(this.specialDates);
        }
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        if (containerEvent.getChild() instanceof CalendarComponent) {
            CalendarComponent calendarComponent = (CalendarComponent)((Object)containerEvent.getChild());
            calendarComponent.removeActionListener(this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ActionEvent actionEvent2 = new ActionEvent(this, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getModifiers());
        Enumeration enumeration = JCListenerList.elements(this.actionListeners);
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(actionEvent2);
        }
    }
}

