/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.ServerJPanel;
import com.klg.jclass.util.ServerRenderable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class ServerRenderer {
    public static void paintComponent(Graphics graphics, Component component) {
        if (!(component instanceof ServerRenderable)) {
            return;
        }
        ServerRenderable serverRenderable = (ServerRenderable)((Object)component);
        serverRenderable.setGraphics(graphics);
        ServerRenderer.paintComponentAndChildren(graphics, component);
        serverRenderable.setGraphics(null);
    }

    protected static void paintComponentAndChildren(Graphics graphics, Component component) {
        component.doLayout();
        component.paint(graphics);
        if (component instanceof Container) {
            Object object;
            int n;
            Object object2;
            Container container = (Container)component;
            Object object3 = null;
            Object object4 = null;
            if (component instanceof RenderProperties) {
                object2 = (RenderProperties)((Object)component);
                n = object2.getAntiAliasing();
                if (n == 1) {
                    object4 = RenderingHints.VALUE_ANTIALIAS_ON;
                } else if (n == 2) {
                    object4 = RenderingHints.VALUE_ANTIALIAS_OFF;
                }
            }
            if (object4 != null && object4 != (object3 = ((Graphics2D)(object2 = (Graphics2D)graphics)).getRenderingHint(RenderingHints.KEY_ANTIALIASING))) {
                ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, object4);
            }
            object2 = graphics.getClipBounds();
            n = container.getComponentCount() - 1;
            while (n >= 0) {
                object = container.getComponent(n);
                if (((Component)object).isVisible()) {
                    Rectangle rectangle = ((Component)object).getBounds();
                    int n2 = rectangle.x + rectangle.width <= ((Rectangle)object2).width ? rectangle.width : ((Rectangle)object2).x + ((Rectangle)object2).width - rectangle.x;
                    int n3 = rectangle.y + rectangle.height <= ((Rectangle)object2).height ? rectangle.height : ((Rectangle)object2).y + ((Rectangle)object2).height - rectangle.y;
                    if (n2 > 0 && n3 > 0) {
                        graphics.translate(rectangle.x, rectangle.y);
                        graphics.setClip(0, 0, n2, n3);
                        ServerRenderer.paintComponentAndChildren(graphics, (Component)object);
                        graphics.translate(-rectangle.x, -rectangle.y);
                    }
                }
                --n;
            }
            graphics.setClip(((Rectangle)object2).x, ((Rectangle)object2).y, ((Rectangle)object2).width, ((Rectangle)object2).height);
            if (object3 != null && object3 != object4) {
                object = (Graphics2D)graphics;
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, object3);
            }
        }
    }

    public static void paintContainer(Graphics graphics, Container container) {
        if (!(container instanceof ServerRenderable)) {
            return;
        }
        ServerRenderable serverRenderable = (ServerRenderable)((Object)container);
        serverRenderable.setGraphics(graphics);
        ServerRenderer.paintContainerAndChildren(graphics, container);
        serverRenderable.setGraphics(null);
    }

    protected static void paintContainerAndChildren(Graphics graphics, Container container) {
        container.doLayout();
        container.paint(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        int n = container.getComponentCount() - 1;
        while (n >= 0) {
            Component component = container.getComponent(n);
            if (component.isVisible()) {
                Rectangle rectangle2 = component.getBounds();
                graphics.translate(rectangle2.x, rectangle2.y);
                graphics.setClip(0, 0, rectangle2.width, rectangle2.height);
                if (component instanceof Container) {
                    ServerRenderer.paintContainerAndChildren(graphics, (Container)component);
                } else {
                    component.paint(graphics);
                }
                graphics.translate(-rectangle2.x, -rectangle2.y);
            }
            --n;
        }
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void paintTopLevelContainer(Graphics graphics, ServerJPanel serverJPanel) {
        if (serverJPanel == null) {
            return;
        }
        serverJPanel.setGraphics(graphics);
        serverJPanel.doLayout();
        serverJPanel.paint(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        int n = serverJPanel.getComponentCount() - 1;
        while (n >= 0) {
            Component component = serverJPanel.getComponent(n);
            if (component.isVisible()) {
                Rectangle rectangle2 = component.getBounds();
                graphics.translate(rectangle2.x, rectangle2.y);
                graphics.setClip(0, 0, rectangle2.width, rectangle2.height);
                if (component instanceof Container) {
                    ServerRenderer.paintContainer(graphics, (Container)component);
                } else {
                    component.paint(graphics);
                }
                graphics.translate(-rectangle2.x, -rectangle2.y);
            }
            --n;
        }
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        serverJPanel.setGraphics(null);
    }

    public static Image snapshot(Component component) {
        Image image = ServerRenderer.createNewImage(component, 2);
        ServerRenderer.snapshot(component, image);
        return image;
    }

    public static Image createNewImage(Component component, int n) {
        if (component == null) {
            throw new IllegalArgumentException("Passed in component is null.");
        }
        Dimension dimension = component.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            throw new IllegalArgumentException("Size of component is zero.");
        }
        return ServerRenderer.createNewImage(dimension.width, dimension.height, n);
    }

    public static Image createNewImage(int n, int n2, int n3) {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("Width and height must be positive");
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
        return bufferedImage;
    }

    public static boolean snapshot(Component component, Image image) {
        if (!(component instanceof ServerRenderable)) {
            return false;
        }
        ServerRenderable serverRenderable = (ServerRenderable)((Object)component);
        if (image != null) {
            Graphics graphics = image.getGraphics();
            Dimension dimension = component.getSize();
            graphics.setClip(0, 0, dimension.width, dimension.height);
            serverRenderable.serverPaint(graphics);
        }
        return true;
    }
}

