/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.data;

import com.klg.jclass.table.JCTableDataEvent;
import com.klg.jclass.table.data.AbstractVectorDataSource;
import java.io.Serializable;
import java.util.Vector;

public class JCVectorDataSource
extends AbstractVectorDataSource
implements Serializable {
    protected Vector cells = AbstractVectorDataSource.createVector();
    protected Vector column_labels = AbstractVectorDataSource.createVector();
    protected Vector row_labels = AbstractVectorDataSource.createVector();
    protected int columns = 5;
    protected int rows = 10;
    protected boolean is_moving = false;

    public JCVectorDataSource() {
    }

    public JCVectorDataSource(int n, int n2, Vector vector, Vector vector2, Vector vector3) {
        this.columns = n2;
        this.rows = n;
        this.cells = vector3;
        if (vector != null) {
            this.row_labels = vector;
        }
        if (vector2 != null) {
            this.column_labels = vector2;
        }
    }

    public int getNumColumns() {
        return this.columns;
    }

    public void setNumColumns(int n) {
        this.columns = n;
        this.setDataChanged(0, 0, 0, 0, 13);
    }

    public int getNumRows() {
        return this.rows;
    }

    public void setNumRows(int n) {
        this.rows = n;
        this.setDataChanged(0, 0, 0, 0, 12);
    }

    public Object getTableColumnLabel(int n) {
        if (n >= 0 && n < this.column_labels.size()) {
            return this.column_labels.elementAt(n);
        }
        return null;
    }

    public Object getTableRowLabel(int n) {
        if (n >= 0 && n < this.row_labels.size()) {
            return this.row_labels.elementAt(n);
        }
        return null;
    }

    public Object getTableDataItem(int n, int n2) {
        Object var3_3 = this.isValidCell(n, n2) ? ((Vector)this.cells.elementAt(n)).elementAt(n2) : null;
        return var3_3;
    }

    public void clearCells() {
        this.setCells((Vector)null);
    }

    public Vector getCells() {
        return this.cells;
    }

    public Vector getColumnLabels() {
        return this.column_labels;
    }

    public Vector getRowLabels() {
        return this.row_labels;
    }

    public static final boolean isCell(int n, int n2) {
        return n >= 0 && n2 >= 0;
    }

    public static final boolean isColumnLabel(int n, int n2) {
        return n2 >= 0 && n == -1;
    }

    public static final boolean isLabel(int n, int n2) {
        return n == -1 ? n2 >= 0 : (n2 == -1 ? n >= 0 : false);
    }

    public static final boolean isRowLabel(int n, int n2) {
        return n >= 0 && n2 == -1;
    }

    public final boolean isValidCell(int n, int n2) {
        return n >= 0 && n < this.cells.size() && this.cells.elementAt(n) != null && n2 >= 0 && n2 < ((Vector)this.cells.elementAt(n)).size();
    }

    public final boolean isValidLabel(int n, int n2) {
        return n2 == -1 ? n < this.row_labels.size() : (n == -1 ? n2 < this.column_labels.size() : false);
    }

    public void setColumnLabel(int n, Object object) {
        this.setLabelValue(-1, n, object);
    }

    public void setColumnLabels(String[] stringArray) {
        this.setColumnLabels(AbstractVectorDataSource.createVector(stringArray));
    }

    public void setColumnLabels(Vector vector) {
        this.column_labels = vector == null ? AbstractVectorDataSource.createVector() : vector;
        this.setDataChanged(-998, -998, 0, 0, 14);
    }

    public void setRowLabel(int n, Object object) {
        this.setLabelValue(n, -1, object);
    }

    public void setRowLabels(String[] stringArray) {
        this.setRowLabels(AbstractVectorDataSource.createVector(stringArray));
    }

    public void setRowLabels(Vector vector) {
        this.row_labels = vector == null ? AbstractVectorDataSource.createVector() : vector;
        this.setDataChanged(-998, -998, 0, 0, 14);
    }

    public void setCell(int n, int n2, Object object) {
        if (!(n != -998 && n != -997 && n < 0 || n2 != -998 && n2 != -997 && n2 < 0)) {
            this.setCellValue(n, n2, object);
        }
    }

    public void setCells(String[][] stringArray) {
        if (stringArray == null) {
            this.setCells(AbstractVectorDataSource.createVector());
        } else {
            Vector vector = AbstractVectorDataSource.createVector(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                AbstractVectorDataSource.setElementAt(vector, n, AbstractVectorDataSource.createVector(stringArray[n]));
                ++n;
            }
            this.setCells(vector);
        }
    }

    public void setCells(Vector vector) {
        this.cells = vector == null ? AbstractVectorDataSource.createVector() : (vector instanceof Vector ? vector : AbstractVectorDataSource.createVector(vector));
        this.setDataChanged(-998, -998, 0, 0, 14);
    }

    protected Object getLabelValue(int n, int n2) {
        if (n >= 0 && n2 == -1 && n < this.row_labels.size()) {
            return this.row_labels.elementAt(n);
        }
        if (n2 >= 0 && n == -1 && n2 < this.column_labels.size()) {
            return this.column_labels.elementAt(n2);
        }
        return null;
    }

    protected void setLabelValue(int n, int n2, Object object) {
        if (!JCVectorDataSource.isLabel(n, n2)) {
            return;
        }
        if (n == -1) {
            if (this.setLabelValue(this.column_labels, n2, object)) {
                this.setDataChanged(-1, n2, 1, 0, 9);
            }
        } else if (this.setLabelValue(this.row_labels, n, object)) {
            this.setDataChanged(n, -1, 1, 0, 8);
        }
    }

    private boolean setLabelValue(Vector vector, int n, Object object) {
        Object e;
        if (n < 0) {
            return false;
        }
        if (n < vector.size() && (e = vector.elementAt(n)) != null && object != null && e.equals(object)) {
            return false;
        }
        AbstractVectorDataSource.setElementAt(vector, n, object);
        if (object == null && n == vector.size() - 1) {
            AbstractVectorDataSource.strip(vector);
        }
        return true;
    }

    private void setCellValue(int n, int n2, Object object) {
        int n3 = 0;
        int n4 = this.rows - 1;
        int n5 = 0;
        int n6 = this.columns - 1;
        if (n >= 0 && n2 >= 0) {
            n3 = n4 = n;
            n5 = n6 = n2;
        } else {
            if (n == -997) {
                n = -998;
            }
            if (n2 == -997) {
                n2 = -998;
            }
            if (n == -998) {
                if (n2 != -998) {
                    n5 = n6 = n2;
                }
                n3 = 0;
                n4 = this.rows - 1;
            }
            if (n2 == -998) {
                if (n != -998) {
                    n3 = n4 = n;
                }
                n5 = 0;
                n6 = this.columns - 1;
            }
            if (n != -998 && n2 != -998) {
                n3 = n4 = n;
                n5 = n6 = n2;
            }
            if (n3 < 0 || n5 < 0) {
                return;
            }
        }
        int n7 = n3;
        while (n7 <= n4) {
            int n8 = n5;
            while (n8 <= n6) {
                block19: {
                    block18: {
                        Object object2;
                        Object object3 = object2 = this.isValidCell(n, n2) ? (Object)((Vector)this.cells.elementAt(n)).elementAt(n2) : null;
                        if (object2 == null) break block18;
                        if (object2.equals(object)) break block19;
                        if (this.isValidCell(n7, n8)) {
                            AbstractVectorDataSource.setElementAt((Vector)this.cells.elementAt(n7), n8, null);
                        }
                    }
                    if (this.cells.size() < n7 + 1 || this.cells.elementAt(n7) == null) {
                        AbstractVectorDataSource.setElementAt(this.cells, n7, AbstractVectorDataSource.createVector(n8 + 1));
                    }
                    AbstractVectorDataSource.setElementAt((Vector)this.cells.elementAt(n7), n8, object);
                    this.setDataChanged(n7, n8, 1, 0, 1);
                }
                ++n8;
            }
            if (object == null && this.isValidCell(n7, n8) && n6 == this.cells.size() - 1) {
                AbstractVectorDataSource.strip((Vector)this.cells.elementAt(n7));
                AbstractVectorDataSource.strip(this.cells);
            }
            ++n7;
        }
    }

    public void setDataChanged(int n, int n2, int n3, int n4, int n5) {
        if (this.is_moving || !this.hasListeners()) {
            return;
        }
        JCTableDataEvent jCTableDataEvent = new JCTableDataEvent(this, n, n2, n3, n4, n5);
        this.fireTableDataEvent(jCTableDataEvent);
    }

    public boolean addColumn(int n, Object object, Vector vector) {
        if (n == Integer.MAX_VALUE) {
            n = this.columns;
        } else if (n < 0 || n > this.columns) {
            return false;
        }
        return this.addColumn(n, object, vector, true);
    }

    protected boolean addColumn(int n, Object object, Vector vector, boolean bl) {
        if (vector != null && this.cells.size() < vector.size()) {
            AbstractVectorDataSource.setElementAt(this.cells, vector.size() - 1, AbstractVectorDataSource.createVector());
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.cells.size()) {
            Vector vector2;
            Vector vector3 = (Vector)this.cells.elementAt(n2);
            if (vector3 == null) {
                vector2 = AbstractVectorDataSource.createVector();
                AbstractVectorDataSource.setElementAt(this.cells, n2, vector2);
            } else {
                vector2 = vector3;
            }
            if (n < vector2.size()) {
                vector2.insertElementAt(null, n);
            }
            Object var9_9 = vector != null && n3 < vector.size() ? vector.elementAt(n3) : null;
            AbstractVectorDataSource.setElementAt(vector2, n, var9_9);
            ++n2;
            ++n3;
        }
        if (bl && this.column_labels.size() != 0 && n < this.column_labels.size()) {
            this.column_labels.insertElementAt(null, n);
        }
        this.setNumColumns(this.columns + 1);
        if (object != null && bl) {
            this.setColumnLabel(n, object);
        }
        this.setDataChanged(-1, n, 1, n, 6);
        return true;
    }

    public boolean addRow(int n, Object object, Vector vector) {
        Vector vector2 = vector;
        if (vector != null && !(vector instanceof Vector)) {
            vector2 = AbstractVectorDataSource.createVector(vector);
        }
        if (n == Integer.MAX_VALUE) {
            n = this.rows;
        } else if (n < 0 || n > this.rows) {
            return false;
        }
        return this.addRow(n, object, vector2, true);
    }

    protected boolean addRow(int n, Object object, Vector vector, boolean bl) {
        if (vector != null) {
            if (n < this.cells.size()) {
                this.cells.insertElementAt(null, n);
            }
            AbstractVectorDataSource.setElementAt(this.cells, n, vector);
        }
        if (bl && this.row_labels.size() != 0 && n < this.row_labels.size()) {
            this.row_labels.insertElementAt(null, n);
        }
        this.setNumRows(this.rows + 1);
        if (object != null && bl) {
            this.setRowLabel(n, object);
        }
        this.setDataChanged(n, -1, 1, n, 3);
        return true;
    }

    public boolean deleteColumns(int n, int n2) {
        return this.deleteColumns(n, n2, true);
    }

    protected boolean deleteColumns(int n, int n2, boolean bl) {
        if (n2 <= 0) {
            return false;
        }
        if (n < 0 || n + n2 > this.columns) {
            return false;
        }
        if (bl && this.column_labels.size() != 0 && n < this.column_labels.size()) {
            AbstractVectorDataSource.removeElementsAt(this.column_labels, n, n2);
        }
        int n3 = 0;
        while (n3 < this.cells.size()) {
            Vector vector = (Vector)this.cells.elementAt(n3);
            if (vector != null) {
                AbstractVectorDataSource.removeElementsAt(vector, n, n2);
            }
            ++n3;
        }
        this.setNumColumns(this.columns - n2);
        this.setDataChanged(-1, n, n2, 0, 7);
        return true;
    }

    public boolean deleteRows(int n, int n2) {
        return this.deleteRows(n, n2, true);
    }

    protected boolean deleteRows(int n, int n2, boolean bl) {
        if (n2 <= 0) {
            return false;
        }
        if (n < 0 || n + n2 > this.rows) {
            return false;
        }
        if (bl && this.row_labels.size() != 0 && n < this.row_labels.size()) {
            AbstractVectorDataSource.removeElementsAt(this.row_labels, n, n2);
        }
        AbstractVectorDataSource.removeElementsAt(this.cells, n, n2);
        this.setNumRows(this.rows - n2);
        this.setDataChanged(n, -1, n2, 0, 4);
        return true;
    }

    public boolean moveColumns(int n, int n2, int n3) {
        if (n2 <= 0) {
            return false;
        }
        if (n < 0 || n + n2 > this.columns && n3 != Integer.MAX_VALUE) {
            return false;
        }
        if (n3 < 0 || n3 > this.columns && n3 != Integer.MAX_VALUE || n <= n3 && n3 < n + n2) {
            return false;
        }
        if (n + n2 == n3) {
            return true;
        }
        return this.moveColumns(n, n2, n3, true);
    }

    protected boolean moveColumns(int n, int n2, int n3, boolean bl) {
        this.is_moving = true;
        if (n3 == Integer.MAX_VALUE) {
            n3 = this.columns;
        }
        Vector vector = AbstractVectorDataSource.createVector(n2);
        Vector vector2 = AbstractVectorDataSource.createVector(n2);
        int n4 = 0;
        while (n4 < n2) {
            Vector vector3 = AbstractVectorDataSource.createVector();
            int n5 = 0;
            while (n5 < this.rows) {
                try {
                    Vector vector4 = (Vector)this.cells.elementAt(n5);
                    vector3.addElement(vector4.elementAt(n + n4));
                }
                catch (Exception exception) {
                    vector3 = null;
                    n5 = this.rows;
                }
                ++n5;
            }
            vector.addElement(vector3);
            vector2.addElement(this.getTableColumnLabel(n + n4));
            ++n4;
        }
        if (!this.deleteColumns(n, n2, bl)) {
            return false;
        }
        if (n < n3) {
            int n6 = 0;
            while (n6 < n2) {
                if (!this.addColumn(n3 + n6 - n2, vector2.elementAt(n6), (Vector)vector.elementAt(n6), bl)) {
                    return false;
                }
                ++n6;
            }
        } else {
            int n7 = 0;
            while (n7 < n2) {
                if (!this.addColumn(n3 + n7, vector2.elementAt(n7), (Vector)vector.elementAt(n7), bl)) {
                    return false;
                }
                ++n7;
            }
        }
        vector = null;
        vector2 = null;
        this.is_moving = false;
        this.setDataChanged(-998, n, n2, n3, 11);
        return true;
    }

    public boolean moveRows(int n, int n2, int n3) {
        if (n2 <= 0) {
            return false;
        }
        if (n < 0 || n + n2 > this.rows) {
            return false;
        }
        if (n3 < 0 || n3 > this.rows || n <= n3 && n3 < n + n2) {
            return false;
        }
        if (n + n2 == n3) {
            return true;
        }
        return this.moveRows(n, n2, n3, true);
    }

    protected boolean moveRows(int n, int n2, int n3, boolean bl) {
        this.is_moving = true;
        Vector vector = AbstractVectorDataSource.createVector(n2);
        Vector vector2 = AbstractVectorDataSource.createVector(n2);
        boolean bl2 = true;
        boolean bl3 = true;
        int n4 = 0;
        while (n4 < n2) {
            try {
                vector.addElement(this.cells.elementAt(n + n4));
            }
            catch (Exception exception) {
                bl2 = false;
            }
            try {
                vector2.addElement(this.getTableRowLabel(n + n4));
            }
            catch (Exception exception) {
                bl3 = false;
            }
            ++n4;
        }
        if (!bl2 && !bl3) {
            return false;
        }
        if (!this.deleteRows(n, n2, bl)) {
            return false;
        }
        if (n < n3) {
            int n5 = 0;
            while (n5 < n2) {
                Vector vector3 = null;
                if (bl2) {
                    vector3 = (Vector)vector.elementAt(n5);
                }
                if (!this.addRow(n3 + n5 - n2, vector2.elementAt(n5), vector3, bl)) {
                    return false;
                }
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < n2) {
                Vector vector4 = null;
                if (bl2) {
                    vector4 = (Vector)vector.elementAt(n6);
                }
                if (!this.addRow(n3 + n6, vector2.elementAt(n6), vector4, bl)) {
                    return false;
                }
                ++n6;
            }
        }
        vector = null;
        vector2 = null;
        this.is_moving = false;
        this.setDataChanged(n, -998, n2, n3, 10);
        return true;
    }
}

