/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.resources.LocaleBundle;
import com.sitraka.licensing.LicenseProperties;
import com.sitraka.licensing.Licenses;
import com.sitraka.licensing.util.Platform;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;

public class Redir {
    private static final String LICENSE_FILE = "jclass-desktopviews.licenses";
    private static final String PRODUCT = "jclass.table";
    private static final String SUITE = "jclass.desktopviews";
    public static final int PERMANENT_LICENSE = 0;
    public static final int EVAL_LICENSE = 1;
    public static final int EVAL_DATE_EXPIRED = 2;
    public static final int LICENSE_FILE_NOT_EXIST = 3;
    public static final int HOST_NOT_VALID = 4;
    public static final int INVALID_LICENSE_VERSION = 5;
    public static final int INVALID_PRODUCT = 6;
    private static final Redir redirInstance = new Redir();
    private boolean licenseFileValid = false;
    private String[] licenseExceptionMessage = new String[10];
    private static int hostValidProp;
    private static String licenseNotLoadMsg;
    private static String serialNumber;

    private Redir() {
        int n = 3;
        n = this.examineLicense();
        if (n == 0) {
            this.licenseFileValid = true;
        }
        int n2 = 0;
        if (!this.licenseFileValid) {
            if (n != 3) {
                this.setOutputErrorMsg(n, n2);
            } else {
                this.licenseExceptionMessage[n2] = licenseNotLoadMsg;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LicenseProperties getLicense() {
        LicenseProperties licenseProperties = null;
        URL uRL = this.getClass().getClassLoader().getResource(LICENSE_FILE);
        if (uRL == null) {
            return null;
        }
        try {
            Licenses licenses = new Licenses(uRL);
            Iterator iterator = licenses.iterator();
            if (iterator == null) {
                return null;
            }
            while (iterator.hasNext()) {
                String string;
                LicenseProperties licenseProperties2 = (LicenseProperties)iterator.next();
                if (!licenseProperties2.isValid() || (string = licenseProperties2.getProduct()) == null || !string.equals(PRODUCT) && !string.equals(SUITE)) continue;
                licenseProperties = licenseProperties2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (licenseProperties != null) return licenseProperties;
        return new LicenseProperties();
    }

    private int examineLicense() {
        LicenseProperties licenseProperties = this.getLicense();
        licenseNotLoadMsg = null;
        if (licenseProperties == null) {
            licenseNotLoadMsg = LocaleBundle.string("Corrupted Table license file");
        }
        if (licenseNotLoadMsg != null) {
            return 3;
        }
        serialNumber = licenseProperties.getSerialNumber();
        String string = licenseProperties.getProduct();
        if (string == null || !string.equals(PRODUCT) && !string.equals(SUITE)) {
            return 6;
        }
        hostValidProp = licenseProperties.validateHost("hosts");
        if (hostValidProp != 1) {
            return 4;
        }
        String string2 = "license_version";
        if (!this.isLicenseVersion(licenseProperties, string2)) {
            return 5;
        }
        return 0;
    }

    private void setOutputErrorMsg(int n, int n2) {
        int n3 = hostValidProp;
        if (n == 5) {
            this.licenseExceptionMessage[n2] = LocaleBundle.string("The serial number is: ") + serialNumber;
            this.licenseExceptionMessage[++n2] = LocaleBundle.string("Invalid Table license version") + "6.3";
            ++n2;
        } else if (n == 6) {
            this.licenseExceptionMessage[n2] = LocaleBundle.string("License file does not contain Table license");
            ++n2;
        }
        if (n3 == 11) {
            this.licenseExceptionMessage[n2] = LocaleBundle.string("Null parameter passed to validation call");
        } else if (n3 == 13) {
            this.licenseExceptionMessage[n2] = LocaleBundle.string("Could not get the name of the local host");
        } else if (n3 == 12) {
            this.licenseExceptionMessage[n2] = LocaleBundle.string("Could not find the host property");
        } else if (n3 == 2 || n3 == 3) {
            this.licenseExceptionMessage[n2] = LocaleBundle.string("The serial number is: ") + serialNumber;
            this.licenseExceptionMessage[++n2] = LocaleBundle.string("Table not licensed for local host: ");
            this.licenseExceptionMessage[++n2] = this.getLocalHostInfo();
        }
    }

    private String getLocalHostInfo() {
        String string = null;
        String string2 = null;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.toString().toLowerCase();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        int n = Platform.getNumberProcessors();
        string = string2 + LocaleBundle.string(" with ") + n + LocaleBundle.string(" CPUs");
        return string;
    }

    public static boolean isValid() {
        return Redir.redirInstance.licenseFileValid;
    }

    public static String[] getLicenseExceptionMessage() {
        return Redir.redirInstance.licenseExceptionMessage;
    }

    private boolean isLicenseVersion(LicenseProperties licenseProperties, String string) {
        if (licenseProperties == null || string == null) {
            return false;
        }
        String string2 = licenseProperties.getProperty(string);
        if (string2 == null) {
            return false;
        }
        return string2.equals("6.3");
    }

    static {
        licenseNotLoadMsg = null;
        serialNumber = null;
    }
}

