/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellBorderModel;
import com.klg.jclass.table.CellStyleModel;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.TableCellInfoModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;

public class JCTableCellInfo
implements TableCellInfoModel,
Serializable {
    protected JCTable table;
    protected int row;
    protected int column;
    protected CellStyleModel style;
    protected Object data;
    protected Insets margin_insets;
    protected Insets border_insets;
    private Rectangle drawing_area = new Rectangle();

    public void initialize(JCTable jCTable, Object object, int n, int n2) {
        this.initialize(jCTable, object, n, n2, null);
    }

    public void initialize(JCTable jCTable, Object object, int n, int n2, CellStyleModel cellStyleModel) {
        this.table = jCTable;
        this.row = n;
        this.column = n2;
        this.style = cellStyleModel == null ? jCTable.getCellStyle(n, n2) : cellStyleModel;
        this.data = object;
    }

    public CellStyleModel getCellStyle() {
        return this.style;
    }

    public Color getBackground() {
        Color color;
        int n = this.style.getRepeatBackground();
        if (n != 0 && (color = this.getRepeatColor(this.row, this.column, n, this.style.getRepeatBackgroundColors())) != null) {
            return color;
        }
        return this.style.getBackground();
    }

    public Color getForeground() {
        Color color;
        int n = this.style.getRepeatForeground();
        if (n != 0 && (color = this.getRepeatColor(this.row, this.column, n, this.style.getRepeatForegroundColors())) != null) {
            return color;
        }
        return this.style.getForeground();
    }

    public Color getSelectedBackground() {
        Color color = this.getSelectedColor(this.table.getSelectedBackgroundMode());
        return color != null ? color : this.getBackground();
    }

    public Color getSelectedForeground() {
        Color color = this.getSelectedColor(this.table.getSelectedForegroundMode());
        return color != null ? color : this.getForeground();
    }

    protected Color getSelectedColor(int n) {
        if (n == 0) {
            return this.table.getSelectedBackground();
        }
        if (n == 1) {
            return this.table.getSelectedForeground();
        }
        if (n == 2) {
            return this.getBackground();
        }
        if (n == 3) {
            return this.getForeground();
        }
        return null;
    }

    public Font getFont() {
        return this.style.getFont();
    }

    public FontMetrics getFontMetrics() {
        return this.table.getFontMetrics(this.style.getFont());
    }

    public int getHorizontalAlignment() {
        return this.style.getHorizontalAlignment();
    }

    public int getVerticalAlignment() {
        return this.style.getVerticalAlignment();
    }

    public Insets getMarginInsets() {
        int n = this.table.getMarginHeight();
        int n2 = this.table.getMarginWidth();
        if (this.margin_insets == null || this.margin_insets.left != n2 && this.margin_insets.top != n) {
            this.margin_insets = new Insets(n, n2, n, n2);
        }
        return this.margin_insets;
    }

    public Insets getBorderInsets() {
        int n = this.table.getCellBorderWidth();
        if (this.border_insets == null || this.border_insets.left != n) {
            this.border_insets = new Insets(n, n, n, n);
        }
        return this.border_insets;
    }

    public int getBorderStyle() {
        return 0;
    }

    public Rectangle getDrawingArea() {
        Rectangle rectangle = this.table.getCellAreaHandler().getBounds(this.row, this.column, this.drawing_area);
        Insets insets = this.getBorderInsets();
        Insets insets2 = this.getMarginInsets();
        rectangle.x = insets.left + insets2.left;
        rectangle.y = insets.top + insets2.top;
        rectangle.width -= insets.left + insets2.left + insets.right + insets2.right;
        rectangle.height -= insets.top + insets2.top + insets.bottom + insets2.bottom;
        return rectangle;
    }

    public boolean isEditable() {
        return this.style.isEditable();
    }

    public boolean isEnabled() {
        return this.style.isTraversable();
    }

    public boolean getSelectAll() {
        return false;
    }

    public int getClipHints() {
        return this.style.getClipHints();
    }

    public Class getDataType() {
        Class clazz = this.style.getDataType();
        if (clazz != null) {
            return clazz;
        }
        clazz = this.table.getColumnClass(this.column);
        if (clazz != null) {
            return clazz;
        }
        if (this.data != null) {
            return this.data.getClass();
        }
        return null;
    }

    public JCTable getTable() {
        return this.table;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public CellBorderModel getCellBorder() {
        return this.style.getCellBorder();
    }

    public int getCellBorderSides() {
        return this.style.getCellBorderSides();
    }

    protected Color getRepeatColor(int n, int n2, int n3, Color[] colorArray) {
        if (colorArray == null) {
            return null;
        }
        int n4 = colorArray.length;
        int n5 = n3 == 1 ? n : n2;
        int n6 = n5 < 0 ? (n4 - -1 * n5 % n4) % n4 : n5 % n4;
        return colorArray[n6];
    }
}

