/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.Moveable;

class DataViewSupport {
    DataViewSupport() {
    }

    protected static boolean dragColumn(JCTable jCTable, int n, int n2) {
        return DataViewSupport.moveColumns(jCTable, n, 1, n2);
    }

    protected static boolean moveColumns(JCTable jCTable, int n, int n2, int n3) {
        if (!DataViewSupport.validateMoveColumns(jCTable, n, n2, n3)) {
            return false;
        }
        if (n + n2 == n3) {
            return true;
        }
        DataViewSupport.moveColumnSeries(jCTable, n, n2, n3);
        return true;
    }

    protected static void moveColumnSeries(JCTable jCTable, int n, int n2, int n3) {
        if (jCTable.moveables != null) {
            int n4 = 0;
            while (n4 < jCTable.moveables.size()) {
                Moveable moveable = (Moveable)jCTable.moveables.elementAt(n4);
                moveable.moveColumns(n, n2, n3);
                ++n4;
            }
        }
        if (jCTable.columnWidths != null) {
            jCTable.columnWidths.move(n, n2, n3);
            if (jCTable.cellLayout != null) {
                jCTable.cellLayout.moveColumns(n, n2, n3);
            }
        }
    }

    static boolean swapColumnArrays(JCTable jCTable, int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray2.length];
        int[] nArray4 = new int[nArray2.length];
        int[] nArray5 = new int[nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            nArray4[nArray[n]] = n;
            ++n;
        }
        int n2 = 0;
        while (n2 < nArray2.length) {
            nArray3[nArray2[n2]] = n2;
            ++n2;
        }
        int n3 = 0;
        while (n3 < nArray2.length) {
            nArray5[n3] = nArray3[nArray[n3]];
            ++n3;
        }
        if (jCTable.moveables != null) {
            int n4 = 0;
            while (n4 < jCTable.moveables.size()) {
                Moveable moveable = (Moveable)jCTable.moveables.elementAt(n4);
                moveable.remapColumns(nArray5);
                ++n4;
            }
        }
        if (jCTable.columnWidths != null) {
            jCTable.columnWidths.remap(nArray5);
            if (jCTable.cellLayout != null) {
                jCTable.cellLayout.remapColumns(nArray4, nArray2);
            }
        }
        return true;
    }

    protected static boolean swapColumns(JCTable jCTable, int n, int n2) {
        DataViewSupport.swapColumnSeries(jCTable, n, n2);
        if (jCTable.cellLayout != null) {
            int n3 = jCTable.cellLayout.getWidth(n);
            int n4 = jCTable.cellLayout.getWidth(n2);
            jCTable.cellLayout.setWidth(n, n4);
            jCTable.cellLayout.setWidth(n2, n3);
        }
        return true;
    }

    protected static void swapColumnSeries(JCTable jCTable, int n, int n2) {
        if (jCTable.moveables != null) {
            int n3 = 0;
            while (n3 < jCTable.moveables.size()) {
                Moveable moveable = (Moveable)jCTable.moveables.elementAt(n3);
                moveable.swapColumns(n, n2);
                ++n3;
            }
        }
        if (jCTable.columnWidths != null) {
            jCTable.columnWidths.swap(n, n2);
        }
    }

    protected static boolean validateMoveColumns(JCTable jCTable, int n, int n2, int n3) {
        int n4 = jCTable.getNumColumns();
        if (n2 <= 0) {
            return false;
        }
        if (n < 0 || n + n2 > n4) {
            return false;
        }
        if (n3 < 0 || n3 > n4 || n <= n3 && n3 < n + n2) {
            return false;
        }
        return n2 < n4;
    }

    protected static void addColumn(JCTable jCTable, int n, int n2, int n3, int n4) {
        if (n < n4 - n2) {
            DataViewSupport.shiftColumnSeries(jCTable, n, n2, 1);
        }
        if (jCTable.cellLayout != null) {
            jCTable.cellLayout.addColumns(n, n2);
        }
        int n5 = n;
        while (n5 < n + n3) {
            jCTable.requestChange(32, -999, n5);
            ++n5;
        }
    }

    static void deleteColumn(JCTable jCTable, int n, int n2, int n3, int n4) {
        DataViewSupport.shiftColumnSeries(jCTable, n, n2, -1);
        if (jCTable.cellLayout != null) {
            jCTable.cellLayout.deleteColumns(n, n2);
        }
    }

    protected static void shiftColumnSeries(JCTable jCTable, int n, int n2, int n3) {
        if (jCTable.moveables != null) {
            int n4 = 0;
            while (n4 < jCTable.moveables.size()) {
                Moveable moveable = (Moveable)jCTable.moveables.elementAt(n4);
                moveable.shiftColumn(n, n2, n3);
                ++n4;
            }
        }
        if (jCTable.columnWidths != null) {
            jCTable.columnWidths.shift(n, n2, n3);
        }
    }

    protected static boolean dragRow(JCTable jCTable, int n, int n2) {
        return DataViewSupport.moveRows(jCTable, n, 1, n2);
    }

    protected static boolean moveRows(JCTable jCTable, int n, int n2, int n3) {
        if (!DataViewSupport.validateMoveRows(jCTable, n, n2, n3)) {
            return false;
        }
        if (n + n2 == n3) {
            return true;
        }
        DataViewSupport.moveRowSeries(jCTable, n, n2, n3);
        return true;
    }

    protected static void moveRowSeries(JCTable jCTable, int n, int n2, int n3) {
        if (jCTable.moveables != null) {
            int n4 = 0;
            while (n4 < jCTable.moveables.size()) {
                Moveable moveable = (Moveable)jCTable.moveables.elementAt(n4);
                moveable.moveRows(n, n2, n3);
                ++n4;
            }
        }
        if (jCTable.rowHeights != null) {
            jCTable.rowHeights.move(n, n2, n3);
            if (jCTable.cellLayout != null) {
                jCTable.cellLayout.moveRows(n, n2, n3);
            }
        }
    }

    protected static boolean swapRows(JCTable jCTable, int n, int n2) {
        DataViewSupport.swapRowSeries(jCTable, n, n2);
        if (jCTable.cellLayout != null) {
            int n3 = jCTable.cellLayout.getHeight(n);
            int n4 = jCTable.cellLayout.getHeight(n2);
            jCTable.cellLayout.setHeight(n, n4);
            jCTable.cellLayout.setHeight(n2, n3);
        }
        return true;
    }

    protected static boolean swapRowArrays(JCTable jCTable, int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray2.length];
        int[] nArray4 = new int[nArray2.length];
        int[] nArray5 = new int[nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            nArray4[nArray[n]] = n;
            ++n;
        }
        int n2 = 0;
        while (n2 < nArray2.length) {
            nArray3[nArray2[n2]] = n2;
            ++n2;
        }
        int n3 = 0;
        while (n3 < nArray2.length) {
            nArray5[n3] = nArray3[nArray[n3]];
            ++n3;
        }
        if (jCTable.moveables != null) {
            int n4 = 0;
            while (n4 < jCTable.moveables.size()) {
                Moveable moveable = (Moveable)jCTable.moveables.elementAt(n4);
                moveable.remapRows(nArray5);
                ++n4;
            }
        }
        if (jCTable.rowHeights != null) {
            jCTable.rowHeights.remap(nArray5);
            if (jCTable.cellLayout != null) {
                jCTable.cellLayout.remapRows(nArray4, nArray2);
            }
        }
        return true;
    }

    protected static void swapRowSeries(JCTable jCTable, int n, int n2) {
        if (jCTable.moveables != null) {
            int n3 = 0;
            while (n3 < jCTable.moveables.size()) {
                Moveable moveable = (Moveable)jCTable.moveables.elementAt(n3);
                moveable.swapRows(n, n2);
                ++n3;
            }
        }
        if (jCTable.rowHeights != null) {
            jCTable.rowHeights.swap(n, n2);
        }
    }

    protected static boolean validateMoveRows(JCTable jCTable, int n, int n2, int n3) {
        int n4 = jCTable.getNumRows();
        if (n2 <= 0) {
            return false;
        }
        if (n < 0 || n + n2 > n4) {
            return false;
        }
        if (n3 < 0 || n3 > n4 || n <= n3 && n3 < n + n2) {
            return false;
        }
        return n2 < n4;
    }

    protected static void addRow(JCTable jCTable, int n, int n2, int n3, int n4) {
        if (n < n3 - n2) {
            DataViewSupport.shiftRowSeries(jCTable, n, n2, 1);
        }
        if (jCTable.cellLayout != null) {
            jCTable.cellLayout.addRows(n, n2);
        }
        int n5 = n;
        while (n5 < n3 - n) {
            jCTable.requestChange(16, n5, -999);
            ++n5;
        }
    }

    static void deleteRow(JCTable jCTable, int n, int n2, int n3, int n4) {
        DataViewSupport.shiftRowSeries(jCTable, n, n2, -1);
        if (jCTable.cellLayout != null) {
            jCTable.cellLayout.deleteRows(n, n2);
        }
    }

    protected static void shiftRowSeries(JCTable jCTable, int n, int n2, int n3) {
        if (jCTable.moveables != null) {
            int n4 = 0;
            while (n4 < jCTable.moveables.size()) {
                Moveable moveable = (Moveable)jCTable.moveables.elementAt(n4);
                moveable.shiftRow(n, n2, n3);
                ++n4;
            }
        }
        if (jCTable.rowHeights != null) {
            jCTable.rowHeights.shift(n, n2, n3);
        }
    }
}

