/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.cell.JCComponentCellRenderer;
import com.klg.jclass.cell.JCLightCellRenderer;
import com.klg.jclass.table.CellArea;
import com.klg.jclass.table.CellAreaHandler;
import com.klg.jclass.table.CellLayoutModel;
import com.klg.jclass.table.CellSize;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.PositionCellSize;
import com.klg.jclass.table.TableCellInfoModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

class CellSizeHandler {
    static Hashtable cachedFontHeights = null;

    CellSizeHandler() {
    }

    protected static void resetDimensions(JCTable jCTable) {
        if (!jCTable.repaint_enabled) {
            jCTable.setRecalcRequired(true);
            return;
        }
        CellSizeHandler.calcColumnWidths(jCTable, -1, Integer.MAX_VALUE, -1, Integer.MAX_VALUE);
        CellSizeHandler.calcRowHeights(jCTable, -1, Integer.MAX_VALUE, -1, Integer.MAX_VALUE);
    }

    protected static boolean calcColumnLabelHeight(JCTable jCTable, int n, int n2) {
        return CellSizeHandler.calcRowHeights(jCTable, -1, -1, n, n2);
    }

    protected static boolean calcRowHeights(JCTable jCTable, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        boolean bl = false;
        if (!jCTable.repaint_enabled) {
            jCTable.setRecalcRequired(true);
            return bl;
        }
        int n7 = jCTable.getNumRows();
        int n8 = jCTable.getNumColumns();
        int n9 = n7 == 0 ? -1 : n7 - 1;
        int n10 = n6 = n8 == 0 ? -1 : n8 - 1;
        if (n == -998) {
            n = -1;
            n2 = n9;
        } else if (n == -997) {
            n = 0;
            n2 = n9;
        }
        if (n3 == -998) {
            n3 = -1;
            n4 = n6;
        } else if (n3 == -997) {
            n3 = 0;
            n4 = n6;
        }
        if (n == -1 && n8 == 0 && ((n5 = jCTable.getRowCellSize(-1).getPixelValue()) == 33001 || n5 == 33002)) {
            n = 0;
        }
        if (n3 == -1 && n7 == 0) {
            n3 = 0;
        }
        if (n2 == Integer.MAX_VALUE) {
            n2 = n9;
        }
        if (n4 == Integer.MAX_VALUE) {
            n4 = n6;
        }
        if (n > n2 || n3 > n4) {
            return bl;
        }
        if (n == n2) {
            return bl |= CellSizeHandler.setPixelHeight(jCTable, n, n, n2, n3, n4);
        }
        CellLayoutModel cellLayoutModel = jCTable.getCellLayout();
        cellLayoutModel.setHeight(-1, 0);
        if (n == -1) {
            bl |= CellSizeHandler.setPixelHeight(jCTable, n, n, n2, n3, n4);
        }
        cellLayoutModel.resetRows();
        bl |= CellSizeHandler.setPixelHeight(jCTable, -997, 0, n2, n3, n4);
        List list = jCTable.getRowHeightValues();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CellSize cellSize;
            int n11;
            PositionCellSize positionCellSize = (PositionCellSize)iterator.next();
            int n12 = positionCellSize.position;
            if (n12 >= 0) {
                bl |= CellSizeHandler.setPixelHeight(jCTable, n12, n12, n12, n3, n4);
                continue;
            }
            if (n12 != -998 && n12 != -997 || (n11 = (cellSize = jCTable.getRowCellSize(n12)).getPixelValue()) != 33001 && n11 != 33002) continue;
            int n13 = n;
            while (n13 <= n2) {
                bl |= CellSizeHandler.setPixelHeight(jCTable, n13, n13, n13, n3, n4);
                ++n13;
            }
        }
        return bl;
    }

    protected static boolean setPixelHeight(JCTable jCTable, int n, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        int n6 = jCTable.getTextHeightOffset() * 2;
        CellLayoutModel cellLayoutModel = jCTable.getCellLayout();
        CellSize cellSize = jCTable.getRowCellSize(n);
        int n7 = cellLayoutModel.getHeight(n);
        int n8 = cellSize.getPixelValue();
        if (cellSize.isHidden()) {
            n8 = 0;
        } else if (n == -1 && !jCTable.isColumnLabelDisplay()) {
            n8 = 0;
        } else {
            switch (n8) {
                case -999: {
                    n8 = Math.max(0, cellSize.getCharValue() * CellSizeHandler.getFontHeight(jCTable, n, n4) + n6);
                    break;
                }
                case 33000: {
                    if (n7 < 0) {
                        n8 = Math.max(0, cellSize.getCharValue() * CellSizeHandler.getFontHeight(jCTable, n, n4) + n6);
                        break;
                    }
                    n8 = n7;
                    break;
                }
                case 33001: {
                    if (n == -998) {
                        n8 = CellSizeHandler.getVariableCellHeight(jCTable, -1, n3, n4, n5, n6);
                        break;
                    }
                    if (n == -997) {
                        n8 = CellSizeHandler.getVariableCellHeight(jCTable, 0, n3, n4, n5, n6);
                        break;
                    }
                    n8 = CellSizeHandler.getVariableCellHeight(jCTable, n, n, n4, n5, n6);
                    break;
                }
                case 33002: {
                    if (n == -998) {
                        n8 = CellSizeHandler.getVariableEstimateCellHeight(jCTable, -1, n3, n4, n5, n6);
                        break;
                    }
                    if (n == -997) {
                        n8 = CellSizeHandler.getVariableEstimateCellHeight(jCTable, 0, n3, n4, n5, n6);
                        break;
                    }
                    n8 = CellSizeHandler.getVariableEstimateCellHeight(jCTable, n, n, n4, n5, n6);
                    break;
                }
            }
            n8 = Math.min(cellSize.getMaxValue(), Math.max(cellSize.getMinValue(), n8));
        }
        if (n7 != n8) {
            bl = true;
        }
        CellSizeHandler.setCellLayoutHeight(cellLayoutModel, n2, n3, n8);
        return bl;
    }

    protected static int getVariableCellHeight(JCTable jCTable, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = n;
        while (n7 <= n2) {
            int n8 = CellSizeHandler.getLargestCellHeight(jCTable, n3, n4, n7);
            n6 = Math.max(n6, n8 + n5);
            ++n7;
        }
        return n6;
    }

    protected static int getVariableEstimateCellHeight(JCTable jCTable, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = 0;
        int n8 = jCTable.getNumColumns();
        int n9 = Math.min(jCTable.variable_estimate_count, n8 - 1);
        int n10 = n;
        while (n10 <= n2) {
            if (n9 == -998) {
                n7 = CellSizeHandler.getLargestCellHeight(jCTable, n3, n4, n10);
            } else if (n9 == -1) {
                n7 = CellSizeHandler.getLargestCellHeight(jCTable, -1, -1, n10);
            } else if (n9 == -997) {
                n7 = CellSizeHandler.getLargestCellHeight(jCTable, 0, n8 - 1, n10);
            } else if (n9 == -996) {
                CellArea cellArea;
                n7 = CellSizeHandler.getCellHeight(jCTable, n10, -1);
                CellAreaHandler cellAreaHandler = jCTable.getCellAreaHandler();
                JCCellRange jCCellRange = cellAreaHandler.getVisibleCells();
                if (jCCellRange.start_column != -999 && jCCellRange.end_column != -999) {
                    n7 = Math.max(n7, CellSizeHandler.getLargestCellHeight(jCTable, jCCellRange.start_column, jCCellRange.end_column, n10));
                }
                if ((cellArea = cellAreaHandler.findByType(3)) != null) {
                    n7 = Math.max(n7, CellSizeHandler.getLargestCellHeight(jCTable, cellArea.start_column, cellArea.end_column, n10));
                }
            } else if (n9 >= 0) {
                n7 = CellSizeHandler.getLargestCellHeight(jCTable, -1, n9, n10);
            }
            n6 = Math.max(n6, n7 += n5);
            ++n10;
        }
        return n6;
    }

    protected static void setCellLayoutHeight(CellLayoutModel cellLayoutModel, int n, int n2, int n3) {
        if (n == -1) {
            cellLayoutModel.setHeight(n, n3);
        } else {
            cellLayoutModel.setHeight(n, n2, n3);
        }
    }

    protected static int getCellHeight(JCTable jCTable, int n, int n2) {
        if (jCTable.getGraphics() == null) {
            jCTable.setRecalcRequired(true);
            return 0;
        }
        Component component = jCTable.getComponent(n, n2);
        if (component != null) {
            return component.getPreferredSize().height;
        }
        Object object = jCTable.getDataView().getObject(n, n2);
        JCCellRenderer jCCellRenderer = jCTable.getDataView().getCellRenderer(n, n2, object);
        return CellSizeHandler.getCellHeight(jCTable, n, n2, object, jCCellRenderer);
    }

    protected static int getCellHeight(JCTable jCTable, int n, int n2, Object object, JCCellRenderer jCCellRenderer) {
        if (jCTable.getGraphics() == null) {
            jCTable.setRecalcRequired(true);
            return 0;
        }
        TableCellInfoModel tableCellInfoModel = jCTable.getCellAreaHandler().getTableCellInfo();
        tableCellInfoModel.initialize(jCTable, object, n, n2);
        Dimension dimension = null;
        if (jCCellRenderer instanceof JCLightCellRenderer) {
            JCLightCellRenderer jCLightCellRenderer = (JCLightCellRenderer)jCCellRenderer;
            dimension = jCLightCellRenderer.getPreferredSize(jCTable.getGraphics(), tableCellInfoModel, object);
        } else if (jCCellRenderer instanceof JCComponentCellRenderer) {
            JCComponentCellRenderer jCComponentCellRenderer = (JCComponentCellRenderer)jCCellRenderer;
            Component component = jCComponentCellRenderer.getRendererComponent(tableCellInfoModel, object, jCTable.isSelected(n, n2));
            dimension = component.getPreferredSize();
        }
        if (dimension == null && jCTable.getGraphics() != null && jCTable.getGraphics().getFontMetrics() != null) {
            return CellSizeHandler.getHeight(jCTable.getGraphics().getFontMetrics(tableCellInfoModel.getFont()), object == null ? "" : object.toString());
        }
        return dimension.height;
    }

    protected static final int getHeight(FontMetrics fontMetrics, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n = 1;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                ++n;
            }
            ++n2;
        }
        return fontMetrics.getHeight() * n;
    }

    protected static final int getLargestCellHeight(JCTable jCTable, int n, int n2, int n3) {
        int n4;
        if (jCTable.getGraphics() == null) {
            jCTable.setRecalcRequired(true);
            return 0;
        }
        int n5 = 0;
        if (n3 < 0 && n < 0) {
            n = 0;
        }
        if (n2 >= (n4 = jCTable.getDataView().getNumColumns())) {
            n2 = n4 - 1;
        }
        int n6 = n;
        while (n6 <= n2) {
            JCCellRange jCCellRange;
            if (jCTable.spanHandler == null || (jCCellRange = jCTable.getSpannedRange(n3, n6)) == null || jCCellRange.start_row == jCCellRange.end_row) {
                n5 = Math.max(n5, CellSizeHandler.getCellHeight(jCTable, n3, n6));
            }
            ++n6;
        }
        return n5;
    }

    protected static boolean calcRowLabelWidth(JCTable jCTable, int n, int n2) {
        return CellSizeHandler.calcColumnWidths(jCTable, n, n2, -1, -1);
    }

    protected static boolean calcColumnWidths(JCTable jCTable, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        boolean bl = false;
        if (!jCTable.repaint_enabled) {
            jCTable.setRecalcRequired(true);
            return false;
        }
        int n7 = jCTable.getNumRows();
        int n8 = jCTable.getNumColumns();
        int n9 = n7 == 0 ? -1 : n7 - 1;
        int n10 = n6 = n8 == 0 ? -1 : n8 - 1;
        if (n == -998) {
            n = -1;
            n2 = n9;
        } else if (n == -997) {
            n = 0;
            n2 = n9;
        }
        if (n3 == -998) {
            n3 = -1;
            n4 = n6;
        } else if (n3 == -997) {
            n3 = 0;
            n4 = n6;
        }
        if (n == -1 && n8 == 0) {
            n = 0;
        }
        if (n3 == -1 && n7 == 0 && ((n5 = jCTable.getColumnCellSize(-1).getPixelValue()) == 33001 || n5 == 33002)) {
            n3 = 0;
        }
        if (n2 == Integer.MAX_VALUE) {
            n2 = n9;
        }
        if (n4 == Integer.MAX_VALUE) {
            n4 = n6;
        }
        if (n > n2 || n3 > n4) {
            return bl;
        }
        if (n3 == n4) {
            return bl |= CellSizeHandler.setPixelWidth(jCTable, n3, n, n2, n3, n4);
        }
        CellLayoutModel cellLayoutModel = jCTable.getCellLayout();
        cellLayoutModel.setWidth(-1, 0);
        if (n3 == -1) {
            bl |= CellSizeHandler.setPixelWidth(jCTable, n3, n, n2, n3, n4);
        }
        cellLayoutModel.resetColumns();
        bl |= CellSizeHandler.setPixelWidth(jCTable, -997, n, n2, 0, n4);
        List list = jCTable.getColumnWidthValues();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CellSize cellSize;
            int n11;
            PositionCellSize positionCellSize = (PositionCellSize)iterator.next();
            int n12 = positionCellSize.position;
            if (n12 >= 0) {
                bl |= CellSizeHandler.setPixelWidth(jCTable, n12, n, n2, n12, n12);
                continue;
            }
            if (n12 != -998 && n12 != -997 || (n11 = (cellSize = jCTable.getColumnCellSize(n12)).getPixelValue()) != 33001 && n11 != 33002) continue;
            int n13 = n3;
            while (n13 <= n4) {
                bl |= CellSizeHandler.setPixelWidth(jCTable, n13, n, n2, n13, n13);
                ++n13;
            }
        }
        return bl;
    }

    protected static boolean setPixelWidth(JCTable jCTable, int n, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        int n6 = jCTable.getTextWidthOffset() * 2;
        CellLayoutModel cellLayoutModel = jCTable.getCellLayout();
        CellSize cellSize = jCTable.getColumnCellSize(n);
        int n7 = jCTable.getCellLayout().getWidth(n);
        int n8 = cellSize.getPixelValue();
        if (cellSize.isHidden()) {
            n8 = 0;
        } else if (n == -1 && !jCTable.isRowLabelDisplay()) {
            n8 = 0;
        } else {
            switch (n8) {
                case -999: {
                    n8 = Math.max(0, cellSize.getCharValue() * CellSizeHandler.getFontWidth(jCTable, n2, n) + n6);
                    break;
                }
                case 33000: {
                    if (n7 < 0) {
                        n8 = Math.max(0, cellSize.getCharValue() * CellSizeHandler.getFontWidth(jCTable, n2, n) + n6);
                        break;
                    }
                    n8 = n7;
                    break;
                }
                case 33001: {
                    if (n == -998) {
                        n8 = CellSizeHandler.getVariableCellWidth(jCTable, n2, n3, -1, n5, n6);
                        break;
                    }
                    if (n == -997) {
                        n8 = CellSizeHandler.getVariableCellWidth(jCTable, n2, n3, 0, n5, n6);
                        break;
                    }
                    n8 = CellSizeHandler.getVariableCellWidth(jCTable, n2, n3, n, n, n6);
                    break;
                }
                case 33002: {
                    if (n == -998) {
                        n8 = CellSizeHandler.getVariableEstimateCellWidth(jCTable, n2, n3, -1, n5, n6);
                        break;
                    }
                    if (n == -997) {
                        n8 = CellSizeHandler.getVariableEstimateCellWidth(jCTable, n2, n3, 0, n5, n6);
                        break;
                    }
                    n8 = CellSizeHandler.getVariableEstimateCellWidth(jCTable, n2, n3, n, n, n6);
                    break;
                }
            }
            n8 = Math.min(cellSize.getMaxValue(), Math.max(cellSize.getMinValue(), n8));
        }
        if (n7 != n8) {
            bl = true;
        }
        CellSizeHandler.setCellLayoutWidth(cellLayoutModel, n4, n5, n8);
        return bl;
    }

    protected static int getVariableCellWidth(JCTable jCTable, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = n3;
        while (n7 <= n4) {
            int n8 = CellSizeHandler.getLargestCellWidth(jCTable, n, n2, n7);
            n6 = Math.max(n6, n8 + n5);
            ++n7;
        }
        return n6;
    }

    protected static int getVariableEstimateCellWidth(JCTable jCTable, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = 0;
        int n8 = jCTable.getNumRows();
        int n9 = Math.min(jCTable.variable_estimate_count, n8 - 1);
        int n10 = n3;
        while (n10 <= n4) {
            if (n9 == -998) {
                n7 = CellSizeHandler.getLargestCellWidth(jCTable, n, n2, n10);
            } else if (n9 == -1) {
                n7 = CellSizeHandler.getLargestCellWidth(jCTable, -1, -1, n10);
            } else if (n9 == -997) {
                n7 = CellSizeHandler.getLargestCellWidth(jCTable, 0, n8 - 1, n10);
            } else if (n9 == -996) {
                CellArea cellArea;
                int n11 = CellSizeHandler.getCellWidth(jCTable, -1, n10);
                CellAreaHandler cellAreaHandler = jCTable.getCellAreaHandler();
                JCCellRange jCCellRange = cellAreaHandler.getVisibleCells();
                if (jCCellRange.start_row != -999 && jCCellRange.end_row != -999) {
                    n7 = Math.max(n11, CellSizeHandler.getLargestCellWidth(jCTable, jCCellRange.start_row, jCCellRange.end_row, n10));
                }
                if ((cellArea = cellAreaHandler.findByType(1)) != null) {
                    n7 = Math.max(n7, CellSizeHandler.getLargestCellWidth(jCTable, cellArea.start_row, cellArea.end_row, n10));
                }
            } else if (n9 >= 0) {
                n7 = CellSizeHandler.getLargestCellWidth(jCTable, -1, n9, n10);
            }
            n6 = Math.max(n6, n7 += n5);
            ++n10;
        }
        return n6;
    }

    protected static void setCellLayoutWidth(CellLayoutModel cellLayoutModel, int n, int n2, int n3) {
        if (n == -1) {
            cellLayoutModel.setWidth(n, n3);
        } else {
            cellLayoutModel.setWidth(n, n2, n3);
        }
    }

    protected static int getCellWidth(JCTable jCTable, int n, int n2) {
        if (jCTable.getGraphics() == null) {
            jCTable.setRecalcRequired(true);
            return 0;
        }
        Component component = jCTable.getComponent(n, n2);
        if (component != null) {
            return component.getPreferredSize().width;
        }
        Object object = jCTable.getDataView().getObject(n, n2);
        JCCellRenderer jCCellRenderer = jCTable.getDataView().getCellRenderer(n, n2, object);
        return CellSizeHandler.getCellWidth(jCTable, n, n2, object, jCCellRenderer);
    }

    protected static int getCellWidth(JCTable jCTable, int n, int n2, Object object, JCCellRenderer jCCellRenderer) {
        if (jCTable.getGraphics() == null) {
            jCTable.setRecalcRequired(true);
            return 0;
        }
        TableCellInfoModel tableCellInfoModel = jCTable.getCellAreaHandler().getTableCellInfo();
        tableCellInfoModel.initialize(jCTable, object, n, n2);
        Dimension dimension = null;
        if (jCCellRenderer instanceof JCLightCellRenderer) {
            JCLightCellRenderer jCLightCellRenderer = (JCLightCellRenderer)jCCellRenderer;
            dimension = jCLightCellRenderer.getPreferredSize(jCTable.getGraphics(), tableCellInfoModel, object);
        } else if (jCCellRenderer instanceof JCComponentCellRenderer) {
            JCComponentCellRenderer jCComponentCellRenderer = (JCComponentCellRenderer)jCCellRenderer;
            Component component = jCComponentCellRenderer.getRendererComponent(tableCellInfoModel, object, jCTable.isSelected(n, n2));
            dimension = component.getPreferredSize();
        }
        if (dimension == null) {
            return CellSizeHandler.getWidth(jCTable.getGraphics().getFontMetrics(tableCellInfoModel.getFont()), object.toString());
        }
        return dimension.width;
    }

    protected static final int getLargestCellWidth(JCTable jCTable, int n, int n2, int n3) {
        int n4;
        if (jCTable.getGraphics() == null) {
            jCTable.setRecalcRequired(true);
            return 0;
        }
        int n5 = 0;
        if (n3 < 0 && n < 0) {
            n = 0;
        }
        if (n2 >= (n4 = jCTable.getDataView().getNumRows())) {
            n2 = n4 - 1;
        }
        int n6 = n;
        while (n6 <= n2) {
            JCCellRange jCCellRange;
            if (jCTable.spanHandler == null || (jCCellRange = jCTable.getSpannedRange(n6, n3)) == null || jCCellRange.start_column == jCCellRange.end_column) {
                n5 = Math.max(n5, CellSizeHandler.getCellWidth(jCTable, n6, n3));
            }
            ++n6;
        }
        return n5;
    }

    protected static final int getWidth(FontMetrics fontMetrics, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        if (string.indexOf(10) != -1) {
            int n;
            int n2 = 0;
            int n3 = 0;
            while ((n = string.indexOf(10, n2)) != -1) {
                n3 = Math.max(n3, fontMetrics.stringWidth(string.substring(n2, n)));
                n2 = n + 1;
            }
            return Math.max(n3, fontMetrics.stringWidth(string.substring(n2, string.length())));
        }
        return fontMetrics.stringWidth(string);
    }

    protected static Dimension getCellDimensions(JCTable jCTable, int n, int n2) {
        if (jCTable.getGraphics() == null) {
            jCTable.setRecalcRequired(true);
            return new Dimension(0, 0);
        }
        Object object = jCTable.getDataView().getObject(n, n2);
        JCCellRenderer jCCellRenderer = jCTable.getDataView().getCellRenderer(n, n2, object);
        return CellSizeHandler.getCellDimensions(jCTable, n, n2, object, jCCellRenderer);
    }

    protected static Dimension getCellDimensions(JCTable jCTable, int n, int n2, Object object, JCCellRenderer jCCellRenderer) {
        Serializable serializable;
        if (jCTable.getGraphics() == null) {
            jCTable.setRecalcRequired(true);
            return new Dimension(0, 0);
        }
        TableCellInfoModel tableCellInfoModel = jCTable.getCellAreaHandler().getTableCellInfo();
        tableCellInfoModel.initialize(jCTable, object, n, n2);
        Dimension dimension = null;
        if (jCCellRenderer instanceof JCLightCellRenderer) {
            serializable = (JCLightCellRenderer)jCCellRenderer;
            dimension = serializable.getPreferredSize(jCTable.getGraphics(), tableCellInfoModel, object);
        } else if (jCCellRenderer instanceof JCComponentCellRenderer) {
            serializable = (JCComponentCellRenderer)jCCellRenderer;
            Component component = serializable.getRendererComponent(tableCellInfoModel, object, jCTable.isSelected(n, n2));
            dimension = component.getPreferredSize();
        }
        if (dimension == null) {
            serializable = jCTable.getGraphics().getFontMetrics(tableCellInfoModel.getFont());
            return new Dimension(CellSizeHandler.getWidth((FontMetrics)serializable, object.toString()), CellSizeHandler.getHeight((FontMetrics)serializable, object.toString()));
        }
        return dimension;
    }

    protected static int getFontHeight(JCTable jCTable, int n, int n2) {
        Object v;
        Font font = jCTable.getCellStyle(n, n2).getFont();
        if (font == null) {
            return 0;
        }
        if (cachedFontHeights == null) {
            cachedFontHeights = new Hashtable();
        }
        if ((v = cachedFontHeights.get(font)) != null && v instanceof Integer) {
            return (Integer)v;
        }
        int n3 = jCTable.getFontMetrics(font).getHeight();
        cachedFontHeights.put(font, new Integer(n3));
        return n3;
    }

    protected static int getFontWidth(JCTable jCTable, int n, int n2) {
        Font font = jCTable.getCellStyle(n, n2).getFont();
        if (font == null) {
            return 0;
        }
        return jCTable.getFontMetrics(font).charWidth('W');
    }
}

