/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.JCVersion;
import com.klg.jclass.swing.gauge.JCAbstractIndicator;
import com.klg.jclass.swing.gauge.JCAbstractNeedle;
import com.klg.jclass.swing.gauge.JCGaugeArea;
import com.klg.jclass.swing.gauge.JCGaugePickEvent;
import com.klg.jclass.swing.gauge.JCGaugePickListener;
import com.klg.jclass.swing.gauge.JCNeedle;
import com.klg.jclass.swing.gauge.JCRange;
import com.klg.jclass.swing.gauge.JCScale;
import com.klg.jclass.swing.gauge.JCTick;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.legend.JCGridLegend;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.LegendComponentLayout;
import com.klg.jclass.util.legend.LegendComponentLayoutUser;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;

public abstract class JCGauge
extends JComponent
implements MouseListener,
MouseMotionListener,
LegendComponentLayoutUser,
Serializable {
    static final long serialVersionUID = 1763099717300034832L;
    protected JCGaugeArea gaugeArea;
    protected JComponent header;
    protected JComponent footer;
    protected JCLegend legend;
    protected JCScale scale;
    protected Vector indicators;
    protected Vector needles;
    protected JCListenerList pickListeners = null;
    protected JCNeedle draggedNeedle = null;
    protected boolean snapToValue = false;
    protected boolean repaintEnabled = true;
    protected Rectangle gaugeAreaLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle legendLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle headerLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle footerLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Image image = null;
    protected boolean scaleImage = true;

    public JCGauge() {
        this.init();
    }

    private void init() {
        this.setOpaque(false);
        this.setLayout(new LegendComponentLayout());
        this.header = new JLabel();
        this.header.setVisible(false);
        this.add(this.header);
        this.gaugeArea = new JCGaugeArea(this);
        this.add(this.gaugeArea);
        this.footer = new JLabel();
        this.footer.setVisible(false);
        this.add(this.footer);
        this.legend = new JCGridLegend();
        this.legend.setVisible(false);
        this.add(this.legend);
        this.indicators = new Vector();
        this.needles = new Vector();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public boolean getSnapToValue() {
        return this.snapToValue;
    }

    public void setSnapToValue(boolean bl) {
        this.snapToValue = bl;
    }

    public void addIndicator(JCAbstractIndicator jCAbstractIndicator) {
        this.indicators.addElement(jCAbstractIndicator);
        this.gaugeArea.add(jCAbstractIndicator);
    }

    public void addIndicator(JCAbstractIndicator jCAbstractIndicator, int n) {
        this.indicators.addElement(jCAbstractIndicator);
        this.gaugeArea.add((Component)jCAbstractIndicator, n);
    }

    public void removeIndicator(JCAbstractIndicator jCAbstractIndicator) {
        if (this.indicators.contains(jCAbstractIndicator)) {
            this.indicators.removeElement(jCAbstractIndicator);
            this.gaugeArea.remove(jCAbstractIndicator);
        }
    }

    public Vector getIndicators() {
        return this.indicators;
    }

    protected void setIndicatorScales(JCScale jCScale) {
        if (this.indicators != null) {
            Enumeration enumeration = this.indicators.elements();
            while (enumeration.hasMoreElements()) {
                JCAbstractIndicator jCAbstractIndicator = (JCAbstractIndicator)enumeration.nextElement();
                jCAbstractIndicator.setScale(jCScale);
            }
        }
    }

    public void addNeedle(JCAbstractNeedle jCAbstractNeedle) {
        this.needles.addElement(jCAbstractNeedle);
        this.gaugeArea.add(jCAbstractNeedle);
    }

    public void addNeedle(JCAbstractNeedle jCAbstractNeedle, int n) {
        this.needles.addElement(jCAbstractNeedle);
        this.gaugeArea.add((Component)jCAbstractNeedle, n);
    }

    public void removeNeedle(JCAbstractNeedle jCAbstractNeedle) {
        if (this.needles.contains(jCAbstractNeedle)) {
            this.needles.removeElement(jCAbstractNeedle);
            this.gaugeArea.remove(jCAbstractNeedle);
        }
    }

    protected void setNeedleScales(JCScale jCScale) {
        if (this.needles != null) {
            Enumeration enumeration = this.needles.elements();
            while (enumeration.hasMoreElements()) {
                JCAbstractNeedle jCAbstractNeedle = (JCAbstractNeedle)enumeration.nextElement();
                jCAbstractNeedle.setScale(jCScale);
            }
        }
    }

    public Vector getNeedles() {
        return this.needles;
    }

    public void addTick(JCTick jCTick) {
        this.scale.addTick(jCTick);
    }

    public void addTick(JCTick jCTick, int n) {
        this.scale.addTick(jCTick, n);
    }

    public void removeTick(JCTick jCTick) {
        this.scale.removeTick(jCTick);
    }

    public Vector getTicks() {
        return this.scale.getTicks();
    }

    public void addRange(JCRange jCRange) {
        this.scale.addRange(jCRange);
    }

    public void addRange(JCRange jCRange, int n) {
        this.scale.addRange(jCRange, n);
    }

    public void removeRange(JCRange jCRange) {
        this.scale.removeRange(jCRange);
    }

    public Vector getRanges() {
        return this.scale.getRanges();
    }

    public JCScale getScale() {
        return this.scale;
    }

    public JCLegend getLegend() {
        return this.legend;
    }

    public void setLegend(JCLegend jCLegend) {
        if (jCLegend == null) {
            return;
        }
        if (this.legend != null) {
            this.remove(this.legend);
        }
        this.legend = jCLegend;
        this.add(this.legend);
    }

    public JCGaugeArea getGaugeArea() {
        return this.gaugeArea;
    }

    public void setGaugeArea(JCGaugeArea jCGaugeArea) {
        if (jCGaugeArea == null) {
            return;
        }
        if (this.gaugeArea != null) {
            this.remove(this.gaugeArea);
        }
        this.gaugeArea = jCGaugeArea;
        this.add(this.gaugeArea);
    }

    public void setRepaintEnabled(boolean bl) {
        this.repaintEnabled = bl;
        if (bl) {
            this.repaint();
        }
    }

    public boolean getRepaintEnabled() {
        return this.repaintEnabled;
    }

    public JCGaugePickEvent pick(Point point) {
        JCGaugePickEvent jCGaugePickEvent = null;
        Component component = this.getComponentAt(point.x, point.y);
        if (component == null) {
            return null;
        }
        Point point2 = new Point(point.x - component.getLocation().x, point.y - component.getLocation().y);
        if (!(component instanceof JCLegend) && component instanceof JCGaugeArea) {
            double d = this.scale.pick(point2);
            if (this.snapToValue) {
                d = Math.round(d);
            }
            if (!this.scale.inBounds((jCGaugePickEvent = new JCGaugePickEvent(this, component, d, point2)).getValue())) {
                jCGaugePickEvent = null;
            }
        }
        return jCGaugePickEvent;
    }

    public void addPickListener(JCGaugePickListener jCGaugePickListener) {
        this.pickListeners = JCListenerList.add(this.pickListeners, jCGaugePickListener);
    }

    public void removePickListener(JCGaugePickListener jCGaugePickListener) {
        this.pickListeners = JCListenerList.remove(this.pickListeners, jCGaugePickListener);
    }

    public void sendPickEvent(JCGaugePickEvent jCGaugePickEvent) {
        Enumeration enumeration = JCListenerList.elements(this.pickListeners);
        while (enumeration.hasMoreElements()) {
            ((JCGaugePickListener)enumeration.nextElement()).pick(jCGaugePickEvent);
        }
    }

    public JComponent getHeader() {
        return this.header;
    }

    public void setHeader(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        if (this.header != null) {
            this.remove(this.header);
        }
        this.header = jComponent;
        this.add(this.header);
    }

    public JComponent getFooter() {
        return this.footer;
    }

    public void setFooter(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        if (this.footer != null) {
            this.remove(this.footer);
        }
        this.footer = jComponent;
        this.add(this.footer);
    }

    public int getDrawingAreaHeight() {
        int n = 0;
        Insets insets = this.getInsets();
        if (insets != null) {
            n = insets.top + insets.bottom;
        }
        return Math.max(0, this.getSize().height - n);
    }

    public int getDrawingAreaWidth() {
        int n = 0;
        Insets insets = this.getInsets();
        if (insets != null) {
            n = insets.left + insets.right;
        }
        return Math.max(0, this.getSize().width - n);
    }

    public Rectangle getLayoutHints(JComponent jComponent) {
        if (jComponent == this.gaugeArea) {
            return this.gaugeAreaLayoutHints;
        }
        if (jComponent == this.legend) {
            return this.legendLayoutHints;
        }
        if (jComponent == this.header) {
            return this.headerLayoutHints;
        }
        if (jComponent == this.footer) {
            return this.footerLayoutHints;
        }
        return null;
    }

    public JComponent getComponentArea() {
        return this.getGaugeArea();
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.redraw();
    }

    public boolean getScaleImage() {
        return this.scaleImage;
    }

    public void setScaleImage(boolean bl) {
        this.scaleImage = bl;
        this.redraw();
    }

    public abstract void redraw();

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.draggedNeedle = null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JCGaugePickEvent jCGaugePickEvent = this.pick(mouseEvent.getPoint());
        this.sendPickEvent(jCGaugePickEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        JCGaugePickEvent jCGaugePickEvent = this.pick(mouseEvent.getPoint());
        this.sendPickEvent(jCGaugePickEvent);
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public void setAbout(String string) {
    }
}

