/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCAbstractScale;
import com.klg.jclass.swing.gauge.JCCircularGauge;
import com.klg.jclass.swing.gauge.JCCircularTick;
import com.klg.jclass.swing.gauge.RadialConstraint;
import com.klg.jclass.swing.gauge.RadialLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.JLabel;

public class JCCircularScale
extends JCAbstractScale
implements Serializable {
    static final long serialVersionUID = 6835510720826476109L;
    protected double startAngle = 0.0;
    protected double stopAngle = 360.0;
    protected double minSize = 8.0;
    protected boolean paintCompleteBackground = false;

    public JCCircularScale(JCCircularGauge jCCircularGauge) {
        super(jCCircularGauge);
        this.setLayout(new RadialLayout());
        this.setForeground(Color.white);
        GaugeUtil.createLegendPopulatorRenderer(jCCircularGauge, this);
    }

    public JCCircularScale(JCCircularGauge jCCircularGauge, JCAbstractScale.Direction direction, double d, double d2, double d3, double d4, Color color) {
        super(jCCircularGauge, direction, d, d2, color);
        this.startAngle = d3;
        this.stopAngle = d4;
        this.setLayout(new RadialLayout());
        GaugeUtil.createLegendPopulatorRenderer(jCCircularGauge, this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getParent().getBounds().width, this.getParent().getBounds().height);
    }

    public Component add(Component component) {
        this.add(component, new RadialConstraint(this.getGauge(), Double.MAX_VALUE, Double.MAX_VALUE));
        return component;
    }

    public Component add(Component component, int n) {
        this.add(component, new RadialConstraint(this.getGauge(), Double.MAX_VALUE, Double.MAX_VALUE), n);
        return component;
    }

    public void paintComponent(Graphics graphics) {
        int n;
        double d = GaugeUtil.normalizeAngle(this.startAngle);
        double d2 = GaugeUtil.normalizeAngle(this.stopAngle);
        JCCircularGauge jCCircularGauge = this.getCircularGauge();
        Rectangle rectangle = jCCircularGauge.getArcBounds();
        super.paintComponent(graphics);
        Graphics graphics2 = graphics.create();
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        if (this.getPaintCompleteBackground()) {
            d = jCCircularGauge.getGaugeType().getStartAngle();
            n = jCCircularGauge.getGaugeType().getSweepAngle();
        } else {
            if (d >= d2) {
                d2 += 360.0;
            }
            n = (int)GaugeUtil.arcAngle(d, d2);
        }
        if (this.image != null) {
            if (this.scaleImage) {
                Shape shape = graphics2.getClip();
                Shape shape2 = this.getCircularScaleShape(this);
                graphics2.setClip(shape2);
                this.drawImage(graphics2, this.image, rectangle);
                graphics2.setClip(shape);
            } else {
                this.drawImage(graphics2, this.image, rectangle);
            }
        } else {
            graphics2.fillArc(n2, n3, n4, n5, (int)d, n);
        }
        graphics2.dispose();
    }

    public double pick(Point point) {
        double d;
        double d2 = 0.0;
        double d3 = GaugeUtil.normalizeAngle(this.startAngle);
        double d4 = GaugeUtil.normalizeAngle(this.stopAngle);
        boolean bl = this.direction.equals(JCAbstractScale.Direction.BACKWARD);
        JCCircularGauge jCCircularGauge = this.getCircularGauge();
        Rectangle rectangle = jCCircularGauge.getArcBounds();
        if (d3 == d4) {
            d4 += 360.0;
        }
        int n = point.x - rectangle.x;
        int n2 = point.y - rectangle.y;
        double d5 = d = GaugeUtil.pointToAngle(n, n2, this.getRadius(), this.getRadius());
        if (d < d3) {
            d += 360.0;
        }
        d2 = GaugeUtil.angleToValue(d, this.min, this.max, d3, d4);
        if (bl) {
            d2 = this.max - d2 + this.min;
        }
        if (!this.inBounds(d2)) {
            double d6 = GaugeUtil.distanceBetweenAngles(d5, d3);
            double d7 = GaugeUtil.distanceBetweenAngles(d5, d4);
            d2 = bl ? (d6 <= d7 ? this.max : this.min) : (d6 <= d7 ? this.min : this.max);
        }
        return d2;
    }

    protected Insets getScaleInsets() {
        Insets insets = this.getInsets();
        Container container = this.getParent();
        int n = insets.top;
        int n2 = insets.left;
        int n3 = insets.bottom;
        int n4 = insets.right;
        if (container != null) {
            Insets insets2 = container.getInsets();
            n = Math.max(insets2.top, n);
            n2 = Math.max(insets2.left, n2);
            n3 = Math.max(insets2.bottom, n3);
            n4 = Math.max(insets2.right, n4);
        }
        return new Insets(n, n2, n3, n4);
    }

    public double getRadius() {
        int n = this.getGauge().getGaugeArea().getBounds().width;
        int n2 = this.getGauge().getGaugeArea().getBounds().height;
        Insets insets = this.getScaleInsets();
        double d = Math.max(this.minSize, (double)Math.min(n -= insets.left + insets.right, n2 -= insets.top + insets.bottom));
        JCCircularGauge.GaugeType gaugeType = this.getCircularGauge().getGaugeType();
        if (gaugeType.equals(JCCircularGauge.GaugeType.FULL_CIRCLE)) {
            d /= 2.0;
        } else if (gaugeType.equals(JCCircularGauge.GaugeType.TOP_HALF_CIRCLE) || gaugeType.equals(JCCircularGauge.GaugeType.BOTTOM_HALF_CIRCLE)) {
            while (n / 2 > n2) {
                --n;
            }
            d = n / 2;
        } else if (gaugeType.equals(JCCircularGauge.GaugeType.LEFT_HALF_CIRCLE) || gaugeType.equals(JCCircularGauge.GaugeType.RIGHT_HALF_CIRCLE)) {
            while (n2 / 2 > n) {
                --n2;
            }
            d = n2 / 2;
        }
        return d *= this.zoomFactor;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d) {
        this.startAngle = d;
        this.redraw();
    }

    public double getStopAngle() {
        return this.stopAngle;
    }

    public void setStopAngle(double d) {
        this.stopAngle = d;
        this.redraw();
    }

    public JCCircularGauge getCircularGauge() {
        return (JCCircularGauge)this.getGauge();
    }

    public boolean getPaintCompleteBackground() {
        return this.paintCompleteBackground;
    }

    public void setPaintCompleteBackground(boolean bl) {
        this.paintCompleteBackground = bl;
        this.redraw();
    }

    public void redraw() {
        if (this.gauge.getRepaintEnabled()) {
            Enumeration enumeration = this.gauge.getTicks().elements();
            while (enumeration.hasMoreElements()) {
                JCCircularTick jCCircularTick = (JCCircularTick)enumeration.nextElement();
                jCCircularTick.redraw(true);
            }
            this.repaint();
        }
    }

    protected Shape getCircularScaleShape(JCCircularScale jCCircularScale) {
        int n;
        double d = GaugeUtil.normalizeAngle(jCCircularScale.getStartAngle());
        double d2 = GaugeUtil.normalizeAngle(jCCircularScale.getStopAngle());
        JCCircularGauge jCCircularGauge = jCCircularScale.getCircularGauge();
        if (jCCircularScale.getPaintCompleteBackground()) {
            d = jCCircularGauge.getGaugeType().getStartAngle();
            n = jCCircularGauge.getGaugeType().getSweepAngle();
        } else {
            if (d >= d2) {
                d2 += 360.0;
            }
            n = (int)GaugeUtil.arcAngle(d, d2);
        }
        Shape shape = null;
        if (jCCircularGauge.getGaugeType() == JCCircularGauge.GaugeType.FULL_CIRCLE && jCCircularScale.getPaintCompleteBackground()) {
            Rectangle rectangle = jCCircularGauge.getArcBounds();
            shape = new Ellipse2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            double d3 = jCCircularScale.getRadius();
            Polygon polygon = new Polygon();
            double d4 = 5.0;
            double d5 = d;
            while (d5 < d2) {
                polygon.addPoint((int)d3, (int)d5);
                d5 += d4;
            }
            polygon.addPoint((int)d3, (int)d2);
            Rectangle rectangle = jCCircularGauge.getArcBounds();
            double d6 = (double)rectangle.x + d3;
            double d7 = (double)rectangle.y + d3;
            Polygon polygon2 = new Polygon();
            polygon2.addPoint((int)d6, (int)d7);
            int n2 = 0;
            while (n2 < polygon.npoints) {
                double d8 = GaugeUtil.toRadians(polygon.ypoints[n2]);
                int n3 = (int)(d6 + (double)polygon.xpoints[n2] * Math.cos(d8));
                int n4 = (int)(d7 - (double)polygon.xpoints[n2] * Math.sin(d8));
                polygon2.addPoint(n3, n4);
                ++n2;
            }
            polygon2.addPoint((int)d6, (int)d7);
            shape = polygon2;
        }
        return shape;
    }

    protected void drawImage(Graphics graphics, Image image, Rectangle rectangle) {
        JLabel jLabel = new JLabel();
        if (super.getScaleImage()) {
            graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.getForeground(), jLabel);
        } else {
            graphics.drawImage(image, rectangle.x, rectangle.y, this.getForeground(), jLabel);
        }
    }
}

