/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.JCGauge;
import com.klg.jclass.swing.gauge.JCRange;
import com.klg.jclass.swing.gauge.JCScale;
import com.klg.jclass.swing.gauge.JCTick;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;

public abstract class JCAbstractScale
extends JComponent
implements JCScale {
    static final long serialVersionUID = -1015210021570456430L;
    protected JCGauge gauge;
    protected Direction direction = Direction.FORWARD;
    protected double min = 0.0;
    protected double max = 100.0;
    protected double zoomFactor = 1.0;
    protected Vector ticks = new Vector();
    protected Vector ranges = new Vector();
    protected Image image;
    protected boolean scaleImage = true;

    public JCAbstractScale(JCGauge jCGauge) {
        this.setLayout(new GridLayout(1, 1));
        this.gauge = jCGauge;
    }

    public JCAbstractScale(JCGauge jCGauge, Direction direction, double d, double d2, Color color) {
        this.setLayout(new GridLayout(1, 1));
        this.gauge = jCGauge;
        this.direction = direction;
        this.min = d;
        this.max = d2;
        this.setForeground(color);
    }

    public JCGauge getGauge() {
        return this.gauge;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
        this.redraw();
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double d) {
        this.max = d;
        this.redraw();
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double d) {
        this.min = d;
        this.redraw();
    }

    public double getExtent() {
        return this.getZoomFactor();
    }

    public void setExtent(double d) {
        this.setZoomFactor(d);
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double d) {
        if (d > 1.0) {
            d = 1.0;
        } else if (d < 0.0) {
            d = 0.0;
        }
        this.zoomFactor = d;
        this.redraw();
    }

    public Vector getTicks() {
        return this.ticks;
    }

    public void addTick(JCTick jCTick) {
        this.addTick(jCTick, 0);
    }

    public void addTick(JCTick jCTick, int n) {
        this.ticks.addElement(jCTick);
        this.add((Component)((Object)jCTick), n);
    }

    public void removeTick(JCTick jCTick) {
        if (this.ticks.contains(jCTick)) {
            this.ticks.removeElement(jCTick);
            this.remove((Component)((Object)jCTick));
        }
    }

    public Vector getRanges() {
        return this.ranges;
    }

    public void addRange(JCRange jCRange) {
        this.addRange(jCRange, 0);
    }

    public void addRange(JCRange jCRange, int n) {
        this.ranges.addElement(jCRange);
        this.add((Component)((Object)jCRange), n);
    }

    public void removeRange(JCRange jCRange) {
        if (this.ranges.contains(jCRange)) {
            this.ranges.removeElement(jCRange);
            this.remove((Component)((Object)jCRange));
        }
    }

    public boolean inBounds(double d) {
        return d >= this.getMin() && d <= this.getMax();
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.redraw();
    }

    public boolean getScaleImage() {
        return this.scaleImage;
    }

    public void setScaleImage(boolean bl) {
        this.scaleImage = bl;
        this.redraw();
    }

    public void redraw() {
    }

    public abstract double pick(Point var1);

    public static class Direction
    implements Serializable {
        public static final Direction BACKWARD = new Direction("backward");
        public static final Direction CLOCKWISE = new Direction("clockwise");
        public static final Direction FORWARD = new Direction("forward");
        public static final Direction COUNTERCLOCKWISE = new Direction("counterclockwise");
        String string;

        private Direction(String string) {
            this.string = string;
        }

        public boolean equals(Direction direction) {
            boolean bl = direction.string.equals(this.string);
            if (!bl) {
                if (direction.string.equals(Direction.BACKWARD.string) && this.string.equals(Direction.CLOCKWISE.string)) {
                    bl = true;
                } else if (direction.string.equals(Direction.CLOCKWISE.string) && this.string.equals(Direction.BACKWARD.string)) {
                    bl = true;
                } else if (direction.string.equals(Direction.FORWARD.string) && this.string.equals(Direction.COUNTERCLOCKWISE.string)) {
                    bl = true;
                } else if (direction.string.equals(Direction.COUNTERCLOCKWISE.string) && this.string.equals(Direction.FORWARD.string)) {
                    bl = true;
                }
            }
            return bl;
        }
    }
}

