/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCIndicator;
import com.klg.jclass.swing.gauge.JCIndicatorStyle;
import com.klg.jclass.swing.gauge.JCScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public abstract class JCAbstractIndicator
extends JComponent
implements JCIndicator {
    static final long serialVersionUID = 7215270223197984024L;
    protected JCScale scale;
    protected double indicatorWidth = 15.0;
    protected boolean reversed = false;
    protected double inner_extent = 0.0;
    protected double outer_extent = 1.0;
    protected JCIndicatorStyle indicatorStyle = JCIndicatorStyle.RECTANGLE;
    protected double value;

    public JCAbstractIndicator(JCScale jCScale) {
        this.scale = jCScale;
        this.value = jCScale.getMin();
    }

    public JCAbstractIndicator(Color color, double d, JCScale jCScale, boolean bl, double d2, double d3, JCIndicatorStyle jCIndicatorStyle, double d4) {
        this.indicatorWidth = d;
        this.scale = jCScale;
        this.inner_extent = d2;
        this.outer_extent = d3;
        this.indicatorStyle = jCIndicatorStyle;
        this.value = d4;
        this.setForeground(color);
        this.setVisible(bl);
    }

    public Dimension getPreferredSize() {
        return this.scale.getGauge().getGaugeArea().getPreferredSize();
    }

    public abstract void paint(Graphics var1);

    public JCScale getScale() {
        return this.scale;
    }

    protected void setScale(JCScale jCScale) {
        this.scale = jCScale;
        this.value = GaugeUtil.clamp(this.value, jCScale.getMin(), jCScale.getMax());
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        if (this.value != (d = GaugeUtil.clamp(d, this.scale.getMin(), this.scale.getMax()))) {
            this.value = d;
            this.redraw();
        }
    }

    public double getInnerExtent() {
        return this.inner_extent;
    }

    public void setInnerExtent(double d) {
        this.inner_extent = d;
        this.redraw();
    }

    public double getOuterExtent() {
        return this.outer_extent;
    }

    public void setOuterExtent(double d) {
        this.outer_extent = d;
        this.redraw();
    }

    public JCIndicatorStyle getIndicatorStyle() {
        return this.indicatorStyle;
    }

    public void setIndicatorStyle(JCIndicatorStyle jCIndicatorStyle) {
        this.indicatorStyle = jCIndicatorStyle;
        this.redraw();
    }

    public double getIndicatorWidth() {
        return this.indicatorWidth;
    }

    public void setIndicatorWidth(double d) {
        this.indicatorWidth = d;
        this.redraw();
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean bl) {
        this.reversed = bl;
        this.redraw();
    }

    public void redraw() {
        if (this.scale.getGauge().getRepaintEnabled()) {
            this.repaint();
        }
    }
}

