/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing;

import com.klg.jclass.swing.JCVersion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;

public class JCMultiSelectList
extends JComponent
implements Serializable {
    protected static final String SELECT_ITEM = ">";
    protected static final String SELECT_ALL = ">>";
    protected static final String DESELECT_ITEM = "<";
    protected static final String DESELECT_ALL = "<<";
    protected JList mainList = null;
    protected JList sourceList = null;
    protected JList selectionList = null;
    protected JScrollPane sourcePane = null;
    protected JScrollPane selectionPane = null;
    protected SelectionButton selectItemButton = null;
    protected SelectionButton selectAllButton = null;
    protected SelectionButton deselectItemButton = null;
    protected SelectionButton deselectAllButton = null;
    protected JPanel buttonPanel = null;
    protected EventHandler eventHandler = new EventHandler();
    protected Dimension defaultListSize = new Dimension(100, 200);
    protected FontMetrics lastFontMetrics = null;
    private static final String uiClassID = "MultiSelectListUI";
    static /* synthetic */ Class class$javax$swing$event$ListSelectionListener;

    public JCMultiSelectList(ListModel listModel) {
        this();
        this.mainList.setModel(listModel);
        this.init();
    }

    public JCMultiSelectList(Object[] objectArray) {
        this();
        this.mainList.setListData(objectArray);
        this.init();
    }

    public JCMultiSelectList(Vector vector) {
        this();
        this.mainList.setListData(vector);
        this.init();
    }

    public JCMultiSelectList() {
        this(4);
    }

    public JCMultiSelectList(int n) {
        this.mainList = new JList();
        this.mainList.addListSelectionListener(this.eventHandler);
        this.sourceList = new JList();
        this.sourceList.setSelectionMode(2);
        this.sourceList.addListSelectionListener(this.eventHandler);
        this.sourceList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    JCMultiSelectList.this.selectItem();
                }
            }
        });
        this.selectionList = new JList();
        this.selectionList.setSelectionMode(2);
        this.selectionList.addListSelectionListener(this.eventHandler);
        this.selectionList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    JCMultiSelectList.this.deselectItem();
                }
            }
        });
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.selectItemButton = this.initButton(new SelectionButton(SELECT_ITEM), "Add selected");
        this.selectAllButton = this.initButton(new SelectionButton(SELECT_ALL), "Add all");
        this.deselectItemButton = this.initButton(new SelectionButton(DESELECT_ITEM), "Remove selected");
        this.deselectAllButton = this.initButton(new SelectionButton(DESELECT_ALL), "Remove all");
        Dimension dimension = JCMultiSelectList.getButtonSize();
        this.buttonPanel.setPreferredSize(new Dimension(dimension.width, 4 * dimension.height));
        this.setLayout(new JCFixedCenterLayout(n));
        this.sourcePane = new JScrollPane(this.sourceList);
        this.sourcePane.setPreferredSize(this.defaultListSize);
        this.selectionPane = new JScrollPane(this.selectionList);
        this.selectionPane.setPreferredSize(this.defaultListSize);
        this.add((Component)this.sourcePane, "West");
        this.add((Component)this.selectionPane, "East");
        this.add((Component)this.buttonPanel, "Center");
        this.setUI(new MultiSelectListUI());
    }

    public void updateUI() {
        this.setUI(new MultiSelectListUI());
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public Object getPrototypeCellValue() {
        return this.mainList.getPrototypeCellValue();
    }

    public void setPrototypeCellValue(Object object) {
        this.mainList.setPrototypeCellValue(object);
        this.sourceList.setPrototypeCellValue(object);
        this.selectionList.setPrototypeCellValue(object);
    }

    public int getFixedCellWidth() {
        return this.mainList.getFixedCellWidth();
    }

    public void setFixedCellWidth(int n) {
        this.mainList.setFixedCellWidth(n);
        this.sourceList.setFixedCellWidth(n);
        this.selectionList.setFixedCellWidth(n);
    }

    public int getFixedCellHeight() {
        return this.mainList.getFixedCellHeight();
    }

    public void setFixedCellHeight(int n) {
        this.mainList.setFixedCellHeight(n);
        this.sourceList.setFixedCellHeight(n);
        this.selectionList.setFixedCellHeight(n);
    }

    public ListCellRenderer getCellRenderer() {
        return this.mainList.getCellRenderer();
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        this.mainList.setCellRenderer(listCellRenderer);
        this.sourceList.setCellRenderer(listCellRenderer);
        this.selectionList.setCellRenderer(listCellRenderer);
    }

    public Color getSelectionForeground() {
        return this.mainList.getSelectionForeground();
    }

    public void setSelectionForeground(Color color) {
        this.mainList.setSelectionForeground(color);
        this.sourceList.setSelectionForeground(color);
        this.selectionList.setSelectionForeground(color);
    }

    public Color getSelectionBackground() {
        return this.mainList.getSelectionBackground();
    }

    public void setSelectionBackground(Color color) {
        this.mainList.setSelectionBackground(color);
        this.sourceList.setSelectionBackground(color);
        this.selectionList.setSelectionBackground(color);
    }

    public ListModel getModel() {
        return this.mainList.getModel();
    }

    public void setModel(ListModel listModel) {
        this.mainList.setModel(listModel);
        this.updateView();
    }

    public void setListData(Object[] objectArray) {
        this.mainList.setListData(objectArray);
        this.updateView();
    }

    public void setListData(Vector vector) {
        this.mainList.setListData(vector);
        this.updateView();
    }

    public ListSelectionModel getSelectionModel() {
        return this.mainList.getSelectionModel();
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.add(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = JCMultiSelectList.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = JCMultiSelectList.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, listSelectionListener);
    }

    protected void fireSelectionValueChanged(int n, int n2, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListSelectionEvent listSelectionEvent = null;
        int n3 = objectArray.length - 2;
        while (n3 >= 0) {
            if (objectArray[n3] == (class$javax$swing$event$ListSelectionListener == null ? JCMultiSelectList.class$("javax.swing.event.ListSelectionListener") : class$javax$swing$event$ListSelectionListener)) {
                if (listSelectionEvent == null) {
                    listSelectionEvent = new ListSelectionEvent(this, n, n2, bl);
                }
                ((ListSelectionListener)objectArray[n3 + 1]).valueChanged(listSelectionEvent);
            }
            n3 -= 2;
        }
    }

    public int getSelectionMode() {
        return this.mainList.getSelectionMode();
    }

    public int getAnchorSelectionIndex() {
        return this.getSelectionModel().getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.mainList.getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.mainList.getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.mainList.getMaxSelectionIndex();
    }

    public boolean isSelectedIndex(int n) {
        return this.mainList.isSelectedIndex(n);
    }

    public boolean isSelectionEmpty() {
        return this.mainList.isSelectionEmpty();
    }

    public void clearSelection() {
        this.mainList.clearSelection();
        this.updateView();
    }

    public void setSelectionInterval(int n, int n2) {
        this.mainList.setSelectionInterval(n, n2);
        this.updateView();
    }

    public void addSelectionInterval(int n, int n2) {
        this.mainList.addSelectionInterval(n, n2);
        this.updateView();
    }

    public void removeSelectionInterval(int n, int n2) {
        this.mainList.removeSelectionInterval(n, n2);
        this.updateView();
    }

    public int getSelectedIndex() {
        return this.mainList.getSelectedIndex();
    }

    public void setSelectedIndex(int n) {
        this.mainList.setSelectedIndex(n);
        this.updateView();
    }

    public int[] getSelectedIndices() {
        return this.mainList.getSelectedIndices();
    }

    public void setSelectedIndices(int[] nArray) {
        this.mainList.setSelectedIndices(nArray);
        this.updateView();
    }

    public Object[] getSelectedValues() {
        return this.mainList.getSelectedValues();
    }

    public Object getSelectedValue() {
        return this.mainList.getSelectedValue();
    }

    public void setSelectedValue(Object object, boolean bl) {
        this.mainList.setSelectedValue(object, bl);
        this.updateView();
    }

    protected String paramString() {
        return super.paramString() + ", the list is: " + this.mainList;
    }

    protected SelectionButton initButton(SelectionButton selectionButton, String string) {
        if (selectionButton != null) {
            this.buttonPanel.add(selectionButton);
            selectionButton.addActionListener(this.eventHandler);
            selectionButton.setToolTipText(string);
        }
        return selectionButton;
    }

    protected void init() {
        this.updateView();
    }

    protected void updateView() {
        ListModel listModel = this.mainList.getModel();
        int[] nArray = this.mainList.getSelectedIndices();
        Vector vector = new Vector(listModel.getSize() - nArray.length);
        Vector vector2 = new Vector(nArray.length);
        int n = 0;
        while (n < listModel.getSize()) {
            if (this.mainList.isSelectedIndex(n)) {
                vector2.addElement(listModel.getElementAt(n));
            } else {
                vector.addElement(listModel.getElementAt(n));
            }
            ++n;
        }
        this.sourceList.setListData(vector);
        this.selectionList.setListData(vector2);
        this.updateButtons();
    }

    public void updateButtons() {
        this.selectItemButton.setEnabled(!this.sourceList.isSelectionEmpty());
        this.selectAllButton.setEnabled(this.sourceList.getModel().getSize() > 0);
        this.deselectItemButton.setEnabled(!this.selectionList.isSelectionEmpty());
        this.deselectAllButton.setEnabled(this.selectionList.getModel().getSize() > 0);
    }

    public static final Dimension getButtonSize() {
        return new Dimension(32, 32);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.sourcePane.getPreferredSize();
        Dimension dimension2 = this.selectionPane.getPreferredSize();
        Dimension dimension3 = this.buttonPanel.getPreferredSize();
        int n = dimension3.width + 2 * this.getListPreferredWidth();
        int n2 = Math.max(dimension3.height, Math.max(dimension.height, dimension2.height));
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.sourceList.getMinimumSize();
        Dimension dimension2 = this.selectionList.getMinimumSize();
        Dimension dimension3 = this.buttonPanel.getMinimumSize();
        int n = dimension3.width + dimension.width + dimension2.width;
        int n2 = Math.max(dimension3.height, Math.max(dimension.height, dimension2.height));
        return new Dimension(n, n2);
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.sourceList.getMaximumSize();
        Dimension dimension2 = this.selectionList.getMaximumSize();
        Dimension dimension3 = this.buttonPanel.getMaximumSize();
        int n = dimension3.width + dimension.width + dimension2.width;
        int n2 = Math.max(dimension3.height, Math.max(dimension.height, dimension2.height));
        return new Dimension(n, n2);
    }

    public void paint(Graphics graphics) {
        this.lastFontMetrics = graphics.getFontMetrics();
        super.paint(graphics);
    }

    public int getListPreferredWidth() {
        ListModel listModel = this.mainList.getModel();
        int n = 0;
        if (this.lastFontMetrics != null) {
            int n2 = 0;
            while (n2 < listModel.getSize()) {
                Object e = listModel.getElementAt(n2);
                if (e instanceof String) {
                    Math.max(this.lastFontMetrics.stringWidth((String)e), n);
                }
                ++n2;
            }
        }
        return n == 0 ? this.defaultListSize.width : n;
    }

    protected void selectItem() {
        if (this.isEnabled()) {
            int[] nArray = this.mainList.getSelectedIndices();
            Object[] objectArray = this.sourceList.getSelectedValues();
            int[] nArray2 = new int[nArray.length + objectArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            ListModel listModel = this.mainList.getModel();
            int n = 0;
            int n2 = nArray.length;
            while (n < listModel.getSize()) {
                Object e = listModel.getElementAt(n);
                int n3 = 0;
                while (n3 < objectArray.length) {
                    if (e == objectArray[n3]) {
                        nArray2[n2++] = n;
                    }
                    ++n3;
                }
                ++n;
            }
            this.doUpdate(this.sourceList, objectArray, nArray2);
        }
    }

    protected void selectAll() {
        this.addSelectionInterval(0, this.mainList.getModel().getSize() - 1);
        this.updateView();
    }

    protected void deselectItem() {
        if (this.isEnabled()) {
            int[] nArray = this.mainList.getSelectedIndices();
            Object[] objectArray = this.selectionList.getSelectedValues();
            int[] nArray2 = new int[nArray.length - objectArray.length];
            ListModel listModel = this.mainList.getModel();
            int n = 0;
            int n2 = 0;
            while (n < nArray.length) {
                Object e = listModel.getElementAt(nArray[n]);
                boolean bl = false;
                int n3 = 0;
                while (n3 < objectArray.length) {
                    if (e == objectArray[n3]) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) {
                    nArray2[n2++] = nArray[n];
                }
                ++n;
            }
            this.doUpdate(this.selectionList, objectArray, nArray2);
        }
    }

    protected void doUpdate(JList jList, Object[] objectArray, int[] nArray) {
        if (objectArray == null || objectArray.length < 1) {
            return;
        }
        int n = this.getIndexFromItem(jList, objectArray[objectArray.length - 1]);
        this.mainList.setSelectedIndices(nArray);
        this.updateView();
        if ((n -= objectArray.length - 1) < jList.getModel().getSize()) {
            jList.setSelectedIndex(n);
        } else {
            jList.setSelectedIndex(jList.getModel().getSize() - 1);
        }
    }

    public int getIndexFromItem(JList jList, Object object) {
        ListModel listModel = jList.getModel();
        int n = 0;
        while (n < listModel.getSize()) {
            Object e = listModel.getElementAt(n);
            if (e.equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected void deselectAll() {
        this.mainList.clearSelection();
        this.updateView();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.sourceList.setEnabled(bl);
        this.selectionList.setEnabled(bl);
        if (bl) {
            this.updateButtons();
        } else {
            this.disableButtons();
        }
    }

    protected void disableButtons() {
        this.selectItemButton.setEnabled(false);
        this.selectAllButton.setEnabled(false);
        this.deselectItemButton.setEnabled(false);
        this.deselectAllButton.setEnabled(false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class MultiSelectListUI
    extends ComponentUI {
        protected MultiSelectListUI() {
        }
    }

    protected class JCFixedCenterLayout
    implements LayoutManager2,
    Serializable {
        protected int hgap;
        protected Component west;
        protected Component east;
        protected Component center;

        public JCFixedCenterLayout() {
            this(0);
        }

        public JCFixedCenterLayout(int n) {
            this.hgap = n;
        }

        public int getHgap() {
            return this.hgap;
        }

        public void setHgap(int n) {
            this.hgap = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLayoutComponent(Component component, Object object) {
            Object object2 = component.getTreeLock();
            synchronized (object2) {
                if (object != null && !(object instanceof String)) {
                    throw new IllegalArgumentException("Cannot add to layout: constraint must be a string or null");
                }
                this.addLayoutComponent((String)object, component);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLayoutComponent(String string, Component component) {
            Object object = component.getTreeLock();
            synchronized (object) {
                if (string == null || "Center".equals(string)) {
                    this.center = component;
                } else if ("East".equals(string)) {
                    this.east = component;
                } else if ("West".equals(string)) {
                    this.west = component;
                } else {
                    throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + string);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLayoutComponent(Component component) {
            Object object = component.getTreeLock();
            synchronized (object) {
                if (component == this.center) {
                    this.center = null;
                } else if (component == this.east) {
                    this.east = null;
                } else if (component == this.west) {
                    this.west = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension minimumLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension = new Dimension(0, 0);
                this.addMinimumSize(dimension, this.east);
                this.addMinimumSize(dimension, this.west);
                this.addMinimumSize(dimension, this.center);
                Insets insets = container.getInsets();
                dimension.width += insets.left + insets.right;
                dimension.height += insets.top + insets.bottom;
                Dimension dimension2 = dimension;
                return dimension2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension = new Dimension(0, 0);
                this.addPreferredSize(dimension, this.east);
                this.addPreferredSize(dimension, this.west);
                this.addPreferredSize(dimension, this.center);
                Insets insets = container.getInsets();
                dimension.width += insets.left + insets.right;
                dimension.height += insets.top + insets.bottom;
                Dimension dimension2 = dimension;
                return dimension2;
            }
        }

        public Dimension maximumLayoutSize(Container container) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.5f;
        }

        public void invalidateLayout(Container container) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n;
                Insets insets = container.getInsets();
                int n2 = insets.top;
                int n3 = container.getBounds().height - insets.bottom;
                int n4 = insets.left;
                int n5 = container.getBounds().width - insets.right;
                int n6 = n = (n5 - n4) / 2;
                if (this.center != null) {
                    Dimension dimension = this.center.getPreferredSize();
                    n = (n5 - n4 - dimension.width) / 2;
                    n6 = n + dimension.width;
                    this.center.setBounds(n, n2, dimension.width, n3 - n2);
                }
                if (this.west != null) {
                    this.west.setBounds(n4, n2, n - n4 - this.hgap, n3 - n2);
                }
                if (this.east != null) {
                    this.east.setBounds(n6 + this.hgap, n2, n5 - n6 - 2 * this.hgap, n3 - n2);
                }
            }
        }

        private void addMinimumSize(Dimension dimension, Component component) {
            if (component != null) {
                this.addSize(dimension, component.getMinimumSize());
            }
        }

        private void addPreferredSize(Dimension dimension, Component component) {
            if (component != null) {
                this.addSize(dimension, component.getPreferredSize());
            }
        }

        private void addSize(Dimension dimension, Dimension dimension2) {
            dimension.width += dimension2.width + this.hgap;
            dimension.height = Math.max(dimension2.height, dimension.height);
        }

        public String toString() {
            return this.getClass().getName() + "[hgap=" + this.hgap + "]";
        }
    }

    protected class SelectionButton
    extends JButton
    implements Serializable {
        SelectionButton(String string) {
            super(string);
            this.setEnabled(false);
            this.setMargin(new Insets(2, 2, 2, 2));
        }

        public Dimension getPreferredSize() {
            return JCMultiSelectList.getButtonSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    private class EventHandler
    implements ActionListener,
    ListSelectionListener,
    Serializable {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof SelectionButton) {
                SelectionButton selectionButton = (SelectionButton)actionEvent.getSource();
                if (selectionButton.equals(JCMultiSelectList.this.selectItemButton)) {
                    JCMultiSelectList.this.selectItem();
                } else if (selectionButton.equals(JCMultiSelectList.this.selectAllButton)) {
                    JCMultiSelectList.this.selectAll();
                } else if (selectionButton.equals(JCMultiSelectList.this.deselectItemButton)) {
                    JCMultiSelectList.this.deselectItem();
                } else if (selectionButton.equals(JCMultiSelectList.this.deselectAllButton)) {
                    JCMultiSelectList.this.deselectAll();
                }
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == JCMultiSelectList.this.mainList) {
                JCMultiSelectList.this.fireSelectionValueChanged(listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), listSelectionEvent.getValueIsAdjusting());
            }
            JCMultiSelectList.this.updateButtons();
        }
    }
}

