/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.render;

import com.klg.jclass.page.JCPageTable;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.Markup;
import com.klg.jclass.page.render.FlowMarker;
import com.klg.jclass.page.render.Render;
import com.klg.jclass.table.TableDataModel;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Iterator;

public class TableMarker
extends Render
implements Cloneable,
FlowMarker {
    protected JCPageTable table;
    protected int firstRow;
    protected int firstColumn;
    protected JCTextStyle style;
    protected int alignment;

    public TableMarker() {
        this(null, null, -1, -1);
    }

    public TableMarker(JCPageTable jCPageTable) {
        this(jCPageTable, null, -1, -1);
    }

    public TableMarker(JCPageTable jCPageTable, JCTextStyle jCTextStyle) {
        this(jCPageTable, jCTextStyle, -1, -1);
    }

    public TableMarker(JCPageTable jCPageTable, int n, int n2) {
        this(jCPageTable, null, -1, -1);
    }

    public TableMarker(JCPageTable jCPageTable, JCTextStyle jCTextStyle, int n, int n2) {
        this.table = jCPageTable;
        this.style = jCTextStyle;
        this.firstRow = n;
        this.firstColumn = n2;
    }

    public JCPageTable getTable() {
        return this.table;
    }

    public void setTable(JCPageTable jCPageTable) {
        this.table = jCPageTable;
    }

    public int getAlignment() {
        return this.table.getAlignment();
    }

    public boolean isAtomic() {
        return true;
    }

    public void draw(Graphics2D graphics2D) {
        if (!(graphics2D instanceof Markup)) {
            return;
        }
        if (this.firstRow != -1 || this.firstColumn != -1) {
            return;
        }
        Markup markup = (Markup)((Object)graphics2D);
        markup.startTable(this.table.getColumnCount());
        if (this.table.hasHeaders()) {
            JCPageTable jCPageTable = this.table.getHeaders();
            this.outputRows(markup, jCPageTable);
        }
        this.outputRows(markup, this.table);
        markup.endTable();
    }

    private void outputRows(Markup markup, JCPageTable jCPageTable) {
        int n = -1;
        int n2 = -1;
        TableDataModel tableDataModel = jCPageTable.getTableData();
        Iterator iterator = jCPageTable.getRowList().iterator();
        while (iterator.hasNext()) {
            ++n;
            n2 = -1;
            markup.startRow();
            JCPageTable.Row row = (JCPageTable.Row)iterator.next();
            if (row == null) {
                markup.endRow();
                continue;
            }
            Iterator iterator2 = row.getCellList().iterator();
            while (iterator2.hasNext()) {
                Object object;
                ++n2;
                JCPageTable.Cell cell = (JCPageTable.Cell)iterator2.next();
                if (cell == null || !cell.isSpanned()) {
                    markup.startCell("left", jCPageTable.isHeader());
                } else {
                    object = cell.getSpanOrigin();
                    if (((Point)object).y != n && ((Point)object).x != n2) continue;
                    markup.startCell("left", jCPageTable.isHeader(), cell.getSpanRows(), cell.getSpanColumns());
                }
                if (cell != null && cell.getFrameRaw() != null) {
                    cell.getFrameRaw().draw((Graphics2D)((Object)markup));
                } else if (tableDataModel != null) {
                    object = tableDataModel.getTableDataItem(n, n2);
                    if (object == null) {
                        markup.endCell(jCPageTable.isHeader());
                        continue;
                    }
                    ((Graphics2D)((Object)markup)).drawString(object.toString(), 0.0f, 0.0f);
                }
                markup.endCell(jCPageTable.isHeader());
            }
            markup.endRow();
        }
    }

    public Object clone() {
        TableMarker tableMarker = (TableMarker)super.clone();
        return tableMarker;
    }
}

