/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.render;

import com.klg.jclass.page.JCUnit;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public abstract class Render
implements Cloneable {
    protected JCUnit.Point origin = new JCUnit.Point();
    protected JCUnit.Dimension bounds = new JCUnit.Dimension();
    protected int layoutStatus = 1;
    public static final int LAYOUT_PASS_0 = 1;
    public static final int LAYOUT_PASS_1 = 2;
    public static final int LAYOUT_PASS_2 = 3;
    public static final int LAYOUT_COMPLETE = 4;

    public JCUnit.Point getLocation() {
        return this.origin;
    }

    public void setLocation(JCUnit.Point point) {
        this.origin = (JCUnit.Point)point.clone();
    }

    public JCUnit.Dimension getSize() {
        return this.bounds;
    }

    public void setSize(JCUnit.Dimension dimension) {
        this.bounds = (JCUnit.Dimension)dimension.clone();
    }

    public int getLayoutStatus() {
        return this.layoutStatus;
    }

    public void setLayoutStatus(int n) {
        if (n <= 0 || n > 4) {
            throw new IllegalArgumentException("Layout status not valid");
        }
        this.layoutStatus = n;
    }

    public abstract boolean isAtomic();

    public Object clone() {
        Render render;
        try {
            render = (Render)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        render.bounds = (JCUnit.Dimension)this.bounds.clone();
        render.origin = (JCUnit.Point)this.origin.clone();
        return render;
    }

    public static boolean isLayoutLower(int n, int n2) {
        if (n <= 0 || n > 4 || n2 <= 0 || n2 > 4) {
            throw new IllegalArgumentException("Layout status not valid");
        }
        return n > n2;
    }

    public void draw(Graphics2D graphics2D) {
        double d = JCUnit.getAsPoints(this.origin.units, this.origin.x);
        double d2 = JCUnit.getAsPoints(this.origin.units, this.origin.y);
        double d3 = JCUnit.getAsPoints(this.bounds.units, this.bounds.width);
        double d4 = JCUnit.getAsPoints(this.bounds.units, this.bounds.height);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        graphics2D.setColor(Color.gray);
        graphics2D.fill(double_);
    }
}

