/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.pcl;

import com.klg.jclass.page.EPSImage;
import com.klg.jclass.page.Graphics2DBase;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.pcl.CharSetEntryPCL;
import com.klg.jclass.page.pcl.FontMetricsPCL;
import com.klg.jclass.page.pcl.FontPCL;
import com.klg.jclass.page.pcl.JCPCLPrinter;
import com.klg.jclass.page.pcl.KernPairPCL;
import com.klg.jclass.page.pcl.TypeFacePCL;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;

public class Graphics2DPCL
extends Graphics2DBase
implements Cloneable {
    protected double base_x = 0.0;
    protected double base_y = 0.0;
    protected Color currentTextColor = null;
    protected Color currentLineColor = null;
    protected Color currentFillColor = null;
    protected boolean textColorChanged = true;
    protected boolean lineColorChanged = true;
    protected boolean fillColorChanged = true;
    protected String symbolSet = new String("");
    protected JCPCLPrinter printer;
    protected static double DECIPOINT = 10.0;
    protected boolean landscapeMode = false;
    protected boolean resetFont = true;
    protected static int[] greyscale = new int[]{0, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 100};
    protected static final int MOVE = 0;
    protected static final int INTERSECT = 1;
    protected static final int PUSH = 0;
    protected static final int REPLACE = 1;

    public Graphics2DPCL(OutputStream outputStream) {
        super(outputStream);
        this.printer = null;
    }

    public Graphics2DPCL(OutputStream outputStream, JCPCLPrinter jCPCLPrinter) {
        super(outputStream);
        this.printer = jCPCLPrinter;
    }

    public Object clone() {
        Graphics2DPCL graphics2DPCL;
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        try {
            graphics2DPCL = (Graphics2DPCL)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        graphics2DPCL.transform = new AffineTransform(this.transform);
        graphics2DPCL.clip = (Rectangle2D)rectangle2D.clone();
        return graphics2DPCL;
    }

    public void drawString(String string, float f, float f2) {
        if (string == null || string.equals("")) {
            return;
        }
        int n = 0;
        int n2 = string.length();
        CharSetEntryPCL charSetEntryPCL = null;
        this.updateContext();
        Rectangle rectangle = this.getClipBounds();
        if ((double)f < ((RectangularShape)rectangle).getX() || (double)f2 < ((RectangularShape)rectangle).getY() || (double)f > ((RectangularShape)rectangle).getX() + ((RectangularShape)rectangle).getWidth() || (double)f2 > ((RectangularShape)rectangle).getY() + ((RectangularShape)rectangle).getHeight()) {
            return;
        }
        if (this.isGL2Mode()) {
            this.exitGl2Mode();
        }
        this.outputTextColor();
        FontPCL fontPCL = (FontPCL)this.getFont();
        if (this.resetFont || this.currentFont == null || !this.currentFont.equals(fontPCL)) {
            this.outputFontDefinition(fontPCL);
            this.resetFont = false;
            this.currentFont = fontPCL;
        }
        if (this.underline) {
            this.output("\u001b&d0D");
        }
        f = (float)((this.base_x + (double)f) * DECIPOINT);
        f2 = (float)((this.base_y + (double)f2) * DECIPOINT);
        this.initializeOutString(f, f2);
        FontMetricsPCL fontMetricsPCL = new FontMetricsPCL(fontPCL);
        n = 0;
        while (n < n2) {
            Integer n3;
            KernPairPCL kernPairPCL;
            char c = string.charAt(n);
            CharSetEntryPCL charSetEntryPCL2 = fontPCL.getCharMetric(c);
            if (charSetEntryPCL != null && charSetEntryPCL.getKerns().size() > 0 && (kernPairPCL = charSetEntryPCL.getKernPair(n3 = new Integer(charSetEntryPCL2.getIndex()))) != null && kernPairPCL.kernValue != 0) {
                this.printOutString();
                double d = fontMetricsPCL.convertToDecipoints(kernPairPCL.kernValue, fontPCL.getSize());
                this.out.x += d;
            }
            double d = fontMetricsPCL.convertToDecipoints(charSetEntryPCL2.metrics.getHorizontalEscapement(), fontPCL.getSize());
            this.appendToOutString(c, d);
            charSetEntryPCL = charSetEntryPCL2;
            ++n;
        }
        this.printOutString();
        if (this.underline) {
            this.output("\u001b&d@");
        }
    }

    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }

    public void translate(double d, double d2) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.transform.translate(d, d2);
        double d3 = rectangle2D.getX() - d;
        double d4 = rectangle2D.getY() - d2;
        double d5 = rectangle2D.getWidth();
        double d6 = rectangle2D.getHeight();
        rectangle2D.setRect(d3, d4, d5, d6);
        this.translateInternal(d, d2);
    }

    public void scale(double d, double d2) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.transform.scale(d, d2);
        double d3 = rectangle2D.getX() / d;
        double d4 = rectangle2D.getY() / d2;
        double d5 = rectangle2D.getWidth() / d;
        double d6 = rectangle2D.getHeight() / d2;
        rectangle2D.setRect(d3, d4, d5, d6);
    }

    protected void restoreTranslation() {
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clipRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void clipRect(double d, double d2, double d3, double d4) {
        this.setClipInternal(d, d2, d3, d4, 1);
    }

    protected void restoreClip() {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
    }

    protected void setCurrentClip(Rectangle2D rectangle2D) {
        if (this.isGL2Mode()) {
            double d = (rectangle2D.getX() + this.base_x) * DECIPOINT;
            double d2 = d + rectangle2D.getWidth() * DECIPOINT;
            double d3 = (rectangle2D.getY() + this.base_y) * DECIPOINT;
            double d4 = d3 + rectangle2D.getHeight() * DECIPOINT;
            d = this.adjustPoint(d, d4, this.landscapeMode);
            d2 = this.adjustPoint(d2, d3, this.landscapeMode);
            this.output("IW" + this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(d4) + " " + this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3));
        }
        this.clip = rectangle2D;
    }

    public void setFont(Font font) {
        this.updateContext();
        if (this.isGL2Mode()) {
            this.exitGl2Mode();
        }
        if (!(font instanceof FontPCL)) {
            font = FontPCL.getNativeFont(font);
        }
        if (this.currentFont != null && this.currentFont.equals(font) && !this.resetFont) {
            return;
        }
        this.resetFont = false;
        this.currentFont = font;
        this.fontChanged = true;
        this.outputFontDefinition(font);
    }

    private void outputFontDefinition(Font font) {
        FontPCL fontPCL = (FontPCL)font;
        TypeFacePCL typeFacePCL = fontPCL.getTypeface();
        if (!this.symbolSet.equals(typeFacePCL.symbol.latin1Set)) {
            this.output("\u001b(" + typeFacePCL.symbol.latin1Set);
            this.symbolSet = new String(typeFacePCL.symbol.latin1Set);
        }
        String string = (typeFacePCL.getStyle() & 0x40) == 0 ? new String("\u001b(s1p") : new String("\u001b(s0p" + fontPCL.getCharsPerInch() + "h");
        string = string + fontPCL.getSize() + "v";
        string = (typeFacePCL.getStyle() & 4) == 0 ? string + "0s" : string + "1s";
        string = (typeFacePCL.getStyle() & 2) == 0 ? string + "0b" : string + "3b";
        string = string + typeFacePCL.general.typefaceSelectionString + "T";
        this.output(string);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.setupGraphics(false);
        int n2 = nArray[0];
        int n3 = nArray2[0];
        n2 = (int)((this.base_x + (double)n2) * DECIPOINT);
        n3 = (int)((this.base_y + (double)n3) * DECIPOINT);
        n2 = (int)this.adjustPoint(n2, n3, this.landscapeMode);
        this.output("PU" + n2 + "," + n3 + ";");
        this.printPoly(nArray, nArray2, n);
        this.cleanupGraphics();
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        boolean bl = true;
        this.printPolygon(nArray, nArray2, n, bl);
    }

    public FontMetrics getFontMetrics(Font font) {
        if (!(font instanceof FontPCL)) {
            font = FontPCL.getNativeFont(font);
        }
        return new FontMetricsPCL((FontPCL)font);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        boolean bl = false;
        this.printPolygon(nArray, nArray2, n, bl);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        this.updateContext();
        if (image instanceof EPSImage) {
            Color color2 = this.getColor();
            this.setColor(Color.lightGray);
            this.fillRect(n, n2, n3, n4);
            this.setColor(color2);
            return true;
        }
        return this.drawJavaImage(image, n, n2, n3, n4, color, imageObserver);
    }

    public void startContext() {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.resetFont = true;
        this.colorChanged = true;
    }

    public void endContext() {
    }

    protected void setClipInternal(double d, double d2, double d3, double d4, int n) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        if (n == 1) {
            if (rectangle2D.getX() > d) {
                d3 -= rectangle2D.getX() - d;
                d = rectangle2D.getX();
            }
            if (rectangle2D.getY() > d2) {
                d4 -= rectangle2D.getY() - d2;
                d2 = rectangle2D.getY();
            }
            if (d + d3 > rectangle2D.getX() + rectangle2D.getWidth()) {
                d3 = rectangle2D.getX() + rectangle2D.getWidth() - d;
            }
            if (d2 + d4 > rectangle2D.getY() + rectangle2D.getHeight()) {
                d4 = rectangle2D.getY() + rectangle2D.getHeight() - d2;
            }
        }
        rectangle2D.setRect(d, d2, d3, d4);
        if (this.isContextCurrent()) {
            this.setCurrentClip(rectangle2D);
        }
    }

    protected void translateInternal(double d, double d2) {
        this.base_x += d;
        this.base_y += d2;
    }

    public void drawArcPW(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        boolean bl;
        double d7 = 1.0;
        double d8 = d3 / 2.0;
        double d9 = d4 / 2.0;
        boolean bl2 = bl = d3 != d4;
        if (d3 == 0.0) {
            this.drawLinePW(d, d2 + d9, d, d2 - d9);
            return;
        }
        if (d4 == 0.0) {
            this.drawLinePW(d + d8, d2, d - d8, d2);
            return;
        }
        this.setupGraphics(false);
        d = (d + this.base_x + d8) * DECIPOINT;
        d2 = (d2 + this.base_y + d9) * DECIPOINT;
        d8 *= DECIPOINT;
        d9 *= DECIPOINT;
        d = this.adjustPoint(d, d2, this.landscapeMode);
        if (bl) {
            d7 = d4 / d3;
            this.output("SC0,1.411111,0,-" + d7 * 1.411111 + ",2;");
            d2 /= d7;
        }
        if (Math.abs(d6) < 360.0) {
            double d10 = d5 / 180.0 * Math.PI;
            double d11 = d + d8 * Math.cos(d10);
            double d12 = d2 + d9 * Math.sin(d10);
            if (bl) {
                d12 /= d7;
            }
            this.output("PU" + this.truncateDecimalDigits(d11) + "," + this.truncateDecimalDigits(d12) + ";PD;AA" + this.truncateDecimalDigits(d) + "," + this.truncateDecimalDigits(d2) + "," + this.truncateDecimalDigits(d6) + ";");
        } else {
            this.output("PU" + this.truncateDecimalDigits(d) + "," + this.truncateDecimalDigits(d2) + ";CI" + this.truncateDecimalDigits(d8) + ";");
        }
        if (bl) {
            this.output("SC0,1.411111,0,-1.4111111,2");
        }
        this.cleanupGraphics();
    }

    public void fillArcPW(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        boolean bl;
        double d7 = d3 / 2.0;
        double d8 = d4 / 2.0;
        boolean bl2 = bl = d3 != d4;
        if (d3 == 0.0) {
            this.drawLinePW(d, d2 + d8, d, d2 - d8);
            return;
        }
        if (d4 == 0.0) {
            this.drawLinePW(d + d7, d2, d - d7, d2);
            return;
        }
        this.setupGraphics(true);
        d = (d + this.base_x + d7) * DECIPOINT;
        d2 = (d2 + this.base_y + d8) * DECIPOINT;
        d7 *= DECIPOINT;
        d8 *= DECIPOINT;
        d = this.adjustPoint(d, d2, this.landscapeMode);
        if (bl) {
            double d9 = d4 / d3;
            this.output("SC0,1.411111,0,-" + d9 * 1.411111 + ",2;");
            d2 /= d9;
        }
        this.output("PU" + this.truncateDecimalDigits(d) + "," + this.truncateDecimalDigits(d2) + ";");
        if (Math.abs(d6) < 360.0) {
            this.output("WG" + d7 + "," + -d5 + "," + -d6 + ";");
        } else {
            this.output("PM0;CI" + d7 + ";PM2;FP;");
        }
        if (bl) {
            this.output("SC0,1.411111,0,-1.4111111,2");
        }
        this.cleanupGraphics();
    }

    public void fillRectPW(double d, double d2, double d3, double d4) {
        this.setupGraphics(true);
        d *= DECIPOINT;
        d2 *= DECIPOINT;
        d = this.base_x * DECIPOINT + d;
        d2 = this.base_y * DECIPOINT + d2;
        d = this.adjustPoint(d, d2, this.landscapeMode);
        this.output("PU" + this.truncateDecimalDigits(d) + "," + this.truncateDecimalDigits(d2) + ";RR" + this.truncateDecimalDigits(d3 *= DECIPOINT) + "," + this.truncateDecimalDigits(d4 *= DECIPOINT) + ";");
        this.cleanupGraphics();
    }

    public void setClipPW(double d, double d2, double d3, double d4) {
        this.setClipInternal(d, d2, d3, d4, 0);
    }

    public void drawRectPW(double d, double d2, double d3, double d4) {
        this.setupGraphics(false);
        d *= DECIPOINT;
        d2 *= DECIPOINT;
        d = this.base_x * DECIPOINT + d;
        d2 = this.base_y * DECIPOINT + d2;
        d = this.adjustPoint(d, d2, this.landscapeMode);
        this.output("PU" + this.truncateDecimalDigits(d) + "," + this.truncateDecimalDigits(d2) + ";ER" + this.truncateDecimalDigits(d3 *= DECIPOINT) + "," + this.truncateDecimalDigits(d4 *= DECIPOINT) + ";");
        this.cleanupGraphics();
    }

    public void drawLinePW(double d, double d2, double d3, double d4) {
        this.setupGraphics(false);
        d = (d + this.base_x) * DECIPOINT;
        d2 = (d2 + this.base_y) * DECIPOINT;
        d3 = (d3 + this.base_x) * DECIPOINT;
        d4 = (d4 + this.base_y) * DECIPOINT;
        d = this.adjustPoint(d, d2, this.landscapeMode);
        d3 = this.adjustPoint(d3, d4, this.landscapeMode);
        this.output("PU" + this.truncateDecimalDigits(d) + "," + this.truncateDecimalDigits(d2) + ";PD" + this.truncateDecimalDigits(d3) + "," + this.truncateDecimalDigits(d4) + ";");
        this.cleanupGraphics();
    }

    public void drawRoundRectPW(double d, double d2, double d3, double d4, double d5, double d6) {
        this.drawRRect(d, d2, d3, d4, d5, d6, "EP;");
    }

    public void fillRoundRectPW(double d, double d2, double d3, double d4, double d5, double d6) {
        this.drawRRect(d, d2, d3, d4, d5, d6, "FP;");
    }

    public Shape getClip() {
        Shape shape = super.getClip() instanceof Rectangle2D ? super.getClip() : super.getClip().getBounds2D();
        return shape;
    }

    protected void exitGl2Mode() {
        if (this.printer != null) {
            this.printer.isGL2Mode = false;
        }
        this.output("\u001b%0A");
    }

    protected void initialiseClip(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = (Rectangle2D)this.getClip();
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        this.base_x = d;
        this.base_y = d2;
        rectangle2D2.setRect(0.0, 0.0, d3, d4);
    }

    protected void appendToOutString(char c, double d) {
        this.out.text.append(c);
        this.out.width += d;
    }

    protected double adjustPoint(double d, double d2, boolean bl) {
        return d - 180.0;
    }

    protected void printOutString() {
        double d = this.out.x;
        double d2 = this.out.y;
        d = this.adjustPoint(d, d2, this.landscapeMode);
        try {
            String string = new String("\u001b&a" + this.truncateDecimalDigits(d) + "h" + this.truncateDecimalDigits(d2) + "V" + this.out.text);
            this.os.write(string.getBytes());
            this.os.write(10);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.out.x += this.out.width;
        this.out.width = 0.0;
        this.out.text.delete(0, this.out.text.length());
    }

    protected void outputGraphicsColor(boolean bl) {
        if (this.colorChanged) {
            this.textColorChanged = true;
            this.lineColorChanged = true;
            this.fillColorChanged = true;
            this.colorChanged = false;
        }
        Color color = this.getColor();
        if (bl) {
            if (color.equals(this.currentFillColor) && !this.fillColorChanged) {
                return;
            }
            this.currentFillColor = color;
            this.fillColorChanged = false;
        } else {
            if (color.equals(this.currentLineColor) && !this.lineColorChanged) {
                return;
            }
            this.currentLineColor = color;
            this.lineColorChanged = false;
        }
        double d = (double)color.getRed() / 255.0;
        double d2 = (double)color.getGreen() / 255.0;
        double d3 = (double)color.getBlue() / 255.0;
        int n = this.convertRGBToGrey(d, d2, d3);
        if (bl) {
            this.output("FT10," + n + ";");
        } else if (n == 100) {
            this.output("SV0;");
        } else {
            this.output("SV1," + n + ";");
        }
    }

    protected void outputTextColor() {
        Color color;
        if (this.colorChanged) {
            this.textColorChanged = true;
            this.lineColorChanged = true;
            this.fillColorChanged = true;
            this.colorChanged = false;
        }
        if ((color = this.getColor()).equals(this.currentTextColor) && !this.textColorChanged) {
            return;
        }
        this.currentTextColor = color;
        this.textColorChanged = false;
        double d = (double)color.getRed() / 255.0;
        double d2 = (double)color.getGreen() / 255.0;
        double d3 = (double)color.getBlue() / 255.0;
        int n = this.convertRGBToGrey(d, d2, d3);
        this.output("\u001b*c" + n + "G");
    }

    protected int convertRGBToGrey(double d, double d2, double d3) {
        float f = (float)(0.3 * d + 0.59 * d2 + 0.11 * d3);
        int n = 100 - Math.round(f * 100.0f);
        return greyscale[n];
    }

    protected void enterGl2Mode(Rectangle2D rectangle2D) {
        if (this.printer != null) {
            this.printer.isGL2Mode = true;
        }
        this.output("\u001b%0B");
        this.output("IN;SP1;TR0;");
        this.output("SC0,1.411111,0,-1.4111111,2");
        this.output("IR0,100,100,0");
        this.setCurrentClip(rectangle2D);
    }

    protected void setLineStroke() {
        if (!this.strokeChanged) {
            return;
        }
        float f = ((BasicStroke)this.currentStroke).getLineWidth();
        double d = JCUnit.getAsCentimeters(JCUnit.POINTS, f) * 10.0;
        if (d == 0.0) {
            this.output("PW;");
        } else {
            this.output("PW" + this.truncateDecimalDigits(d) + ";");
        }
        float[] fArray = ((BasicStroke)this.currentStroke).getDashArray();
        float f2 = ((BasicStroke)this.currentStroke).getDashPhase();
        if (fArray != null) {
            double d2 = JCUnit.getAsCentimeters(JCUnit.POINTS, fArray[0]) * 20.0;
            this.output("LT2," + this.truncateDecimalDigits(d2) + ",1;");
            this.dashMode = true;
        } else if (this.dashMode) {
            this.output("LT;");
            this.dashMode = false;
        }
        this.strokeChanged = false;
    }

    protected void traceRectanglePath(double d, double d2, double d3, double d4, double d5) {
        double d6 = d + d5;
        double d7 = d2 + d5;
        double d8 = d2 + d4 - d5;
        double d9 = d + d3 - d5;
        double d10 = d2 + d4;
        double d11 = d + d3;
        this.output("PU" + d6 + "," + d2 + ";");
        this.output("PM0;PD;AA" + d6 + "," + d7 + "," + "-90;");
        this.output("PD" + d + "," + d8 + ";" + "AA" + d6 + "," + d8 + ",-90;");
        this.output("PD" + d9 + "," + d10 + ";" + "AA" + d9 + "," + d8 + ",-90;");
        this.output("PD" + d11 + "," + d7 + ";" + "AA" + d9 + "," + d7 + ",-90;PM2;");
    }

    public void drawRRect(double d, double d2, double d3, double d4, double d5, double d6, String string) {
        double d7;
        if (d5 <= 0.0 || d6 <= 0.0) {
            if (string.equals("EP")) {
                this.drawRectPW(d, d2, d3, d4);
            } else {
                this.fillRectPW(d, d2, d3, d4);
            }
        }
        this.setupGraphics(string.equals("FP"));
        d = (d + this.base_x) * DECIPOINT;
        d2 = (d2 + this.base_y) * DECIPOINT;
        d3 *= DECIPOINT;
        d4 *= DECIPOINT;
        d = this.adjustPoint(d, d2, this.landscapeMode);
        if (d5 != d6) {
            d7 = d6 / d5;
            this.output("SC0,1,0," + d7 + ",2;");
            d2 /= d7;
            d4 /= d7;
        }
        this.traceRectanglePath(d, d2, d3, d4, d5 * DECIPOINT);
        this.output(string);
        if (d5 != d6) {
            d7 = d5 / d6;
            this.output("SC0,1,0," + d7 + ",2;");
        }
        this.cleanupGraphics();
    }

    protected void printPoly(int[] nArray, int[] nArray2, int n) {
        int n2 = 1;
        while (n2 < n) {
            int n3 = nArray[n2];
            int n4 = nArray2[n2];
            n3 = (int)((this.base_x + (double)n3) * DECIPOINT);
            n4 = (int)((this.base_y + (double)n4) * DECIPOINT);
            n3 = (int)this.adjustPoint(n3, n4, this.landscapeMode);
            this.output("PD" + n3 + "," + n4 + ";");
            ++n2;
        }
    }

    protected void printPolygon(int[] nArray, int[] nArray2, int n, boolean bl) {
        this.setupGraphics(bl);
        int n2 = nArray[0];
        int n3 = nArray2[0];
        n2 = (int)((this.base_x + (double)n2) * DECIPOINT);
        n3 = (int)((this.base_y + (double)n3) * DECIPOINT);
        n2 = (int)this.adjustPoint(n2, n3, this.landscapeMode);
        this.output("PU" + n2 + "," + n3 + ";" + "\nPM0;");
        this.printPoly(nArray, nArray2, n);
        if (bl) {
            if (this.getWindingRule() == 0) {
                this.output("PM2;\nFP;");
            } else {
                this.output("PM2;\nFP1;");
            }
        } else {
            this.output("PM2;\nEP;");
        }
        this.cleanupGraphics();
    }

    protected void setupGraphics(boolean bl) {
        if (!this.isContextCurrent()) {
            this.updateContext();
        }
        if (!this.isGL2Mode()) {
            Rectangle rectangle = this.getClipBounds();
            this.enterGl2Mode(rectangle);
        }
        if (!bl) {
            this.setLineStroke();
        }
        this.outputGraphicsColor(bl);
    }

    protected void cleanupGraphics() {
        if (this.printer == null) {
            this.exitGl2Mode();
        }
    }

    protected void terminateRun(int n, int n2, int n3) {
        this.output("PU" + (n - n2) + "," + n3 + ";RR" + n2 + ",1;");
    }

    protected boolean drawJavaImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        int[] nArray = new int[n5 * n6];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n5, n6, nArray, 0, n5);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return false;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return false;
        }
        if (this.isGL2Mode()) {
            this.exitGl2Mode();
        }
        n = (int)((this.base_x + (double)n) * DECIPOINT);
        n2 = (int)((this.base_y + (double)n2) * DECIPOINT);
        n3 = (int)((double)n3 * DECIPOINT);
        n4 = (int)((double)n4 * DECIPOINT);
        this.output("\u001b*c" + n3 + "x" + n4 + "Y");
        n = (int)this.adjustPoint(n, n2, this.landscapeMode);
        this.output("\u001b*p" + n + "x" + n2 + "Y");
        this.output("\u001b*c0T");
        this.output("\u001b%0B");
        this.output("IN;SP1;TR0;");
        this.output("SC0," + pixelGrabber.getWidth() + ",0," + pixelGrabber.getHeight() + ";");
        this.output("IR0,100,100,0;");
        int n7 = -2;
        int n8 = pixelGrabber.getWidth();
        int n9 = pixelGrabber.getHeight();
        int n10 = 0;
        while (n10 < n9) {
            int n11 = 0;
            int n12 = 0;
            while (n12 < n8) {
                int n13 = nArray[n10 * n8 + n12];
                int n14 = n13 >> 16 & 0xFF;
                int n15 = n13 >> 8 & 0xFF;
                int n16 = n13 & 0xFF;
                int n17 = this.convertRGBToGrey((double)n14 / 255.0, (double)n15 / 255.0, (double)n16 / 255.0);
                if (n17 == -1) {
                    if (n11 > 0) {
                        this.terminateRun(n12, n11, n10);
                        n11 = 0;
                    }
                } else {
                    if (n17 != n7) {
                        if (n11 > 0) {
                            this.terminateRun(n12, n11, n10);
                            n11 = 0;
                        }
                        StringBuffer stringBuffer = new StringBuffer("FT10,");
                        stringBuffer.append(n17);
                        this.output(stringBuffer.toString());
                        n7 = n17;
                    }
                    ++n11;
                }
                ++n12;
            }
            if (n11 > 0) {
                this.terminateRun(n12, n11, n10);
            }
            ++n10;
        }
        this.output("\u001b%0A");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u001b*p0x0Y\n\u001b*c");
        double d = this.printer.currentPageSize.getX() + this.printer.currentPageSize.getWidth();
        stringBuffer.append((int)(d * DECIPOINT));
        stringBuffer.append("x");
        double d2 = this.printer.currentPageSize.getY() + this.printer.currentPageSize.getHeight();
        stringBuffer.append((int)(d2 * DECIPOINT));
        stringBuffer.append("y0T");
        this.output(stringBuffer.toString());
        return true;
    }

    protected boolean isGL2Mode() {
        return this.printer != null && this.printer.isGL2Mode;
    }
}

