/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.awt;

import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCPage;
import com.klg.jclass.page.awt.JCAWTScreenPrinter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class JCPrintPage
extends JComponent {
    protected JCDocument document;
    protected int page = -1;
    protected Dimension preferredDimension;
    protected Color bgColor = Color.white;
    protected boolean requiresRepaint = true;
    protected Image image;
    protected JCAWTScreenPrinter printer;

    public JCPrintPage(JCAWTScreenPrinter jCAWTScreenPrinter) {
        this.printer = jCAWTScreenPrinter;
        this.preferredDimension = new Dimension(612, 792);
    }

    public JCPrintPage(JCAWTScreenPrinter jCAWTScreenPrinter, Dimension dimension) {
        this.printer = jCAWTScreenPrinter;
        this.preferredDimension = dimension;
    }

    public void setBackground(Color color) {
        this.bgColor = color;
    }

    public void setDocument(JCDocument jCDocument) {
        this.requiresRepaint = true;
        this.document = jCDocument;
    }

    public void setPage(int n) {
        this.page = n;
        this.requiresRepaint = true;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.preferredDimension;
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredDimension = dimension;
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.document != null && this.page != -1) {
            if (this.requiresRepaint) {
                JCPage jCPage = (JCPage)this.document.getPages().get(this.page);
                Rectangle2D rectangle2D = jCPage.getPageSize();
                int n = (int)rectangle2D.getWidth();
                int n2 = (int)rectangle2D.getHeight();
                this.image = this.printer.getComponent().createImage(n, n2);
                Graphics graphics2 = this.image.getGraphics();
                graphics2.setColor(this.bgColor);
                graphics2.fillRect(0, 0, n, n2);
                this.printer.setGraphics((Graphics2D)graphics2);
                this.document.print(this.printer, this.page, this.page);
                this.printer.setGraphics(null);
                graphics.drawImage(this.image, 10, 10, this.printer.getComponent());
                this.requiresRepaint = false;
            } else if (this.image != null) {
                graphics.drawImage(this.image, 10, 10, this.printer.getComponent());
            }
        }
    }

    public void dispose() {
        this.document = null;
        this.image.flush();
        this.image = null;
    }
}

