/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.awt;

import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCPage;
import com.klg.jclass.page.JCPrinter;
import com.klg.jclass.page.awt.JCAWTPrinter;
import com.klg.jclass.page.awt.JCAWTScreenPrinter;
import com.klg.jclass.page.awt.JCPrintPage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JCAWTPreviewer
extends JDialog
implements WindowListener,
ActionListener {
    protected JButton firstButton;
    protected JButton prevButton;
    protected JButton nextButton;
    protected JButton lastButton;
    protected JButton printButton;
    protected JButton closeButton;
    protected JScrollPane pane;
    protected JLabel status;
    int currentPage = 0;
    protected JCAWTScreenPrinter printer;
    protected JCDocument document;
    protected JCPrintPage printPage;

    public JCAWTPreviewer(String string, JFrame jFrame, JCDocument jCDocument) {
        this(string, jFrame, jCDocument, new JCAWTScreenPrinter());
    }

    public JCAWTPreviewer(String string, JFrame jFrame, JCDocument jCDocument, JCPrinter jCPrinter) {
        super((Frame)jFrame, string);
        if (!(jCPrinter instanceof JCAWTScreenPrinter)) {
            throw new RuntimeException("Printer must be instance of JCAWTScreenPrinter");
        }
        this.printer = (JCAWTScreenPrinter)jCPrinter;
        this.document = jCDocument;
        this.printPage = (JCPrintPage)this.printer.getComponent();
        int n = this.getPageHeight() + 133;
        int n2 = this.getPageWidth() + 88;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (n > dimension.height) {
            n = dimension.height;
        }
        if (n2 > dimension.width) {
            n2 = dimension.width;
        }
        this.setSize(n2, n);
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 1, 1));
        this.firstButton = new JButton("First");
        jPanel.add(this.firstButton);
        this.firstButton.addActionListener(this);
        this.prevButton = new JButton("Previous");
        jPanel.add(this.prevButton);
        this.prevButton.addActionListener(this);
        this.nextButton = new JButton("Next");
        jPanel.add(this.nextButton);
        this.nextButton.addActionListener(this);
        this.lastButton = new JButton("Last");
        jPanel.add(this.lastButton);
        this.lastButton.addActionListener(this);
        this.printButton = new JButton("Print");
        jPanel.add(this.printButton);
        this.printButton.addActionListener(this);
        this.closeButton = new JButton("Close");
        jPanel.add(this.closeButton);
        this.closeButton.addActionListener(this);
        Dimension dimension2 = new Dimension((int)((double)this.getPageWidth() * 1.05), (int)((double)this.getPageHeight() * 1.05));
        this.pane = new JScrollPane();
        this.pane.setSize(dimension2);
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)this.pane, "Center");
        this.status = new JLabel("", 2);
        this.getContentPane().add((Component)this.status, "South");
        this.createPage(dimension2);
        this.addWindowListener(this);
    }

    public void createPage(Dimension dimension) {
        this.pane.setViewportView(this.printPage);
        this.printPage.setPreferredSize(dimension);
        this.printPage.setSize(dimension);
        this.printPage.setDocument(this.document);
        this.showPage(0);
    }

    public void showPage(int n) {
        if (n >= this.getNumPages() || n <= -1) {
            throw new RuntimeException("Page index out of range " + n);
        }
        this.currentPage = n;
        this.printPage.setPage(n);
        this.status.setText(this.currentPage + 1 + " of " + this.getNumPages() + ".");
    }

    void close() {
        this.setVisible(false);
        this.dispose();
    }

    public void dispose() {
        this.document = null;
        this.printer = null;
        this.printPage.dispose();
        this.printPage = null;
        this.pane.setViewportView(null);
        super.dispose();
    }

    protected int getNumPages() {
        return this.document.getPages().size();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.equals(this.firstButton)) {
                this.showPage(0);
            } else if (jButton.equals(this.prevButton)) {
                if (this.currentPage > 0) {
                    this.showPage(this.currentPage - 1);
                }
            } else if (jButton.equals(this.nextButton)) {
                if (this.currentPage < this.getNumPages() - 1) {
                    this.showPage(this.currentPage + 1);
                }
            } else if (jButton.equals(this.lastButton)) {
                this.showPage(this.getNumPages() - 1);
            } else if (jButton.equals(this.printButton)) {
                if (this.document != null) {
                    if (this.document.getPrinter() instanceof JCAWTScreenPrinter) {
                        JCAWTPrinter jCAWTPrinter;
                        JCPage jCPage = this.document.getFlow().getCurrentPage();
                        Rectangle2D rectangle2D = jCPage.getPageSize();
                        try {
                            jCAWTPrinter = new JCAWTPrinter(this.document.getTemplates());
                        }
                        catch (PrinterException printerException) {
                            return;
                        }
                        catch (JCAWTPrinter.PrinterJobCancelledException printerJobCancelledException) {
                            return;
                        }
                        jCAWTPrinter.getGraphics();
                        jCAWTPrinter.print(this.document);
                    } else if (this.document.getPrinter() instanceof JCAWTPrinter) {
                        this.document.print();
                    } else {
                        JFileChooser jFileChooser = new JFileChooser();
                        int n = jFileChooser.showSaveDialog(this);
                        if (n == 0) {
                            File file = jFileChooser.getSelectedFile();
                            FileOutputStream fileOutputStream = null;
                            OutputStream outputStream = null;
                            try {
                                fileOutputStream = new FileOutputStream(file);
                                outputStream = this.document.getPrinter().getOutputStream();
                                this.document.getPrinter().setOutputStream(fileOutputStream);
                                this.document.print();
                                fileOutputStream.flush();
                                ((OutputStream)fileOutputStream).close();
                                this.document.getPrinter().setOutputStream(outputStream);
                            }
                            catch (IOException iOException) {
                                this.document.getPrinter().setOutputStream(outputStream);
                                JOptionPane.showMessageDialog(null, iOException.toString(), "File error", 0);
                                return;
                            }
                        }
                    }
                }
            } else if (jButton.equals(this.closeButton)) {
                this.close();
            }
        }
    }

    public int getPageWidth() {
        return (int)this.document.getFlow().getCurrentPage().getPageSize().getWidth();
    }

    public int getPageHeight() {
        return (int)this.document.getFlow().getCurrentPage().getPageSize().getHeight();
    }

    public JCPrinter getPrinter() {
        return this.printer;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

