/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.adobe.postscript;

import com.klg.jclass.page.EPSImage;
import com.klg.jclass.page.Graphics2DBase;
import com.klg.jclass.page.adobe.postscript.CharMetricPS;
import com.klg.jclass.page.adobe.postscript.FontMetricsPS;
import com.klg.jclass.page.adobe.postscript.FontPS;
import com.klg.jclass.page.adobe.postscript.JCPostScriptPrinter;
import com.klg.jclass.page.adobe.postscript.PairKern;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class Graphics2DPS
extends Graphics2DBase {
    boolean fontWritten = false;
    protected static final char[] hd = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected int readAheadAmount = 1000;
    protected JCPostScriptPrinter printer = null;

    public Graphics2DPS(OutputStream outputStream) {
        super(outputStream);
    }

    public Graphics2DPS(OutputStream outputStream, JCPostScriptPrinter jCPostScriptPrinter) {
        super(outputStream);
        this.printer = jCPostScriptPrinter;
    }

    public void drawString(String string, float f, float f2) {
        double d;
        if (string == null || string.equals("")) {
            return;
        }
        this.updateContext();
        f2 = -f2;
        CharMetricPS charMetricPS = null;
        this.outputCurrentColor();
        FontPS fontPS = (FontPS)this.getFont();
        if (!this.fontWritten) {
            this.outputFont(fontPS);
        }
        this.initializeOutString(f, f2);
        int n = 0;
        while (n < string.length()) {
            PairKern pairKern;
            CharMetricPS charMetricPS2 = fontPS.getCharMetric(string.charAt(n));
            if (charMetricPS != null && (pairKern = charMetricPS.getKernByName(charMetricPS2.getName())) != null && pairKern.xAmount != 0) {
                this.printOutString();
                this.out.x += FontMetricsPS.asPoints(pairKern.xAmount, fontPS.getSize());
            }
            d = FontMetricsPS.asPoints(charMetricPS2.getWx(), fontPS.getSize());
            this.appendToOutString(string.charAt(n), d);
            charMetricPS = charMetricPS2;
            ++n;
        }
        this.printOutString();
        if (this.underline) {
            d = FontMetricsPS.asPoints(fontPS.getUnderlineThickness(), fontPS.getSize());
            this.setStroke(new BasicStroke((float)d));
            f2 = (float)((double)(-f2) - FontMetricsPS.asPoints(fontPS.getUnderlinePosition(), fontPS.getSize()));
            this.drawLinePW(f, f2, this.out.x, f2);
        }
    }

    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }

    public void translate(double d, double d2) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.transform.translate(d, d2);
        double d3 = rectangle2D.getX() - d;
        double d4 = rectangle2D.getY() - d2;
        double d5 = rectangle2D.getWidth();
        double d6 = rectangle2D.getHeight();
        rectangle2D.setRect(d3, d4, d5, d6);
        this.clipSet = true;
        if (this.isContextCurrent()) {
            d2 = -d2;
            this.output(this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(d2) + " translate");
        }
    }

    public void scale(double d, double d2) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.transform.scale(d, d2);
        double d3 = rectangle2D.getX() / d;
        double d4 = rectangle2D.getY() / d2;
        double d5 = rectangle2D.getWidth() / d;
        double d6 = rectangle2D.getHeight() / d2;
        rectangle2D.setRect(d3, d4, d5, d6);
        this.clipSet = true;
        if (this.isContextCurrent()) {
            this.output(this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(d2) + " scale");
        }
    }

    public void rotate(double d) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.transform.rotate(d);
        if (d == 1.5707963267948966 || d == 4.71238898038469) {
            double d2 = rectangle2D.getY();
            double d3 = rectangle2D.getX();
            double d4 = rectangle2D.getHeight();
            double d5 = rectangle2D.getWidth();
            rectangle2D.setRect(d2, d3, d4, d5);
            this.clipSet = true;
        }
        d = Math.PI * 2 - d;
        d = Math.toDegrees(d);
        if (this.isContextCurrent()) {
            this.output(this.truncateDecimalDigits(d) + " " + " rotate");
        }
    }

    public void rotate(double d, double d2, double d3) {
        this.translate(d2, d3);
        this.rotate(d);
        this.translate(-d2, -d3);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clipRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void clipRect(double d, double d2, double d3, double d4) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        if (this.clipSet) {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            Rectangle2D.intersect(rectangle2D, new Rectangle2D.Double(d, d2, d3, d4), double_);
            rectangle2D = double_;
        } else {
            rectangle2D.setRect(d, d2, d3, d4);
            this.clipSet = true;
        }
        if (this.isContextCurrent()) {
            this.output(this.truncateDecimalDigits(rectangle2D.getX()) + " " + this.truncateDecimalDigits(-rectangle2D.getY()) + " " + this.truncateDecimalDigits(rectangle2D.getWidth()) + " " + this.truncateDecimalDigits(-rectangle2D.getHeight()) + " rc");
        }
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.updateContext();
        this.outputCurrentColor();
        this.setLineStroke();
        this.output("newpath " + nArray[0] + " " + -nArray2[0] + " moveto");
        int n2 = 1;
        while (n2 < n) {
            this.output(nArray[n2] + " " + -nArray2[n2] + " lineto");
            ++n2;
        }
        this.output("stroke");
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.printPolygon(nArray, nArray2, n, "stroke");
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.printPolygon(nArray, nArray2, n, "fill");
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        this.updateContext();
        if (image instanceof EPSImage) {
            return this.drawEPSImage((EPSImage)image, n, n2, n3, n4, color, imageObserver);
        }
        return this.drawJavaImage(image, n, n2, n3, n4, color, imageObserver);
    }

    public void setFont(Font font) {
        this.updateContext();
        if (!(font instanceof FontPS)) {
            font = FontPS.getNativeFont(font);
        }
        if (this.currentFont != null && this.fontWritten && this.currentFont.equals(font) && this.currentFont.getStyle() == font.getStyle() && this.currentFont.getSize() == font.getSize()) {
            return;
        }
        this.currentFont = font;
        this.outputFont(font);
    }

    protected void outputFont(Font font) {
        String string = font.getName();
        int n = font.getSize();
        if (!string.equals("Symbol") && !string.equals("ZapfDingbats")) {
            if (!this.loadedFonts.contains(string)) {
                this.loadedFonts.put(string, string);
                this.output("/" + string + "-ISOLatin1 /" + string + " iso");
            }
            this.output("/" + string + "-ISOLatin1 " + n + " sf");
        } else {
            this.output("/" + string + n + " sf");
        }
        this.fontWritten = true;
    }

    public FontMetrics getFontMetrics(Font font) {
        if (!(font instanceof FontPS)) {
            font = FontPS.getNativeFont(font);
        }
        return new FontMetricsPS((FontPS)font);
    }

    public void startContext() {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.output("gsave % frame begin");
        double[] dArray = new double[6];
        this.transform.getMatrix(dArray);
        this.output("[" + this.truncateDecimalDigits(dArray[0]) + " " + this.truncateDecimalDigits(dArray[1]) + " " + this.truncateDecimalDigits(dArray[2]) + " " + this.truncateDecimalDigits(dArray[3]) + " " + this.truncateDecimalDigits(dArray[4]) + " " + this.truncateDecimalDigits(-1.0 * dArray[5]) + "] concat");
        this.output(this.truncateDecimalDigits(rectangle2D.getX()) + " " + this.truncateDecimalDigits(-rectangle2D.getY()) + " " + this.truncateDecimalDigits(rectangle2D.getWidth()) + " " + this.truncateDecimalDigits(-rectangle2D.getHeight()) + " rc");
        this.strokeChanged = true;
    }

    public void endContext() {
        this.output("grestore % frame end");
        this.fontWritten = false;
    }

    public void drawArcPW(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        this.updateContext();
        this.setLineStroke();
        this.outputCurrentColor();
        this.output("newpath");
        this.outputEllipticArc(d, d2, d3 / 2.0, d4 / 2.0, d5, d6);
        this.output("stroke");
    }

    public void fillArcPW(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        this.updateContext();
        this.outputCurrentColor();
        this.output("newpath");
        this.output(this.truncateDecimalDigits(d + d3 / 2.0) + " " + this.truncateDecimalDigits(-(d2 + d4 / 2.0)) + " moveto");
        this.outputEllipticArc(d, d2, d3 / 2.0, d4 / 2.0, d5, d6);
        this.output("closepath fill");
    }

    protected void outputEllipticArc(double d, double d2, double d3, double d4, double d5, double d6) {
        String string = d6 >= 0.0 ? " arc" : " arcn";
        double d7 = d5 + d6;
        if (d3 == d4) {
            this.output(this.truncateDecimalDigits(d + d3) + " " + this.truncateDecimalDigits(-(d2 + d4)) + " " + this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(d5) + " " + this.truncateDecimalDigits(d7) + string);
        } else {
            this.output(this.truncateDecimalDigits(d + d3) + " " + this.truncateDecimalDigits(-(d2 + d4)) + " translate");
            this.output(this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(d4) + " scale");
            this.output("0 0 1 " + this.truncateDecimalDigits(d5) + " " + this.truncateDecimalDigits(d7) + string);
            this.output(this.truncateDecimalDigits(1.0 / d3) + " " + this.truncateDecimalDigits(1.0 / d4) + " scale");
            this.output(this.truncateDecimalDigits(-(d + d3)) + " " + this.truncateDecimalDigits(d2 + d4) + " translate");
        }
    }

    public void setClipPW(double d, double d2, double d3, double d4) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        boolean bl = this.isContextCurrent();
        if (bl) {
            this.endContext();
        }
        if (this.parent != null && ((Graphics2DPS)this.parent).clipSet) {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            Rectangle2D rectangle2D2 = (Rectangle2D)this.parent.getClip();
            try {
                Object object;
                AffineTransform affineTransform;
                if (((Graphics2DBase)this.parent).isFrameRoot()) {
                    affineTransform = this.transform.createInverse();
                } else {
                    object = (AffineTransform)((Graphics2D)this.parent).getTransform().clone();
                    if (((AffineTransform)object).isIdentity()) {
                        affineTransform = this.transform.createInverse();
                    } else {
                        affineTransform = ((AffineTransform)object).createInverse();
                        affineTransform.concatenate(this.transform);
                    }
                }
                object = affineTransform.createTransformedShape(rectangle2D2);
                Rectangle2D.intersect(object.getBounds2D(), new Rectangle2D.Double(d, d2, d3, d4), double_);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                Rectangle2D.intersect(rectangle2D2, new Rectangle2D.Double(d, d2, d3, d4), double_);
            }
            d = ((RectangularShape)double_).getX();
            d2 = ((RectangularShape)double_).getY();
            d3 = ((RectangularShape)double_).getWidth();
            d4 = ((RectangularShape)double_).getHeight();
        }
        rectangle2D.setRect(d, d2, d3, d4);
        this.clipSet = true;
        if (bl) {
            this.startContext();
        }
    }

    public void fillRectPW(double d, double d2, double d3, double d4) {
        this.updateContext();
        this.outputCurrentColor();
        this.output(this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(-d2) + " " + this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(-d4) + " rf");
    }

    public void drawRectPW(double d, double d2, double d3, double d4) {
        this.updateContext();
        this.outputCurrentColor();
        this.setLineStroke();
        this.output(this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(-d2) + " " + this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(-d4) + " rs");
    }

    public void drawLinePW(double d, double d2, double d3, double d4) {
        this.updateContext();
        this.outputCurrentColor();
        this.setLineStroke();
        this.output(this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(-d2) + " " + this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(-d4) + " dla");
    }

    public void drawRoundRectPW(double d, double d2, double d3, double d4, double d5, double d6) {
        this.drawRRect(d, -d2, d3, -d4, d5, d6, "stroke");
    }

    public void fillRoundRectPW(double d, double d2, double d3, double d4, double d5, double d6) {
        this.drawRRect(d, -d2, d3, -d4, d5, d6, "fill");
    }

    public void flushLoadedFonts() {
        this.loadedFonts.clear();
    }

    public void epsfOutputFile(BufferedReader bufferedReader) {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null && !string.equals("%%EOF")) {
                this.output(string);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
    }

    public boolean drawEPSImage(EPSImage ePSImage, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        this.output("PFBeginEpsf");
        n2 = -n2;
        n4 = -n4;
        this.output(n + " " + (n2 + n4) + " translate");
        Rectangle2D rectangle2D = this.getEPSBBox(ePSImage.getInputSource());
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        this.output(this.truncateDecimalDigits((double)n3 / (d3 - d)) + " " + this.truncateDecimalDigits((double)(-n4) / (d4 - d2)) + " scale");
        this.output(this.truncateDecimalDigits(-d) + " " + this.truncateDecimalDigits(-d2) + " translate");
        this.output("%%BeginDocument");
        this.epsfOutputFile(ePSImage.getInputSource());
        this.output("%%EndDocument");
        this.output("PFEndEpsf");
        return true;
    }

    protected void appendToOutString(char c, double d) {
        String string = "\\()";
        char c2 = '\\';
        if (c < ' ' || c > '~') {
            if (c <= '\u00ff') {
                this.out.text.append(this.octal3(c));
            } else if (c == '\u20ac') {
                if (this.printer != null && this.printer.getCharacterEncoding() == 1) {
                    this.out.text.append(this.octal3('\u0080'));
                } else {
                    this.out.text.append(this.octal3('\u00a4'));
                }
            } else {
                System.err.println("Warning: expecting single-byte character, found multi-byte character 0x" + Integer.toHexString(c));
                this.out.text.append(this.octal3(' '));
            }
        } else {
            if (string.indexOf(c) != -1) {
                this.out.text.append(c2);
            }
            this.out.text.append(c);
        }
        this.out.width += d;
    }

    protected String octal3(char c) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(Integer.toOctalString(c));
        int n2 = n = stringBuffer.length();
        while (n2 < 3) {
            stringBuffer.insert(0, 0);
            ++n2;
        }
        stringBuffer.insert(0, '\\');
        return stringBuffer.toString();
    }

    protected void printOutString() {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.out.text.toString());
        stringBuffer.append(") ");
        stringBuffer.append(this.truncateDecimalDigits(this.out.x));
        stringBuffer.append(" ");
        stringBuffer.append(this.truncateDecimalDigits(this.out.y));
        stringBuffer.append(" st");
        this.output(stringBuffer.toString());
        this.out.x += this.out.width;
        this.out.width = 0.0;
        this.out.text.delete(0, this.out.text.length());
    }

    protected void outputCurrentColor() {
        if (!this.colorChanged) {
            return;
        }
        Color color = this.getColor();
        String string = this.truncateDecimalDigits((double)color.getRed() / 255.0) + " " + this.truncateDecimalDigits((double)color.getGreen() / 255.0) + " " + this.truncateDecimalDigits((double)color.getBlue() / 255.0) + " setrgbcolor";
        this.output(string);
        this.colorChanged = false;
    }

    protected void printPolygon(int[] nArray, int[] nArray2, int n, String string) {
        this.updateContext();
        this.outputCurrentColor();
        this.output("newpath " + nArray[0] + " " + -nArray2[0] + " moveto");
        int n2 = 1;
        while (n2 < n) {
            int n3 = nArray[n2];
            int n4 = -nArray2[n2];
            this.output(n3 + " " + n4 + " lineto");
            ++n2;
        }
        if (string.equals("fill") && this.getWindingRule() != 1) {
            string = "eofill";
        }
        this.output("closepath " + string);
    }

    protected void drawRRect(double d, double d2, double d3, double d4, double d5, double d6, String string) {
        double d7 = 1.0;
        this.updateContext();
        this.outputCurrentColor();
        this.setLineStroke();
        if (d6 != d5) {
            d7 = d6 / d5;
            this.output("1 " + this.truncateDecimalDigits(d7) + " scale");
            d2 /= d7;
            d4 /= d7;
        }
        this.output("newpath");
        this.output(this.truncateDecimalDigits(d + d5) + " " + this.truncateDecimalDigits(d2) + " moveto");
        this.output(this.truncateDecimalDigits(d + d3) + " " + this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d + d3) + " " + this.truncateDecimalDigits(d2 + d4) + " " + this.truncateDecimalDigits(d5) + " arct");
        this.output(this.truncateDecimalDigits(d + d3) + " " + this.truncateDecimalDigits(d2 + d4) + " " + this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(d2 + d4) + " " + this.truncateDecimalDigits(d5) + " arct");
        this.output(this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(d2 + d4) + " " + this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d5) + " arct");
        this.output(this.truncateDecimalDigits(d) + " " + this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d + d3) + " " + this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d5) + " arct");
        this.output("closepath " + string);
        if (d6 != d5) {
            this.output("1 " + this.truncateDecimalDigits(1.0 / d7) + " scale");
        }
    }

    protected void setLineStroke() {
        if (this.strokeChanged) {
            float f = ((BasicStroke)this.currentStroke).getLineWidth();
            this.output(this.truncateDecimalDigits(f) + " setlinewidth");
            float[] fArray = ((BasicStroke)this.currentStroke).getDashArray();
            float f2 = ((BasicStroke)this.currentStroke).getDashPhase();
            if (fArray != null) {
                this.output("[");
                int n = 0;
                while (n < fArray.length) {
                    this.output(" " + this.truncateDecimalDigits(fArray[n]) + " ");
                    ++n;
                }
                this.output("] ");
                this.output(String.valueOf(f2).toString());
                this.output(" setdash");
                this.dashMode = true;
            } else if (this.dashMode) {
                this.output("[] 0 setdash");
                this.dashMode = false;
            }
        }
        this.strokeChanged = false;
    }

    protected void emitColorImageProlog(int n) {
        this.output("% Color picture");
        this.output("% define string to hold a scanline's worth of data");
        this.output("/pix " + n * 3);
        this.output(" string def");
        this.output("% define space for color conversions");
        this.output("/grays " + n);
        this.output(" string def  % space for gray scale line");
        this.output("/npixls 0 def");
        this.output("/rgbindx 0 def");
        this.output("% define 'colorimage' if it isn't defined");
        this.output("%   ('colortogray' and 'mergeprocs' come from xwd2ps");
        this.output("%     via xgrab)");
        this.output("/colorimage where   % do we know about 'colorimage'?");
        this.output("{ pop }           % yes: pop off the 'dict' returned");
        this.output("{                 % no:  define one");
        this.output("/colortogray {  % define an RGB->I function");
        this.output("/rgbdata exch store    % call input 'rgbdata'");
        this.output("rgbdata length 3 idiv");
        this.output("/npixls exch store");
        this.output("/rgbindx 0 store");
        this.output("0 1 npixls 1 sub {");
        this.output("grays exch");
        this.output("rgbdata rgbindx       get 20 mul    % Red");
        this.output("rgbdata rgbindx 1 add get 32 mul    % Green");
        this.output("rgbdata rgbindx 2 add get 12 mul    % Blue");
        this.output("add add 64 idiv      % I = .5G + .31R + .18B");
        this.output("put");
        this.output("/rgbindx rgbindx 3 add store");
        this.output("} for");
        this.output("grays 0 npixls getinterval");
        this.output("} bind def");
        this.output("");
        this.output("% Utility procedure for colorimage operator.");
        this.output("% This procedure takes two procedures off the");
        this.output("% stack and merges them into a single procedure.");
        this.output("");
        this.output("/mergeprocs { % def");
        this.output("dup length");
        this.output("3 -1 roll");
        this.output("dup");
        this.output("length");
        this.output("dup");
        this.output("5 1 roll");
        this.output("3 -1 roll");
        this.output("add");
        this.output("array cvx");
        this.output("dup");
        this.output("3 -1 roll");
        this.output("0 exch");
        this.output("putinterval");
        this.output("dup");
        this.output("4 2 roll");
        this.output("putinterval");
        this.output("} bind def");
        this.output("");
        this.output("/colorimage { % def");
        this.output("pop pop     % remove 'false 3' operands");
        this.output("{colortogray} mergeprocs");
        this.output("image");
        this.output("} bind def");
        this.output("} ifelse          % end of 'false' case");
    }

    protected boolean drawJavaImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.output("%doImage");
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        int n7 = (int)rectangle2D.getWidth();
        int n8 = (int)rectangle2D.getHeight();
        if (n3 == n5 && n4 == n6 && (n7 < n3 || n8 < n4)) {
            n5 = Math.min(n7, n5);
            n6 = Math.min(n8, n6);
            n3 = n5;
            n4 = n6;
        }
        int[] nArray = new int[n5 * n6];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n5, n6, nArray, 0, n5);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return false;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return false;
        }
        this.output("gsave");
        this.output("% build a temporary dictionary");
        this.output("20 dict begin");
        this.emitColorImageProlog(pixelGrabber.getWidth());
        this.output("% lower left corner");
        n2 = -n2;
        this.output(n + " " + n2 + " translate");
        if (n3 == 0 || n4 == 0) {
            n4 = pixelGrabber.getHeight();
            n3 = pixelGrabber.getWidth();
        }
        this.output("% size of image");
        this.output(n3 + " " + n4 + " scale");
        this.output(pixelGrabber.getWidth() + " " + pixelGrabber.getHeight());
        this.output(" 8");
        this.output("[" + pixelGrabber.getWidth() + " 0 0 -" + pixelGrabber.getHeight() + " 0 " + "0" + "]");
        this.output("{currentfile pix readhexstring pop}");
        this.output("false 3 colorimage");
        this.output("");
        int n9 = 0;
        int n10 = 0;
        int n11 = 72;
        char[] cArray = new char[n11 + 1];
        int n12 = pixelGrabber.getHeight();
        int n13 = pixelGrabber.getWidth();
        int n14 = 0;
        while (n14 < n12) {
            n9 = 0;
            ++n10;
            int n15 = 0;
            while (n15 < n13) {
                int n16 = nArray[n14 * n13 + n15];
                cArray[n9++] = hd[(n16 & 0xF00000) >> 20];
                cArray[n9++] = hd[(n16 & 0xF0000) >> 16];
                cArray[n9++] = hd[(n16 & 0xF000) >> 12];
                cArray[n9++] = hd[(n16 & 0xF00) >> 8];
                cArray[n9++] = hd[(n16 & 0xF0) >> 4];
                cArray[n9++] = hd[n16 & 0xF];
                if (n9 >= n11) {
                    String string = String.copyValueOf(cArray, 0, n9);
                    this.output(string);
                    if (n10 > 5) {
                        try {
                            Thread.sleep(15L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        n10 = 0;
                    }
                    n9 = 0;
                }
                ++n15;
            }
            if (n9 != 0) {
                String string = String.copyValueOf(cArray, 0, n9);
                this.output(string);
            }
            ++n14;
        }
        this.output("");
        this.output("end");
        this.output("grestore");
        return true;
    }

    protected Rectangle2D getEPSBBox(BufferedReader bufferedReader) {
        String string = "%%BoundingBox:";
        try {
            String string2;
            bufferedReader.mark(this.readAheadAmount);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf(string) <= -1 || string2.indexOf("(atend)") != -1) continue;
                int n = string2.indexOf(string) + string.length();
                StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n + 1, string2.length()));
                double d = Double.valueOf(stringTokenizer.nextToken());
                double d2 = Double.valueOf(stringTokenizer.nextToken());
                double d3 = Double.valueOf(stringTokenizer.nextToken());
                double d4 = Double.valueOf(stringTokenizer.nextToken());
                bufferedReader.reset();
                return new Rectangle2D.Double(d, d2, d3, d4);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            iOException.printStackTrace();
        }
        throw new RuntimeException("Bounding box not set for EPS image");
    }

    public Graphics create() {
        Graphics graphics = super.create();
        ((Graphics2DPS)graphics).fontWritten = false;
        return graphics;
    }
}

