/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.Graphics2DBase;
import com.klg.jclass.page.JCPrintEvent;
import com.klg.jclass.page.JCPrintListener;
import com.klg.jclass.page.PrintException;
import com.klg.jclass.util.JCListenerList;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeModel;

public abstract class JCPrinter {
    protected Graphics2D graphics;
    protected OutputStream os;
    protected boolean collate = true;
    protected boolean reverseOrder = false;
    protected int numCopies = 1;
    protected int endPage = -1;
    protected int startPage = 0;
    protected int pageCount = 0;
    protected JCListenerList printListeners = null;
    protected boolean isDocOpen = false;
    protected int orientation = 0;
    protected boolean compressed = true;
    protected TreeModel bookmarkTree = null;
    protected boolean bookmarkTreeVisible = false;
    public int imageNumber;

    public abstract void setup();

    public abstract boolean isImageScalable();

    public void openDocument(Rectangle2D rectangle2D) {
        this.isDocOpen = true;
        this.imageNumber = 0;
        JCPrintEvent jCPrintEvent = new JCPrintEvent(this, 3);
        Enumeration enumeration = JCListenerList.elements(this.printListeners);
        while (enumeration.hasMoreElements()) {
            JCPrintListener jCPrintListener = (JCPrintListener)enumeration.nextElement();
            jCPrintListener.openDocument(jCPrintEvent);
        }
    }

    public void closeDocument(Rectangle2D rectangle2D) {
        this.isDocOpen = false;
        JCPrintEvent jCPrintEvent = new JCPrintEvent(this, 4);
        Enumeration enumeration = JCListenerList.elements(this.printListeners);
        while (enumeration.hasMoreElements()) {
            JCPrintListener jCPrintListener = (JCPrintListener)enumeration.nextElement();
            jCPrintListener.closeDocument(jCPrintEvent);
        }
    }

    public void beginPage(Rectangle2D rectangle2D, int n) {
        JCPrintEvent jCPrintEvent = new JCPrintEvent(this, 1, n);
        Enumeration enumeration = JCListenerList.elements(this.printListeners);
        while (enumeration.hasMoreElements()) {
            JCPrintListener jCPrintListener = (JCPrintListener)enumeration.nextElement();
            jCPrintListener.beginPage(jCPrintEvent);
        }
    }

    public void endPage(Rectangle2D rectangle2D) {
        JCPrintEvent jCPrintEvent = new JCPrintEvent(this, 2);
        Enumeration enumeration = JCListenerList.elements(this.printListeners);
        while (enumeration.hasMoreElements()) {
            JCPrintListener jCPrintListener = (JCPrintListener)enumeration.nextElement();
            jCPrintListener.endPage(jCPrintEvent);
        }
    }

    public boolean isDocumentOpen() {
        return this.isDocOpen;
    }

    public void setCompressed(boolean bl) {
        this.compressed = bl;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCollate(boolean bl) {
        this.collate = bl;
    }

    public boolean getCollate() {
        return this.collate;
    }

    public void setNumCopies(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of Copies must be >= 1.");
        }
        this.numCopies = n;
    }

    public int getNumCopies() {
        return this.numCopies;
    }

    public void setOutputPageEnd(int n) {
        this.endPage = n;
    }

    public int getOutputPageEnd() {
        return this.endPage;
    }

    public void setOutputPageStart(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Start page must be > 0.");
        }
        this.startPage = n;
    }

    public int getOutputPageStart() {
        return this.startPage;
    }

    public void setOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("Output Stream cannot be <null>.");
        }
        this.os = outputStream;
        Graphics2DBase graphics2DBase = (Graphics2DBase)this.getGraphics();
        graphics2DBase.setOutputStream(outputStream);
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public void setReverseOrder(boolean bl) {
        this.reverseOrder = bl;
    }

    public boolean getReverseOrder() {
        return this.reverseOrder;
    }

    public List getFontFamilies() {
        return null;
    }

    public boolean isBookmarkTreeVisible() {
        return this.bookmarkTreeVisible;
    }

    public boolean supportsHyperlinks() {
        return false;
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    protected void setOrientation(int n) {
        this.orientation = n;
    }

    protected int getOrientation() {
        return this.orientation;
    }

    protected boolean isLandscape(double d, double d2) {
        if (this.orientation == 0) {
            return Math.abs(d) > Math.abs(d2);
        }
        return this.orientation == 2;
    }

    protected void output(String string) {
        try {
            try {
                this.os.write(string.getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.os.write(string.getBytes());
            }
            this.os.write(10);
        }
        catch (IOException iOException) {
            throw new PrintException(iOException.toString());
        }
    }

    protected void output(byte[] byArray) {
        try {
            this.os.write(byArray);
        }
        catch (IOException iOException) {
            throw new PrintException(iOException.toString());
        }
    }

    protected void output(byte[] byArray, int n, int n2) {
        try {
            this.os.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new PrintException(iOException.toString());
        }
    }

    protected void output(byte by) {
        try {
            this.os.write(by);
        }
        catch (IOException iOException) {
            throw new PrintException(iOException.toString());
        }
    }

    public void addPrintListener(JCPrintListener jCPrintListener) {
        this.printListeners = JCListenerList.add(this.printListeners, jCPrintListener);
    }

    public void removePrintListener(JCPrintListener jCPrintListener) {
        this.printListeners = JCListenerList.remove(this.printListeners, jCPrintListener);
    }
}

