/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.EndOfFrameException;
import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCFrame;
import com.klg.jclass.page.JCPageTable;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.JCUnit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JCPageTableFromJTable {
    protected static int defaultColumnWidth = 75;
    protected static int[][] alignment_map = new int[][]{{0, 4}, {2, 2}, {4, 3}, {10, 1}, {11, 1}};

    public static JCPageTable createTable(JCDocument jCDocument, JTable jTable, boolean bl) {
        TableModel tableModel = jTable.getModel();
        return JCPageTableFromJTable.createTable(jCDocument, tableModel, jTable, bl);
    }

    public static JCPageTable createTable(JCDocument jCDocument, TableModel tableModel, boolean bl) {
        return JCPageTableFromJTable.createTable(jCDocument, tableModel, null, bl);
    }

    protected static JCPageTable createTable(JCDocument jCDocument, TableModel tableModel, JTable jTable, boolean bl) {
        JCPageTable jCPageTable = null;
        TableColumnModel tableColumnModel = null;
        int n = 0;
        if (jTable != null) {
            tableColumnModel = jTable.getColumnModel();
            n = jTable.getColumnCount();
        } else if (tableModel != null) {
            n = tableModel.getColumnCount();
        }
        Vector<Object> vector = new Vector<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            Object object;
            int n3 = defaultColumnWidth;
            if (tableColumnModel != null) {
                object = tableColumnModel.getColumn(n2);
                n3 = ((TableColumn)object).getPreferredWidth();
            }
            object = new JCUnit.Measure(JCUnit.POINTS, n3);
            vector.add(object);
            ++n2;
        }
        jCPageTable = new JCPageTable(jCDocument, vector);
        jCPageTable.setAlignment(4);
        jCPageTable.createHeaders();
        if (bl) {
            JCPageTableFromJTable.populateTable(jCPageTable, tableModel, jTable, true);
        }
        return jCPageTable;
    }

    public static void populateTable(JCPageTable jCPageTable, JTable jTable) {
        JCPageTableFromJTable.populateTable(jCPageTable, jTable.getModel(), jTable, true);
    }

    public static void populateTable(JCPageTable jCPageTable, JTable jTable, boolean bl) {
        JCPageTableFromJTable.populateTable(jCPageTable, jTable.getModel(), jTable, bl);
    }

    public static void populateTable(JCPageTable jCPageTable, TableModel tableModel) {
        JCPageTableFromJTable.populateTable(jCPageTable, tableModel, null, false);
    }

    protected static int convertSwingToTextStyleAlignment(int n) {
        int n2 = 2;
        int n3 = 0;
        while (n3 < alignment_map.length) {
            if (alignment_map[n3][0] == n) {
                n2 = alignment_map[n3][1];
            }
            ++n3;
        }
        return n2;
    }

    protected static JLabel getLabelComponent(Component component) {
        JLabel jLabel = null;
        if (component instanceof JLabel) {
            jLabel = (JLabel)component;
        } else if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            if (componentArray == null) {
                return null;
            }
            int n = 0;
            while (n < componentArray.length) {
                jLabel = JCPageTableFromJTable.getLabelComponent(componentArray[n]);
                if (jLabel != null) break;
                ++n;
            }
        }
        return jLabel;
    }

    protected static JCTextStyle setFontAndAlignment(TableCellRenderer tableCellRenderer, JCTextStyle jCTextStyle, JTable jTable, Object object, int n, int n2) {
        if (tableCellRenderer == null || jCTextStyle == null) {
            return null;
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, n, n2);
        if (component != null) {
            JLabel jLabel = JCPageTableFromJTable.getLabelComponent(component);
            int n3 = jCTextStyle.getAlignment();
            if (jLabel != null) {
                n3 = jLabel.getHorizontalAlignment();
                n3 = JCPageTableFromJTable.convertSwingToTextStyleAlignment(n3);
            }
            if (component.getFont() != jCTextStyle.getFont() || jCTextStyle.getAlignment() != n3) {
                jCTextStyle = (JCTextStyle)jCTextStyle.clone();
                if (component.getFont() != jCTextStyle.getFont()) {
                    jCTextStyle.setFont(component.getFont());
                }
                if (jCTextStyle.getAlignment() != n3) {
                    jCTextStyle.setAlignment(n3);
                }
                jCTextStyle = jCTextStyle.getImmutable();
            }
        }
        return jCTextStyle;
    }

    protected static void populateTable(JCPageTable jCPageTable, TableModel tableModel, JTable jTable) {
        JCPageTableFromJTable.populateTable(jCPageTable, tableModel, jTable, true);
    }

    protected static void populateTable(JCPageTable jCPageTable, TableModel tableModel, JTable jTable, boolean bl) {
        JCTextStyle jCTextStyle;
        JCTextStyle jCTextStyle2 = jCTextStyle = JCTextStyle.stringToStyle("default text");
        JCTextStyle jCTextStyle3 = null;
        TableColumnModel tableColumnModel = null;
        TableColumn tableColumn = null;
        int n = 0;
        if (jTable != null) {
            tableColumnModel = jTable.getColumnModel();
            n = jTable.getColumnCount();
        } else if (tableModel != null) {
            n = tableModel.getColumnCount();
        }
        JCPageTable jCPageTable2 = jCPageTable.getHeaders();
        if (jCPageTable2 == null) {
            jCPageTable2 = jCPageTable.createHeaders();
        }
        try {
            TableCellRenderer tableCellRenderer = null;
            int n2 = 0;
            while (n2 < n) {
                Object object;
                JCFrame jCFrame = jCPageTable2.getCellFrame(0, n2);
                Object object2 = "";
                if (tableColumnModel != null) {
                    tableColumn = tableColumnModel.getColumn(n2);
                    object2 = tableColumn.getHeaderValue();
                } else if (tableModel != null) {
                    object2 = tableModel.getColumnName(n2);
                }
                jCTextStyle3 = null;
                if (jTable != null && bl) {
                    if (tableColumnModel != null) {
                        tableColumn = tableColumnModel.getColumn(n2);
                        tableCellRenderer = tableColumn.getHeaderRenderer();
                    }
                    if (tableCellRenderer == null && (object = jTable.getTableHeader()) != null) {
                        tableCellRenderer = ((JTableHeader)object).getDefaultRenderer();
                    }
                    if (tableCellRenderer != null) {
                        object = jCPageTable.getHeaders().getCell(0, n2).getStyle();
                        jCTextStyle3 = JCPageTableFromJTable.setFontAndAlignment(tableCellRenderer, (JCTextStyle)object, jTable, object2, -1, n2);
                    }
                }
                if (jCTextStyle3 == null && (jCTextStyle3 = jCPageTable.getHeaders().getCell(0, n2).getStyle()) == null) {
                    jCTextStyle3 = jCTextStyle;
                }
                jCTextStyle2 = jCTextStyle3;
                if (object2 instanceof Image) {
                    jCFrame.embedImage(jCTextStyle2, (Image)object2);
                } else if (object2 instanceof Icon) {
                    jCFrame.embedIcon(jCTextStyle2, (Icon)object2);
                } else {
                    object = object2 != null ? object2.toString() : "";
                    jCFrame.printWithNewlines(jCTextStyle2, (String)object);
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < tableModel.getRowCount()) {
                int n4 = 0;
                while (n4 < n) {
                    Object object;
                    int n5 = n4;
                    if (jTable != null) {
                        n5 = jTable.convertColumnIndexToModel(n4);
                    }
                    JCFrame jCFrame = jCPageTable.getCellFrame(n3, n4);
                    Object object3 = tableModel.getValueAt(n3, n5);
                    jCTextStyle3 = null;
                    if (jTable != null && bl) {
                        if (tableColumnModel != null) {
                            tableColumn = tableColumnModel.getColumn(n4);
                            tableCellRenderer = tableColumn.getCellRenderer();
                        }
                        if (tableCellRenderer == null) {
                            tableCellRenderer = jTable.getDefaultRenderer(jTable.getColumnClass(n4));
                        }
                        if (tableCellRenderer != null) {
                            object = jCPageTable.getCell(n3, n4).getStyle();
                            jCTextStyle3 = JCPageTableFromJTable.setFontAndAlignment(tableCellRenderer, (JCTextStyle)object, jTable, object3, n3, n4);
                        }
                    }
                    if (jCTextStyle3 == null && (jCTextStyle3 = jCPageTable.getCell(n3, n4).getStyle()) == null) {
                        jCTextStyle3 = jCTextStyle;
                    }
                    jCTextStyle2 = jCTextStyle3;
                    if (object3 instanceof Image) {
                        jCFrame.embedImage(jCTextStyle2, (Image)object3);
                    } else if (object3 instanceof Icon) {
                        jCFrame.embedIcon(jCTextStyle2, (Icon)object3);
                    } else {
                        object = object3 != null ? object3.toString() : "";
                        jCFrame.printWithNewlines(jCTextStyle2, (String)object);
                    }
                    ++n4;
                }
                ++n3;
            }
        }
        catch (EndOfFrameException endOfFrameException) {
            // empty catch block
        }
    }
}

