/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.EndOfFrameException;
import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCFrame;
import com.klg.jclass.page.JCPageTable;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.JCUnit;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JOptionPane;

public class JCPageTableFromJDBC {
    public static JCTextStyle defStyle = null;

    public static JCPageTable createTable(JCDocument jCDocument, ResultSet resultSet) {
        return JCPageTableFromJDBC.createTable(jCDocument, resultSet, true);
    }

    public static JCPageTable createTable(JCDocument jCDocument, ResultSet resultSet, boolean bl) {
        JCPageTable jCPageTable = null;
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            Vector<JCUnit.Measure> vector = new Vector<JCUnit.Measure>(resultSetMetaData.getColumnCount());
            int n = 0;
            while (n < resultSetMetaData.getColumnCount()) {
                int n2 = resultSetMetaData.getColumnDisplaySize(n + 1);
                n2 = Math.max(n2, 75);
                JCUnit.Measure measure = new JCUnit.Measure(JCUnit.POINTS, n2);
                vector.add(measure);
                ++n;
            }
            jCPageTable = new JCPageTable(jCDocument, vector);
            jCPageTable.setAlignment(4);
            jCPageTable.createHeaders();
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(null, sQLException.toString(), "SQL error", 0);
            return jCPageTable;
        }
        if (bl) {
            JCPageTableFromJDBC.populateTable(jCPageTable, resultSet);
        }
        return jCPageTable;
    }

    public static void populateTable(JCPageTable jCPageTable, ResultSet resultSet) {
        try {
            try {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                JCPageTable jCPageTable2 = jCPageTable.createHeaders();
                int n = 0;
                while (n < resultSetMetaData.getColumnCount()) {
                    JCTextStyle jCTextStyle = JCPageTableFromJDBC.deriveCellStyle(jCPageTable2.getCell(0, n));
                    JCFrame jCFrame = jCPageTable2.getCellFrame(0, n);
                    jCFrame.printWithNewlines(jCTextStyle, resultSetMetaData.getColumnLabel(n + 1));
                    ++n;
                }
                int n2 = 0;
                while (resultSet.next()) {
                    int n3 = 0;
                    while (n3 < resultSetMetaData.getColumnCount()) {
                        JCTextStyle jCTextStyle = JCPageTableFromJDBC.deriveCellStyle(jCPageTable.getCell(n2, n3));
                        JCFrame jCFrame = jCPageTable.getCellFrame(n2, n3);
                        String string = resultSet.getString(n3 + 1);
                        jCFrame.printWithNewlines(jCTextStyle, string);
                        ++n3;
                    }
                    ++n2;
                }
            }
            catch (SQLException sQLException) {
                JOptionPane.showMessageDialog(null, sQLException.toString(), "SQL error", 0);
            }
        }
        catch (EndOfFrameException endOfFrameException) {
            // empty catch block
        }
    }

    protected static JCTextStyle deriveCellStyle(JCPageTable.Cell cell) {
        JCTextStyle jCTextStyle = null;
        if (defStyle == null) {
            defStyle = JCTextStyle.stringToStyle("default text");
        }
        if (cell != null) {
            jCTextStyle = cell.getStyle();
        }
        if (jCTextStyle == null) {
            jCTextStyle = defStyle;
        }
        return jCTextStyle;
    }
}

