/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.cell.EditorRendererRegistry;
import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.cell.JCComponentCellRenderer;
import com.klg.jclass.cell.JCLightCellRenderer;
import com.klg.jclass.page.EndOfFrameException;
import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCDrawStyle;
import com.klg.jclass.page.JCFlowInfo;
import com.klg.jclass.page.JCFrame;
import com.klg.jclass.page.JCTableStyle;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.PageTableCellInfo;
import com.klg.jclass.page.PageTableVectorDataSource;
import com.klg.jclass.page.render.BoxRender;
import com.klg.jclass.page.render.LineRender;
import com.klg.jclass.page.render.Render;
import com.klg.jclass.page.render.TableCellRender;
import com.klg.jclass.table.EditableTableDataModel;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionVariable;
import com.klg.jclass.util.formulae.MathScalar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.util.List;
import java.util.Vector;

public class JCPageTable {
    protected JCDocument document;
    protected JCPageTable header;
    protected JCPageTable mainTable;
    protected List rowList;
    protected List columnList;
    protected JCTableStyle tableStyle;
    protected Cell defaultCell;
    protected int alignment;
    protected int borderMode;
    protected int dominance;
    protected int overflowMode;
    protected int columnCount;
    protected int rowCount;
    protected boolean isHeader;
    protected boolean isComplete;
    protected EditableTableDataModel tableData;
    public static final int OVERFLOW_CLIP_COLUMNS = 1;
    public static final int OVERFLOW_WRAP_COLUMNS = 2;
    public static final int OVERFLOW_TEAROFF_COLUMNS = 3;
    public static final int OVERFLOW_WRAP_COLUMNS_NEXT = 4;
    public static final int BORDER_USE_INTERNAL = 1;
    public static final int BORDER_USE_EXTERNAL = 2;
    public static final int ROW_DOMINANCE = 1;
    public static final int COLUMN_DOMINANCE = 2;
    public static final int CELL_ALIGNMENT_NONE = 1;
    public static final int CELL_ALIGNMENT_TOP = 2;
    public static final int CELL_ALIGNMENT_CENTER = 3;
    public static final int CELL_ALIGNMENT_BOTTOM = 4;
    public static final Row UNINITIALISED_ROW = null;
    public static final Cell UNINITIALISED_CELL = null;

    public JCPageTable(JCDocument jCDocument, List list) {
        this(jCDocument, list.toArray(), null, (JCTableStyle)JCTableStyle.STYLE_DEFAULT.clone());
    }

    public JCPageTable(JCDocument jCDocument, List list, JCTableStyle jCTableStyle) {
        this(jCDocument, list.toArray(), null, jCTableStyle);
    }

    public JCPageTable(JCDocument jCDocument, JCUnit.Measure[] measureArray) {
        this(jCDocument, measureArray, (JCPageTable)null, (JCTableStyle)JCTableStyle.STYLE_DEFAULT.clone());
    }

    public JCPageTable(JCDocument jCDocument, JCUnit.Measure[] measureArray, JCTableStyle jCTableStyle) {
        this(jCDocument, measureArray, (JCPageTable)null, jCTableStyle);
    }

    public JCPageTable(JCDocument jCDocument, int n, JCUnit.Measure measure) {
        this(jCDocument, (JCPageTable)null, (JCTableStyle)JCTableStyle.STYLE_DEFAULT.clone());
        int n2 = 0;
        while (n2 < n) {
            this.createColumn(measure, n2);
            ++n2;
        }
        this.columnCount = n;
    }

    public JCPageTable(JCDocument jCDocument, int n, JCUnit.Measure measure, JCTableStyle jCTableStyle) {
        this(jCDocument, (JCPageTable)null, jCTableStyle);
        int n2 = 0;
        while (n2 < n) {
            this.createColumn(measure, n2);
            ++n2;
        }
        this.columnCount = n;
    }

    public JCPageTable(JCDocument jCDocument, int n) {
        this(jCDocument, n, new JCUnit.Measure(JCUnit.INCHES, 1.0));
    }

    public JCPageTable(JCDocument jCDocument, int n, JCTableStyle jCTableStyle) {
        this(jCDocument, n, new JCUnit.Measure(JCUnit.INCHES, 1.0), jCTableStyle);
    }

    protected JCPageTable(JCDocument jCDocument, List list, JCPageTable jCPageTable, JCTableStyle jCTableStyle) {
        this(jCDocument, list.toArray(), jCPageTable, jCTableStyle);
    }

    protected JCPageTable(JCDocument jCDocument, JCUnit.Measure[] measureArray, JCPageTable jCPageTable, JCTableStyle jCTableStyle) {
        this(jCDocument, (Object[])measureArray, jCPageTable, jCTableStyle);
    }

    protected JCPageTable(JCDocument jCDocument, Object[] objectArray, JCPageTable jCPageTable, JCTableStyle jCTableStyle) {
        this(jCDocument, jCPageTable, jCTableStyle);
        int n = 0;
        while (n < objectArray.length) {
            JCUnit.Measure measure = (JCUnit.Measure)objectArray[n];
            this.createColumn(measure, n);
            ++n;
        }
        this.columnCount = objectArray.length;
    }

    protected JCPageTable(JCDocument jCDocument, JCPageTable jCPageTable, JCTableStyle jCTableStyle) {
        Object object;
        if (jCPageTable != null) {
            this.isHeader = true;
            this.mainTable = jCPageTable;
        } else {
            this.isHeader = false;
            jCPageTable = null;
        }
        this.header = null;
        this.tableStyle = jCTableStyle;
        this.rowList = new Vector();
        this.rowCount = 0;
        this.columnList = new Vector();
        this.document = jCDocument;
        this.document.addTable(this);
        if (!jCTableStyle.getShowFirstRowTopBorder()) {
            object = this.getRow(0);
            ((Row)object).setBorderStyle(JCDrawStyle.BLANK);
        }
        this.alignment = jCPageTable != null ? jCPageTable.getAlignment() : 4;
        this.defaultCell = new Cell();
        if (jCPageTable == null) {
            this.defaultCell.setCellAlignment(2);
            object = new JCUnit.Measure(JCUnit.POINTS, 2.0);
            this.defaultCell.setLeftMargin((JCUnit.Measure)object);
            this.defaultCell.setRightMargin((JCUnit.Measure)object);
            this.defaultCell.setTopMargin((JCUnit.Measure)object);
            this.defaultCell.setBottomMargin((JCUnit.Measure)object);
        }
        this.defaultCell.setStyle(jCTableStyle.getTextStyle());
        this.tableData = new PageTableVectorDataSource(this);
        this.borderMode = 2;
        this.dominance = 1;
        this.overflowMode = 2;
        this.isComplete = false;
    }

    public void fitToFrame(JCFrame jCFrame, JCTextStyle jCTextStyle) {
        Object object;
        JCUnit.Measure measure = (JCUnit.Measure)jCFrame.getColumnWidth().clone();
        measure.subtract(jCTextStyle.getLeftIndent());
        measure.subtract(jCTextStyle.getRightIndent());
        JCUnit.Measure measure2 = new JCUnit.Measure();
        JCUnit.Measure measure3 = new JCUnit.Measure();
        measure2.add(this.getLeftBorder().getDrawnWidth());
        measure2.add(this.getRightBorder().getDrawnWidth());
        int n = 0;
        while (n < this.columnCount) {
            Column column = this.getColumn(n);
            measure3.add(column.getWidth());
            if (n != this.columnCount - 1) {
                Column column2 = this.getHeadersColumn(n);
                if (column2 == null) {
                    object = column.getBorderWidth();
                } else {
                    double d = Math.max(column.getBorderWidth().getAs(JCUnit.POINTS), column2.getBorderWidth().getAs(JCUnit.POINTS));
                    object = new JCUnit.Measure(JCUnit.POINTS, d);
                }
                measure2.add((JCUnit.Measure)object);
            }
            ++n;
        }
        measure.subtract(measure2);
        double d = measure.getAs(JCUnit.POINTS) / measure3.getAs(JCUnit.POINTS);
        n = 0;
        while (n < this.columnCount) {
            object = this.getColumn(n);
            Column column = this.getHeadersColumn(n);
            ((Column)object).getWidth().multiply(d);
            if (column != null) {
                column.getWidth().multiply(d);
            }
            ++n;
        }
    }

    public Column getHeadersColumn(int n) {
        if (this.getHeaders() != null) {
            return this.getHeaders().getColumn(n);
        }
        return null;
    }

    public void setColumnWidth(int n, JCUnit.Measure measure) {
        Column column = this.getColumn(n);
        column.setWidth(measure);
    }

    public void setColumnWidths(List list) {
        this.setColumnWidths(list.toArray());
    }

    public void setColumnWidths(JCUnit.Measure[] measureArray) {
        this.setColumnWidths((Object[])measureArray);
    }

    protected void setColumnWidths(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.setColumnWidth(n, (JCUnit.Measure)objectArray[n]);
            ++n;
        }
    }

    public void addRow(String[] stringArray) {
        Row row = this.getRow(this.rowCount);
        int n = stringArray.length;
        if (n > this.columnCount) {
            n = this.columnCount;
        }
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] != null && stringArray[n2].length() != 0) {
                Cell cell = row.getCell(n2);
                JCFrame jCFrame = cell.getFrame();
                JCTextStyle jCTextStyle = cell.getStyle();
                if (jCTextStyle == null) {
                    jCTextStyle = JCTextStyle.stringToStyle("default text");
                }
                try {
                    jCFrame.print(jCTextStyle, stringArray[n2]);
                }
                catch (EndOfFrameException endOfFrameException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    public void addRow(JCTextStyle jCTextStyle, String[] stringArray) {
        Row row = this.getRow(this.rowCount);
        int n = stringArray.length;
        if (n > this.columnCount) {
            n = this.columnCount;
        }
        int n2 = 0;
        while (n2 < n) {
            Cell cell = row.getCell(n2);
            JCFrame jCFrame = cell.getFrame();
            try {
                jCFrame.print(jCTextStyle, stringArray[n2]);
            }
            catch (EndOfFrameException endOfFrameException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public void addRow(int n, String[] stringArray) {
        Row row = this.getRow(n);
        int n2 = stringArray.length;
        if (n2 > this.columnCount) {
            n2 = this.columnCount;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] != null && stringArray[n3].length() != 0) {
                Cell cell = row.getCell(n3);
                JCFrame jCFrame = cell.getFrame();
                JCTextStyle jCTextStyle = cell.getStyle();
                if (jCTextStyle == null) {
                    jCTextStyle = JCTextStyle.stringToStyle("default text");
                }
                try {
                    jCFrame.print(jCTextStyle, stringArray[n3]);
                }
                catch (EndOfFrameException endOfFrameException) {
                    // empty catch block
                }
            }
            ++n3;
        }
    }

    public void addRow(int n, int n2, String[] stringArray) {
        Row row = this.getRow(n);
        int n3 = stringArray.length;
        if (n3 > this.columnCount - n2) {
            n3 = this.columnCount - n2;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (stringArray[n4] != null && stringArray[n4].length() != 0) {
                Cell cell = row.getCell(n4 + n2);
                JCFrame jCFrame = cell.getFrame();
                JCTextStyle jCTextStyle = cell.getStyle();
                if (jCTextStyle == null) {
                    jCTextStyle = JCTextStyle.stringToStyle("default text");
                }
                try {
                    jCFrame.print(jCTextStyle, stringArray[n4]);
                }
                catch (EndOfFrameException endOfFrameException) {
                    // empty catch block
                }
            }
            ++n4;
        }
    }

    public void addRow(Object[] objectArray) {
        Row row = this.getRow(this.rowCount);
        int n = objectArray.length;
        if (n > this.columnCount) {
            n = this.columnCount;
        }
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2] != null) {
                Cell cell = row.getCell(n2);
                cell.setCellValue(objectArray[n2]);
            }
            ++n2;
        }
    }

    public void addRow(int n, Object[] objectArray) {
        Row row = this.getRow(this.rowCount);
        int n2 = objectArray.length;
        if (n2 > this.columnCount) {
            n2 = this.columnCount;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (objectArray[n3] != null) {
                Cell cell = row.getCell(n3);
                cell.setCellValue(objectArray[n3]);
            }
            ++n3;
        }
    }

    public void addRow(int n, int n2, Object[] objectArray) {
        Row row = this.getRow(n);
        int n3 = objectArray.length;
        if (n3 > this.columnCount - n2) {
            n3 = this.columnCount - n2;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (objectArray[n4] != null) {
                Cell cell = row.getCell(n4 + n2);
                cell.setCellValue(objectArray[n4]);
            }
            ++n4;
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        if (n <= 0 || n > 5) {
            throw new IllegalArgumentException("Unrecognised horizontal alignment");
        }
        this.alignment = n;
        if (this.header != null) {
            this.header.setAlignment(n);
        }
    }

    public boolean isBackgroundColorInherited() {
        return this.isHeader && this.tableStyle.getBackground() == null;
    }

    public Color getBackgroundColor() {
        if (this.isBackgroundColorInherited()) {
            return this.mainTable.getBackgroundColor();
        }
        return this.tableStyle.getBackground();
    }

    public void setBackgroundColor(Color color) {
        this.tableStyle.setBackground(color);
    }

    public int getBorderMode() {
        return this.borderMode;
    }

    public void setBorderMode(int n) {
        if (n <= 0 || n > 2) {
            throw new IllegalArgumentException("Unrecognised border mode");
        }
        this.borderMode = n;
    }

    public JCDrawStyle getTopBorder() {
        if (this.isTopBorderInherited()) {
            return this.mainTable.getTopBorder();
        }
        return this.tableStyle.getTopBorder();
    }

    public boolean isTopBorderInherited() {
        return this.isHeader && this.tableStyle.getTopBorder() == null;
    }

    public void setTopBorder(JCDrawStyle jCDrawStyle) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        this.tableStyle.setTopBorder(jCDrawStyle);
    }

    public JCDrawStyle getBottomBorder() {
        if (this.isBottomBorderInherited()) {
            return this.mainTable.getBottomBorder();
        }
        return this.tableStyle.getBottomBorder();
    }

    public boolean isBottomBorderInherited() {
        return this.isHeader && this.tableStyle.getBottomBorder() == null;
    }

    public void setBottomBorder(JCDrawStyle jCDrawStyle) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        this.tableStyle.setBottomBorder(jCDrawStyle);
    }

    public JCDrawStyle getLeftBorder() {
        if (this.isLeftBorderInherited()) {
            return this.mainTable.getLeftBorder();
        }
        return this.tableStyle.getLeftBorder();
    }

    public boolean isLeftBorderInherited() {
        return this.isHeader && this.tableStyle.getLeftBorder() == null;
    }

    public void setLeftBorder(JCDrawStyle jCDrawStyle) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        this.tableStyle.setLeftBorder(jCDrawStyle);
    }

    public JCDrawStyle getRightBorder() {
        if (this.isRightBorderInherited()) {
            return this.mainTable.getRightBorder();
        }
        return this.tableStyle.getRightBorder();
    }

    public boolean isRightBorderInherited() {
        return this.isHeader && this.tableStyle.getRightBorder() == null;
    }

    public void setRightBorder(JCDrawStyle jCDrawStyle) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        this.tableStyle.setRightBorder(jCDrawStyle);
    }

    public JCDrawStyle getRowBorder() {
        if (this.isRowBorderInherited()) {
            return this.mainTable.getRowBorder();
        }
        return this.tableStyle.getRowBorder();
    }

    public boolean isRowBorderInherited() {
        return this.isHeader && this.tableStyle.getRowBorder() == null;
    }

    public void setRowBorder(JCDrawStyle jCDrawStyle) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        this.tableStyle.setRowBorder(jCDrawStyle);
    }

    public JCDrawStyle getColumnBorder() {
        if (this.isColumnBorderInherited()) {
            return this.mainTable.getColumnBorder();
        }
        return this.tableStyle.getColumnBorder();
    }

    public boolean isColumnBorderInherited() {
        return this.isHeader && this.tableStyle.getColumnBorder() == null;
    }

    public void setColumnBorder(JCDrawStyle jCDrawStyle) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        this.tableStyle.setColumnBorder(jCDrawStyle);
    }

    public JCDrawStyle getHeaderBorder() {
        if (this.isHeader()) {
            return this.mainTable.getHeaderBorder();
        }
        return this.tableStyle.getHeaderBorder();
    }

    public boolean isHeaderBorderInherited() {
        return this.isHeader && this.tableStyle.getHeaderBorder() == null;
    }

    public void setHeaderBorder(JCDrawStyle jCDrawStyle) {
        if (this.isHeader()) {
            throw new IllegalArgumentException("Must set the header border on the main table");
        }
        jCDrawStyle = jCDrawStyle.getImmutable();
        this.tableStyle.setHeaderBorder(jCDrawStyle);
    }

    public void setAllBorders(JCDrawStyle jCDrawStyle) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        this.setBottomBorder(jCDrawStyle);
        this.setTopBorder(jCDrawStyle);
        this.setLeftBorder(jCDrawStyle);
        this.setRightBorder(jCDrawStyle);
        this.setRowBorder(jCDrawStyle);
        this.setColumnBorder(jCDrawStyle);
        this.setHeaderBorder(jCDrawStyle);
    }

    public void setEdgeBorders(JCDrawStyle jCDrawStyle) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        this.setBottomBorder(jCDrawStyle);
        this.setTopBorder(jCDrawStyle);
        this.setLeftBorder(jCDrawStyle);
        this.setRightBorder(jCDrawStyle);
    }

    public void setHorizontalBorders(JCDrawStyle jCDrawStyle) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        this.setBottomBorder(jCDrawStyle);
        this.setTopBorder(jCDrawStyle);
        this.setHeaderBorder(jCDrawStyle);
        this.setRowBorder(jCDrawStyle);
    }

    public void setInternalBorders(JCDrawStyle jCDrawStyle) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        this.setRowBorder(jCDrawStyle);
        this.setColumnBorder(jCDrawStyle);
    }

    public void setVerticalBorders(JCDrawStyle jCDrawStyle) {
        jCDrawStyle = jCDrawStyle.getImmutable();
        this.setLeftBorder(jCDrawStyle);
        this.setRightBorder(jCDrawStyle);
        this.setColumnBorder(jCDrawStyle);
    }

    public Cell getCell(int n, int n2) {
        if (n < 0 || n2 < 0 || n2 >= this.columnCount) {
            throw new IllegalArgumentException("cell position out of range");
        }
        Row row = this.getRow(n);
        Cell cell = row.getCell(n2);
        if (cell.isSpanned()) {
            Point point = cell.getSpanOrigin();
            if (point.x != n2 || point.y != n) {
                cell = this.getCell(point.y, point.x);
            }
        }
        return cell;
    }

    public JCFrame getCellFrame(int n, int n2) {
        Cell cell = this.getCell(n, n2);
        return cell.getFrame();
    }

    public void printToCell(int n, int n2, String string) {
        Cell cell = this.getCell(n, n2);
        JCFrame jCFrame = cell.getFrame();
        JCTextStyle jCTextStyle = cell.getStyle();
        if (jCTextStyle == null) {
            jCTextStyle = JCTextStyle.stringToStyle("default text");
        }
        try {
            jCFrame.print(jCTextStyle, string);
        }
        catch (EndOfFrameException endOfFrameException) {
            // empty catch block
        }
    }

    public void printToCell(int n, int n2, JCTextStyle jCTextStyle, String string) {
        Cell cell = this.getCell(n, n2);
        JCFrame jCFrame = cell.getFrame();
        try {
            jCFrame.print(jCTextStyle, string);
        }
        catch (EndOfFrameException endOfFrameException) {
            // empty catch block
        }
    }

    public boolean isDefaultCellAlignmentInherited() {
        return this.isHeader && this.defaultCell.isCellAlignmentInherited();
    }

    public int getDefaultCellAlignment() {
        if (this.isDefaultCellAlignmentInherited()) {
            return this.mainTable.getDefaultCellAlignment();
        }
        return this.defaultCell.getCellAlignment();
    }

    public void setDefaultCellAlignment(int n) {
        this.defaultCell.setCellAlignment(n);
    }

    public Column getColumn(int n) {
        if (n < 0 || n >= this.columnCount) {
            throw new IllegalArgumentException("column index out of range");
        }
        return (Column)this.columnList.get(n);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public List getColumnList() {
        return this.columnList;
    }

    public boolean isDefaultStyleInherited() {
        return this.defaultCell.isStyleInherited() && this.isHeader;
    }

    public JCTextStyle getDefaultStyle() {
        if (this.isDefaultStyleInherited()) {
            return this.mainTable.getDefaultStyle();
        }
        return this.defaultCell.getStyle();
    }

    public void setDefaultStyle(JCTextStyle jCTextStyle) {
        this.defaultCell.setStyle(jCTextStyle);
    }

    public boolean isDefaultBottomMarginInherited() {
        return this.defaultCell.isBottomMarginInherited() && this.isHeader;
    }

    public JCUnit.Measure getDefaultBottomMargin() {
        if (this.isDefaultBottomMarginInherited()) {
            return this.mainTable.getDefaultBottomMargin();
        }
        return this.defaultCell.getBottomMargin();
    }

    public void setDefaultBottomMargin(JCUnit.Measure measure) {
        this.defaultCell.setBottomMargin(measure);
    }

    public boolean isDefaultTopMarginInherited() {
        return this.defaultCell.isTopMarginInherited() && this.isHeader;
    }

    public JCUnit.Measure getDefaultTopMargin() {
        if (this.isDefaultTopMarginInherited()) {
            return this.mainTable.getDefaultTopMargin();
        }
        return this.defaultCell.getTopMargin();
    }

    public void setDefaultTopMargin(JCUnit.Measure measure) {
        this.defaultCell.setTopMargin(measure);
    }

    public boolean isDefaultLeftMarginInherited() {
        return this.defaultCell.isLeftMarginInherited() && this.isHeader;
    }

    public JCUnit.Measure getDefaultLeftMargin() {
        if (this.isDefaultLeftMarginInherited()) {
            return this.mainTable.getDefaultLeftMargin();
        }
        return this.defaultCell.getLeftMargin();
    }

    public void setDefaultLeftMargin(JCUnit.Measure measure) {
        this.defaultCell.setLeftMargin(measure);
    }

    public boolean isDefaultRightMarginInherited() {
        return this.defaultCell.isRightMarginInherited() && this.isHeader;
    }

    public JCUnit.Measure getDefaultRightMargin() {
        if (this.isDefaultRightMarginInherited()) {
            return this.mainTable.getDefaultRightMargin();
        }
        return this.defaultCell.getRightMargin();
    }

    public void setDefaultRightMargin(JCUnit.Measure measure) {
        this.defaultCell.setRightMargin(measure);
    }

    public TableDataModel getTableData() {
        return this.tableData;
    }

    public JCDocument getDocument() {
        return this.document;
    }

    public void setDocument(JCDocument jCDocument) {
        this.document = jCDocument;
        int n = 0;
        while (n < this.rowCount) {
            int n2 = 0;
            while (n2 < this.columnCount) {
                JCFrame jCFrame;
                Cell cell = this.getCellRaw(n, n2);
                if (cell != UNINITIALISED_CELL && (jCFrame = cell.getFrameRaw()) != null) {
                    jCFrame.setDocument(jCDocument);
                }
                ++n2;
            }
            ++n;
        }
    }

    public int getRowColumnDominance() {
        return this.dominance;
    }

    public void setRowColumnDominance(int n) {
        if (n <= 0 || n > 2) {
            throw new IllegalArgumentException("Unrecognised row/column dominance");
        }
        this.dominance = n;
    }

    public JCPageTable getHeaders() {
        return this.header;
    }

    public JCPageTable createHeaders() {
        if (this.isHeader) {
            throw new IllegalArgumentException("Can't create headers for headers");
        }
        Vector<JCUnit.Measure> vector = new Vector<JCUnit.Measure>();
        int n = 0;
        while (n < this.columnCount) {
            Column column = (Column)this.columnList.get(n);
            vector.add(column.getWidth());
            ++n;
        }
        this.header = new JCPageTable(this.document, vector, this, this.tableStyle.getHeaderStyle());
        return this.header;
    }

    public boolean hasHeaders() {
        return this.header != null;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public int getOverflowMode() {
        return this.overflowMode;
    }

    public void setOverflowMode(int n) {
        if (n <= 0 || n > 4 || n == 3) {
            throw new IllegalArgumentException("Unrecognised overflow mode");
        }
        this.overflowMode = n;
    }

    /*
     * Unable to fully structure code
     */
    public Row getRow(int var1_1) {
        block8: {
            if (var1_1 < 0) {
                throw new IllegalArgumentException("row out of range");
            }
            if (var1_1 >= this.rowCount) ** GOTO lbl13
            var2_2 = (Row)this.rowList.get(var1_1);
            if (var2_2 != JCPageTable.UNINITIALISED_ROW) break block8;
            var2_2 = new Row(var1_1);
            this.rowList.set(var1_1, var2_2);
            break block8;
lbl-1000:
            // 1 sources

            {
                this.rowList.add(JCPageTable.UNINITIALISED_ROW);
                ++this.rowCount;
lbl13:
                // 2 sources

                ** while (this.rowCount < var1_1)
            }
lbl14:
            // 1 sources

            var2_2 = new Row(var1_1);
            this.rowList.add(var2_2);
            this.rowCount = this.rowList.size();
        }
        if (this.tableStyle.getAlternate() != null && this.tableStyle.getAlternate().rowOriented) {
            if (var1_1 % 2 == 0) {
                var2_2.setBackgroundColor(this.tableStyle.getAlternate().c1);
            } else {
                var2_2.setBackgroundColor(this.tableStyle.getAlternate().c2);
            }
        }
        return var2_2;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public List getRowList() {
        return this.rowList;
    }

    public void spanCells(int n, int n2, int n3, int n4) {
        Cell cell;
        int n5;
        Row row;
        if (n < 0 || n2 < 0 || n2 >= this.columnCount) {
            throw new IllegalArgumentException("Cell position out of range");
        }
        if (n3 < 1 || n4 < 1 || n2 + n4 > this.columnCount) {
            throw new IllegalArgumentException("Invalid span range");
        }
        if (n3 == 1 && n4 == 1) {
            return;
        }
        int n6 = 0;
        while (n6 < n3) {
            if (n + n6 < this.rowCount && (row = (Row)this.rowList.get(n + n6)) != UNINITIALISED_ROW) {
                List list = row.getCellList();
                int n7 = list.size();
                n5 = 0;
                while (n5 < n4) {
                    if (n2 + n5 < n7 && (cell = (Cell)list.get(n2 + n5)) != UNINITIALISED_CELL && cell.isSpanned()) {
                        throw new IllegalArgumentException("Span range conflicts");
                    }
                    ++n5;
                }
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < n3) {
            row = this.getRow(n + n6);
            n5 = 0;
            while (n5 < n4) {
                cell = row.getCell(n2 + n5);
                cell.setSpanOrigin(n, n2);
                ++n5;
            }
            ++n6;
        }
        cell = this.getCell(n, n2);
        cell.setSpanSize(n3, n4);
        JCUnit.Measure measure = (JCUnit.Measure)this.getColumn(n2).getWidth().clone();
        n5 = 1;
        while (n5 < n4) {
            measure.add(this.getColumn(n2).getBorderWidth());
            measure.add(this.getColumn(n2 + n5).getWidth());
            ++n5;
        }
        cell.setWidth(measure);
    }

    public JCUnit.Measure getRowRangeHeight(int n, int n2) {
        if (n < 0 || n2 >= this.rowCount) {
            throw new IllegalArgumentException("Invalid row range");
        }
        Row row = this.getRow(n);
        JCUnit.Measure measure = row.getTopBorderWidth(true);
        int n3 = n + 1;
        while (n3 <= n2) {
            measure.add(row.getHeight());
            measure.add(row.getExtraHeight());
            measure.add(row.getBorderWidth());
            row = this.getRow(n3);
            ++n3;
        }
        measure.add(row.getHeight());
        measure.add(row.getExtraHeight());
        measure.add(row.getBottomBorderWidth(true));
        return measure;
    }

    public JCUnit.Measure getColumnRangeWidth(int n, int n2) {
        if (n < 0 || n2 >= this.columnCount) {
            throw new IllegalArgumentException("Invalid column range");
        }
        Column column = this.getColumn(n);
        JCUnit.Measure measure = column.getLeftBorderWidth(true);
        int n3 = n + 1;
        while (n3 <= n2) {
            measure.add(column.getWidth());
            measure.add(column.getBorderWidth());
            column = this.getColumn(n3);
            ++n3;
        }
        measure.add(column.getWidth());
        measure.add(column.getRightBorderWidth(true));
        return measure;
    }

    public int getRowSet(int n, JCUnit.Measure measure, JCUnit.Measure measure2) {
        int n2 = n;
        JCUnit.Measure measure3 = this.getRowRangeHeight(n, n2);
        JCUnit.Measure measure4 = new JCUnit.Measure();
        while (measure.greaterThan(measure3) && n2 < this.rowCount - 1) {
            measure4 = measure3;
            measure3 = this.getRowRangeHeight(n, ++n2);
        }
        if (measure.lessThan(measure3) && n2 > n) {
            --n2;
        } else {
            measure4 = measure3;
        }
        measure2.assign(measure4);
        return n2;
    }

    public int getColumnSet(int n, JCUnit.Measure measure, JCUnit.Measure measure2) {
        int n2 = n;
        JCUnit.Measure measure3 = this.getColumnRangeWidth(n, n2);
        JCUnit.Measure measure4 = new JCUnit.Measure();
        while (measure.greaterThan(measure3) && n2 < this.columnCount - 1) {
            measure4 = measure3;
            measure3 = this.getColumnRangeWidth(n, ++n2);
        }
        if (measure.lessThan(measure3) && n2 > n) {
            --n2;
        } else {
            measure4 = measure3;
        }
        measure2.assign(measure4);
        return n2;
    }

    public void completeLayout() {
        if (!this.isComplete) {
            if (this.hasHeaders()) {
                this.header.completeLayout();
                if (this.header.getRowCount() == 0) {
                    this.header = null;
                }
            }
            this.computeRowHeights();
            this.isComplete = true;
        }
    }

    public void drawTablePart(JCFrame jCFrame, int n, int n2, int n3, int n4, JCUnit.Measure measure, JCUnit.Measure measure2, JCUnit.Measure measure3) {
        JCUnit.Measure measure4;
        JCUnit.Measure measure5;
        JCUnit.Measure measure6;
        if (this.isHeader) {
            int n5 = this.mainTable.getAlignment();
        } else {
            int n6 = this.alignment;
        }
        JCFlowInfo jCFlowInfo = jCFrame.getFlowInfo();
        JCUnit.Measure measure7 = (JCUnit.Measure)jCFlowInfo.leftOfColumn.clone();
        JCUnit.Measure measure8 = jCFlowInfo.insertion.getY();
        if (this.alignment == 3) {
            measure7.add(jCFrame.getColumnWidth());
            measure7.subtract(measure3);
        } else if (this.alignment == 4 || this.alignment == 5) {
            JCUnit.Measure measure9 = (JCUnit.Measure)jCFrame.getColumnWidth().clone();
            measure9.subtract(measure3);
            measure9.divide(2.0);
            measure7.add(measure9);
        }
        if (n2 == 0 || this.borderMode == 2) {
            measure6 = this.getLeftBorder().getDrawnWidth();
            if (this.isHeader) {
                measure5 = this.mainTable.getLeftBorder().getDrawnWidth();
                if (measure5.greaterThan(measure6)) {
                    measure6 = measure5;
                }
            } else if (this.hasHeaders() && (measure5 = this.header.getLeftBorder().getDrawnWidth()).greaterThan(measure6)) {
                measure6 = measure5;
            }
        } else {
            measure6 = this.getColumn(n2 - 1).getBorderWidth();
        }
        measure6.divide(2.0);
        if (n4 == this.columnCount - 1 || this.borderMode == 2) {
            measure4 = this.getRightBorder().getDrawnWidth();
            if (this.isHeader) {
                measure5 = this.mainTable.getRightBorder().getDrawnWidth();
                if (measure5.greaterThan(measure4)) {
                    measure4 = measure5;
                }
            } else if (this.hasHeaders() && (measure5 = this.header.getRightBorder().getDrawnWidth()).greaterThan(measure4)) {
                measure4 = measure5;
            }
        } else {
            measure4 = this.getColumn(n4).getBorderWidth();
        }
        measure4.divide(2.0);
        JCUnit.Measure measure10 = (JCUnit.Measure)measure7.clone();
        measure10.add(measure6);
        JCUnit.Measure measure11 = (JCUnit.Measure)measure7.clone();
        measure11.add(measure3);
        measure11.subtract(measure4);
        JCUnit.Measure measure12 = this.hasHeaders() ? new JCUnit.Measure() : (n == 0 || this.borderMode == 2 ? this.getTopBorder().getDrawnWidth() : this.getRow(n - 1).getBorderWidth());
        measure12 = (JCUnit.Measure)measure12.clone();
        measure12.divide(2.0);
        JCUnit.Measure measure13 = this.isHeader ? this.getHeaderBorder().getDrawnWidth() : (n3 == this.rowCount - 1 || this.borderMode == 2 ? this.getBottomBorder().getDrawnWidth() : this.getRow(n3).getBorderWidth());
        measure13 = (JCUnit.Measure)measure13.clone();
        measure13.divide(2.0);
        JCUnit.Measure measure14 = (JCUnit.Measure)measure8.clone();
        measure14.add(measure);
        measure14.add(measure12);
        JCUnit.Measure measure15 = (JCUnit.Measure)measure8.clone();
        measure15.add(measure);
        measure15.add(measure2);
        measure15.subtract(measure13);
        this.drawTableBackgrounds(jCFrame, n, n2, n3, n4, measure10, measure14, measure11, measure15);
        if (this.hasHeaders()) {
            int n7 = this.header.getRowCount() - 1;
            this.header.drawTablePart(jCFrame, 0, n2, n7, n4, new JCUnit.Measure(), measure, measure3);
        }
        this.drawTableBorders(jCFrame, n, n2, n3, n4, measure10, measure14);
        measure10.add(measure6);
        measure14.add(measure12);
        this.pasteCells(jCFrame, n, n2, n3, n4, measure10, measure14);
    }

    protected void createColumn(JCUnit.Measure measure, int n) {
        Column column = new Column(measure, n);
        this.columnList.add(column);
        if (this.tableStyle.getAlternate() != null && !this.tableStyle.getAlternate().rowOriented) {
            if (n % 2 == 0) {
                column.setBackgroundColor(this.tableStyle.getAlternate().c1);
            } else {
                column.setBackgroundColor(this.tableStyle.getAlternate().c2);
            }
        }
    }

    protected JCUnit.Measure getLeftBorderWidth() {
        JCUnit.Measure measure;
        JCUnit.Measure measure2 = this.getLeftBorder().getDrawnWidth();
        if (this.hasHeaders() && (measure = this.header.getLeftBorder().getDrawnWidth()).greaterThan(measure2)) {
            measure2 = measure;
        }
        if (this.isHeader && (measure = this.mainTable.getLeftBorder().getDrawnWidth()).greaterThan(measure2)) {
            measure2 = measure;
        }
        return measure2;
    }

    protected JCUnit.Measure getRightBorderWidth() {
        JCUnit.Measure measure;
        JCUnit.Measure measure2 = this.getRightBorder().getDrawnWidth();
        if (this.hasHeaders() && (measure = this.header.getRightBorder().getDrawnWidth()).greaterThan(measure2)) {
            measure2 = measure;
        }
        if (this.isHeader && (measure = this.mainTable.getRightBorder().getDrawnWidth()).greaterThan(measure2)) {
            measure2 = measure;
        }
        return measure2;
    }

    protected JCUnit.Measure getColumnBorderWidth() {
        JCUnit.Measure measure;
        JCUnit.Measure measure2 = this.getColumnBorder().getDrawnWidth();
        if (this.hasHeaders() && (measure = this.header.getColumnBorder().getDrawnWidth()).greaterThan(measure2)) {
            measure2 = measure;
        }
        if (this.isHeader && (measure = this.mainTable.getColumnBorder().getDrawnWidth()).greaterThan(measure2)) {
            measure2 = measure;
        }
        return measure2;
    }

    private void computeRowHeights() {
        Row row;
        int n = 0;
        while (n < this.rowCount) {
            row = this.getRow(n);
            row.basicHeight();
            ++n;
        }
        n = 0;
        while (n < this.rowCount) {
            row = (Row)this.rowList.get(n);
            List list = row.getCellList();
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2) {
                Cell cell = (Cell)list.get(n3);
                if (cell != UNINITIALISED_CELL && cell.isSpanned()) {
                    Point point = cell.getSpanOrigin();
                    if (point.x == n3 && point.y == n) {
                        int n4;
                        int n5 = cell.getSpanColumns();
                        if (n5 > 1) {
                            Column column = this.getColumn(n3);
                            int n6 = 1;
                            while (n6 < n5) {
                                column.addDepartingSpan();
                                column = this.getColumn(n3 + n6);
                                column.addArrivingSpan();
                                ++n6;
                            }
                        }
                        if ((n4 = cell.getSpanRows()) != 1) {
                            Row row2;
                            JCUnit.Measure measure = cell.fixHeight();
                            JCUnit.Measure measure2 = new JCUnit.Measure();
                            int n7 = 0;
                            int n8 = 0;
                            while (n8 < n4) {
                                row2 = (Row)this.rowList.get(n8 + n);
                                measure.subtract(row2.getHeight());
                                measure2.add(row2.getExtraHeight());
                                if (!row2.hasFixedHeight()) {
                                    ++n7;
                                }
                                ++n8;
                            }
                            if (!measure.lessThan(measure2) && n7 != 0) {
                                JCUnit.Measure measure3 = (JCUnit.Measure)measure.clone();
                                measure3.divide(n7);
                                JCUnit.Measure measure4 = new JCUnit.Measure();
                                n8 = 0;
                                while (n8 < n4) {
                                    row2 = (Row)this.rowList.get(n8 + n);
                                    if (!row2.hasFixedHeight()) {
                                        measure2 = row2.getExtraHeight();
                                        --n7;
                                        if (measure3.lessThan(measure2)) {
                                            measure.subtract(measure2);
                                            if (measure.greaterThan(measure4)) {
                                                measure3.assign(measure);
                                                measure3.divide(n7);
                                            }
                                        } else {
                                            row2.setExtraHeight(measure3);
                                            measure.subtract(measure3);
                                        }
                                    }
                                    ++n8;
                                }
                            }
                        }
                    }
                }
                ++n3;
            }
            ++n;
        }
    }

    private Cell getCellRaw(int n, int n2) {
        if (n < 0 || n >= this.rowCount || n2 < 0 || n2 >= this.columnCount) {
            return null;
        }
        Row row = (Row)this.rowList.get(n);
        if (row == UNINITIALISED_ROW) {
            return UNINITIALISED_CELL;
        }
        List list = row.getCellList();
        if (n2 >= list.size()) {
            return UNINITIALISED_CELL;
        }
        return (Cell)list.get(n2);
    }

    private JCDrawStyle getRawBottomBorder(int n, int n2) {
        if (n < 0 || n >= this.rowCount || n2 < 0 || n2 >= this.columnCount) {
            return null;
        }
        Cell cell = this.getCellRaw(n, n2);
        if (cell == UNINITIALISED_CELL) {
            return this.getRow(n).getBorderStyle();
        }
        return cell.getBottomEdgeStyle();
    }

    private JCDrawStyle getRawRightBorder(int n, int n2) {
        if (n < 0 || n >= this.rowCount || n2 < 0 || n2 >= this.columnCount) {
            return null;
        }
        Cell cell = this.getCellRaw(n, n2);
        if (cell == UNINITIALISED_CELL) {
            return this.getColumn(n2).getBorderStyle();
        }
        return cell.getRightEdgeStyle();
    }

    private void drawBackground(JCFrame jCFrame, Color color, JCUnit.Measure measure, JCUnit.Measure measure2, JCUnit.Measure measure3, JCUnit.Measure measure4) {
        JCDrawStyle jCDrawStyle = JCDrawStyle.stringToStyle("__tableFillStyle" + color.toString());
        if (jCDrawStyle == null) {
            jCDrawStyle = new JCDrawStyle("__tableFillStyle" + color.toString());
            jCDrawStyle.setFillForegroundColor(color);
            jCDrawStyle.makeImmutable();
        }
        JCUnit.Point point = measure.units == measure2.units ? new JCUnit.Point(measure.units, measure.distance, measure2.distance) : new JCUnit.Point(measure.units, measure.distance, measure2.getAs(measure.units));
        JCUnit.Point point2 = measure3.units == measure4.units ? new JCUnit.Point(measure3.units, measure3.distance, measure4.distance) : new JCUnit.Point(measure3.units, measure3.distance, measure4.getAs(measure3.units));
        List list = jCFrame.getRenderList();
        BoxRender boxRender = new BoxRender(point, point2, jCDrawStyle);
        boxRender.setFilled(true);
        list.add(boxRender);
    }

    private void drawCellBackgrounds(JCFrame jCFrame, int n, int n2, int n3, int n4, JCUnit.Measure measure, JCUnit.Measure measure2) {
        JCUnit.Measure measure3;
        if (n < 0 || n3 >= this.rowCount || n > n3) {
            throw new IllegalArgumentException("Invalid row range");
        }
        if (n2 < 0 || n4 >= this.columnCount || n2 > n4) {
            throw new IllegalArgumentException("Invalid column range");
        }
        JCUnit.Measure measure4 = new JCUnit.Measure();
        JCUnit.Measure measure5 = (JCUnit.Measure)measure2.clone();
        JCUnit.Measure measure6 = new JCUnit.Measure();
        JCUnit.Measure measure7 = new JCUnit.Measure();
        JCUnit.Measure[] measureArray = new JCUnit.Measure[n4 - n2 + 1];
        if (this.hasHeaders()) {
            measure3 = this.getHeaderBorder().getDrawnWidth();
            measure3.divide(2.0);
        } else {
            measure3 = new JCUnit.Measure();
        }
        int n5 = n;
        while (n5 <= n3) {
            measure7.assign(measure5);
            measure7.add(this.getRow(n5).getDrawnHeight(n5 == n, n5 == n3));
            if (n5 == n) {
                measure5.subtract(measure3);
            }
            measure4.assign(measure);
            int n6 = n2;
            while (n6 <= n4) {
                if (n5 == n) {
                    measureArray[n6 - n2] = this.getColumn(n6).getDrawnWidth(n6 == n2, n6 == n4);
                }
                measure6.assign(measure4);
                measure6.add(measureArray[n6 - n2]);
                Cell cell = this.getCellRaw(n5, n6);
                if (cell != UNINITIALISED_CELL) {
                    if (cell.isSpanned()) {
                        cell = this.getCell(n5, n6);
                    }
                    if (cell.isSpanned() || !cell.isBackgroundColorInherited()) {
                        Color color = cell.getBackgroundColor();
                        if (color == null) {
                            color = jCFrame.getColor();
                        }
                        if (color != null) {
                            this.drawBackground(jCFrame, color, measure4, measure5, measure6, measure7);
                        }
                    }
                }
                measure4.assign(measure6);
                ++n6;
            }
            measure5.assign(measure7);
            ++n5;
        }
    }

    private void drawRowBackgrounds(JCFrame jCFrame, int n, int n2, int n3, int n4, JCUnit.Measure measure, JCUnit.Measure measure2, JCUnit.Measure measure3) {
        JCUnit.Measure measure4;
        if (n < 0 || n2 >= this.rowCount || n > n2) {
            throw new IllegalArgumentException("Invalid row range");
        }
        JCUnit.Measure measure5 = (JCUnit.Measure)measure2.clone();
        JCUnit.Measure measure6 = new JCUnit.Measure();
        if (this.hasHeaders()) {
            measure4 = this.getHeaderBorder().getDrawnWidth();
            measure4.divide(2.0);
        } else {
            measure4 = new JCUnit.Measure();
        }
        int n5 = n;
        while (n5 <= n2) {
            Row row = this.getRow(n5);
            measure6.assign(measure5);
            measure6.add(row.getDrawnHeight(n5 == n, n5 == n2));
            if (n5 == n) {
                measure5.subtract(measure4);
            }
            if (!row.isBackgroundColorInherited()) {
                Color color = row.getBackgroundColor();
                JCUnit.Measure measure7 = (JCUnit.Measure)measure.clone();
                JCUnit.Measure measure8 = (JCUnit.Measure)measure7.clone();
                int n6 = n3;
                int n7 = -1;
                int n8 = n3;
                while (n8 <= n4) {
                    Cell cell = this.getCellRaw(n5, n8);
                    if (cell != UNINITIALISED_CELL && cell.isSpanned()) {
                        if (n7 >= 0) {
                            this.drawBackground(jCFrame, color, measure7, measure5, measure8, measure6);
                            n7 = -1;
                            measure7 = (JCUnit.Measure)measure8.clone();
                        }
                        measure8.add(this.getColumn(n8).getDrawnWidth(n8 == n3, n8 == n4));
                    } else {
                        if (n7 < 0) {
                            measure7 = (JCUnit.Measure)measure8.clone();
                        }
                        measure8.add(this.getColumn(n8).getDrawnWidth(n8 == n3, n8 == n4));
                        n7 = n8;
                    }
                    ++n8;
                }
                if (n7 >= 0) {
                    this.drawBackground(jCFrame, color, measure7, measure5, measure8, measure6);
                }
            }
            measure5.assign(measure6);
            ++n5;
        }
    }

    private void drawColumnBackgrounds(JCFrame jCFrame, int n, int n2, int n3, int n4, JCUnit.Measure measure, JCUnit.Measure measure2, JCUnit.Measure measure3) {
        if (n < 0 || n2 >= this.columnCount || n > n2) {
            throw new IllegalArgumentException("Invalid column range");
        }
        JCUnit.Measure measure4 = (JCUnit.Measure)measure.clone();
        JCUnit.Measure measure5 = new JCUnit.Measure();
        if (this.hasHeaders()) {
            JCUnit.Measure measure6 = measure2;
            measure2 = this.getHeaderBorder().getDrawnWidth();
            measure2.divide(-2.0);
            measure2.add(measure6);
        }
        int n5 = n;
        while (n5 <= n2) {
            Column column = this.getColumn(n5);
            measure5.assign(measure4);
            measure5.add(column.getDrawnWidth(n5 == n, n5 == n2));
            boolean bl = column.isBackgroundColorInherited();
            if (bl && this.isHeader()) {
                bl = this.mainTable.getColumn(n5).isBackgroundColorInherited();
            }
            if (!bl) {
                Color color = column.getBackgroundColor();
                JCUnit.Measure measure7 = (JCUnit.Measure)measure2.clone();
                JCUnit.Measure measure8 = (JCUnit.Measure)measure7.clone();
                int n6 = n3;
                int n7 = -1;
                int n8 = n3;
                while (n8 <= n4) {
                    Cell cell = this.getCellRaw(n8, n5);
                    if (cell != UNINITIALISED_CELL && cell.isSpanned()) {
                        if (n7 >= 0) {
                            this.drawBackground(jCFrame, color, measure4, measure7, measure5, measure8);
                            n7 = -1;
                            measure7 = (JCUnit.Measure)measure8.clone();
                        }
                        measure8.add(this.getRow(n8).getDrawnHeight(n8 == n3, n8 == n4));
                    } else {
                        if (n7 < 0) {
                            measure7 = (JCUnit.Measure)measure8.clone();
                        }
                        measure8.add(this.getRow(n8).getDrawnHeight(n8 == n3, n8 == n4));
                        n7 = n8;
                    }
                    ++n8;
                }
                if (n7 >= 0) {
                    this.drawBackground(jCFrame, color, measure4, measure7, measure5, measure8);
                }
            }
            measure4.assign(measure5);
            ++n5;
        }
    }

    private void drawTableBackgrounds(JCFrame jCFrame, int n, int n2, int n3, int n4, JCUnit.Measure measure, JCUnit.Measure measure2, JCUnit.Measure measure3, JCUnit.Measure measure4) {
        JCUnit.Measure measure5;
        if (this.hasHeaders()) {
            measure5 = this.getHeaderBorder().getDrawnWidth();
            measure5.divide(2.0);
        } else {
            measure5 = new JCUnit.Measure();
        }
        Color color = this.getBackgroundColor();
        if (color != null) {
            JCUnit.Measure measure6 = (JCUnit.Measure)measure2.clone();
            measure6.subtract(measure5);
            this.drawBackground(jCFrame, color, measure, measure6, measure3, measure4);
        }
        if (this.dominance == 1) {
            this.drawColumnBackgrounds(jCFrame, n2, n4, n, n3, measure, measure2, measure4);
            this.drawRowBackgrounds(jCFrame, n, n3, n2, n4, measure, measure2, measure3);
        } else {
            this.drawRowBackgrounds(jCFrame, n, n3, n2, n4, measure, measure2, measure3);
            this.drawColumnBackgrounds(jCFrame, n2, n4, n, n3, measure, measure2, measure4);
        }
        this.drawCellBackgrounds(jCFrame, n, n2, n3, n4, measure, measure2);
    }

    private JCDrawStyle selectDominantStyle(JCDrawStyle jCDrawStyle, JCDrawStyle jCDrawStyle2, JCUnit.Measure measure) {
        JCUnit.Measure measure2;
        JCUnit.Measure measure3 = jCDrawStyle != null ? jCDrawStyle.getDrawnWidth() : new JCUnit.Measure();
        if (measure3.greaterThan(measure2 = jCDrawStyle2 != null ? jCDrawStyle2.getDrawnWidth() : new JCUnit.Measure())) {
            measure.assign(measure3);
            return jCDrawStyle;
        }
        if (measure3.lessThan(measure2)) {
            measure.assign(measure2);
            return jCDrawStyle2;
        }
        if (!measure3.isZero()) {
            measure.assign(measure3);
            return jCDrawStyle;
        }
        measure.assign(measure3);
        if (jCDrawStyle != null && (jCDrawStyle2 == null || jCDrawStyle.getLineType() != 1)) {
            return jCDrawStyle;
        }
        return jCDrawStyle2;
    }

    private void drawBorder(JCFrame jCFrame, JCDrawStyle jCDrawStyle, JCUnit.Measure measure, JCUnit.Measure measure2, JCUnit.Measure measure3, JCUnit.Measure measure4) {
        JCUnit.Point[] pointArray = new JCUnit.Point[2];
        if (jCDrawStyle.getForegroundColor() == null) {
            return;
        }
        pointArray[0] = measure.units == measure2.units ? new JCUnit.Point(measure.units, measure.distance, measure2.distance) : new JCUnit.Point(measure.units, measure.distance, measure2.getAs(measure.units));
        pointArray[1] = measure3.units == measure4.units ? new JCUnit.Point(measure3.units, measure3.distance, measure4.distance) : new JCUnit.Point(measure3.units, measure3.distance, measure4.getAs(measure3.units));
        List list = jCFrame.getRenderList();
        list.add(new LineRender(pointArray, jCDrawStyle));
    }

    private void drawRowBorder(JCFrame jCFrame, int n, int n2, int n3, int n4, int n5, JCUnit.Measure measure, JCUnit.Measure measure2, JCUnit.Measure[] measureArray) {
        JCUnit.Measure measure3 = new JCUnit.Measure();
        JCUnit.Measure measure4 = new JCUnit.Measure();
        JCUnit.Measure measure5 = new JCUnit.Measure();
        measure3 = n3 == 0 || this.borderMode == 2 ? this.getLeftBorder().getDrawnWidth() : this.getIntersectionBorderOffset(n, n3 - 1, true);
        measure4 = n5 == this.columnCount - 1 || this.borderMode == 2 ? this.getRightBorder().getDrawnWidth() : this.getIntersectionBorderOffset(n, n5, true);
        JCUnit.Measure measure6 = new JCUnit.Measure(JCUnit.POINTS, 1.0);
        JCUnit.Measure measure7 = new JCUnit.Measure(JCUnit.POINTS, 0.0);
        if (measure3.lessThan(measure6)) {
            measure3.assign(measure7);
        }
        if (measure4.lessThan(measure6)) {
            measure4.assign(measure7);
        }
        measure3.divide(2.0);
        measure4.divide(2.0);
        JCUnit.Measure measure8 = (JCUnit.Measure)measure.clone();
        measure8.subtract(measure3);
        JCDrawStyle jCDrawStyle = this.getEffectiveRowBorder(n, n3, n2, n4);
        JCUnit.Measure measure9 = (JCUnit.Measure)measure.clone();
        int n6 = n3;
        while (n6 <= n5) {
            JCDrawStyle jCDrawStyle2 = this.getEffectiveRowBorder(n, n6, n2, n4);
            if (jCDrawStyle2 != null && !jCDrawStyle2.equals(jCDrawStyle) || jCDrawStyle2 == null && jCDrawStyle != null) {
                JCUnit.Measure measure10 = this.getIntersectionBorderOffset(n, n6, true);
                if (measure10.lessThan(measure6)) {
                    measure10.assign(measure7);
                }
                measure10.divide(2.0);
                if (jCDrawStyle != null) {
                    measure5.assign(measure9);
                    measure5.add(measure10);
                    this.drawBorder(jCFrame, jCDrawStyle, measure8, measure2, measure5, measure2);
                }
                jCDrawStyle = jCDrawStyle2;
                measure8.assign(measure9);
                measure8.subtract(measure10);
            }
            measure9.add(measureArray[n6]);
            ++n6;
        }
        if (jCDrawStyle != null) {
            measure9.add(measure4);
            this.drawBorder(jCFrame, jCDrawStyle, measure8, measure2, measure9, measure2);
        }
    }

    private JCDrawStyle getEffectiveRowBorder(int n, int n2, int n3, int n4) {
        JCDrawStyle jCDrawStyle = null;
        if (n >= n3 && n < n4) {
            return this.getRawBottomBorder(n, n2);
        }
        if (this.borderMode != 2 && n >= 0 && n < this.rowCount) {
            return this.getRawBottomBorder(n, n2);
        }
        if (n < n3) {
            jCDrawStyle = this.hasHeaders() ? this.getHeaderBorder() : this.getTopBorder();
            if (n == -1 || this.hasHeaders()) {
                return jCDrawStyle;
            }
        } else if (n + 1 >= n4) {
            jCDrawStyle = this.isHeader() ? this.getHeaderBorder() : this.getBottomBorder();
            if (n + 1 == n4) {
                return jCDrawStyle;
            }
        } else {
            throw new IllegalArgumentException("Invalid row address to get border");
        }
        if (this.getRawBottomBorder(n, n2) == null) {
            return null;
        }
        return jCDrawStyle;
    }

    private void drawColumnBorder(JCFrame jCFrame, int n, int n2, int n3, int n4, int n5, JCUnit.Measure measure, JCUnit.Measure measure2, JCUnit.Measure[] measureArray) {
        JCUnit.Measure measure3 = new JCUnit.Measure();
        JCUnit.Measure measure4 = new JCUnit.Measure();
        JCUnit.Measure measure5 = new JCUnit.Measure();
        measure3 = n2 == 0 || this.borderMode == 2 || this.hasHeaders() ? (this.hasHeaders() ? this.getHeaderBorder().getDrawnWidth() : this.getTopBorder().getDrawnWidth()) : this.getIntersectionBorderOffset(n2 - 1, n, false);
        measure4 = n4 == this.rowCount - 1 || this.borderMode == 2 ? (this.isHeader() ? this.getHeaderBorder().getDrawnWidth() : this.getBottomBorder().getDrawnWidth()) : this.getIntersectionBorderOffset(n4, n, false);
        JCUnit.Measure measure6 = new JCUnit.Measure(JCUnit.POINTS, 1.0);
        JCUnit.Measure measure7 = new JCUnit.Measure(JCUnit.POINTS, 0.0);
        if (measure3.lessThan(measure6)) {
            measure3.assign(measure7);
        }
        if (measure4.lessThan(measure6)) {
            measure4.assign(measure7);
        }
        measure3.divide(2.0);
        measure4.divide(2.0);
        JCUnit.Measure measure8 = (JCUnit.Measure)measure2.clone();
        measure8.subtract(measure3);
        JCDrawStyle jCDrawStyle = this.getEffectiveColumnBorder(n2, n, n3, n5);
        JCUnit.Measure measure9 = (JCUnit.Measure)measure2.clone();
        int n6 = n2;
        while (n6 <= n4) {
            JCDrawStyle jCDrawStyle2 = this.getEffectiveColumnBorder(n6, n, n3, n5);
            if (jCDrawStyle2 != null && !jCDrawStyle2.equals(jCDrawStyle) || jCDrawStyle2 == null && jCDrawStyle != null) {
                JCUnit.Measure measure10 = this.getIntersectionBorderOffset(n6, n, false);
                if (measure10.lessThan(measure6)) {
                    measure10.assign(measure7);
                }
                measure10.divide(2.0);
                if (jCDrawStyle != null) {
                    measure5.assign(measure9);
                    measure5.add(measure10);
                    this.drawBorder(jCFrame, jCDrawStyle, measure, measure8, measure, measure5);
                }
                jCDrawStyle = jCDrawStyle2;
                measure8.assign(measure9);
                measure8.subtract(measure10);
            }
            measure9.add(measureArray[n6]);
            ++n6;
        }
        if (jCDrawStyle != null) {
            measure9.add(measure4);
            this.drawBorder(jCFrame, jCDrawStyle, measure, measure8, measure, measure9);
        }
    }

    private JCDrawStyle getEffectiveColumnBorder(int n, int n2, int n3, int n4) {
        JCDrawStyle jCDrawStyle = null;
        if (n2 >= n3 && n2 < n4) {
            return this.getRawRightBorder(n, n2);
        }
        if (this.borderMode != 2 && n2 >= 0 && n2 < this.columnCount) {
            return this.getRawRightBorder(n, n2);
        }
        if (n2 < n3) {
            jCDrawStyle = this.getLeftBorder();
            if (n2 == -1) {
                return jCDrawStyle;
            }
        } else if (n2 + 1 >= n4) {
            jCDrawStyle = this.getRightBorder();
            if (n2 + 1 == n4) {
                return jCDrawStyle;
            }
        } else {
            throw new IllegalArgumentException("Invalid column address to get border");
        }
        if (this.getRawRightBorder(n, n2) == null) {
            return null;
        }
        return jCDrawStyle;
    }

    private JCUnit.Measure getIntersectionBorderOffset(int n, int n2, boolean bl) {
        JCUnit.Measure measure;
        JCDrawStyle jCDrawStyle = null;
        JCDrawStyle jCDrawStyle2 = null;
        if (bl) {
            if (n >= 0) {
                jCDrawStyle = this.getRawRightBorder(n, n2);
            }
        } else if (n2 >= 0) {
            jCDrawStyle = this.getRawBottomBorder(n, n2);
        }
        JCUnit.Measure measure2 = jCDrawStyle != null ? jCDrawStyle.getDrawnWidth() : new JCUnit.Measure();
        if (bl) {
            if (n + 1 < this.rowCount) {
                jCDrawStyle2 = this.getRawRightBorder(n + 1, n2);
            }
        } else if (n2 + 1 < this.columnCount) {
            jCDrawStyle2 = this.getRawBottomBorder(n, n2 + 1);
        }
        if (jCDrawStyle2 != null && (measure = jCDrawStyle2.getDrawnWidth()).greaterThan(measure2)) {
            measure2.assign(measure);
        }
        return measure2;
    }

    private void drawTableBorders(JCFrame jCFrame, int n, int n2, int n3, int n4, JCUnit.Measure measure, JCUnit.Measure measure2) {
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl = this.borderMode == 2;
        JCUnit.Measure[] measureArray = new JCUnit.Measure[this.columnCount];
        JCUnit.Measure[] measureArray2 = new JCUnit.Measure[this.rowCount];
        JCUnit.Measure measure3 = (JCUnit.Measure)measure.clone();
        JCUnit.Measure measure4 = (JCUnit.Measure)measure2.clone();
        int n9 = n;
        while (n9 <= n3) {
            measureArray2[n9] = this.getRow(n9).getDrawnHeight(n9 == n, n9 == n3);
            ++n9;
        }
        int n10 = n2;
        while (n10 <= n4) {
            measureArray[n10] = this.getColumn(n10).getDrawnWidth(n10 == n2, n10 == n4);
            ++n10;
        }
        if (!bl) {
            n8 = n;
            n7 = n3;
            n6 = n2;
            n5 = n4;
            if (n2 > 0) {
                n6 = n2 - 1;
                measureArray[n6] = new JCUnit.Measure();
            }
            if (n4 + 1 == this.columnCount) {
                n5 = n4 - 1;
            }
            if (n > 0 && !this.hasHeaders()) {
                n8 = n - 1;
                measureArray2[n8] = new JCUnit.Measure();
            }
            if (n3 + 1 == this.rowCount) {
                n7 = n3 - 1;
            }
        } else {
            n6 = n2;
            n8 = n;
            n5 = n4 - 1;
            n7 = n3 - 1;
        }
        if (this.dominance == 1) {
            n10 = n6;
            while (n10 <= n5) {
                measure3.add(measureArray[n10]);
                this.drawColumnBorder(jCFrame, n10, n, n2, n3, n4, measure3, measure2, measureArray2);
                ++n10;
            }
            n9 = n8;
            while (n9 <= n7) {
                measure4.add(measureArray2[n9]);
                this.drawRowBorder(jCFrame, n9, n, n2, n3, n4, measure, measure4, measureArray);
                ++n9;
            }
        } else {
            n9 = n8;
            while (n9 <= n7) {
                measure4.add(measureArray2[n9]);
                this.drawRowBorder(jCFrame, n9, n, n2, n3, n4, measure, measure4, measureArray);
                ++n9;
            }
            n10 = n6;
            while (n10 <= n5) {
                measure3.add(measureArray[n10]);
                this.drawColumnBorder(jCFrame, n10, n, n2, n3, n4, measure3, measure2, measureArray2);
                ++n10;
            }
        }
        measure4.assign(measure2);
        n9 = n8;
        while (n9 <= n7) {
            measure3.assign(measure);
            measure4.add(measureArray2[n9]);
            n10 = n6;
            while (n10 <= n5) {
                measure3.add(measureArray[n10]);
                this.checkBorderIntersection(jCFrame, n9, n10, measure3, measure4);
                ++n10;
            }
            ++n9;
        }
        if (n7 < n3) {
            measure4.add(measureArray2[n3]);
        }
        if (n5 < n4) {
            measure3.add(measureArray[n4]);
        }
        if (this.dominance == 1) {
            if (n2 == 0 || bl) {
                this.drawColumnBorder(jCFrame, n2 - 1, n, n2, n3, n4, measure, measure2, measureArray2);
            }
            if (n4 + 1 == this.columnCount || bl) {
                this.drawColumnBorder(jCFrame, n4, n, n2, n3, n4, measure3, measure2, measureArray2);
            }
            if (!this.hasHeaders() && (n == 0 || bl)) {
                this.drawRowBorder(jCFrame, n - 1, n, n2, n3, n4, measure, measure2, measureArray);
            }
            if (n3 + 1 == this.rowCount || bl) {
                this.drawRowBorder(jCFrame, n3, n, n2, n3, n4, measure, measure4, measureArray);
            }
        } else {
            if (!this.hasHeaders() && (n == 0 || bl)) {
                this.drawRowBorder(jCFrame, n - 1, n, n2, n3, n4, measure, measure2, measureArray);
            }
            if (n3 + 1 == this.rowCount || bl) {
                this.drawRowBorder(jCFrame, n3, n, n2, n3, n4, measure, measure4, measureArray);
            }
            if (n2 == 0 || bl) {
                this.drawColumnBorder(jCFrame, n2 - 1, n, n2, n3, n4, measure, measure2, measureArray2);
            }
            if (n4 + 1 == this.columnCount || bl) {
                this.drawColumnBorder(jCFrame, n4, n, n2, n3, n4, measure3, measure2, measureArray2);
            }
        }
    }

    private void checkBorderIntersection(JCFrame jCFrame, int n, int n2, JCUnit.Measure measure, JCUnit.Measure measure2) {
        JCUnit.Measure measure3;
        Color color;
        JCDrawStyle jCDrawStyle;
        JCDrawStyle jCDrawStyle2;
        JCDrawStyle jCDrawStyle3;
        JCDrawStyle jCDrawStyle4 = null;
        if (this.dominance == 1) {
            if (n + 1 >= this.rowCount) {
                return;
            }
            jCDrawStyle3 = this.getRawRightBorder(n, n2);
            jCDrawStyle2 = this.getRawRightBorder(n + 1, n2);
            jCDrawStyle = this.getRawBottomBorder(n, n2);
            if (n2 + 1 < this.columnCount) {
                jCDrawStyle4 = this.getRawBottomBorder(n, n2 + 1);
            }
        } else {
            if (n2 + 1 >= this.columnCount) {
                return;
            }
            jCDrawStyle3 = this.getRawBottomBorder(n, n2);
            jCDrawStyle2 = this.getRawBottomBorder(n, n2 + 1);
            jCDrawStyle = this.getRawRightBorder(n, n2);
            if (n + 1 < this.rowCount) {
                jCDrawStyle4 = this.getRawRightBorder(n + 1, n2);
            }
        }
        if (jCDrawStyle != null && jCDrawStyle.equals(jCDrawStyle4) || jCDrawStyle == jCDrawStyle4) {
            return;
        }
        Color color2 = color = jCDrawStyle4 != null ? jCDrawStyle4.getForegroundColor() : jCDrawStyle.getForegroundColor();
        if (jCDrawStyle3 == null || !jCDrawStyle3.equals(jCDrawStyle2) || jCDrawStyle3.getForegroundColor() == null) {
            return;
        }
        if (jCDrawStyle3.getForegroundColor().equals(color)) {
            return;
        }
        JCUnit.Measure measure4 = new JCUnit.Measure();
        if (jCDrawStyle != null) {
            measure4.assign(jCDrawStyle.getDrawnWidth());
        }
        if (jCDrawStyle4 != null && (measure3 = jCDrawStyle4.getDrawnWidth()).greaterThan(measure4)) {
            measure4.assign(measure3);
        }
        measure4.divide(2.0);
        if (this.dominance == 1) {
            JCUnit.Measure measure5 = (JCUnit.Measure)measure2.clone();
            JCUnit.Measure measure6 = (JCUnit.Measure)measure2.clone();
            measure5.subtract(measure4);
            measure6.add(measure4);
            this.drawBorder(jCFrame, jCDrawStyle3, measure, measure5, measure, measure6);
        } else {
            JCUnit.Measure measure7 = (JCUnit.Measure)measure.clone();
            JCUnit.Measure measure8 = (JCUnit.Measure)measure.clone();
            measure7.subtract(measure4);
            measure8.add(measure4);
            this.drawBorder(jCFrame, jCDrawStyle3, measure7, measure2, measure8, measure2);
        }
    }

    private void pasteCells(JCFrame jCFrame, int n, int n2, int n3, int n4, JCUnit.Measure measure, JCUnit.Measure measure2) {
        if (n < 0 || n3 >= this.rowCount || n > n3) {
            throw new IllegalArgumentException("Invalid row range");
        }
        if (n2 < 0 || n4 >= this.columnCount || n2 > n4) {
            throw new IllegalArgumentException("Invalid column range");
        }
        JCUnit.Measure measure3 = new JCUnit.Measure();
        JCUnit.Measure measure4 = new JCUnit.Measure();
        JCUnit.Measure measure5 = new JCUnit.Measure();
        measure4.assign(measure2);
        int n5 = n;
        while (n5 <= n3) {
            measure3.assign(measure);
            Row row = this.getRow(n5);
            measure5.assign(row.getHeight());
            measure5.add(row.getExtraHeight());
            int n6 = n2;
            while (n6 <= n4) {
                Object object;
                Cell cell = this.getCellRaw(n5, n6);
                Column column = this.isHeader() ? this.mainTable.getColumn(n6) : this.getColumn(n6);
                if (cell != UNINITIALISED_CELL && cell.getFrameRaw() != null) {
                    if (cell.isSpanned()) {
                        object = cell.getSpanOrigin();
                        if (!(((Point)object).x != n6 && n6 != n2 || ((Point)object).y != n5 && n5 != n)) {
                            cell.pasteSpan(jCFrame, n5, n6, n3, n4, measure3, measure4);
                        }
                    } else {
                        cell.paste(jCFrame, measure3, measure4, measure5);
                    }
                } else if (this.tableData != null && (object = this.tableData.getTableDataItem(n5, n6)) != null) {
                    Cloneable cloneable;
                    if (this.isTableDataValueInherited(n5, n6) && object instanceof Expression) {
                        ExpressionVariable.setVariable(this, "currentRow", new MathScalar(n5));
                        ExpressionVariable.setVariable(this, "currentColumn", new MathScalar(n6));
                        cloneable = (Expression)object;
                        try {
                            this.tableData.setTableDataItem(cloneable.clone(), n5, n6);
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            // empty catch block
                        }
                    }
                    cloneable = new TableCellRender(this, n5, n6);
                    JCUnit.Point point = new JCUnit.Point(measure3.units);
                    point.setX(measure3);
                    point.setY(measure4);
                    ((Render)cloneable).setLocation(point);
                    JCUnit.Dimension dimension = new JCUnit.Dimension(measure5.units);
                    dimension.setWidth(column.getWidth());
                    dimension.setHeight(measure5);
                    ((Render)cloneable).setSize(dimension);
                    jCFrame.getRenderList().add(cloneable);
                }
                measure3.add(column.getWidth());
                measure3.add(column.getBorderWidth());
                ++n6;
            }
            measure4.add(measure5);
            measure4.add(row.getBorderWidth());
            ++n5;
        }
    }

    private boolean isTableDataValueInherited(int n, int n2) {
        Vector vector = ((PageTableVectorDataSource)this.tableData).getCells();
        if (n >= vector.size()) {
            return true;
        }
        Vector vector2 = (Vector)vector.get(n);
        if (n2 >= vector2.size()) {
            return true;
        }
        return vector2.get(n2) == null;
    }

    public class Cell {
        protected Color background = null;
        protected JCDrawStyle bottomBorder = null;
        protected JCDrawStyle rightBorder = null;
        protected JCTextStyle textStyle = null;
        protected int cellAlignment = 1;
        protected JCUnit.Measure bottomMargin = null;
        protected JCUnit.Measure leftMargin = null;
        protected JCUnit.Measure rightMargin = null;
        protected JCUnit.Measure topMargin = null;
        protected Row rowParent = null;
        protected Column columnParent = null;
        protected JCFrame frame = null;
        protected JCUnit.Measure cellHeight = null;
        protected JCUnit.Measure width = null;
        protected int rowNumber = 0;
        protected int columnNumber = 0;
        protected boolean isSpanned = false;
        protected Point spanOrigin;
        protected int spanRows = 0;
        protected int spanColumns = 0;

        public Cell() {
        }

        public Cell(Row row, int n) {
            this();
            this.rowParent = row;
            this.rowNumber = this.rowParent.getRowNumber();
            this.columnNumber = n;
            this.columnParent = jCPageTable.getColumn(n);
            this.width = this.columnParent.getWidth();
            if (this.rowParent.hasFixedHeight()) {
                this.cellHeight = (JCUnit.Measure)this.rowParent.getHeight().clone();
            }
        }

        public boolean isBackgroundColorInherited() {
            return this.background == null;
        }

        public Color getBackgroundColor() {
            if (this.isBackgroundColorInherited()) {
                if (this.rowParent == null) {
                    return this.background;
                }
                if (JCPageTable.this.dominance == 1) {
                    if (this.rowParent.isBackgroundColorInherited()) {
                        return this.columnParent.getBackgroundColor();
                    }
                    return this.rowParent.getBackgroundColor();
                }
                if (this.columnParent.isBackgroundColorInherited()) {
                    return this.rowParent.getBackgroundColor();
                }
                return this.columnParent.getBackgroundColor();
            }
            return this.background;
        }

        public void setBackgroundColor(Color color) {
            this.background = color;
            if (this.frame != null) {
                this.frame.setColor(color);
            }
        }

        public boolean isBottomBorderInherited() {
            return this.bottomBorder == null;
        }

        public JCDrawStyle getBottomBorderStyle() {
            if (this.isBottomBorderInherited()) {
                if (this.rowParent == null) {
                    return JCPageTable.this.getRowBorder();
                }
                if (!this.isSpanned) {
                    return this.rowParent.getBorderStyle();
                }
                Cell cell = JCPageTable.this.getCell(this.spanOrigin.y, this.spanOrigin.x);
                Row row = JCPageTable.this.getRow(cell.getRowNumber() + cell.getSpanRows() - 1);
                return row.getBorderStyle();
            }
            return this.bottomBorder;
        }

        public void setBottomBorderStyle(JCDrawStyle jCDrawStyle) {
            this.bottomBorder = jCDrawStyle = jCDrawStyle.getImmutable();
        }

        public boolean isRightBorderInherited() {
            return this.rightBorder == null;
        }

        public JCDrawStyle getRightBorderStyle() {
            if (this.isRightBorderInherited()) {
                if (this.rowParent == null) {
                    return JCPageTable.this.getColumnBorder();
                }
                if (!this.isSpanned) {
                    return this.columnParent.getBorderStyle();
                }
                Cell cell = JCPageTable.this.getCell(this.spanOrigin.y, this.spanOrigin.x);
                Column column = JCPageTable.this.getColumn(cell.getColumnNumber() + cell.getSpanColumns() - 1);
                return column.getBorderStyle();
            }
            return this.rightBorder;
        }

        public void setRightBorderStyle(JCDrawStyle jCDrawStyle) {
            this.rightBorder = jCDrawStyle = jCDrawStyle.getImmutable();
        }

        public boolean isCellAlignmentInherited() {
            return this.cellAlignment == 1;
        }

        public int getCellAlignment() {
            if (this.isCellAlignmentInherited()) {
                if (this.rowParent == null) {
                    return this.cellAlignment;
                }
                if (JCPageTable.this.dominance == 1) {
                    if (this.rowParent.isDefaultCellAlignmentInherited()) {
                        return this.columnParent.getDefaultCellAlignment();
                    }
                    return this.rowParent.getDefaultCellAlignment();
                }
                if (this.columnParent.isDefaultCellAlignmentInherited()) {
                    return this.rowParent.getDefaultCellAlignment();
                }
                return this.columnParent.getDefaultCellAlignment();
            }
            return this.cellAlignment;
        }

        public void setCellAlignment(int n) {
            if (n <= 0 || n > 4) {
                throw new IllegalArgumentException("Unrecognised cell alignment");
            }
            this.cellAlignment = n;
        }

        public boolean isStyleInherited() {
            return this.textStyle == null;
        }

        public JCTextStyle getStyle() {
            if (this.isStyleInherited()) {
                if (this.rowParent == null) {
                    return JCPageTable.this.getDefaultStyle();
                }
                if (JCPageTable.this.dominance == 1) {
                    if (this.rowParent.isDefaultStyleInherited()) {
                        return this.columnParent.getDefaultStyle();
                    }
                    return this.rowParent.getDefaultStyle();
                }
                if (this.columnParent.isDefaultStyleInherited()) {
                    return this.rowParent.getDefaultStyle();
                }
                return this.columnParent.getDefaultStyle();
            }
            return this.textStyle;
        }

        public void setStyle(JCTextStyle jCTextStyle) {
            this.textStyle = jCTextStyle = jCTextStyle.getImmutable();
        }

        public boolean isBottomMarginInherited() {
            return this.bottomMargin == null;
        }

        public JCUnit.Measure getBottomMargin() {
            if (this.isBottomMarginInherited()) {
                if (this.rowParent == null) {
                    return JCPageTable.this.getDefaultBottomMargin();
                }
                if (JCPageTable.this.dominance == 1) {
                    if (this.rowParent.isDefaultBottomMarginInherited()) {
                        return this.columnParent.getDefaultBottomMargin();
                    }
                    return this.rowParent.getDefaultBottomMargin();
                }
                if (this.columnParent.isDefaultBottomMarginInherited()) {
                    return this.rowParent.getDefaultBottomMargin();
                }
                return this.columnParent.getDefaultBottomMargin();
            }
            return this.bottomMargin;
        }

        public void setBottomMargin(JCUnit.Measure measure) {
            if (measure.isNegative()) {
                throw new IllegalArgumentException("Margin width must be non-negative");
            }
            this.bottomMargin = measure;
        }

        public boolean isTopMarginInherited() {
            return this.topMargin == null;
        }

        public JCUnit.Measure getTopMargin() {
            if (this.isTopMarginInherited()) {
                if (this.rowParent == null) {
                    return JCPageTable.this.getDefaultTopMargin();
                }
                if (JCPageTable.this.dominance == 1) {
                    if (this.rowParent.isDefaultTopMarginInherited()) {
                        return this.columnParent.getDefaultTopMargin();
                    }
                    return this.rowParent.getDefaultTopMargin();
                }
                if (this.columnParent.isDefaultTopMarginInherited()) {
                    return this.rowParent.getDefaultTopMargin();
                }
                return this.columnParent.getDefaultTopMargin();
            }
            return this.topMargin;
        }

        public void setTopMargin(JCUnit.Measure measure) {
            if (measure.isNegative()) {
                throw new IllegalArgumentException("Margin width must be non-negative");
            }
            this.topMargin = measure;
        }

        public boolean isLeftMarginInherited() {
            return this.leftMargin == null;
        }

        public JCUnit.Measure getLeftMargin() {
            if (this.isLeftMarginInherited()) {
                if (this.rowParent == null) {
                    return JCPageTable.this.getDefaultLeftMargin();
                }
                if (JCPageTable.this.dominance == 1) {
                    if (this.rowParent.isDefaultLeftMarginInherited()) {
                        return this.columnParent.getDefaultLeftMargin();
                    }
                    return this.rowParent.getDefaultLeftMargin();
                }
                if (this.columnParent.isDefaultLeftMarginInherited()) {
                    return this.rowParent.getDefaultLeftMargin();
                }
                return this.columnParent.getDefaultLeftMargin();
            }
            return this.leftMargin;
        }

        public void setLeftMargin(JCUnit.Measure measure) {
            if (measure.isNegative()) {
                throw new IllegalArgumentException("Margin width must be non-negative");
            }
            this.leftMargin = measure;
            if (this.rowParent == null) {
                return;
            }
            JCUnit.Measure measure2 = (JCUnit.Measure)this.width.clone();
            measure2.subtract(this.getRightMargin());
            measure2.subtract(measure);
            if (this.frame != null) {
                JCUnit.Dimension dimension = this.frame.getSize();
                dimension.setWidth(measure2);
                this.frame.setSize(dimension);
            }
        }

        public boolean isRightMarginInherited() {
            return this.rightMargin == null;
        }

        public JCUnit.Measure getRightMargin() {
            if (this.isRightMarginInherited()) {
                if (this.rowParent == null) {
                    return JCPageTable.this.getDefaultRightMargin();
                }
                if (JCPageTable.this.dominance == 1) {
                    if (this.rowParent.isDefaultRightMarginInherited()) {
                        return this.columnParent.getDefaultRightMargin();
                    }
                    return this.rowParent.getDefaultRightMargin();
                }
                if (this.columnParent.isDefaultRightMarginInherited()) {
                    return this.rowParent.getDefaultRightMargin();
                }
                return this.columnParent.getDefaultRightMargin();
            }
            return this.rightMargin;
        }

        public void setRightMargin(JCUnit.Measure measure) {
            if (measure.isNegative()) {
                throw new IllegalArgumentException("Margin width must be non-negative");
            }
            this.rightMargin = measure;
            if (this.rowParent == null) {
                return;
            }
            JCUnit.Measure measure2 = (JCUnit.Measure)this.width.clone();
            measure2.subtract(this.getLeftMargin());
            measure2.subtract(measure);
            if (this.frame != null) {
                JCUnit.Dimension dimension = this.frame.getSize();
                dimension.setWidth(measure2);
                this.frame.setSize(dimension);
            }
        }

        public boolean isCellValueInherited() {
            Vector vector = ((PageTableVectorDataSource)JCPageTable.this.tableData).getCells();
            if (this.rowNumber >= vector.size()) {
                return true;
            }
            Vector vector2 = (Vector)vector.get(this.rowNumber);
            if (this.columnNumber >= vector2.size()) {
                return true;
            }
            return vector2.get(this.columnNumber) == null;
        }

        public Object getCellValue() {
            if (this.rowParent == null) {
                return null;
            }
            return JCPageTable.this.tableData.getTableDataItem(this.rowNumber, this.columnNumber);
        }

        public void setCellValue(Object object) {
            if (this.rowParent == null) {
                return;
            }
            JCPageTable.this.tableData.setTableDataItem(object, this.rowNumber, this.columnNumber);
        }

        public JCUnit.Measure getHeight() {
            if (this.rowParent.hasFixedHeight()) {
                return this.rowParent.getHeight();
            }
            if (this.cellHeight != null) {
                return this.cellHeight;
            }
            JCUnit.Measure measure = (JCUnit.Measure)this.getTopMargin().clone();
            measure.add(this.getBottomMargin());
            if (this.frame != null) {
                JCUnit.Measure measure2 = this.frame.getSize().getHeight();
                JCUnit.Measure measure3 = !measure2.equals(JCFrame.FLEXIBLE_SIZE) && measure2.greaterThan(new JCUnit.Measure(0.0)) ? this.frame.getSize().getHeight() : this.frame.getInsertionPoint().getY();
                measure3.add(this.frame.getMargins().getBottom());
                measure.add(measure3);
            }
            return measure;
        }

        public void setHeight(JCUnit.Measure measure) {
            if (measure.isNegative()) {
                throw new IllegalArgumentException("Invalid cell height");
            }
            this.cellHeight = (JCUnit.Measure)measure.clone();
            JCUnit.Measure measure2 = (JCUnit.Measure)measure.clone();
            if (this.frame != null) {
                measure2.subtract(this.getTopMargin());
                measure2.subtract(this.getBottomMargin());
                if (measure2.isNegative()) {
                    measure2.distance = 0.0;
                }
                JCUnit.Dimension dimension = this.frame.getSize();
                dimension.setHeight(measure2);
                this.frame.setSize(dimension);
            }
        }

        public JCUnit.Measure getWidth() {
            if (this.width == null) {
                return this.columnParent.getWidth();
            }
            return this.width;
        }

        public void setWidth(JCUnit.Measure measure) {
            if (measure.isNegative()) {
                throw new IllegalArgumentException("Invalid cell width");
            }
            this.width = (JCUnit.Measure)measure.clone();
            JCUnit.Measure measure2 = (JCUnit.Measure)measure.clone();
            if (this.leftMargin != null) {
                measure2.subtract(this.leftMargin);
            }
            if (this.rightMargin != null) {
                measure2.subtract(this.rightMargin);
            }
            if (measure2.isNegative()) {
                measure2.distance = 0.0;
            }
            if (this.frame != null) {
                JCUnit.Dimension dimension = this.frame.getSize();
                dimension.width = measure2.getAs(dimension.units);
                this.frame.setSize(dimension);
            }
        }

        public JCFrame getFrame() {
            if (this.isSpanned && (this.spanOrigin.y != this.rowNumber || this.spanOrigin.x != this.columnNumber)) {
                return JCPageTable.this.getCell(this.spanOrigin.y, this.spanOrigin.x).getFrame();
            }
            if (this.frame == null) {
                JCUnit.Measure measure;
                JCUnit.Measure measure2 = (JCUnit.Measure)this.width.clone();
                measure2.subtract(this.getLeftMargin());
                measure2.subtract(this.getRightMargin());
                if (measure2.isNegative()) {
                    measure2.distance = 0.0;
                }
                JCUnit.Dimension dimension = new JCUnit.Dimension(measure2.units);
                dimension.setWidth(measure2);
                if (this.cellHeight != null) {
                    measure = (JCUnit.Measure)this.cellHeight.clone();
                    measure.subtract(this.getTopMargin());
                    measure.subtract(this.getBottomMargin());
                    if (measure.isNegative()) {
                        measure.distance = 0.0;
                    }
                } else {
                    measure = (JCUnit.Measure)JCFrame.FLEXIBLE_SIZE.clone();
                }
                dimension.setHeight(measure);
                String string = "cell_frame_" + this.rowNumber + "_" + this.columnNumber;
                this.frame = new JCFrame(string, JCPageTable.this.getDocument());
                this.frame.setSize(dimension);
            }
            return this.frame;
        }

        public JCFrame getFrameRaw() {
            return this.frame;
        }

        public boolean isSpanned() {
            return this.isSpanned;
        }

        public Point getSpanOrigin() {
            if (!this.isSpanned) {
                return new Point(-1, -1);
            }
            return this.spanOrigin;
        }

        public void setSpanOrigin(Point point) {
            this.spanOrigin = new Point(point);
            this.isSpanned = true;
        }

        public void setSpanOrigin(int n, int n2) {
            this.spanOrigin = new Point(n2, n);
            this.isSpanned = true;
        }

        public int getSpanRows() {
            return this.spanRows;
        }

        public int getSpanColumns() {
            return this.spanColumns;
        }

        public void setSpanSize(int n, int n2) {
            if (n < 1 || n2 < 1 || n2 > JCPageTable.this.getColumnCount()) {
                throw new IllegalArgumentException("Invalid span size");
            }
            this.spanRows = n;
            this.spanColumns = n2;
        }

        public Column getColumn() {
            return this.columnParent;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public Row getRow() {
            return this.rowParent;
        }

        public int getRowNumber() {
            return this.rowNumber;
        }

        public JCUnit.Measure fixHeight() {
            Object object;
            JCUnit.Measure measure = (JCUnit.Measure)this.getTopMargin().clone();
            measure.add(this.getBottomMargin());
            if (this.frame != null) {
                this.frame.complete();
                JCUnit.Measure measure2 = this.frame.getSize().getHeight();
                JCUnit.Measure measure3 = !measure2.equals(JCFrame.FLEXIBLE_SIZE) && measure2.greaterThan(new JCUnit.Measure(0.0)) ? this.frame.getSize().getHeight() : this.frame.getInsertionPoint().getY();
                measure3.add(this.frame.getMargins().getBottom());
                JCUnit.Dimension dimension = this.frame.getSize();
                dimension.setHeight(measure3);
                this.frame.setSize(dimension);
                measure.add(measure3);
            } else if (JCPageTable.this.tableData != null && (object = JCPageTable.this.tableData.getTableDataItem(this.rowNumber, this.columnNumber)) != null) {
                Dimension dimension;
                Class<?> clazz = object.getClass();
                JCCellRenderer jCCellRenderer = EditorRendererRegistry.getCentralRegistry().getCellRendererInstance(clazz, null);
                PageTableCellInfo pageTableCellInfo = new PageTableCellInfo(JCPageTable.this, this.rowNumber, this.columnNumber);
                if (jCCellRenderer instanceof JCComponentCellRenderer) {
                    Component component = ((JCComponentCellRenderer)jCCellRenderer).getRendererComponent(pageTableCellInfo, object, false);
                    dimension = component.getPreferredSize();
                } else {
                    Graphics graphics = JCPageTable.this.document.getPrinter().getGraphics();
                    dimension = ((JCLightCellRenderer)jCCellRenderer).getPreferredSize(graphics, pageTableCellInfo, object);
                }
                measure.add(new JCUnit.Measure(JCUnit.POINTS, dimension.height));
            }
            if (this.rowParent.hasFixedHeight()) {
                return this.rowParent.getHeight();
            }
            if (this.cellHeight != null) {
                return this.cellHeight;
            }
            this.cellHeight = measure;
            return this.cellHeight;
        }

        protected JCDrawStyle getBottomEdgeStyle() {
            JCDrawStyle jCDrawStyle;
            if (this.isSpanned) {
                Cell cell = JCPageTable.this.getCell(this.spanOrigin.y, this.spanOrigin.x);
                if (this.spanOrigin.y + cell.getSpanRows() - 1 > this.rowNumber) {
                    return null;
                }
                jCDrawStyle = cell.getBottomBorderStyle();
            } else {
                jCDrawStyle = this.getBottomBorderStyle();
            }
            return jCDrawStyle;
        }

        protected JCDrawStyle getRightEdgeStyle() {
            JCDrawStyle jCDrawStyle;
            if (this.isSpanned) {
                Cell cell = JCPageTable.this.getCell(this.spanOrigin.y, this.spanOrigin.x);
                if (this.spanOrigin.x + cell.getSpanColumns() - 1 > this.columnNumber) {
                    return null;
                }
                jCDrawStyle = cell.getRightBorderStyle();
            } else {
                jCDrawStyle = this.getRightBorderStyle();
            }
            return jCDrawStyle;
        }

        protected void paste(JCFrame jCFrame, JCUnit.Measure measure, JCUnit.Measure measure2) {
            JCFrame jCFrame2 = (JCFrame)this.frame.clone();
            JCUnit.Point point = new JCUnit.Point(measure.units, measure.distance, measure2.distance);
            if (measure2.units != measure.units) {
                point.y = measure2.getAs(measure.units);
            }
            jCFrame2.setLocation(point);
            jCFrame.getFrameList().add(jCFrame2);
        }

        protected void paste(JCFrame jCFrame, JCUnit.Measure measure, JCUnit.Measure measure2, JCUnit.Margins margins) {
            JCFrame jCFrame2 = (JCFrame)this.frame.clone();
            JCUnit.Point point = new JCUnit.Point(measure.units, measure.distance, measure2.distance);
            if (measure2.units != measure.units) {
                point.y = measure2.getAs(measure.units);
            }
            jCFrame2.setLocation(point);
            jCFrame2.setClipMask(margins);
            jCFrame.getFrameList().add(jCFrame2);
        }

        protected void paste(JCFrame jCFrame, JCUnit.Measure measure, JCUnit.Measure measure2, JCUnit.Measure measure3) {
            JCUnit.Measure measure4;
            JCUnit.Measure measure5 = (JCUnit.Measure)measure.clone();
            JCUnit.Measure measure6 = (JCUnit.Measure)measure2.clone();
            JCUnit.Measure measure7 = this.getTopMargin();
            JCUnit.Measure measure8 = this.getBottomMargin();
            JCUnit.Measure measure9 = this.getLeftMargin();
            JCUnit.Measure measure10 = this.getRightMargin();
            JCUnit.Measure measure11 = this.frame.getSize().getHeight();
            JCUnit.Measure measure12 = this.frame.getSize().getWidth();
            JCUnit.Measure measure13 = (JCUnit.Measure)measure9.clone();
            int n = this.getCellAlignment();
            if (n == 2) {
                measure4 = (JCUnit.Measure)measure7.clone();
            } else if (n == 3) {
                measure4 = (JCUnit.Measure)measure3.clone();
                measure4.subtract(measure7);
                measure4.subtract(measure8);
                measure4.subtract(measure11);
                measure4.divide(2.0);
                measure4.add(measure7);
            } else if (n == 4) {
                measure4 = (JCUnit.Measure)measure3.clone();
                measure4.subtract(measure8);
                measure4.subtract(measure11);
            } else {
                measure4 = (JCUnit.Measure)measure7.clone();
            }
            JCUnit.Measure measure14 = (JCUnit.Measure)measure11.clone();
            JCUnit.Measure measure15 = new JCUnit.Measure();
            if (measure7.greaterThan(measure4)) {
                measure15.assign(measure7);
                measure15.subtract(measure4);
                measure14.subtract(measure15);
            }
            JCUnit.Measure measure16 = (JCUnit.Measure)measure11.clone();
            measure16.add(measure4);
            JCUnit.Measure measure17 = (JCUnit.Measure)measure3.clone();
            measure17.subtract(measure8);
            if (measure16.greaterThan(measure17)) {
                measure14.subtract(measure16);
                measure14.add(measure17);
            }
            JCUnit.Measure measure18 = (JCUnit.Measure)measure12.clone();
            JCUnit.Measure measure19 = new JCUnit.Measure();
            if (measure9.greaterThan(measure13)) {
                measure19.assign(measure9);
                measure19.subtract(measure13);
                measure18.subtract(measure19);
            }
            JCUnit.Measure measure20 = (JCUnit.Measure)measure12.clone();
            measure20.add(measure13);
            JCUnit.Measure measure21 = (JCUnit.Measure)this.getWidth().clone();
            measure21.subtract(measure10);
            if (measure20.greaterThan(measure21)) {
                measure18.subtract(measure20);
                measure18.add(measure21);
            }
            measure5.add(measure13);
            measure6.add(measure4);
            JCUnit.Margins margins = new JCUnit.Margins(measure19.units);
            margins.left = measure19.distance;
            margins.top = measure15.getAs(measure19.units);
            margins.right = measure18.getAs(measure19.units);
            margins.bottom = measure14.getAs(measure19.units);
            this.paste(jCFrame, measure5, measure6, margins);
        }

        protected void pasteSpan(JCFrame jCFrame, int n, int n2, int n3, int n4, JCUnit.Measure measure, JCUnit.Measure measure2) {
            JCUnit.Measure measure3;
            if (!this.isSpanned) {
                JCUnit.Measure measure4 = (JCUnit.Measure)this.rowParent.getHeight().clone();
                measure4.add(this.rowParent.getExtraHeight());
                this.paste(jCFrame, measure, measure2, measure4);
                return;
            }
            if (this.spanOrigin.y != this.rowNumber || this.spanOrigin.x != this.columnNumber) {
                Cell cell = JCPageTable.this.getCell(this.spanOrigin.y, this.spanOrigin.x);
                cell.pasteSpan(jCFrame, n, n2, n3, n4, measure, measure2);
                return;
            }
            JCUnit.Measure measure5 = new JCUnit.Measure();
            JCUnit.Measure measure6 = new JCUnit.Measure();
            JCUnit.Measure measure7 = new JCUnit.Measure();
            JCUnit.Measure measure8 = new JCUnit.Measure();
            Row row = JCPageTable.this.getRow(this.spanOrigin.y);
            JCUnit.Measure measure9 = (JCUnit.Measure)row.getHeight().clone();
            measure9.add(row.getExtraHeight());
            int n5 = this.spanOrigin.y + 1;
            while (n5 < this.spanOrigin.y + this.spanRows) {
                JCUnit.Measure measure10 = row.getBorderWidth();
                if (n5 == n) {
                    measure5.assign(measure9);
                    measure10.divide(2.0);
                    measure5.add(measure10);
                    measure10.multiply(2.0);
                }
                if (n5 == n3 + 1) {
                    measure6.assign(measure9);
                    measure10.divide(2.0);
                    measure6.add(measure10);
                    measure10.multiply(2.0);
                }
                measure9.add(measure10);
                row = JCPageTable.this.getRow(n5);
                measure9.add(row.getHeight());
                measure9.add(row.getExtraHeight());
                ++n5;
            }
            if (!measure6.isZero()) {
                measure6.subtract(measure9);
                measure6.multiply(-1.0);
            }
            Column column = JCPageTable.this.getColumn(this.spanOrigin.x);
            JCUnit.Measure measure11 = (JCUnit.Measure)column.getWidth().clone();
            int n6 = this.spanOrigin.x + 1;
            while (n6 < this.spanOrigin.x + this.spanColumns) {
                if (n6 == n2) {
                    measure7.assign(measure11);
                }
                measure11.add(column.getBorderWidth());
                if (n6 == n4 + 1) {
                    measure8.assign(measure11);
                }
                column = JCPageTable.this.getColumn(n6);
                measure11.add(column.getWidth());
                ++n6;
            }
            if (!measure8.isZero()) {
                measure8.subtract(measure11);
                measure8.multiply(-1.0);
            }
            if (measure5.isZero() && measure6.isZero() && measure7.isZero() && measure8.isZero()) {
                this.paste(jCFrame, measure, measure2, measure9);
                return;
            }
            JCUnit.Measure measure12 = this.frame.getSize().getHeight();
            JCUnit.Measure measure13 = this.frame.getSize().getWidth();
            JCUnit.Measure measure14 = this.getLeftMargin();
            JCUnit.Measure measure15 = this.getTopMargin();
            JCUnit.Measure measure16 = this.getBottomMargin();
            JCUnit.Measure measure17 = measure14;
            int n7 = this.getCellAlignment();
            if (n7 == 2) {
                measure3 = (JCUnit.Measure)measure15.clone();
            } else if (n7 == 3) {
                measure3 = (JCUnit.Measure)measure9.clone();
                measure3.subtract(measure15);
                measure3.subtract(measure16);
                measure3.subtract(measure12);
                measure3.divide(2.0);
                measure3.add(measure15);
            } else if (n7 == 4) {
                measure3 = (JCUnit.Measure)measure9.clone();
                measure3.subtract(measure16);
                measure3.subtract(measure12);
            } else {
                measure3 = (JCUnit.Measure)measure15.clone();
            }
            JCUnit.Measure measure18 = (JCUnit.Measure)measure12.clone();
            JCUnit.Measure measure19 = (JCUnit.Measure)measure5.clone();
            measure19.subtract(measure3);
            if (measure19.isNegative()) {
                measure19.distance = 0.0;
            } else {
                measure18.subtract(measure19);
            }
            JCUnit.Measure measure20 = (JCUnit.Measure)measure12.clone();
            measure20.add(measure3);
            JCUnit.Measure measure21 = (JCUnit.Measure)measure9.clone();
            measure21.subtract(measure6);
            if (measure20.greaterThan(measure21)) {
                measure18.subtract(measure20);
                measure18.add(measure21);
            }
            JCUnit.Measure measure22 = (JCUnit.Measure)measure13.clone();
            JCUnit.Measure measure23 = (JCUnit.Measure)measure7.clone();
            measure23.subtract(measure14);
            if (measure23.isNegative()) {
                measure23.distance = 0.0;
            } else {
                measure22.subtract(measure23);
            }
            JCUnit.Measure measure24 = (JCUnit.Measure)measure13.clone();
            measure24.add(measure14);
            JCUnit.Measure measure25 = (JCUnit.Measure)measure11.clone();
            measure25.subtract(measure8);
            if (measure24.greaterThan(measure25)) {
                measure22.subtract(measure24);
                measure22.add(measure25);
            }
            JCUnit.Margins margins = new JCUnit.Margins(measure23.units);
            margins.left = measure23.distance;
            margins.top = measure19.getAs(measure23.units);
            margins.right = measure22.getAs(measure23.units);
            margins.bottom = measure18.getAs(measure23.units);
            JCUnit.Measure measure26 = (JCUnit.Measure)measure.clone();
            measure26.add(measure17);
            measure26.subtract(measure7);
            JCUnit.Measure measure27 = (JCUnit.Measure)measure2.clone();
            measure27.add(measure3);
            measure27.subtract(measure5);
            this.paste(jCFrame, measure26, measure27, margins);
        }
    }

    public class Column {
        protected JCDrawStyle rightBorder = null;
        protected Color background = null;
        protected Cell defaultCell;
        protected JCUnit.Measure width;
        protected JCUnit.Measure borderWidth;
        protected int arrivingSpans;
        protected int departingSpans;
        protected int columnNumber;

        public Column() {
            this.defaultCell = new Cell();
            this.width = null;
            this.borderWidth = null;
            this.columnNumber = -1;
            this.arrivingSpans = 0;
            this.departingSpans = 0;
        }

        public Column(int n) {
            this();
            this.columnNumber = n;
        }

        public Column(JCUnit.Measure measure, int n) {
            this();
            this.setWidth(measure);
            this.columnNumber = n;
        }

        public boolean isBackgroundColorInherited() {
            return this.background == null;
        }

        public Color getBackgroundColor() {
            if (this.isBackgroundColorInherited()) {
                if (JCPageTable.this.isHeader() && this.columnNumber != -1) {
                    if (!JCPageTable.this.mainTable.getColumn(this.columnNumber).isBackgroundColorInherited()) {
                        return JCPageTable.this.mainTable.getColumn(this.columnNumber).getBackgroundColor();
                    }
                    return JCPageTable.this.getBackgroundColor();
                }
                return JCPageTable.this.getBackgroundColor();
            }
            return this.background;
        }

        public void setBackgroundColor(Color color) {
            this.background = color;
        }

        public boolean isBorderStyleInherited() {
            return this.rightBorder == null;
        }

        public JCDrawStyle getBorderStyle() {
            if (this.isBorderStyleInherited()) {
                if (JCPageTable.this.isHeader() && this.columnNumber != -1) {
                    return JCPageTable.this.mainTable.getColumn(this.columnNumber).getBorderStyle();
                }
                return JCPageTable.this.getColumnBorder();
            }
            return this.rightBorder;
        }

        public void setBorderStyle(JCDrawStyle jCDrawStyle) {
            this.rightBorder = jCDrawStyle = jCDrawStyle.getImmutable();
        }

        public boolean isDefaultCellAlignmentInherited() {
            return this.defaultCell.isCellAlignmentInherited();
        }

        public int getDefaultCellAlignment() {
            if (this.isDefaultCellAlignmentInherited()) {
                if (JCPageTable.this.isHeader() && this.columnNumber != -1) {
                    return JCPageTable.this.mainTable.getColumn(this.columnNumber).getDefaultCellAlignment();
                }
                return JCPageTable.this.getDefaultCellAlignment();
            }
            if (!JCPageTable.this.isHeader && this.defaultCell.getCellAlignment() == 1) {
                return 2;
            }
            return this.defaultCell.getCellAlignment();
        }

        public void setDefaultCellAlignment(int n) {
            this.defaultCell.setCellAlignment(n);
        }

        public boolean isDefaultStyleInherited() {
            return this.defaultCell.isStyleInherited();
        }

        public JCTextStyle getDefaultStyle() {
            if (this.isDefaultStyleInherited()) {
                if (JCPageTable.this.isHeader() && this.columnNumber != -1) {
                    return JCPageTable.this.mainTable.getColumn(this.columnNumber).getDefaultStyle();
                }
                return JCPageTable.this.getDefaultStyle();
            }
            return this.defaultCell.getStyle();
        }

        public void setDefaultStyle(JCTextStyle jCTextStyle) {
            this.defaultCell.setStyle(jCTextStyle);
        }

        public boolean isDefaultBottomMarginInherited() {
            return this.defaultCell.isBottomMarginInherited();
        }

        public JCUnit.Measure getDefaultBottomMargin() {
            if (this.isDefaultBottomMarginInherited()) {
                if (JCPageTable.this.isHeader() && this.columnNumber != -1) {
                    return JCPageTable.this.mainTable.getColumn(this.columnNumber).getDefaultBottomMargin();
                }
                return JCPageTable.this.getDefaultBottomMargin();
            }
            return this.defaultCell.getBottomMargin();
        }

        public void setDefaultBottomMargin(JCUnit.Measure measure) {
            this.defaultCell.setBottomMargin(measure);
        }

        public boolean isDefaultTopMarginInherited() {
            return this.defaultCell.isTopMarginInherited();
        }

        public JCUnit.Measure getDefaultTopMargin() {
            if (this.isDefaultTopMarginInherited()) {
                if (JCPageTable.this.isHeader() && this.columnNumber != -1) {
                    return JCPageTable.this.mainTable.getColumn(this.columnNumber).getDefaultTopMargin();
                }
                return JCPageTable.this.getDefaultTopMargin();
            }
            return this.defaultCell.getTopMargin();
        }

        public void setDefaultTopMargin(JCUnit.Measure measure) {
            this.defaultCell.setTopMargin(measure);
        }

        public boolean isDefaultLeftMarginInherited() {
            return this.defaultCell.isLeftMarginInherited();
        }

        public JCUnit.Measure getDefaultLeftMargin() {
            if (this.isDefaultLeftMarginInherited()) {
                if (JCPageTable.this.isHeader() && this.columnNumber != -1) {
                    return JCPageTable.this.mainTable.getColumn(this.columnNumber).getDefaultLeftMargin();
                }
                return JCPageTable.this.getDefaultLeftMargin();
            }
            return this.defaultCell.getLeftMargin();
        }

        public void setDefaultLeftMargin(JCUnit.Measure measure) {
            this.defaultCell.setLeftMargin(measure);
        }

        public boolean isDefaultRightMarginInherited() {
            return this.defaultCell.isRightMarginInherited();
        }

        public JCUnit.Measure getDefaultRightMargin() {
            if (this.isDefaultRightMarginInherited()) {
                if (JCPageTable.this.isHeader() && this.columnNumber != -1) {
                    return JCPageTable.this.mainTable.getColumn(this.columnNumber).getDefaultRightMargin();
                }
                return JCPageTable.this.getDefaultRightMargin();
            }
            return this.defaultCell.getRightMargin();
        }

        public void setDefaultRightMargin(JCUnit.Measure measure) {
            this.defaultCell.setRightMargin(measure);
        }

        public boolean isDefaultCellValueInherited() {
            return JCPageTable.this.tableData.getTableColumnLabel(this.columnNumber) == null;
        }

        public Object getDefaultCellValue() {
            return JCPageTable.this.tableData.getTableColumnLabel(this.columnNumber);
        }

        public void setDefaultCellValue(Object object) {
            ((PageTableVectorDataSource)JCPageTable.this.tableData).setColumnLabel(this.columnNumber, object);
        }

        public JCUnit.Measure getWidth() {
            return this.width;
        }

        public void setWidth(JCUnit.Measure measure) {
            if (measure.isNegative()) {
                throw new IllegalArgumentException("Invalid column width");
            }
            this.width = (JCUnit.Measure)measure.clone();
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        protected void addArrivingSpan() {
            ++this.arrivingSpans;
        }

        protected int getArrivingSpans() {
            return this.arrivingSpans;
        }

        protected void addDepartingSpan() {
            ++this.departingSpans;
        }

        protected int getDepartingSpans() {
            return this.departingSpans;
        }

        private JCUnit.Measure calculateBorderWidth() {
            JCUnit.Measure measure;
            JCUnit.Measure measure2 = this.getBorderStyle().getDrawnWidth();
            List list = JCPageTable.this.getRowList();
            int n = list.size();
            if (!JCPageTable.this.isHeader() && JCPageTable.this.header != null && (measure = JCPageTable.this.header.getColumn(this.columnNumber).getBorderWidth()).greaterThan(measure2)) {
                measure2 = measure;
            }
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    Cell cell;
                    block7: {
                        List list2;
                        Row row = (Row)list.get(n2);
                        if (row == UNINITIALISED_ROW || (list2 = row.getCellList()).size() <= this.columnNumber || (cell = (Cell)list2.get(this.columnNumber)) == UNINITIALISED_CELL) break block6;
                        if (!cell.isSpanned()) break block7;
                        Point point = cell.getSpanOrigin();
                        if (point.y != n2 || point.x + (cell = JCPageTable.this.getCell(point.y, point.x)).getSpanColumns() - 1 != this.columnNumber) break block6;
                    }
                    if (!cell.isRightBorderInherited() && (measure = cell.getRightBorderStyle().getDrawnWidth()).greaterThan(measure2)) {
                        measure2 = measure;
                    }
                }
                ++n2;
            }
            return measure2;
        }

        protected JCUnit.Measure getLeftBorderWidth() {
            return this.getLeftBorderWidth(true);
        }

        protected boolean noArrivingSpans() {
            boolean bl = this.arrivingSpans == 0;
            boolean bl2 = false;
            if (JCPageTable.this.isHeader()) {
                bl2 = JCPageTable.this.mainTable.getColumn(this.columnNumber).getArrivingSpans() == 0;
            } else if (JCPageTable.this.hasHeaders()) {
                bl2 = JCPageTable.this.header.getColumn(this.columnNumber).getArrivingSpans() == 0;
            }
            return bl && bl2;
        }

        protected boolean noDepartingSpans() {
            boolean bl = this.departingSpans == 0;
            boolean bl2 = false;
            if (JCPageTable.this.isHeader()) {
                bl2 = JCPageTable.this.mainTable.getColumn(this.columnNumber).getDepartingSpans() == 0;
            } else if (JCPageTable.this.hasHeaders()) {
                bl2 = JCPageTable.this.header.getColumn(this.columnNumber).getDepartingSpans() == 0;
            }
            return bl && bl2;
        }

        protected JCUnit.Measure getLeftBorderWidth(boolean bl) {
            JCUnit.Measure measure;
            JCUnit.Measure measure2 = this.columnNumber > 0 ? (JCPageTable.this.isHeader() ? JCPageTable.this.mainTable.getColumn(this.columnNumber - 1).getBorderWidth() : JCPageTable.this.getColumn(this.columnNumber - 1).getBorderWidth()) : new JCUnit.Measure();
            int n = JCPageTable.this.getBorderMode();
            JCUnit.Measure measure3 = JCPageTable.this.getLeftBorderWidth();
            if (n == 1 && this.columnNumber > 0) {
                measure = measure2;
            } else if (this.noArrivingSpans()) {
                measure = (JCUnit.Measure)measure3.clone();
            } else {
                measure = measure3.greaterThan(measure2) ? (JCUnit.Measure)measure3.clone() : measure2;
                if (bl) {
                    measure.add(measure3);
                    measure.divide(2.0);
                }
            }
            if (!bl) {
                measure.divide(2.0);
            }
            return measure;
        }

        protected JCUnit.Measure getRightBorderWidth() {
            return this.getRightBorderWidth(true);
        }

        protected JCUnit.Measure getRightBorderWidth(boolean bl) {
            JCUnit.Measure measure;
            int n = JCPageTable.this.getBorderMode();
            JCUnit.Measure measure2 = JCPageTable.this.getRightBorderWidth();
            JCUnit.Measure measure3 = JCPageTable.this.isHeader() ? JCPageTable.this.mainTable.getColumn(this.columnNumber).getBorderWidth() : this.getBorderWidth();
            if (this.noDepartingSpans()) {
                measure = this.columnNumber == JCPageTable.this.getColumnCount() - 1 || n == 2 ? (JCUnit.Measure)measure2.clone() : measure3;
            } else if (n == 1) {
                measure = measure3;
            } else {
                measure = measure3.greaterThan(measure2) ? measure3 : (JCUnit.Measure)measure2.clone();
                if (bl) {
                    measure.add(measure2);
                    measure.divide(2.0);
                }
            }
            if (!bl) {
                measure.divide(2.0);
            }
            return measure;
        }

        protected JCUnit.Measure getDrawnWidth(boolean bl, boolean bl2) {
            JCUnit.Measure measure;
            if (bl) {
                measure = this.getLeftBorderWidth(false);
            } else {
                measure = JCPageTable.this.isHeader() ? JCPageTable.this.mainTable.getColumn(this.columnNumber - 1).getBorderWidth() : JCPageTable.this.getColumn(this.columnNumber - 1).getBorderWidth();
                measure.divide(2.0);
            }
            measure.add(this.width);
            if (bl2) {
                measure.add(this.getRightBorderWidth(false));
            } else {
                JCUnit.Measure measure2 = JCPageTable.this.isHeader() ? JCPageTable.this.mainTable.getColumn(this.columnNumber).getBorderWidth() : this.getBorderWidth();
                measure2.divide(2.0);
                measure.add(measure2);
            }
            return measure;
        }

        protected JCUnit.Measure getBorderWidth() {
            if (this.borderWidth == null) {
                JCUnit.Measure measure = this.columnNumber + 1 == JCPageTable.this.getColumnCount() ? JCPageTable.this.getRightBorder().getDrawnWidth() : this.calculateBorderWidth();
                this.borderWidth = (JCUnit.Measure)measure.clone();
            }
            return (JCUnit.Measure)this.borderWidth.clone();
        }
    }

    public class Row {
        protected List cellList;
        protected JCDrawStyle bottomBorder = null;
        protected Color background = null;
        protected Cell defaultCell;
        protected JCUnit.Measure rowHeight;
        protected boolean fixedHeight = false;
        protected JCUnit.Measure extraHeight;
        protected JCUnit.Measure borderWidth;
        protected int arrivingSpans;
        protected int departingSpans;
        protected int rowNumber;

        public Row() {
            this.defaultCell = new Cell();
            this.cellList = new Vector();
            this.rowHeight = null;
            this.extraHeight = null;
            this.borderWidth = null;
            this.rowNumber = -1;
            this.arrivingSpans = 0;
            this.departingSpans = 0;
        }

        public Row(int n) {
            this();
            this.rowNumber = n;
        }

        public boolean isBackgroundColorInherited() {
            return this.background == null;
        }

        public Color getBackgroundColor() {
            if (this.isBackgroundColorInherited()) {
                return JCPageTable.this.getBackgroundColor();
            }
            return this.background;
        }

        public void setBackgroundColor(Color color) {
            this.background = color;
        }

        public boolean isBorderStyleInherited() {
            return this.bottomBorder == null;
        }

        public JCDrawStyle getBorderStyle() {
            if (this.isBorderStyleInherited()) {
                return JCPageTable.this.getRowBorder();
            }
            return this.bottomBorder;
        }

        public void setBorderStyle(JCDrawStyle jCDrawStyle) {
            this.bottomBorder = jCDrawStyle = jCDrawStyle.getImmutable();
        }

        public Cell getCell(int n) {
            Cell cell;
            if (n < 0 || n >= JCPageTable.this.columnCount) {
                throw new IllegalArgumentException("cell position out of range");
            }
            int n2 = this.cellList.size();
            if (n >= n2) {
                int n3 = n2;
                while (n3 <= n) {
                    this.cellList.add(UNINITIALISED_CELL);
                    ++n3;
                }
            }
            if ((cell = (Cell)this.cellList.get(n)) == UNINITIALISED_CELL) {
                cell = new Cell(this, n);
                this.cellList.set(n, cell);
            }
            if (cell.isSpanned()) {
                Point point = cell.getSpanOrigin();
                if (point.x != n || point.y != this.rowNumber) {
                    cell = JCPageTable.this.getCell(point.y, point.x);
                }
            }
            return cell;
        }

        public List getCellList() {
            return this.cellList;
        }

        public boolean isDefaultCellAlignmentInherited() {
            return this.defaultCell.isCellAlignmentInherited();
        }

        public int getDefaultCellAlignment() {
            if (this.isDefaultCellAlignmentInherited()) {
                return JCPageTable.this.getDefaultCellAlignment();
            }
            return this.defaultCell.getCellAlignment();
        }

        public void setDefaultCellAlignment(int n) {
            this.defaultCell.setCellAlignment(n);
        }

        public boolean isDefaultStyleInherited() {
            return this.defaultCell.isStyleInherited();
        }

        public JCTextStyle getDefaultStyle() {
            if (this.isDefaultStyleInherited()) {
                return JCPageTable.this.getDefaultStyle();
            }
            return this.defaultCell.getStyle();
        }

        public void setDefaultStyle(JCTextStyle jCTextStyle) {
            this.defaultCell.setStyle(jCTextStyle);
        }

        public boolean isDefaultBottomMarginInherited() {
            return this.defaultCell.isBottomMarginInherited();
        }

        public JCUnit.Measure getDefaultBottomMargin() {
            if (this.isDefaultBottomMarginInherited()) {
                return JCPageTable.this.getDefaultBottomMargin();
            }
            return this.defaultCell.getBottomMargin();
        }

        public void setDefaultBottomMargin(JCUnit.Measure measure) {
            this.defaultCell.setBottomMargin(measure);
        }

        public boolean isDefaultTopMarginInherited() {
            return this.defaultCell.isTopMarginInherited();
        }

        public JCUnit.Measure getDefaultTopMargin() {
            if (this.isDefaultTopMarginInherited()) {
                return JCPageTable.this.getDefaultTopMargin();
            }
            return this.defaultCell.getTopMargin();
        }

        public void setDefaultTopMargin(JCUnit.Measure measure) {
            this.defaultCell.setTopMargin(measure);
        }

        public boolean isDefaultLeftMarginInherited() {
            return this.defaultCell.isLeftMarginInherited();
        }

        public JCUnit.Measure getDefaultLeftMargin() {
            if (this.isDefaultLeftMarginInherited()) {
                return JCPageTable.this.getDefaultLeftMargin();
            }
            return this.defaultCell.getLeftMargin();
        }

        public void setDefaultLeftMargin(JCUnit.Measure measure) {
            this.defaultCell.setLeftMargin(measure);
        }

        public boolean isDefaultRightMarginInherited() {
            return this.defaultCell.isRightMarginInherited();
        }

        public JCUnit.Measure getDefaultRightMargin() {
            if (this.isDefaultRightMarginInherited()) {
                return JCPageTable.this.getDefaultRightMargin();
            }
            return this.defaultCell.getRightMargin();
        }

        public void setDefaultRightMargin(JCUnit.Measure measure) {
            this.defaultCell.setRightMargin(measure);
        }

        public boolean isDefaultCellValueInherited() {
            return JCPageTable.this.tableData.getTableRowLabel(this.rowNumber) == null;
        }

        public Object getDefaultCellValue() {
            return JCPageTable.this.tableData.getTableRowLabel(this.rowNumber);
        }

        public void setDefaultCellValue(Object object) {
            ((PageTableVectorDataSource)JCPageTable.this.tableData).setRowLabel(this.rowNumber, object);
        }

        protected boolean hasFixedHeight() {
            return this.fixedHeight;
        }

        public JCUnit.Measure getHeight() {
            return (JCUnit.Measure)this.rowHeight.clone();
        }

        public void setHeight(JCUnit.Measure measure) {
            if (measure.isNegative()) {
                throw new IllegalArgumentException("Invalid row height");
            }
            this.rowHeight = (JCUnit.Measure)measure.clone();
            Cell cell = null;
            int n = this.cellList.size();
            int n2 = 0;
            while (n2 < n) {
                cell = (Cell)this.cellList.get(n2);
                cell.setHeight(this.rowHeight);
                ++n2;
            }
            this.fixedHeight = true;
        }

        public int getRowNumber() {
            return this.rowNumber;
        }

        protected JCUnit.Measure getExtraHeight() {
            if (this.extraHeight == null) {
                this.extraHeight = new JCUnit.Measure();
            }
            return this.extraHeight;
        }

        protected void setExtraHeight(JCUnit.Measure measure) {
            if (measure.isNegative()) {
                throw new IllegalArgumentException("Invalid height");
            }
            if (this.fixedHeight) {
                throw new IllegalArgumentException("Can't adjust height of fixed row");
            }
            this.extraHeight = (JCUnit.Measure)measure.clone();
        }

        protected int getArrivingSpans() {
            return this.arrivingSpans;
        }

        protected int getDepartingSpans() {
            return this.departingSpans;
        }

        protected JCUnit.Measure basicHeight() {
            JCUnit.Measure measure = new JCUnit.Measure(JCUnit.POINTS, 0.0);
            int n = this.cellList.size();
            int n2 = 0;
            while (n2 < n) {
                JCUnit.Measure measure2;
                Object object;
                Cell cell = (Cell)this.cellList.get(n2);
                if (cell != UNINITIALISED_CELL) {
                    if (cell.isSpanned()) {
                        Point point = cell.getSpanOrigin();
                        object = JCPageTable.this.getCell(point.y, point.x);
                        if (((Cell)object).getSpanRows() > 1) {
                            measure2 = new JCUnit.Measure();
                            if (point.y < this.rowNumber) {
                                ++this.arrivingSpans;
                            }
                            if (this.rowNumber - point.y < cell.getSpanRows() - 1) {
                                ++this.departingSpans;
                            }
                        } else {
                            measure2 = cell.fixHeight();
                        }
                    } else {
                        measure2 = cell.fixHeight();
                    }
                } else if (JCPageTable.this.getRowColumnDominance() == 1) {
                    measure2 = (JCUnit.Measure)this.getDefaultTopMargin().clone();
                    measure2.add(this.getDefaultBottomMargin());
                } else {
                    object = JCPageTable.this.getColumn(n2);
                    measure2 = (JCUnit.Measure)((Column)object).getDefaultTopMargin().clone();
                    measure2.add(((Column)object).getDefaultBottomMargin());
                }
                if (measure.lessThan(measure2)) {
                    measure = (JCUnit.Measure)measure2.clone();
                }
                ++n2;
            }
            if (this.fixedHeight) {
                return this.rowHeight;
            }
            this.rowHeight = measure;
            return measure;
        }

        private JCUnit.Measure calculateBorderWidth() {
            JCUnit.Measure measure = this.getBorderStyle().getDrawnWidth();
            int n = this.cellList.size();
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    JCUnit.Measure measure2;
                    Cell cell;
                    block6: {
                        cell = (Cell)this.cellList.get(n2);
                        if (cell == UNINITIALISED_CELL) break block5;
                        if (!cell.isSpanned()) break block6;
                        Point point = cell.getSpanOrigin();
                        if (point.x != n2 || point.y + (cell = JCPageTable.this.getCell(point.y, point.x)).getSpanRows() - 1 != this.rowNumber) break block5;
                    }
                    if (!cell.isBottomBorderInherited() && (measure2 = cell.getBottomBorderStyle().getDrawnWidth()).greaterThan(measure)) {
                        measure = measure2;
                    }
                }
                ++n2;
            }
            return measure;
        }

        protected JCUnit.Measure getBorderWidth() {
            if (this.borderWidth == null) {
                JCUnit.Measure measure = this.rowNumber + 1 == JCPageTable.this.getRowCount() ? JCPageTable.this.getBottomBorder().getDrawnWidth() : this.calculateBorderWidth();
                this.borderWidth = (JCUnit.Measure)measure.clone();
            }
            return (JCUnit.Measure)this.borderWidth.clone();
        }

        protected JCUnit.Measure getBottomBorderWidth() {
            return this.getBottomBorderWidth(true);
        }

        protected JCUnit.Measure getBottomBorderWidth(boolean bl) {
            JCUnit.Measure measure;
            JCUnit.Measure measure2 = JCPageTable.this.isHeader() ? JCPageTable.this.getHeaderBorder().getDrawnWidth() : JCPageTable.this.getBottomBorder().getDrawnWidth();
            int n = JCPageTable.this.getBorderMode();
            JCUnit.Measure measure3 = this.getBorderWidth();
            if (this.departingSpans == 0) {
                measure = this.rowNumber == JCPageTable.this.getRowCount() - 1 || n == 2 ? (JCUnit.Measure)measure2.clone() : measure3;
            } else if (n == 1) {
                measure = measure3;
            } else {
                measure = measure3.greaterThan(measure2) ? measure3 : (JCUnit.Measure)measure2.clone();
                if (bl) {
                    measure.add(measure2);
                    measure.divide(2.0);
                }
            }
            if (!bl) {
                measure.divide(2.0);
            }
            return measure;
        }

        protected JCUnit.Measure getTopBorderWidth() {
            return this.getTopBorderWidth(true);
        }

        protected JCUnit.Measure getTopBorderWidth(boolean bl) {
            JCUnit.Measure measure;
            JCUnit.Measure measure2 = this.rowNumber > 0 ? JCPageTable.this.getRow(this.rowNumber - 1).getBorderWidth() : new JCUnit.Measure();
            if (JCPageTable.this.hasHeaders()) {
                measure = this.arrivingSpans != 0 ? measure2 : new JCUnit.Measure();
                if (bl) {
                    measure.divide(2.0);
                }
            } else {
                int n = JCPageTable.this.getBorderMode();
                JCUnit.Measure measure3 = JCPageTable.this.getTopBorder().getDrawnWidth();
                if (n == 1 && this.rowNumber > 0) {
                    measure = measure2;
                } else if (this.arrivingSpans == 0) {
                    measure = (JCUnit.Measure)measure3.clone();
                } else {
                    measure = measure3.greaterThan(measure2) ? (JCUnit.Measure)measure3.clone() : measure2;
                    if (bl) {
                        measure.add(measure3);
                        measure.divide(2.0);
                    }
                }
            }
            if (!bl) {
                measure.divide(2.0);
            }
            return measure;
        }

        protected JCUnit.Measure getDrawnHeight(boolean bl, boolean bl2) {
            JCUnit.Measure measure;
            if (bl) {
                measure = this.getTopBorderWidth(false);
            } else {
                measure = JCPageTable.this.getRow(this.rowNumber - 1).getBorderWidth();
                measure.divide(2.0);
            }
            measure.add(this.rowHeight);
            measure.add(this.getExtraHeight());
            if (bl2) {
                measure.add(this.getBottomBorderWidth(false));
            } else {
                JCUnit.Measure measure2 = this.getBorderWidth();
                measure2.divide(2.0);
                measure.add(measure2);
            }
            return measure;
        }
    }
}

