/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid.customizer;

import com.klg.jclass.higrid.LocaleBundle;
import com.klg.jclass.util.JCTypeConverter;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class FontEditor
extends JPanel {
    static final int MIXED_STYLE = -1;
    static final int MIXED_SIZE = -1;
    JComboBox familyChoser;
    JComboBox styleChoser;
    JComboBox sizeChoser;
    private String[] fonts;
    private String[] style_names = new String[]{"plain", "bold", "italic", "bold and italic"};
    private int[] styles = new int[]{0, 1, 2, 3};
    private int[] point_sizes = new int[]{3, 5, 8, 10, 12, 14, 18, 24, 28, 30, 32, 36, 48};
    boolean levelFont;

    public FontEditor(ItemListener itemListener) {
        this(itemListener, false);
    }

    public FontEditor(ItemListener itemListener, boolean bl) {
        super(new FlowLayout());
        this.fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.levelFont = bl;
        this.familyChoser = new JComboBox();
        this.styleChoser = new JComboBox();
        this.sizeChoser = new JComboBox();
        if (bl) {
            this.familyChoser.addItem(LocaleBundle.string("MixedCellFonts"));
            this.styleChoser.addItem(LocaleBundle.string("MixedCellFonts"));
            this.sizeChoser.addItem(LocaleBundle.string("MixedCellFonts"));
        }
        int n = 0;
        while (n < this.fonts.length) {
            this.familyChoser.addItem(this.fonts[n]);
            ++n;
        }
        this.familyChoser.addItemListener(itemListener);
        this.add(this.familyChoser);
        int n2 = 0;
        while (n2 < this.style_names.length) {
            this.styleChoser.addItem(this.style_names[n2]);
            ++n2;
        }
        this.styleChoser.addItemListener(itemListener);
        this.add(this.styleChoser);
        int n3 = 0;
        while (n3 < this.point_sizes.length) {
            this.sizeChoser.addItem("" + this.point_sizes[n3]);
            ++n3;
        }
        this.sizeChoser.addItemListener(itemListener);
        this.add(this.sizeChoser);
    }

    void selectFontName(String string) {
        int n;
        int n2 = n = this.levelFont ? 0 : 1;
        if (this.levelFont && string == null) {
            n = 0;
        } else {
            int n3 = 0;
            while (n3 < this.fonts.length) {
                if (string.equals(this.fonts[n3])) {
                    n = this.levelFont ? n3 + 1 : n3;
                    break;
                }
                ++n3;
            }
        }
    }

    void selectFontStyle(int n) {
        int n2;
        int n3 = n2 = this.levelFont ? 0 : 1;
        if (this.levelFont && n == -1) {
            n2 = 0;
        } else {
            int n4 = 0;
            while (n4 < this.styles.length) {
                if (n == this.styles[n4]) {
                    n2 = this.levelFont ? n4 + 1 : n4;
                    break;
                }
                ++n4;
            }
        }
        this.styleChoser.setSelectedIndex(n2);
    }

    void selectFontSize(int n) {
        int n2;
        int n3 = n2 = this.levelFont ? 0 : 4;
        if (this.levelFont && n == -1) {
            n2 = 0;
        } else {
            int n4 = 0;
            while (n4 < this.point_sizes.length) {
                if (n == this.point_sizes[n4]) {
                    n2 = this.levelFont ? n4 + 1 : n4;
                    break;
                }
                ++n4;
            }
        }
        this.sizeChoser.setSelectedIndex(n2);
    }

    void selectFont(Font font) {
        if (font == null) {
            return;
        }
        this.selectFontName(font.getName());
        this.selectFontStyle(font.getStyle());
        this.selectFontSize(font.getSize());
    }

    void selectFont(String string, int n, int n2) {
        this.selectFontName(string);
        this.selectFontStyle(n);
        this.selectFontSize(n2);
    }

    Font getSelectedFont() {
        String string = this.getFontName();
        int n = this.getFontStyle();
        int n2 = this.getFontSize();
        return new Font(string, n, n2);
    }

    String getFontName() {
        String string = (String)this.familyChoser.getSelectedItem();
        if (string == null) {
            string = "Serif";
        } else if (string.equals(LocaleBundle.string("MixedCellFonts"))) {
            string = null;
        }
        return string;
    }

    int getFontStyle() {
        JCTypeConverter jCTypeConverter = new JCTypeConverter();
        String string = (String)this.styleChoser.getSelectedItem();
        int n = -1;
        if (!string.equals(LocaleBundle.string("MixedCellFonts"))) {
            n = JCTypeConverter.toEnum(string, "cellFontStyle", this.style_names, this.styles, 0);
        }
        return n;
    }

    int getFontSize() {
        JCTypeConverter jCTypeConverter = new JCTypeConverter();
        String string = (String)this.sizeChoser.getSelectedItem();
        int n = -1;
        if (!string.equals(LocaleBundle.string("MixedCellFonts"))) {
            n = 12;
            try {
                n = new Integer(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }
}

