/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid.customizer;

import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.LocaleBundle;
import com.klg.jclass.higrid.SummaryColumn;
import com.klg.jclass.higrid.beans.JCHiGridEvent;
import com.klg.jclass.higrid.beans.JCHiGridNode;
import com.klg.jclass.higrid.customizer.CellFormatPage;
import com.klg.jclass.higrid.customizer.FontEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class CellFontPage
extends CellFormatPage
implements ItemListener {
    FontEditor cellFontEditor;

    public CellFontPage() {
        super(LocaleBundle.string("Font"));
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(LocaleBundle.string("Font")));
        this.cellFontEditor = new FontEditor(this);
        jPanel.add(this.cellFontEditor);
        this.add((Component)jPanel, "North");
    }

    public void valueChanged() {
        if (this.cellFormat == null) {
            return;
        }
        Font font = this.cellFontEditor.getSelectedFont();
        if (font != null && !font.equals(this.cellFormat.getFont())) {
            this.cellFormat.setFont(this.getFontMetrics(font), font);
            this.getJCHiGridNode().setChanged();
            this.getJCHiGridNode().getGridProperties().fireJCHiGridEvent(new JCHiGridEvent((Object)this.getJCHiGridNode().getGridProperties(), this.getJCHiGridNode()));
        }
    }

    public void showValue() {
        if (this.cellFormat == null) {
            return;
        }
        this.cellFontEditor.selectFont(this.cellFormat.getFont());
    }

    public void setJCHiGridNode(JCHiGridNode jCHiGridNode, CellFormat cellFormat, SummaryColumn summaryColumn) {
        this.showValue();
    }

    public void setSelectedColumn(CellFormat cellFormat, SummaryColumn summaryColumn) {
        super.setSelectedColumn(cellFormat, summaryColumn);
        this.showValue();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.isInitializing()) {
            return;
        }
        this.valueChanged();
    }
}

