/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.higrid.AfterDetailsFormat;
import com.klg.jclass.higrid.BeforeDetailsFormat;
import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.FooterFormat;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.HiGridInternalData;
import com.klg.jclass.higrid.RowFormat;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.SummaryDataTable;
import com.klg.jclass.higrid.Walkable;
import java.util.Enumeration;
import java.util.Vector;

class SummaryRefreshWalk
implements Walkable {
    static final long serialVersionUID = 3128056133926266838L;
    private HiGrid grid;
    private int height;
    private boolean found;

    public SummaryRefreshWalk(HiGrid hiGrid, int n) {
        this.grid = hiGrid;
        this.height = n;
        this.found = false;
    }

    public boolean getDownward() {
        return true;
    }

    public boolean done() {
        return this.found;
    }

    public void next(RowNode rowNode) {
        if (rowNode != null && this.height >= 0) {
            this.height -= rowNode.getHeight();
            this.refreshSummaryRow(rowNode);
        }
    }

    public void previous(RowNode rowNode) {
    }

    public boolean find(RowNode rowNode) {
        if (this.height < 0) {
            this.found = true;
        }
        return this.found;
    }

    private void refreshSummaryRow(RowNode rowNode) {
        RowFormat rowFormat = rowNode.getRowFormat();
        if ((rowFormat instanceof FooterFormat || rowFormat instanceof BeforeDetailsFormat || rowFormat instanceof AfterDetailsFormat) && this.isSummaryDataChanged(this.grid, rowNode)) {
            this.grid.refreshRow(rowNode);
        }
    }

    private boolean isSummaryDataChanged(HiGrid hiGrid, RowNode rowNode) {
        DataTableModel dataTableModel = rowNode.getDataTableModel();
        HiGridInternalData hiGridInternalData = (HiGridInternalData)dataTableModel.getInternalData(hiGrid);
        SummaryDataTable summaryDataTable = (SummaryDataTable)hiGridInternalData.getDataTable();
        RowFormat rowFormat = rowNode.getRowFormat();
        Vector vector = rowFormat.getDataFormats();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            String string = cellFormat.getName();
            if (!summaryDataTable.isResultDataChanged(hiGrid, dataTableModel, rowFormat, rowNode, string)) continue;
            return true;
        }
        return false;
    }
}

