/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.datasource.BindingModel;
import com.klg.jclass.datasource.ColumnModel;
import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.ProviderModel;
import com.klg.jclass.higrid.SummaryColumn;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class SummaryMetaData
extends DataSourceTreeNode
implements MetaDataModel,
Serializable {
    static final long serialVersionUID = -332831412824408705L;
    private int numColumns;
    private Vector columns;
    private Hashtable identifiers;
    private int metaID;

    public SummaryMetaData() {
        super(null);
        this.init();
    }

    void init() {
        this.numColumns = 0;
        this.columns = new Vector();
        this.identifiers = new Hashtable();
        this.metaID = -1;
    }

    public void setMetaID(int n) {
        this.metaID = n;
    }

    public void appendColumn(SummaryColumn summaryColumn) {
        this.columns.addElement(summaryColumn);
        this.identifiers.put(summaryColumn.getIdentifier(), new Integer(this.numColumns));
        ++this.numColumns;
    }

    public void insertColumn(SummaryColumn summaryColumn, int n) {
        this.columns.insertElementAt(summaryColumn, n);
        ++this.numColumns;
        this.setupIdentifiers();
    }

    public void removeColumn(SummaryColumn summaryColumn) {
        this.columns.removeElement(summaryColumn);
        --this.numColumns;
        this.setupIdentifiers();
    }

    public void removeColumn(int n) {
        this.columns.removeElementAt(n);
        --this.numColumns;
        this.setupIdentifiers();
    }

    public SummaryColumn getColumn(String string) {
        return (SummaryColumn)this.columns.elementAt(this.getColumnIndex(string));
    }

    public void setupSumaryColumns(Vector vector) {
        this.columns = vector;
        this.numColumns = vector.size();
        this.setupIdentifiers();
    }

    protected void setupIdentifiers() {
        this.identifiers.clear();
        int n = 0;
        while (n < this.numColumns) {
            this.identifiers.put(((SummaryColumn)this.columns.elementAt(n)).getIdentifier(), new Integer(n));
            ++n;
        }
    }

    public int getColumnIndex(String string) {
        return (Integer)this.identifiers.get(string);
    }

    public void clear() {
        this.init();
    }

    public String getColumnIdentifier(int n) throws DataModelException {
        return ((SummaryColumn)this.columns.elementAt(n)).getIdentifier();
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    public int getJavaColumnType(String string) throws DataModelException {
        if (this.numColumns == 0) {
            return 1010;
        }
        return ((SummaryColumn)this.columns.elementAt(this.getColumnIndex(string))).getDataType();
    }

    public void setCommitPolicy(int n) {
    }

    public int getCommitPolicy() {
        return 1;
    }

    public DataModel getDataModel() {
        return null;
    }

    public void setInsertAllowed(String string, boolean bl) {
    }

    public void setUpdateAllowed(String string, boolean bl) {
    }

    public void setDeleteAllowed(String string, boolean bl) {
    }

    public boolean getInsertAllowed(String string) {
        return false;
    }

    public boolean getUpdateAllowed(String string) {
        return false;
    }

    public boolean getDeleteAllowed(String string) {
        return false;
    }

    public int getMetaID() {
        return this.metaID;
    }

    public String getDescription() {
        return null;
    }

    public void setDescription(String string) {
    }

    public boolean getAutoCommit() throws DataModelException {
        return false;
    }

    public void setAutoCommit(boolean bl) throws DataModelException {
    }

    public void rollbackTransaction() throws DataModelException {
    }

    public void commitTransaction() throws DataModelException {
    }

    public Vector getColumnObjects() {
        return null;
    }

    public boolean isUpdateAllowedOnColumn(String string) {
        return false;
    }

    public void addColumn(ColumnModel columnModel) {
    }

    public ColumnModel getColumnObject(String string) throws DataModelException {
        return null;
    }

    public Object getNativeMetaData() {
        return null;
    }

    public void setShowDeletedRows(boolean bl) {
    }

    public boolean getShowDeletedRows() {
        return true;
    }

    public void setMaxRows(int n) {
    }

    public int getMaxRows() {
        return -1;
    }

    public void setCacheChildren(boolean bl) {
    }

    public boolean getCacheChildren() {
        return true;
    }

    public DataTableModel getCurrentDataTable() {
        return null;
    }

    public long getCurrentBookmark() {
        return -1L;
    }

    public void setCurrentDataTable(DataTableModel dataTableModel) {
    }

    public void setCurrentBookmark(long l) {
    }

    public void setStoreClass(String string) throws DataModelException {
    }

    public Class getStoreClass() throws DataModelException {
        return null;
    }

    public BindingModel getBinding() {
        return null;
    }

    public void setBinding(BindingModel bindingModel) {
    }

    public ProviderModel getProvider() {
        return null;
    }

    public void setProviderClassName(String string) throws DataModelException {
    }
}

