/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.Walkable;
import java.util.Vector;

class RowSelectWalk
implements Walkable {
    static final long serialVersionUID = 820932069783880501L;
    private HiGrid grid;
    private int selectionMode;
    private boolean finished;
    private RowNode lastSelectedRowNode;
    private RowNode currentRowNode;
    private int found;
    private Vector selectedRows = null;

    public RowSelectWalk(HiGrid hiGrid, int n, RowNode rowNode, RowNode rowNode2) {
        this.grid = hiGrid;
        this.selectionMode = n;
        this.lastSelectedRowNode = rowNode;
        this.currentRowNode = rowNode2;
        this.finished = false;
        this.found = 0;
        this.selectedRows = new Vector();
    }

    public boolean getDownward() {
        return true;
    }

    public boolean done() {
        return this.finished;
    }

    public void next(RowNode rowNode) {
        if (rowNode != null) {
            this.selectRow(rowNode);
        }
    }

    public void previous(RowNode rowNode) {
    }

    public boolean find(RowNode rowNode) {
        if (this.found > 1) {
            this.finished = true;
        }
        return this.finished;
    }

    private void selectRow(RowNode rowNode) {
        if (rowNode.getRowFormat() instanceof RecordFormat) {
            if (rowNode == this.lastSelectedRowNode) {
                ++this.found;
            }
            if (rowNode == this.currentRowNode) {
                ++this.found;
            }
            if (this.found > 0) {
                if (!this.grid.controller.canSelectRowNode(this.selectionMode, this.lastSelectedRowNode, rowNode)) {
                    return;
                }
                this.selectedRows.addElement(rowNode);
            }
        }
    }

    public Vector getSelectedRows() {
        return this.selectedRows;
    }
}

