/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.HiGridPrintEvent;
import com.klg.jclass.higrid.LocaleBundle;
import com.klg.jclass.higrid.PrePrintRowTreeWalk;
import com.klg.jclass.higrid.PrePrintWalk;
import com.klg.jclass.higrid.PrintGrid;
import com.klg.jclass.higrid.PrintWalk;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.RowTree;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.io.Serializable;
import java.util.Vector;

public class PrintGrid12
extends PrintGrid
implements Printable,
Pageable,
Serializable {
    static final long serialVersionUID = 671101792413160098L;
    public static final int DEFAULT_PAGE_MARGIN_IN_72TH_INCHES = 72;
    protected static final int MARGIN_ADJUSTMENT_IN_72TH_INCHES = 15;
    protected transient HiGrid grid;
    protected transient PageFormat currentPageFormat;
    protected transient Insets defaultMargin = new Insets(72, 72, 72, 72);
    protected transient Insets margin;
    protected transient int totalNumPages;
    protected transient int currentPage;
    protected transient int rowPageIndex;
    protected transient int columnPageIndex;
    protected transient int printFormat = 0;
    protected transient RowTree printRowTree;
    protected transient Vector rowNodeList;
    protected transient int rowPages = 0;
    protected transient int columnPages = 0;

    public PrintGrid12(HiGrid hiGrid) {
        this.grid = hiGrid;
        this.setMargin(this.getDefaultMargin());
        this.printRowTree = null;
    }

    public void initialize(PageFormat pageFormat) {
        this.setPageFormat(pageFormat);
        this.printRowTree = this.getPrintTimeRowTree();
        if (this.printRowTree == null) {
            return;
        }
        PrePrintWalk prePrintWalk = new PrePrintWalk(this, this.grid, pageFormat);
        this.printRowTree.walk((RowNode)this.printRowTree.getRootNode().getFirstChild(), prePrintWalk);
        this.totalNumPages = prePrintWalk.getPrintPages();
        this.rowPages = prePrintWalk.getRowPages();
        this.columnPages = prePrintWalk.getColumnPages();
        this.rowNodeList = prePrintWalk.getRowNodeList();
    }

    protected void disposePrintTimeRowTree() {
        this.printRowTree = null;
        this.rowNodeList = null;
    }

    protected RowTree getPrintTimeRowTree() {
        RowTree rowTree = this.grid.getRowTree();
        this.printFormat = this.grid.getPrintFormat();
        if (this.printFormat == 0) {
            return rowTree;
        }
        if (this.grid.getDataModel() == null || this.grid.getFormatTree() == null) {
            return null;
        }
        PrePrintRowTreeWalk prePrintRowTreeWalk = new PrePrintRowTreeWalk();
        rowTree.walk((RowNode)rowTree.getRootNode().getFirstChild(), prePrintRowTreeWalk);
        int[] nArray = prePrintRowTreeWalk.getMetaIDArray();
        if (nArray == null) {
            return rowTree;
        }
        RowTree rowTree2 = new RowTree(this.grid, false);
        rowTree2.createPrintTimeTree(this.grid.getFormatTree(), nArray);
        return rowTree2;
    }

    public int getPageWidth() {
        return (int)this.getPageFormat().getWidth();
    }

    public int getPageHeight() {
        return (int)this.getPageFormat().getHeight();
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        if (insets == null) {
            insets = this.getDefaultMargin();
        } else {
            this.margin = insets;
        }
    }

    public Insets getDefaultMargin() {
        return this.defaultMargin;
    }

    public PageFormat getPageFormat() {
        return this.currentPageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.currentPageFormat = pageFormat;
    }

    public int getPrintableHeight() {
        return (int)this.getPageFormat().getImageableHeight();
    }

    public int getPrintableWidth() {
        return (int)this.getPageFormat().getImageableWidth();
    }

    protected Point getPrintOffset(PageFormat pageFormat) {
        return new Point(this.margin.left, this.margin.top);
    }

    public int getRowPageIndex() {
        return this.rowPageIndex;
    }

    public int getColumnPageIndex() {
        return this.columnPageIndex;
    }

    public int getCurrentPageIndex() {
        return this.currentPage;
    }

    public int getTotalNumPages() {
        return this.totalNumPages;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (this.printRowTree == null || graphics == null || this.rowNodeList == null || this.rowNodeList.isEmpty() || n >= this.getTotalNumPages() || n < 0) {
            return 1;
        }
        this.setPageFormat(pageFormat);
        this.currentPage = Math.max(0, Math.min(n, this.getTotalNumPages() - 1));
        this.rowPageIndex = n / this.columnPages;
        this.columnPageIndex = n - this.rowPageIndex * this.columnPages;
        PrintWalk printWalk = new PrintWalk(this, this.grid, pageFormat);
        RowNode rowNode = (RowNode)this.rowNodeList.elementAt(this.rowPageIndex);
        Point point = this.getPrintOffset(pageFormat);
        graphics.setClip(0, 0, (int)pageFormat.getWidth(), (int)pageFormat.getHeight());
        this.doPrintPageHeader(graphics, pageFormat);
        Graphics graphics2 = graphics.create();
        graphics2.clipRect(point.x, point.y, (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        graphics2.translate(point.x, point.y);
        printWalk.init(graphics2, this.currentPage);
        this.printRowTree.walk(rowNode, printWalk);
        graphics2.dispose();
        if (this.rowPageIndex == this.rowPages - 1) {
            this.doPrintEnd(graphics, pageFormat, point.y + printWalk.getHeight());
        }
        this.doPrintPageFooter(graphics, pageFormat);
        return 0;
    }

    public int getNumberOfPages() {
        return this.getTotalNumPages();
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return this.getPageFormat();
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    protected void doPrintPageHeader(Graphics graphics, PageFormat pageFormat) {
        Graphics graphics2 = graphics.create();
        graphics2.setColor(Color.black);
        Insets insets = this.getMargin();
        graphics2.setClip(insets.left, 0, this.getPrintableWidth(), insets.top);
        graphics2.translate(insets.left, 0);
        this.grid.fireHiGridPrintEvent(new HiGridPrintEvent(this.grid, 2001, this, graphics2, pageFormat, this.getCurrentPageIndex(), this.getTotalNumPages()));
        graphics2.dispose();
    }

    protected void doPrintPageFooter(Graphics graphics, PageFormat pageFormat) {
        Graphics graphics2 = graphics.create();
        graphics2.setColor(Color.black);
        Insets insets = this.getMargin();
        graphics2.setClip(insets.left, this.getPageHeight() - insets.bottom, this.getPrintableWidth(), insets.bottom);
        graphics2.translate(insets.left, this.getPageHeight() - insets.bottom);
        this.grid.fireHiGridPrintEvent(new HiGridPrintEvent(this.grid, 2002, this, graphics2, pageFormat, this.getCurrentPageIndex(), this.getTotalNumPages()));
        graphics2.dispose();
    }

    protected void doPrintEnd(Graphics graphics, PageFormat pageFormat, int n) {
        Graphics graphics2 = graphics.create();
        graphics2.setColor(Color.black);
        Insets insets = this.getMargin();
        graphics2.clipRect(insets.left, n, this.getPrintableWidth(), this.getPageHeight() - n - insets.bottom);
        graphics2.translate(insets.left, n);
        this.grid.fireHiGridPrintEvent(new HiGridPrintEvent(this.grid, 2003, this, graphics2, pageFormat, this.getCurrentPageIndex(), this.getTotalNumPages()));
        graphics2.dispose();
    }

    public void printPageFooter(HiGridPrintEvent hiGridPrintEvent) {
        Graphics graphics = hiGridPrintEvent.getGraphics();
        Rectangle rectangle = graphics.getClipBounds();
        Font font = this.grid.getFont();
        if (font != null) {
            graphics.setFont(font);
            graphics.setColor(Color.black);
            String string = LocaleBundle.string("PrintTextPage") + " " + (hiGridPrintEvent.getPageIndex() + 1) + " " + LocaleBundle.string("PrintTextOf") + " " + hiGridPrintEvent.getNumPages();
            graphics.drawString(string, 0, rectangle.height / 2);
        }
    }
}

