/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.higrid.HeaderFormat;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.Walkable;

public class HeaderTipWalk
implements Walkable {
    static final long serialVersionUID = 3803023194486635795L;
    private RowNode startRowNode;
    private RowNode topRowNode;
    private HeaderFormat startHeaderFormat;
    private RecordFormat startRecordFormat;
    private int rowTipDisplay;
    private boolean done;
    private boolean headerVisible;
    private boolean recordsContiguous;

    public HeaderTipWalk(RowNode rowNode, RowNode rowNode2, int n) {
        this.topRowNode = rowNode;
        this.startRowNode = rowNode2;
        this.rowTipDisplay = n;
        this.startHeaderFormat = rowNode2.getFormatNode().getHeaderFormat();
        this.startRecordFormat = (RecordFormat)rowNode2.getRowFormat();
        this.done = false;
        this.headerVisible = false;
        this.recordsContiguous = true;
    }

    public boolean getDownward() {
        return false;
    }

    public boolean done() {
        return this.done;
    }

    public void next(RowNode rowNode) {
        if (rowNode != null && rowNode.getParent() != null) {
            if (rowNode.getRowFormat() instanceof HeaderFormat && rowNode.getRowFormat().equals(this.startHeaderFormat)) {
                this.headerVisible = true;
            }
            if (rowNode.getRowFormat() instanceof RecordFormat && !rowNode.getRowFormat().equals(this.startRecordFormat) && !this.headerVisible) {
                this.recordsContiguous = false;
            }
        }
    }

    public void previous(RowNode rowNode) {
    }

    public boolean find(RowNode rowNode) {
        if (rowNode == this.topRowNode) {
            this.done = true;
        }
        return this.done;
    }

    public boolean shouldDisplay() {
        boolean bl;
        switch (this.rowTipDisplay) {
            case 1: {
                bl = !this.headerVisible || !this.recordsContiguous;
                break;
            }
            case 0: {
                bl = !this.headerVisible;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }
}

