/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.Controller;
import com.klg.jclass.higrid.GridScrollbarCallback;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.HiGridErrorEvent;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RowFormat;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.RowNodeWalk;
import com.klg.jclass.higrid.RowTree;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JScrollBar;

public class GridScrollbar
implements Serializable,
AdjustmentListener,
GridScrollbarCallback {
    static final long serialVersionUID = 2256552432959303071L;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int DISPLAY_AS_NEEDED = 0;
    public static final int DISPLAY_ALWAYS = 1;
    public static final int DISPLAY_NEVER = 2;
    private static final int INITIAL_ROWTIP_WIDTH = 100;
    protected static final int MAGIC_BLOCK_INCREMENT = 2;
    private Adjustable adjustable;
    private Component component;
    private HiGrid grid;
    private int display = 0;
    private int trackValue = -1;
    private int startValue = 0;
    private int draggingValue = 0;
    private RowNode oldTopRowNode = null;
    private boolean waitingForTrack = false;
    private boolean settingVisibility = false;
    private JLabel rowtip = null;
    private GridScrollbarCallback rowtipCallback = null;
    private boolean rowtipVisible = true;

    public GridScrollbar(HiGrid hiGrid, int n) {
        this.grid = hiGrid;
        JScrollBar jScrollBar = new JScrollBar(n);
        this.adjustable = jScrollBar;
        this.component = jScrollBar;
        this.adjustable.addAdjustmentListener(this);
        if (n == 1) {
            this.rowtip = new JLabel();
            this.rowtip.setHorizontalAlignment(0);
            this.rowtip.setOpaque(true);
            this.rowtip.setFont(new Font("Serif", 0, 12));
            this.rowtip.setForeground(Color.black);
            this.rowtip.setBackground(new Color(255, 255, 225));
            this.setRowtipCallback(this);
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
        this.grid.resetScrollbarConstraints();
        this.grid.layoutGrid();
    }

    public void setAdjustable(Adjustable adjustable) {
        this.adjustable.removeAdjustmentListener(this);
        this.adjustable = adjustable;
        this.adjustable.addAdjustmentListener(this);
    }

    public Adjustable getAdjustable() {
        return this.adjustable;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.adjustable == null || this.component == null || this.adjustable != adjustmentEvent.getAdjustable()) {
            return;
        }
        if (this.settingVisibility) {
            return;
        }
        int n = adjustmentEvent.getValue();
        int n2 = adjustmentEvent.getAdjustmentType();
        int n3 = this.adjustable.getOrientation();
        if (n3 == 1) {
            if (this.oldTopRowNode == null) {
                this.oldTopRowNode = this.grid.getRowTree().getTopRowNode();
            }
            boolean bl = false;
            int n4 = n - this.draggingValue;
            int n5 = this.grid.getController().getCurrentAction();
            if (this.startValue == this.draggingValue && (n5 == 0 || n5 == 6 || n5 == 5) && Math.abs(n4) == this.getBlockIncrement()) {
                bl = true;
                if (n4 < 0) {
                    n += 2;
                    n = this.grid.getRowTree().doPageUp(n);
                } else if (n4 > 0) {
                    n -= 2;
                    n = this.grid.getRowTree().doPageDown(n);
                }
            }
            this.draggingValue = n = this.getAdjustedValue(n);
            if (this.adjustable instanceof JScrollBar) {
                if (((JScrollBar)this.adjustable).getValueIsAdjusting()) {
                    if (this.rowtip.getParent() == null) {
                        this.addRowtip(n);
                    } else {
                        this.trackValue = n;
                        this.updateRowtip(n);
                        this.placeRowtip();
                    }
                } else {
                    bl = n != this.startValue;
                    this.trackValue = -1;
                    this.removeRowtip();
                    if (!bl) {
                        this.grid.refresh(false);
                    }
                }
            } else {
                if (this.trackValue == -1 && !this.waitingForTrack) {
                    this.addRowtip(n);
                }
                if (this.trackValue == n) {
                    bl = n != this.startValue;
                    this.trackValue = -1;
                    this.grid.getGridArea().remove(this.rowtip);
                } else {
                    this.trackValue = n;
                    this.updateRowtip(n);
                    this.placeRowtip();
                }
            }
            if (bl) {
                this.removeRowtip();
                this.grid.getRowTree().setTopRow(n);
                boolean bl2 = n > this.startValue;
                this.grid.refresh(this.oldTopRowNode, this.grid.getRowTree().getTopRowNode(), bl2);
                Controller controller = this.grid.getController();
                controller.showEditor(false);
                controller.positionEditor();
                controller.showEditor(true);
                controller.acquireFocusForCellEditor();
                this.waitingForTrack = false;
                this.trackValue = -1;
                this.startValue = n;
                this.draggingValue = n;
                this.oldTopRowNode = this.grid.getRowTree().getTopRowNode();
            }
        } else if (n3 == 0 && this.trackValue != n) {
            this.trackValue = n;
            this.adjustable.setValue(n);
            this.grid.refresh(false);
            this.grid.getController().acquireFocusForCellEditor();
        }
    }

    public int getDisplay() {
        return this.display;
    }

    public void setDisplay(int n) {
        this.display = n;
        this.grid.layoutGrid();
    }

    public void setVisible(boolean bl) {
        this.component.setVisible(bl);
    }

    public boolean isVisible() {
        return this.component.isVisible();
    }

    public void setSize(Dimension dimension) {
        this.component.setSize(dimension);
    }

    public void setUnitIncrement(int n) {
    }

    public int getUnitIncrement() {
        return this.adjustable.getUnitIncrement();
    }

    public void setBlockIncrement(int n) {
    }

    public int getBlockIncrement() {
        return this.adjustable.getBlockIncrement();
    }

    public void setValues(int n, int n2, int n3, int n4) {
        this.adjustable.setMinimum(n3);
        this.adjustable.setMaximum(n4);
        this.adjustable.setVisibleAmount(n2);
        this.adjustable.setValue(n);
    }

    public void setValue(int n) {
        if (n == this.adjustable.getValue()) {
            return;
        }
        this.adjustable.setValue(n);
        if (this.adjustable.getOrientation() == 0) {
            this.adjustmentValueChanged(new AdjustmentEvent(this.adjustable, 601, 5, n));
        }
    }

    public int getValue() {
        return this.adjustable.getValue();
    }

    public int getOrientation() {
        return this.adjustable.getOrientation();
    }

    public void setMinimum(int n) {
        this.adjustable.setMinimum(n);
    }

    public int getMinimum() {
        return this.adjustable.getMinimum();
    }

    public void setMaximum(int n) {
        this.adjustable.setMaximum(n);
    }

    public int getMaximum() {
        return this.adjustable.getMaximum();
    }

    public boolean atEnd() {
        int n = this.adjustable.getValue();
        int n2 = this.adjustable.getMaximum();
        int n3 = this.adjustable.getVisibleAmount();
        return n == 0 || n >= n2 - n3;
    }

    public void scrollLineDown() {
        int n = this.getValue() + this.getUnitIncrement();
        int n2 = 1;
        this.adjustmentValueChanged(new AdjustmentEvent(this.getAdjustable(), 601, n2, n));
    }

    public void scrollLineUp() {
        int n = this.getValue() - this.getUnitIncrement();
        int n2 = 2;
        this.adjustmentValueChanged(new AdjustmentEvent(this.getAdjustable(), 601, n2, n));
    }

    public void scrollPageDown() {
        int n = this.getValue() + this.getBlockIncrement();
        int n2 = 4;
        this.adjustmentValueChanged(new AdjustmentEvent(this.getAdjustable(), 601, n2, n));
    }

    public void scrollPageUp() {
        int n = this.getValue();
        if (n == 0) {
            return;
        }
        if ((n -= this.getBlockIncrement()) <= 0) {
            this.setValue(0);
            return;
        }
        int n2 = 3;
        this.adjustmentValueChanged(new AdjustmentEvent(this.getAdjustable(), 601, n2, n));
    }

    public void initValues() {
        this.adjustable.setMinimum(0);
        this.adjustable.setMaximum(100);
        this.adjustable.setValue(0);
        this.adjustable.setUnitIncrement(this.adjustable.getOrientation() == 0 ? 10 : 1);
        this.adjustable.setBlockIncrement(2);
        this.adjustable.setVisibleAmount(10);
    }

    public void adjustValues(int n, int n2) {
        if (n2 >= n || n == this.adjustable.getMaximum() && n2 == this.adjustable.getVisibleAmount()) {
            return;
        }
        this.adjustable.setMaximum(n);
        this.settingVisibility = true;
        this.adjustable.setVisibleAmount(n2);
        this.settingVisibility = false;
        if (this.adjustable.getOrientation() == 0) {
            this.adjustable.setBlockIncrement(n2);
        }
    }

    protected int getAdjustedValue(int n) {
        if (n < this.adjustable.getMinimum()) {
            n = this.adjustable.getMinimum();
        }
        if (n > this.adjustable.getMaximum() - this.adjustable.getVisibleAmount()) {
            n = this.adjustable.getMaximum() - this.adjustable.getVisibleAmount();
        }
        return n;
    }

    protected RowNode getLabelRowNode(int n) {
        RowTree rowTree = this.grid.getRowTree();
        if (rowTree == null || rowTree.getRoot() == null) {
            return null;
        }
        RowNodeWalk rowNodeWalk = new RowNodeWalk(n);
        rowTree.walk((RowNode)rowTree.getRootNode().getFirstChild(), rowNodeWalk);
        return rowNodeWalk.getFoundNode();
    }

    public GridScrollbarCallback getRowtipCallback() {
        return this.rowtipCallback;
    }

    public void setRowtipCallback(GridScrollbarCallback gridScrollbarCallback) {
        this.rowtipCallback = gridScrollbarCallback;
    }

    public String getRowtipText() {
        return this.rowtip.getText();
    }

    public Component getRowtip() {
        return this.rowtip;
    }

    protected boolean isRowtipVisible() {
        return this.rowtipVisible;
    }

    protected void setRowtipVisible(boolean bl) {
        this.rowtipVisible = bl;
    }

    protected void removeRowtip() {
        this.grid.getGridArea().remove(this.rowtip);
    }

    protected void addRowtip(int n) {
        if (this.rowtipCallback != null && this.isRowtipVisible()) {
            this.rowtip.setText("");
            this.rowtip.setVisible(false);
            this.updateRowtip(n);
            this.placeRowtip();
            this.grid.getGridArea().add((Component)this.rowtip, 0);
            this.rowtip.setVisible(true);
        }
    }

    protected void placeRowtip() {
        if (this.rowtipCallback != null && this.isRowtipVisible()) {
            this.rowtipCallback.positionRowtip(this.grid.getGridArea(), this.rowtip);
        }
    }

    protected void updateRowtip(int n) {
        if (this.rowtipCallback != null && this.isRowtipVisible()) {
            RowNode rowNode = this.getLabelRowNode(n);
            if (rowNode == null) {
                return;
            }
            String string = this.rowtipCallback.setRowtipText(rowNode, n, this.adjustable);
            if (string != null) {
                this.rowtip.setText(string);
            }
        }
    }

    public String setRowtipText(RowNode rowNode, int n, Adjustable adjustable) {
        String string = null;
        DataTableModel dataTableModel = rowNode.getDataTableModel();
        RowFormat rowFormat = rowNode.getRowFormat();
        if (rowNode.getRowFormat().getDataFormats().isEmpty()) {
            return "";
        }
        CellFormat cellFormat = (CellFormat)rowNode.getRowFormat().getDataFormats().elementAt(0);
        String string2 = cellFormat.getName();
        if (rowFormat instanceof RecordFormat) {
            Object object = null;
            try {
                object = dataTableModel.getResultData(rowNode.getBookmark(), string2);
            }
            catch (Exception exception) {
                this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
            }
            if (object != null) {
                string = object.toString();
            }
        }
        if (string == null) {
            string = string2;
        }
        return string;
    }

    public void positionRowtip(Container container, Component component) {
        ((JLabel)component).setHorizontalAlignment(0);
        ((JLabel)component).setOpaque(true);
        component.setFont(new Font("Serif", 0, 12));
        component.setForeground(Color.black);
        component.setBackground(new Color(255, 255, 225));
        int n = 0;
        int n2 = 0;
        if (container != null) {
            Dimension dimension = container.getSize();
            int n3 = this.getFontHeight(component.getFont());
            int n4 = this.getStringWidth(component.getFont(), this.getRowtipText());
            n4 = Math.max(n4, 100);
            n4 = Math.min(n4, dimension.width);
            component.setSize(n4, n3);
            n = dimension.width - n4 - 1;
            n2 = (dimension.height - n3) / 2;
            component.setLocation(n, n2);
            component.setVisible(true);
        }
    }

    protected void removeOldReferences() {
        this.oldTopRowNode = null;
    }

    private int getStringWidth(Font font, String string) {
        FontMetrics fontMetrics = this.getComponent().getFontMetrics(font);
        return fontMetrics.stringWidth(string) + (font.isItalic() ? font.getSize() / 3 + 1 : 0);
    }

    private int getFontHeight(Font font) {
        FontMetrics fontMetrics = this.getComponent().getFontMetrics(font);
        return fontMetrics.getLeading() + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
    }
}

