/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.higrid.CellStyleModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class CellStyle
implements CellStyleModel,
Serializable {
    static final long serialVersionUID = -6376210120084557576L;
    protected Color backgroundColor;
    protected Color foregroundColor;
    protected Color selectedBackgroundColor;
    protected Color selectedForegroundColor;
    protected int borderStyle;
    protected Insets borderInsets;
    protected int verticalAlignment;
    protected int horizontalAlignment;
    protected int editWidthPolicy;
    protected int editHeightPolicy;
    protected Insets marginInsets;
    protected Font font;
    protected boolean allowWidthSizing;
    protected boolean selectAll;
    protected int clipHints;

    public CellStyle() {
        this.setBackground(new ColorUIResource(UIManager.getColor("Table.background")));
        this.setForeground(new ColorUIResource(UIManager.getColor("Table.foreground")));
        this.setSelectedBackground(new ColorUIResource(UIManager.getColor("Table.selectionBackground")));
        this.setSelectedForeground(new ColorUIResource(UIManager.getColor("Table.selectionForeground")));
        this.setFont(new FontUIResource(UIManager.getFont("Table.font")));
        this.setBorderStyle(3);
        this.setBorderInsets(new Insets(2, 2, 2, 2));
        this.setMarginInsets(new Insets(2, 2, 2, 2));
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(2);
        this.setEditWidthPolicy(0);
        this.setEditHeightPolicy(1);
        this.setAllowWidthSizing(true);
        this.setSelectAll(true);
        this.setClipHints(3);
    }

    public void copyPlafFromCellStyle(CellStyleModel cellStyleModel) {
        if (this.getBackground() instanceof ColorUIResource) {
            this.setBackground(cellStyleModel.getBackground());
        }
        if (this.getForeground() instanceof ColorUIResource) {
            this.setForeground(cellStyleModel.getForeground());
        }
        if (this.getSelectedBackground() instanceof ColorUIResource) {
            this.setSelectedBackground(cellStyleModel.getSelectedBackground());
        }
        if (this.getSelectedForeground() instanceof ColorUIResource) {
            this.setSelectedForeground(cellStyleModel.getSelectedForeground());
        }
        if (this.getFont() instanceof FontUIResource) {
            this.setFont(cellStyleModel.getFont());
        }
    }

    public void copyFromCellStyle(CellStyleModel cellStyleModel) {
        this.setBackground(cellStyleModel.getBackground());
        this.setForeground(cellStyleModel.getForeground());
        this.setSelectedBackground(cellStyleModel.getSelectedBackground());
        this.setSelectedForeground(cellStyleModel.getSelectedForeground());
        this.setBorderStyle(cellStyleModel.getBorderStyle());
        this.setBorderInsets((Insets)cellStyleModel.getBorderInsets().clone());
        this.setMarginInsets((Insets)cellStyleModel.getMarginInsets().clone());
        this.setVerticalAlignment(cellStyleModel.getVerticalAlignment());
        this.setHorizontalAlignment(cellStyleModel.getHorizontalAlignment());
        this.setEditWidthPolicy(cellStyleModel.getEditWidthPolicy());
        this.setEditHeightPolicy(cellStyleModel.getEditHeightPolicy());
        this.setFont(cellStyleModel.getFont());
        this.setAllowWidthSizing(cellStyleModel.getAllowWidthSizing());
        this.setSelectAll(cellStyleModel.getSelectAll());
        this.setClipHints(cellStyleModel.getClipHints());
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public void setBackground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this.backgroundColor = color;
    }

    public Color getForeground() {
        return this.foregroundColor;
    }

    public void setForeground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this.foregroundColor = color;
    }

    public Color getSelectedBackground() {
        return this.selectedBackgroundColor;
    }

    public void setSelectedBackground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this.selectedBackgroundColor = color;
    }

    public Color getSelectedForeground() {
        return this.selectedForegroundColor;
    }

    public void setSelectedForeground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this.selectedForegroundColor = color;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(int n) {
        this.borderStyle = n;
    }

    public Insets getBorderInsets() {
        return this.borderInsets;
    }

    public void setBorderInsets(Insets insets) {
        this.borderInsets = insets;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    public int getEditWidthPolicy() {
        return this.editWidthPolicy;
    }

    public void setEditWidthPolicy(int n) {
        this.editWidthPolicy = n;
    }

    public int getEditHeightPolicy() {
        return this.editHeightPolicy;
    }

    public void setEditHeightPolicy(int n) {
        this.editHeightPolicy = n;
    }

    public Insets getMarginInsets() {
        return this.marginInsets;
    }

    public void setMarginInsets(Insets insets) {
        this.marginInsets = insets;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException();
        }
        this.font = font;
    }

    public boolean getAllowWidthSizing() {
        return this.allowWidthSizing;
    }

    public void setAllowWidthSizing(boolean bl) {
        this.allowWidthSizing = bl;
    }

    public void setOtherAllowWidthSizing(boolean bl) {
        this.allowWidthSizing = bl;
    }

    public boolean getSelectAll() {
        return this.selectAll;
    }

    public void setSelectAll(boolean bl) {
        this.selectAll = bl;
    }

    public int getClipHints() {
        return this.clipHints;
    }

    public void setClipHints(int n) {
        this.clipHints = n;
    }
}

