/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field;

import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.Field;
import com.klg.jclass.field.JCFieldComponent;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCVersion;
import com.klg.jclass.field.validate.AbstractValidator;
import com.klg.jclass.field.validate.JCValidator;
import com.klg.jclass.util.value.JCValueListener;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.plaf.ComboBoxUI;

public class JCComboField
extends JComboBox
implements JCFieldComponent {
    protected Field field = null;
    transient JTextField text;
    protected boolean required = true;
    protected ListModel original_picklist = null;
    boolean autoComplete = false;
    boolean autoSuggest = false;
    boolean autoRefinement = false;
    boolean autoAppend = true;
    protected String[] prefixList = null;
    public static final String version = JCVersion.getVersionString();

    public JCComboField() {
        this.setEditable(true);
        this.text = this.getTextFieldEditor();
        this.createField(null);
        this.field.addListDataListener(this);
    }

    public JCComboField(Class clazz) {
        this();
        this.field.setClass(clazz);
    }

    public JCComboField(Class clazz, JCValidator jCValidator) {
        this();
        this.field.setValidator(jCValidator);
        this.field.setClass(clazz);
    }

    public JCComboField(JCValueModel jCValueModel) {
        this();
        this.field.setValueModel(jCValueModel);
    }

    public JCComboField(JCValueModel jCValueModel, JCValidator jCValidator) {
        this();
        this.field.setValidator(jCValidator);
        this.field.setValueModel(jCValueModel);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        if (this.field != null) {
            this.field.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void addValueListener(JCValueListener jCValueListener) {
        this.field.addValueListener(jCValueListener);
    }

    public void removeValueListener(JCValueListener jCValueListener) {
        this.field.removeValueListener(jCValueListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        if (this.field != null) {
            this.field.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public DataProperties getDataProperties() {
        return this.field.getDataProperties();
    }

    public void setDataProperties(DataProperties dataProperties) {
        this.field.setDataProperties(dataProperties);
    }

    protected void createField(JCValidator jCValidator) {
        this.field = new Field(this, jCValidator);
    }

    public String getAbout() {
        return version;
    }

    public synchronized void setAbout(String string) {
    }

    public void addNotify() {
        super.addNotify();
        this.field.addNotify();
    }

    public void setBackground(Color color) {
        if (this.field == null || this.field.internalBackgroundChange) {
            super.setBackground(color);
        } else {
            this.field.validBackground = color;
            if (this.field.getState() != 3) {
                super.setBackground(color);
            }
        }
    }

    public void setForeground(Color color) {
        if (this.field == null || this.field.internalForegroundChange) {
            super.setForeground(color);
        } else {
            this.field.validForeground = color;
            if (this.field.getState() != 3) {
                super.setForeground(color);
            }
        }
    }

    protected JTextField getTextFieldEditor() {
        return (JTextField)this.getEditor().getEditorComponent();
    }

    public Object getValue() {
        return this.field.getValue();
    }

    public void setValue(Object object) {
        this.field.setValue(object);
    }

    public JCValueModel getValueModel() {
        return this.field.getValueModel();
    }

    public void setValueModel(JCValueModel jCValueModel) {
        this.field.setValueModel(jCValueModel);
    }

    public JCValidator getValidator() {
        return this.field.getValidator();
    }

    public void setValidator(JCValidator jCValidator) {
        this.field.setValidator(jCValidator);
        this.original_picklist = jCValidator == null ? null : jCValidator.getPickList();
    }

    public JCInvalidInfo getInvalidInfo() {
        return this.field.getInvalidInfo();
    }

    public void setInvalidInfo(JCInvalidInfo jCInvalidInfo) {
        this.field.setInvalidInfo(jCInvalidInfo);
    }

    public int getState() {
        return this.field.getState();
    }

    public boolean getSelectOnEnter() {
        return this.field.getSelectOnEnter();
    }

    public void setSelectOnEnter(boolean bl) {
        this.field.setSelectOnEnter(bl);
    }

    public void commitEdit() {
        this.field.commitEdit();
    }

    public boolean isRequired() {
        return this.required;
    }

    public ListModel getPickList() {
        JCValidator jCValidator = this.field.getValidator();
        if (jCValidator == null) {
            return null;
        }
        return jCValidator.getPickList();
    }

    protected ListModel getOriginalPickList() {
        return this.original_picklist;
    }

    public void setPickList(ListModel listModel) {
        this.setTemporaryPickList(listModel);
        this.original_picklist = listModel;
    }

    protected void setTemporaryPickList(ListModel listModel) {
        JCValidator jCValidator = this.field.getValidator();
        if (jCValidator == null) {
            return;
        }
        jCValidator.setPickList(listModel);
        this.field.fireContentsChanged(this.field, 0, listModel.getSize());
    }

    protected void restoreOriginalPickList() {
        this.setTemporaryPickList(this.original_picklist);
    }

    public void setAutoComplete(boolean bl, boolean bl2, boolean bl3, boolean bl4, String[] stringArray) {
        if (this.autoComplete != bl && !bl) {
            this.field.turnOffAutoCompleteMode();
        }
        this.autoComplete = bl;
        this.autoAppend = bl2;
        this.autoSuggest = bl3;
        this.autoRefinement = bl3 ? bl4 : false;
        this.prefixList = stringArray;
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public boolean isAutoSuggest() {
        return this.autoSuggest;
    }

    public boolean isAutoAppend() {
        return this.autoAppend;
    }

    public boolean isAutoRefinement() {
        return this.autoRefinement;
    }

    public String[] getPrefixList() {
        return this.prefixList;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public void setUI(ComboBoxUI comboBoxUI) {
        super.setUI(comboBoxUI);
        this.text = this.getTextFieldEditor();
        if (this.field != null) {
            JCValueModel jCValueModel = this.field.getValueModel();
            this.createField(null);
            this.setValidator(this.field.getValidator());
            this.setValueModel(jCValueModel);
        }
    }

    public void updateUI() {
        this.setUI((ComboBoxUI)UIManager.getUI(this));
    }

    public void addActionListener(ActionListener actionListener) {
        this.text.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.text.removeActionListener(actionListener);
    }

    public void setItems(String[] stringArray) {
        if (this.getItemCount() > 0) {
            this.removeAllItems();
        }
        int n = 0;
        while (n < stringArray.length) {
            this.add(stringArray[n]);
            ++n;
        }
    }

    public void add(String string) {
        this.addItem(string);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this.field != null) {
            Serializable serializable;
            JCValidator jCValidator = this.getValidator();
            if (jCValidator instanceof AbstractValidator) {
                serializable = (AbstractValidator)jCValidator;
                ((AbstractValidator)serializable).setLocale(locale);
            }
            if ((serializable = this.getValueModel()) != null) {
                this.field.setValue(serializable.getValue());
            }
        }
    }
}

