/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.util;

import java.io.Serializable;
import java.util.StringTokenizer;

public class SqlStatementColumn
implements Serializable {
    static final long serialVersionUID = 7083424415349465593L;
    private String alias;
    private String column;
    private String qualifier;
    private String catalog;
    private String schema;
    private String table;
    private boolean isTableColumn = true;
    private String text;

    public SqlStatementColumn(String string, String string2, String string3) {
        this.column = string;
        this.qualifier = string2;
        this.setAlias(string3);
        this.parseQualifier();
    }

    public String getColumnName() {
        return this.column;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String string) {
        String string2 = this.getQualifiedName();
        this.qualifier = string;
        if (this.alias == string2) {
            this.setAlias(this.getQualifiedName());
        }
    }

    public String getQualifiedName() {
        return this.qualifier == null ? this.column : this.qualifier + "." + this.column;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = this.column == "*" ? this.getQualifiedName() : (string == null ? this.getQualifiedName() : string);
    }

    public boolean isTableColumn() {
        return this.isTableColumn;
    }

    public void setIsTableColumn(boolean bl) {
        this.isTableColumn = bl;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return new String("[column name: " + this.column + " qualifier: " + this.qualifier + " alias: " + this.alias + " isTableColumn: " + this.isTableColumn + " text: " + this.text + "]\n");
    }

    void parseQualifier() {
        String string = this.getQualifier();
        if (string == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.insert(0, stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(stringBuffer.toString(), ".", false);
        if (stringTokenizer.hasMoreTokens()) {
            this.table = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.schema = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.catalog = stringTokenizer.nextToken();
        }
    }

    public String getCatalogName() {
        return this.catalog;
    }

    public String getSchemaName() {
        return this.schema;
    }

    public String getTableName() {
        return this.table;
    }
}

