/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.util;

import com.klg.jclass.datasource.Binding;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.util.DataBinding;
import java.awt.Component;

public abstract class NavigatorDataBinding
extends DataBinding {
    public NavigatorDataBinding(Component component) {
        super(component);
    }

    public NavigatorDataBinding(Component component, Binding binding) {
        super(component);
        this.setDataBinding(binding);
    }

    public boolean addRow() {
        try {
            ((Binding)this.binding).addRow(this);
            this.moveToRowIndex(this.getNumRows() - 1);
            return true;
        }
        catch (DataModelException dataModelException) {
            this.processException(dataModelException);
            return false;
        }
    }

    public boolean deleteRow() {
        int n = this.getCurrentRowIndex();
        return n >= 0 ? this.deleteRows(n, 1) : false;
    }

    public boolean deleteRows(int n, int n2) {
        if (n2 <= 0) {
            return false;
        }
        try {
            ((Binding)this.binding).deleteRows(this, n, n2);
        }
        catch (DataModelException dataModelException) {
            this.processException(dataModelException);
            return false;
        }
        return true;
    }

    public boolean requeryRow() {
        int n = this.getCurrentRowIndex();
        return n >= 0 ? this.requeryRows(n, 1) : false;
    }

    public boolean requeryRows(int n, int n2) {
        if (n2 <= 0) {
            return false;
        }
        try {
            int n3 = n;
            while (n3 < n + n2) {
                this.binding.requeryRow(this, n);
                ++n3;
            }
            return true;
        }
        catch (DataModelException dataModelException) {
            this.processException(dataModelException);
            return false;
        }
    }

    public boolean requeryRowAndDetails() {
        int n = this.getCurrentRowIndex();
        return n >= 0 ? this.requeryRowsAndDetails(n, 1) : false;
    }

    public boolean requeryRowsAndDetails(int n, int n2) {
        if (n2 <= 0) {
            return false;
        }
        try {
            int n3 = n;
            while (n3 < n + n2) {
                this.binding.requeryRowAndDetails(this, n3);
                ++n3;
            }
            return true;
        }
        catch (DataModelException dataModelException) {
            this.processException(dataModelException);
            return false;
        }
    }

    public boolean requeryAll() {
        try {
            this.binding.requeryAll(this);
            return true;
        }
        catch (DataModelException dataModelException) {
            this.processException(dataModelException);
            return false;
        }
    }

    public boolean cancelRow() {
        int n = this.getCurrentRowIndex();
        return n >= 0 ? this.cancelRows(n, 1) : false;
    }

    public boolean cancelRows(int n, int n2) {
        if (n2 <= 0) {
            return false;
        }
        try {
            int n3 = n;
            while (n3 < n + n2) {
                ((Binding)this.binding).cancelRowChanges(this, n3);
                ++n3;
            }
            return true;
        }
        catch (DataModelException dataModelException) {
            this.processException(dataModelException);
            return false;
        }
    }

    public boolean cancelAll() {
        try {
            ((Binding)this.binding).cancelAll(this);
            return true;
        }
        catch (DataModelException dataModelException) {
            this.processException(dataModelException);
            return false;
        }
    }

    public boolean commitRow() {
        int n = this.getCurrentRowIndex();
        return n >= 0 ? this.commitRows(n, 1) : false;
    }

    public boolean commitRows(int n, int n2) {
        if (n2 <= 0) {
            return false;
        }
        try {
            int n3 = n;
            while (n3 < n + n2) {
                ((Binding)this.binding).commitRow(this, n3);
                ++n3;
            }
            return true;
        }
        catch (DataModelException dataModelException) {
            this.processException(dataModelException);
            return false;
        }
    }

    public boolean commitAll() {
        try {
            ((Binding)this.binding).commitAll(this);
            return true;
        }
        catch (DataModelException dataModelException) {
            this.processException(dataModelException);
            return false;
        }
    }

    public Object getTableRowLabel(int n) {
        return n + (this.isRowModified(n) ? "*" : "  ");
    }

    public Object getResultData(int n, int n2) {
        try {
            return this.binding.getCell((DataModelListener)this, n, n2);
        }
        catch (DataModelException dataModelException) {
            this.processException(dataModelException);
            return null;
        }
    }

    public boolean updateCell(Object object, int n, int n2) {
        try {
            ((Binding)this.binding).setCell(this, n, n2, object);
            return true;
        }
        catch (DataModelException dataModelException) {
            this.processException(dataModelException);
            return false;
        }
    }

    public boolean isRowModified(int n) {
        boolean bl = false;
        try {
            ((Binding)this.binding).isRowModified(n);
        }
        catch (DataModelException dataModelException) {
            this.processException(dataModelException);
        }
        return bl;
    }

    public int getRowStatus(int n) {
        try {
            return ((Binding)this.binding).getRowStatus(n);
        }
        catch (DataModelException dataModelException) {
            this.processException(dataModelException);
            return -1;
        }
    }

    public boolean requeryLevel() {
        try {
            this.binding.requeryLevel(this);
            return true;
        }
        catch (DataModelException dataModelException) {
            this.processException(dataModelException);
            return false;
        }
    }

    protected void setDataAvailable(boolean bl) {
        boolean bl2 = this.component.isEnabled();
        bl = this.isEnabled();
        if (bl != bl2) {
            this.component.setEnabled(bl);
        }
    }

    public boolean isEnabled() {
        if (this.binding != null) {
            return this.binding.getDataModel() != null && this.binding.getMetaDataModel() != null;
        }
        return false;
    }

    public boolean isAvailable() {
        return this.isDataAvailable();
    }
}

