/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.swing;

import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.swing.JCBorder;
import com.klg.jclass.util.swing.JCIconCreator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.JComponent;

class NavigatorButton
extends JComponent
implements MouseListener,
Serializable {
    static final int FIRST = 0;
    static final int PREVIOUS = 1;
    static final int INSERT = 2;
    static final int DELETE = 3;
    static final int NEXT = 4;
    static final int LAST = 5;
    static final int MENU = 6;
    private int type = 0;
    private boolean pressed = false;
    private transient Image enabledIcon = null;
    private transient Image disabledIcon = null;
    private JCListenerList actionListeners;
    private static final int width = 15;
    private static final int height = 15;
    private transient Image buffer = null;
    private static final String[][] iconStrings = new String[][]{{"         ", "  .   .  ", "  .  ..  ", "  . ...  ", "  .....  ", "  . ...  ", "  .  ..  ", "  .   .  ", "         "}, {"         ", "     .   ", "    ..   ", "   ...   ", "  ....   ", "   ...   ", "    ..   ", "     .   ", "         "}, {"       . ", " .    ...", " ..    . ", " ... .   ", " .....   ", " ... .   ", " ..  .   ", " .   .   ", "         "}, {"         ", "  .   .  ", "  .. ..  ", "   ...   ", "    .    ", "   ...   ", "  .. ..  ", "  .   .  ", "         "}, {"         ", "   .     ", "   ..    ", "   ...   ", "   ....  ", "   ...   ", "   ..    ", "   .     ", "         "}, {"         ", "   .   . ", "   ..  . ", "   ... . ", "   ..... ", "   ... . ", "   ..  . ", "   .   . ", "         "}, {" .....   ", " . . .   ", " .....   ", " .  ..   ", " .....   ", " ..  .   ", " .. .....", "     ... ", "      .  "}};

    NavigatorButton(int n) {
        this.type = n;
        super.setEnabled(false);
        this.addMouseListener(this);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Object object;
        if (this.buffer == null) {
            object = this.getBounds();
            this.buffer = this.createImage(((Rectangle)object).width, ((Rectangle)object).height);
        }
        object = this.buffer.getGraphics();
        ((Graphics)object).setColor(this.pressed ? this.getBackground().darker() : this.getBackground());
        ((Graphics)object).fillRect(0, 0, this.getSize().width, this.getSize().height);
        JCBorder.drawNormal((Graphics)object, 1, 0, 0, this.getSize().width, this.getSize().height, Color.black, Color.black);
        JCBorder.drawNormal((Graphics)object, 1, 1, 1, this.getSize().width - 1, this.getSize().height - 1, this.pressed ? Color.black : Color.white, this.pressed ? Color.white : Color.black);
        if (this.enabledIcon == null) {
            this.createIcons();
        }
        Image image = this.isEnabled() ? this.enabledIcon : this.disabledIcon;
        ((Graphics)object).drawImage(image, (this.getSize().width - image.getWidth(null)) / 2, (this.getSize().height - image.getHeight(null)) / 2, null);
        graphics.drawImage(this.buffer, 0, 0, this);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.createIcons();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.createIcons();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.add(this.actionListeners, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.remove(this.actionListeners, actionListener);
    }

    public Dimension getPreferredSize() {
        return new Dimension(15, 15);
    }

    public Dimension getMinimumSize() {
        return new Dimension(15, 15);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.pressed = true;
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.pressed = false;
        this.repaint();
        ActionEvent actionEvent = new ActionEvent(this, 1001, "" + this.type, 0);
        Enumeration enumeration = JCListenerList.elements(this.actionListeners);
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(actionEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void createIcons() {
        Color color = this.getForeground();
        Color color2 = this.getBackground();
        if (color == null || color2 == null) {
            return;
        }
        JCIconCreator jCIconCreator = new JCIconCreator(9, 9);
        jCIconCreator.setColor('.', color);
        jCIconCreator.setPixels(iconStrings[this.type]);
        this.enabledIcon = jCIconCreator.getIcon().getImage();
        jCIconCreator.clear();
        jCIconCreator.setColor('.', color2.darker());
        jCIconCreator.setPixels(iconStrings[this.type]);
        this.disabledIcon = jCIconCreator.getIcon().getImage();
    }
}

