/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.jdbc;

import com.klg.jclass.datasource.Binding;
import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.TreeData;
import com.klg.jclass.datasource.jdbc.DataTableConnection;
import com.klg.jclass.datasource.jdbc.MetaData;
import com.klg.jclass.datasource.util.ColumnMap;
import java.util.Enumeration;

public class JDBCBinding
extends Binding {
    static final long serialVersionUID = -920646318559618093L;

    public JDBCBinding(DataModel dataModel) {
        super(dataModel);
    }

    public JDBCBinding(DataTableConnection dataTableConnection, String string) throws DataModelException {
        super(new TreeData());
        this.metaDataModel = new MetaData(this.dataModel, dataTableConnection, string);
        this.metaDataModel.setBinding(this);
        ((MetaData)this.metaDataModel).open();
    }

    public JDBCBinding(DataTableConnection dataTableConnection, String string, Binding binding, String[] stringArray) throws DataModelException {
        this(dataTableConnection, string, binding);
        int n = 0;
        while (n < stringArray.length) {
            this.addJoinColumn(stringArray[n], stringArray[n]);
            ++n;
        }
        this.open();
    }

    public JDBCBinding(DataTableConnection dataTableConnection, String string, Binding binding, String[][] stringArray) throws DataModelException {
        this(dataTableConnection, string, binding);
        int n = 0;
        while (n < stringArray.length) {
            this.addJoinColumn(stringArray[n][0], stringArray[n][1]);
            ++n;
        }
        this.open();
    }

    protected JDBCBinding(DataTableConnection dataTableConnection, String string, Binding binding) throws DataModelException {
        super(binding);
        this.dataModel = binding.getDataModel();
        this.metaDataModel = new MetaData(binding.getDataModel(), binding.getMetaDataModel(), dataTableConnection);
        this.metaDataModel.setBinding(this);
        this.dataModel.addDataModelListener(this.eventListener);
        ((MetaData)this.metaDataModel).setStatement(string);
    }

    public String getQuery() {
        return ((MetaData)this.metaDataModel).getStatement();
    }

    public void setDataModel(DataModel dataModel) {
        this.dataModel = dataModel;
    }

    public void addJoinColumn(String string, String string2) {
        ((MetaData)this.metaDataModel).joinOnParentColumn(string2, string);
    }

    public void open() throws DataModelException {
        StringBuffer stringBuffer = new StringBuffer(" WHERE ");
        Enumeration enumeration = ((MetaData)this.metaDataModel).getJoinColumns().elements();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" AND ");
            }
            ColumnMap columnMap = (ColumnMap)enumeration.nextElement();
            stringBuffer.append(columnMap.getChildColumn());
            stringBuffer.append(" = ? ");
        }
        ((MetaData)this.metaDataModel).setWhereClause(stringBuffer.toString());
        ((MetaData)this.metaDataModel).open();
    }
}

