/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.customizer;

import com.klg.jclass.datasource.DataSourceTreeModel;
import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.datasource.ErrorDialog;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.beans.JCDataEvent;
import com.klg.jclass.datasource.beans.SerializedProperties;
import com.klg.jclass.datasource.customizer.CustomizePage;
import com.klg.jclass.datasource.customizer.DesignTimeMetaData;
import com.klg.jclass.datasource.customizer.EditorTreeNode;
import com.klg.jclass.datasource.customizer.SerializationPageParent;
import com.klg.jclass.util.swing.JCAlignLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class TreeEditor
extends CustomizePage
implements FocusListener,
ActionListener,
ListSelectionListener,
TreeSelectionListener,
SerializationPageParent,
DesignTimeMetaData {
    protected JButton btnAdd;
    protected JButton btnDelete;
    protected JButton btnDescription;
    protected JButton btnClear;
    protected JTree outliner;
    protected JTabbedPane tabManager;
    protected JTextField modelName;
    private Progress progress = null;
    private static int descriptionCounter = 0;
    private boolean returnNewInstance = false;
    private static final boolean TRACE = false;

    public TreeEditor(String string) {
        this(string, false);
    }

    public TreeEditor(String string, boolean bl) {
        super(string);
        this.init(bl);
    }

    public void addNotify() {
        if (this.progress == null) {
            // empty if block
        }
        super.addNotify();
    }

    public void init() {
        this.init(false);
    }

    public void init(boolean bl) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.outliner = new JTree();
        this.outliner.setShowsRootHandles(true);
        this.outliner.setEditable(true);
        this.outliner.setModel(null);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        this.btnAdd = new JButton(LocaleBundle.string("Add"));
        this.btnDelete = new JButton(LocaleBundle.string("Delete"));
        this.btnClear = new JButton(LocaleBundle.string("Clear"));
        this.btnDescription = new JButton(LocaleBundle.string("Description..."));
        this.add(this.getNorthComponent(bl), "North");
        this.modelName.addActionListener(this);
        this.modelName.addFocusListener(this);
        jPanel3.setLayout(new GridBagLayout());
        jPanel4.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        jPanel3.add((Component)this.btnAdd, gridBagConstraints);
        jPanel3.add((Component)this.btnDelete, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel3.add((Component)this.btnClear, gridBagConstraints);
        jPanel4.add((Component)this.btnDescription, gridBagConstraints);
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel.add((Component)new JScrollPane(this.outliner), "Center");
        jPanel.add((Component)jPanel2, "South");
        this.tabManager = this.createTabs();
        if (this.tabManager != null) {
            this.add((Component)this.tabManager, "East");
        }
        this.add((Component)jPanel, "Center");
        this.outliner.addTreeSelectionListener(this);
        this.btnAdd.addActionListener(this);
        this.btnDescription.addActionListener(this);
        this.btnDelete.addActionListener(this);
        this.btnClear.addActionListener(this);
    }

    public Component getNorthComponent(boolean bl) {
        JPanel jPanel = new JPanel();
        this.modelName = new JTextField("", 30);
        jPanel.add(new JLabel(LocaleBundle.string("Model Name")));
        jPanel.setLayout(new JCAlignLayout());
        jPanel.add(this.modelName);
        return jPanel;
    }

    public Insets getInsets() {
        return new Insets(5, 5, 5, 0);
    }

    public String getAsText() {
        return LocaleBundle.string("Click to edit...");
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = this.getAsText();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n);
    }

    public String getJavaInitializationString() {
        String string = this.getResourceName();
        string = string == null ? new String("") : string.trim();
        return string.replace('\\', '/');
    }

    protected void expandTree() {
        DataSourceTreeNode dataSourceTreeNode = (DataSourceTreeNode)this.outliner.getModel().getRoot();
        if (dataSourceTreeNode != null) {
            Enumeration<TreeNode> enumeration = dataSourceTreeNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DataSourceTreeNode dataSourceTreeNode2 = (DataSourceTreeNode)enumeration.nextElement();
                TreePath treePath = new TreePath(dataSourceTreeNode2.getPath());
                this.outliner.expandPath(treePath);
            }
            this.outliner.setSelectionPath(new TreePath(dataSourceTreeNode.getPath()));
        }
    }

    protected void buildTree(EditorTreeNode editorTreeNode, DataSourceTreeNode dataSourceTreeNode) {
        if (dataSourceTreeNode == (DataSourceTreeNode)null) {
            return;
        }
        if (dataSourceTreeNode.getUserObject() == null) {
            return;
        }
        EditorTreeNode editorTreeNode2 = new EditorTreeNode(dataSourceTreeNode);
        if (this.outliner.getModel() == null) {
            this.outliner.setModel(new DataSourceTreeModel(editorTreeNode2));
        } else {
            ((DataSourceTreeModel)this.outliner.getModel()).insertNodeInto(editorTreeNode2, editorTreeNode, editorTreeNode.getChildCount());
        }
        Enumeration<TreeNode> enumeration = dataSourceTreeNode.children();
        while (enumeration.hasMoreElements()) {
            this.buildTree(editorTreeNode2, (DataSourceTreeNode)enumeration.nextElement());
        }
    }

    EditorTreeNode addNode(String string) {
        EditorTreeNode editorTreeNode = null;
        if (this.outliner.getModel() != null) {
            editorTreeNode = (EditorTreeNode)(this.outliner.getLastSelectedPathComponent() != null ? this.outliner.getLastSelectedPathComponent() : this.outliner.getModel().getRoot());
        }
        DataSourceTreeNode dataSourceTreeNode = new DataSourceTreeNode();
        return this.addNode(editorTreeNode, dataSourceTreeNode, string);
    }

    EditorTreeNode addNode(EditorTreeNode editorTreeNode, DataSourceTreeNode dataSourceTreeNode, String string) {
        DataSourceTreeNode dataSourceTreeNode2 = null;
        if (editorTreeNode != null) {
            dataSourceTreeNode2 = (DataSourceTreeNode)editorTreeNode.getUserObject();
        }
        this.addNodeData(dataSourceTreeNode2, dataSourceTreeNode, string);
        EditorTreeNode editorTreeNode2 = new EditorTreeNode(dataSourceTreeNode);
        if (editorTreeNode == null) {
            this.outliner.setModel(new DataSourceTreeModel(editorTreeNode2));
            ((DataSourceTreeModel)this.outliner.getModel()).nodeStructureChanged(editorTreeNode);
        } else {
            ((DataSourceTreeModel)this.outliner.getModel()).insertNodeInto(editorTreeNode2, editorTreeNode, editorTreeNode.getChildCount());
        }
        TreePath treePath = new TreePath(editorTreeNode2.getPath());
        this.outliner.setSelectionPath(treePath);
        return editorTreeNode2;
    }

    void setNodeDescription() {
        EditorTreeNode editorTreeNode = (EditorTreeNode)this.outliner.getLastSelectedPathComponent();
        if (editorTreeNode == null) {
            return;
        }
        String string = editorTreeNode.getDescription();
        if (string == null || string.trim().length() == 0) {
            string = LocaleBundle.string("Node") + descriptionCounter++;
            editorTreeNode.setDescription(string);
        }
        this.outliner.startEditingAtPath(this.outliner.getSelectionPath());
    }

    void deleteNode() {
        EditorTreeNode editorTreeNode;
        EditorTreeNode editorTreeNode2;
        EditorTreeNode editorTreeNode3 = (EditorTreeNode)this.outliner.getLastSelectedPathComponent();
        if (editorTreeNode3 == null) {
            return;
        }
        this.removeNodeData((DataSourceTreeNode)editorTreeNode3.getUserObject());
        if (editorTreeNode3.getChildCount() > 0) {
            editorTreeNode3.removeAllChildren();
            ((DataSourceTreeModel)this.outliner.getModel()).nodeStructureChanged(editorTreeNode3);
        }
        if ((editorTreeNode2 = (EditorTreeNode)editorTreeNode3.getNextNode()) == null) {
            editorTreeNode2 = (EditorTreeNode)editorTreeNode3.getPreviousNode();
        }
        if ((editorTreeNode = (EditorTreeNode)editorTreeNode3.getParent()) == null) {
            this.outliner.setModel(null);
            this.clearData();
            this.nodeSelected(null);
        } else {
            ((DataSourceTreeModel)this.outliner.getModel()).removeNodeFromParent(editorTreeNode3);
        }
        if (editorTreeNode2 != null) {
            TreePath treePath = new TreePath(editorTreeNode2.getPath());
            this.outliner.setSelectionPath(treePath);
        }
        ((SerializedProperties)this.target).fireJCDataEvent(new JCDataEvent(this.target));
    }

    void clear() {
        this.outliner.setModel(null);
        this.clearData();
        this.nodeSelected(null);
        ((SerializedProperties)this.target).fireJCDataEvent(new JCDataEvent(this.target));
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        this.nodeSelected((EditorTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1));
        this.outliner.scrollPathToVisible(treePath);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.equals(this.btnAdd)) {
                EditorTreeNode editorTreeNode = null;
                editorTreeNode = this.addNode(LocaleBundle.string("Node") + descriptionCounter++);
                if (editorTreeNode != null) {
                    ((SerializedProperties)this.target).fireJCDataEvent(new JCDataEvent(this.target));
                }
            } else if (jButton.equals(this.btnDescription)) {
                this.setNodeDescription();
            } else if (jButton.equals(this.btnDelete)) {
                this.deleteNode();
            } else if (jButton.equals(this.btnClear)) {
                this.clear();
            }
        } else if (actionEvent.getSource() instanceof JTextField && this.modelName.equals(actionEvent.getSource())) {
            this.setModelName();
            ((SerializedProperties)this.target).fireJCDataEvent(new JCDataEvent(this.target));
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setModelName();
        EditorTreeNode editorTreeNode = (EditorTreeNode)this.outliner.getLastSelectedPathComponent();
        if (editorTreeNode == null) {
            return;
        }
        ((SerializedProperties)this.target).fireJCDataEvent(new JCDataEvent(this.target));
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    public abstract JTabbedPane createTabs();

    public void setBean(Object object) {
        super.setBean(object);
    }

    public boolean loadFromFile(String string) {
        SerializedProperties serializedProperties = (SerializedProperties)this.target;
        String string2 = serializedProperties.getSerializationFile();
        if (!string.toLowerCase().endsWith(".ser")) {
            string = string + ".ser";
        }
        try {
            this.setValue(string);
        }
        catch (Exception exception) {
            serializedProperties.setSerializationFile(string2);
            return false;
        }
        this.showNewBeanComponent();
        return true;
    }

    public void saveToFile() {
        if (this.target == null) {
            return;
        }
        try {
            SerializedProperties serializedProperties = (SerializedProperties)this.target;
            if (serializedProperties.isSerializationRequired()) {
                if (!this.isClosed() && !serializedProperties.isResourceNameSpecified()) {
                    ErrorDialog.showError(null, LocaleBundle.string("Please enter a resource name and save the bean component to a file."));
                }
                SerializedProperties.toFile((SerializedProperties)serializedProperties, (String)serializedProperties.getSerializationFile());
                this.returnNewInstance = true;
            }
        }
        catch (Exception exception) {
            ErrorDialog.showError(null, exception + System.getProperty("line.separator") + LocaleBundle.string("Failed to serialize"));
        }
    }

    public boolean isClosed() {
        return this.getParent() != null && this.getParent() instanceof Component ? !this.getParent().isShowing() : !this.isShowing();
    }

    public Object getValue() {
        if (!this.returnNewInstance) {
            return this.target;
        }
        this.saveToFile();
        SerializedProperties serializedProperties = null;
        try {
            serializedProperties = SerializedProperties.fromFile((String)((SerializedProperties)this.target).getSerializationFile());
            this.returnNewInstance = false;
        }
        catch (Exception exception) {
            ErrorDialog.showError(null, exception + System.getProperty("line.separator") + LocaleBundle.string("Failed to deserialize"));
        }
        return serializedProperties;
    }

    public abstract void setValue(Object var1);

    public abstract void setModelName();

    public abstract void addNodeData(DataSourceTreeNode var1, DataSourceTreeNode var2, String var3);

    public abstract void removeNodeData(DataSourceTreeNode var1);

    public abstract void clearData();

    public abstract String getResourceName();

    public abstract void nodeSelected(EditorTreeNode var1);

    public abstract void showNewBeanComponent();

    protected class Progress
    implements Runnable {
        JDialog dlg = new JDialog(new JFrame());
        Thread thread = null;

        Progress() {
            if (!TreeEditor.this.isClosed()) {
                return;
            }
            this.dlg.setTitle(LocaleBundle.string("Please wait..."));
            this.dlg.setModal(false);
            JLabel jLabel = new JLabel(LocaleBundle.string("Loading Property Editor/Customizer..."));
            jLabel.setHorizontalAlignment(0);
            this.dlg.getContentPane().add(jLabel);
            this.dlg.pack();
            this.dlg.setSize(300, 100);
            this.setVisible(true);
            Thread thread = new Thread(this);
            thread.start();
        }

        public void setVisible(boolean bl) {
            if (bl) {
                this.centerDialog();
            }
            this.dlg.setVisible(bl);
        }

        void centerDialog() {
            int n = 0;
            int n2 = 0;
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            n = (dimension.width - this.dlg.getSize().width) / 2;
            n2 = (dimension.height - this.dlg.getSize().height) / 2;
            this.dlg.setLocation(n, n2);
        }

        public void run() {
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (TreeEditor.this.isClosed());
            this.dlg.dispose();
            TreeEditor.this.progress = null;
        }
    }
}

