/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.customizer;

import com.klg.jclass.datasource.ErrorDialog;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.beans.NodeProperties;
import com.klg.jclass.datasource.customizer.Table;
import com.klg.jclass.datasource.util.ColumnMap;
import com.klg.jclass.datasource.util.SqlStatement;
import com.klg.jclass.datasource.util.SqlStatementColumn;
import com.klg.jclass.datasource.util.SqlStatementTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class JoinDialog
extends JDialog
implements ActionListener,
ItemListener {
    JLabel lblParent;
    JLabel lblChild;
    JList joinList;
    JButton btnAdd;
    JButton btnModify;
    JButton btnDelete;
    JButton btnAutoJoin;
    JButton btnOk;
    JComboBox parentColumn;
    JComboBox childColumn;
    JComboBox parentTable;
    JComboBox childTable;
    DefaultListModel listModel = new DefaultListModel();
    Table joinParent;
    Table joinChild;
    SqlStatement parentSqlStatement;
    SqlStatement childSqlStatement;
    NodeProperties parentComp;
    NodeProperties childComp;
    boolean allowMoreThanTwoTables;
    boolean onlyUseParentSelectedColumns;
    Vector tables;
    private static final String equalJoin = " = ";

    JoinDialog(Frame frame, Vector vector, SqlStatement sqlStatement, NodeProperties nodeProperties) {
        this(frame, vector, sqlStatement, nodeProperties, sqlStatement, nodeProperties, false, false);
    }

    JoinDialog(Frame frame, Vector vector, SqlStatement sqlStatement, NodeProperties nodeProperties, SqlStatement sqlStatement2, NodeProperties nodeProperties2, boolean bl, boolean bl2) {
        super(frame);
        Vector vector2 = vector == null ? new Vector() : vector;
        this.parentSqlStatement = sqlStatement;
        this.parentComp = nodeProperties;
        this.childSqlStatement = sqlStatement2;
        this.childComp = nodeProperties2;
        this.allowMoreThanTwoTables = bl;
        this.onlyUseParentSelectedColumns = bl2;
        this.setModal(true);
        this.setTitle(LocaleBundle.string("Join"));
        this.init();
        this.loadJoin(vector2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JoinDialog.this.setVisible(false);
            }
        });
    }

    public void init() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.btnAdd = new JButton(LocaleBundle.string("Add"));
        this.btnModify = new JButton(LocaleBundle.string("Modify"));
        this.btnDelete = new JButton(LocaleBundle.string("Delete"));
        this.btnAutoJoin = new JButton(LocaleBundle.string("Auto Join"));
        this.btnOk = new JButton(LocaleBundle.string("OK"));
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel("");
        JLabel jLabel2 = new JLabel(LocaleBundle.string("Table"));
        JLabel jLabel3 = new JLabel(LocaleBundle.string("Column Name"));
        this.lblParent = new JLabel(LocaleBundle.string("Primary"));
        this.lblChild = new JLabel(LocaleBundle.string("Foreign"));
        this.parentTable = new JComboBox();
        this.parentColumn = new JComboBox();
        this.childTable = new JComboBox();
        this.childColumn = new JComboBox();
        this.joinList = new JList(this.listModel);
        JPanel jPanel3 = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        jPanel.add((Component)this.btnAdd, gridBagConstraints);
        jPanel.add((Component)this.btnModify, gridBagConstraints);
        jPanel.add((Component)this.btnDelete, gridBagConstraints);
        jPanel.add((Component)this.btnAutoJoin, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)this.btnOk, gridBagConstraints);
        jPanel2.setLayout(new GridLayout(3, 3, 5, 5));
        jPanel2.add(jLabel);
        jPanel2.add(jLabel2);
        jPanel2.add(jLabel3);
        jPanel2.add(this.lblParent);
        jPanel2.add(this.parentTable);
        jPanel2.add(this.parentColumn);
        jPanel2.add(this.lblChild);
        jPanel2.add(this.childTable);
        jPanel2.add(this.childColumn);
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.add((Component)jPanel, "South");
        this.getContentPane().add((Component)new JScrollPane(this.joinList), "Center");
        this.getContentPane().add((Component)jPanel3, "South");
        this.joinList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                JoinDialog.this.showSelectedJoin();
            }
        });
        this.parentTable.addItemListener(this);
        this.childTable.addItemListener(this);
        this.btnAdd.addActionListener(this);
        this.btnModify.addActionListener(this);
        this.btnDelete.addActionListener(this);
        this.btnAutoJoin.addActionListener(this);
        this.btnOk.addActionListener(this);
    }

    void loadJoin(Vector vector) {
        Object object;
        Enumeration enumeration;
        if (this.onlyUseParentSelectedColumns) {
            this.parentTable.addItem(LocaleBundle.string("<PARENT QUERY>"));
        } else {
            enumeration = this.parentSqlStatement.getTables();
            while (enumeration.hasMoreElements()) {
                object = (SqlStatementTable)enumeration.nextElement();
                this.parentTable.addItem(((SqlStatementTable)object).getAlias());
            }
        }
        enumeration = this.childSqlStatement.getTables();
        while (enumeration.hasMoreElements()) {
            object = (SqlStatementTable)enumeration.nextElement();
            this.childTable.addItem(((SqlStatementTable)object).getAlias());
        }
        this.parentTable.setEnabled(!this.onlyUseParentSelectedColumns && (this.allowMoreThanTwoTables || vector.size() == 0));
        this.childTable.setEnabled(this.allowMoreThanTwoTables || vector.size() == 0);
        object = vector.elements();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            ColumnMap columnMap = this.getJoinColumns(string);
            this.addJoin(columnMap.getParentColumn(), columnMap.getChildColumn());
        }
        if (this.joinList.getModel().getSize() > 0) {
            this.joinList.setSelectedIndex(0);
            this.showSelectedJoin();
        } else {
            this.loadParentColumns();
            this.loadChildColumns();
        }
    }

    ColumnMap getJoinColumns(String string) {
        String string2 = new String(string.substring(0, string.indexOf(equalJoin)));
        String string3 = new String(string.substring(string.indexOf(equalJoin) + equalJoin.length()));
        return new ColumnMap(string2, string3);
    }

    void loadParentColumns() {
        block4: {
            block3: {
                if (this.parentColumn.getItemCount() > 0) {
                    this.parentColumn.removeAllItems();
                }
                if (!this.onlyUseParentSelectedColumns) break block3;
                Enumeration enumeration = this.getParentSelectedColumns().elements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    this.parentColumn.addItem(string);
                }
                break block4;
            }
            this.joinParent = this.getTable((String)this.parentTable.getSelectedItem(), this.parentSqlStatement, this.parentComp);
            if (this.joinParent == null) break block4;
            String[] stringArray = this.joinParent.getColumnNames();
            int n = 0;
            while (n < stringArray.length) {
                this.parentColumn.addItem(stringArray[n]);
                ++n;
            }
        }
    }

    Vector getAllTableColumns(SqlStatement sqlStatement, NodeProperties nodeProperties) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = sqlStatement.getTables();
        while (enumeration.hasMoreElements()) {
            SqlStatementTable sqlStatementTable = (SqlStatementTable)enumeration.nextElement();
            Table table = this.getTable(sqlStatementTable.getQualifiedName(), sqlStatement, nodeProperties);
            if (table == null) continue;
            String[] stringArray = table.getColumnNames();
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
        }
        return vector;
    }

    Vector getParentSelectedColumns() {
        Vector vector = new Vector();
        Enumeration enumeration = this.parentSqlStatement.getColumns();
        while (enumeration.hasMoreElements()) {
            SqlStatementColumn sqlStatementColumn = (SqlStatementColumn)enumeration.nextElement();
            if (sqlStatementColumn.getAlias().indexOf("*") > -1) {
                if (sqlStatementColumn.getTableName() == null) {
                    vector = this.getAllTableColumns(this.parentSqlStatement, this.parentComp);
                    continue;
                }
                this.joinParent = this.getTable(sqlStatementColumn.getTableName(), this.parentSqlStatement, this.parentComp);
                if (this.joinParent == null) continue;
                String[] stringArray = this.joinParent.getColumnNames();
                int n = 0;
                while (n < stringArray.length) {
                    vector.addElement(stringArray[n]);
                    ++n;
                }
                continue;
            }
            vector.addElement(sqlStatementColumn.getAlias());
        }
        return vector;
    }

    void loadChildColumns() {
        if (this.childColumn.getItemCount() > 0) {
            this.childColumn.removeAllItems();
        }
        this.joinChild = this.getTable((String)this.childTable.getSelectedItem(), this.childSqlStatement, this.childComp);
        if (this.joinChild != null) {
            String[] stringArray = this.joinChild.getColumnNames();
            int n = 0;
            while (n < stringArray.length) {
                this.childColumn.addItem(stringArray[n]);
                ++n;
            }
        }
    }

    public Table getTable(String string, SqlStatement sqlStatement, NodeProperties nodeProperties) {
        Object object;
        String string2 = null;
        Enumeration enumeration = sqlStatement.getTables();
        while (enumeration.hasMoreElements()) {
            object = (SqlStatementTable)enumeration.nextElement();
            if (!((SqlStatementTable)object).getAlias().equals(string)) continue;
            string2 = ((SqlStatementTable)object).getQualifiedName();
            break;
        }
        object = null;
        try {
            object = nodeProperties.getConnection() == null ? null : new Table(nodeProperties.getConnection().getConnection(), string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    Vector getJoinStrings() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.joinList.getModel().getSize()) {
            vector.addElement(this.joinList.getModel().getElementAt(n));
            ++n;
        }
        return vector;
    }

    void showSelectedJoin() {
        if (this.joinList.getSelectedIndex() == -1) {
            return;
        }
        String string = (String)this.joinList.getSelectedValue();
        ColumnMap columnMap = this.getJoinColumns(string);
        if (this.onlyUseParentSelectedColumns) {
            this.loadParentColumns();
            this.parentColumn.setSelectedItem(columnMap.getParentColumn());
        } else {
            this.parentTable.setSelectedItem(columnMap.getParentColumn().substring(0, columnMap.getParentColumn().lastIndexOf(".")));
            this.loadParentColumns();
            this.parentColumn.setSelectedItem(columnMap.getParentColumn().substring(columnMap.getParentColumn().lastIndexOf(".") + 1));
        }
        this.childTable.setSelectedItem(columnMap.getChildColumn().substring(0, columnMap.getChildColumn().lastIndexOf(".")));
        this.loadChildColumns();
        this.childColumn.setSelectedItem(columnMap.getChildColumn().substring(columnMap.getChildColumn().lastIndexOf(".") + 1));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.equals(this.btnAdd)) {
                this.addJoin();
            } else if (jButton.equals(this.btnModify)) {
                this.modifyJoin();
            } else if (jButton.equals(this.btnDelete)) {
                this.deleteJoin();
            } else if (jButton.equals(this.btnAutoJoin)) {
                this.autoJoin();
            } else if (jButton.equals(this.btnOk)) {
                this.setVisible(false);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource().equals(this.joinList)) {
                this.showSelectedJoin();
            } else if (itemEvent.getSource().equals(this.parentTable)) {
                this.loadParentColumns();
            } else if (itemEvent.getSource().equals(this.childTable)) {
                this.loadChildColumns();
            }
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            int n = this.getParent().getBounds().x + (this.getParent().getBounds().width - this.getBounds().width) / 2;
            int n2 = this.getParent().getBounds().y + (this.getParent().getBounds().height - this.getBounds().height) / 2;
            if (n >= 0 && n2 >= 0) {
                this.setLocation(n, n2);
            }
        }
        super.setVisible(bl);
    }

    private boolean joinExists(String string, String string2) {
        boolean bl = false;
        int n = 0;
        while (n < this.joinList.getModel().getSize()) {
            if (this.joinList.getModel().getElementAt(n).equals(string + equalJoin + string2) || this.joinList.getModel().getElementAt(n).equals(string2 + equalJoin + string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private void addJoin(String string, String string2) {
        if (string.length() == 0 || string2.length() == 0) {
            return;
        }
        if (!this.joinExists(string, string2)) {
            String string3 = string + equalJoin + string2;
            this.listModel.addElement(string3);
            int n = this.listModel.getSize();
            this.parentTable.setEnabled(!this.onlyUseParentSelectedColumns && (this.allowMoreThanTwoTables || n == 0));
            this.childTable.setEnabled(this.allowMoreThanTwoTables || n == 0);
        }
    }

    private void addJoin() {
        String string = (this.onlyUseParentSelectedColumns ? "" : this.parentTable.getSelectedItem() + ".") + this.parentColumn.getSelectedItem();
        String string2 = this.childTable.getSelectedItem() + "." + this.childColumn.getSelectedItem();
        this.addJoin(string, string2);
    }

    private void modifyJoin() {
        String string = (this.onlyUseParentSelectedColumns ? "" : this.parentTable.getSelectedItem() + ".") + this.parentColumn.getSelectedItem();
        String string2 = this.childTable.getSelectedItem() + "." + this.childColumn.getSelectedItem();
        if (string.length() == 0 || string2.length() == 0) {
            return;
        }
        this.deleteJoin();
        this.addJoin(string, string2);
    }

    private void deleteJoin() {
        int n = this.joinList.getSelectedIndex();
        if (n > -1) {
            this.joinList.remove(n);
            int n2 = this.listModel.getSize();
            this.parentTable.setEnabled(!this.onlyUseParentSelectedColumns && (this.allowMoreThanTwoTables || n2 == 0));
            this.childTable.setEnabled(this.allowMoreThanTwoTables || n2 == 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void autoJoin() {
        var1_1 = null;
        try {
            var1_1 = this.parentComp.getConnection() == null ? null : this.parentComp.getConnection().getConnection();
        }
        catch (Exception var2_2) {
            ErrorDialog.showError((Frame)this.getParent(), var2_2 + " " + LocaleBundle.string("Cannot auto join") + " " + LocaleBundle.string("Cannot establish connection for parent"));
            return;
        }
        if (var1_1 == null) {
            return;
        }
        var2_3 = null;
        try {
            var2_3 = this.childComp.getConnection() == null ? null : this.childComp.getConnection().getConnection();
        }
        catch (Exception var3_4) {
            ErrorDialog.showError((Frame)this.getParent(), var3_4 + " " + LocaleBundle.string("Cannot auto join") + " " + LocaleBundle.string("Cannot establish connection"));
            return;
        }
        if (var2_3 == null) {
            return;
        }
        if (!this.childSqlStatement.getTables().hasMoreElements() || !this.parentSqlStatement.getTables().hasMoreElements()) {
            ErrorDialog.showError((Frame)this.getParent(), LocaleBundle.string("Cannot auto join") + " " + LocaleBundle.string("No table exists"));
            return;
        }
        var3_5 = null;
        if (this.allowMoreThanTwoTables) {
            var3_5 = this.parentSqlStatement.getTables();
        } else {
            var4_6 = new Vector<E>();
            var5_7 = this.parentSqlStatement.getTables();
            while (var5_7.hasMoreElements()) {
                var6_8 = (SqlStatementTable)var5_7.nextElement();
                if (var6_8.getAlias() != this.parentTable.getSelectedItem()) continue;
                var4_6.addElement(var6_8);
                break;
            }
            var3_5 = var4_6.elements();
        }
        while (var3_5.hasMoreElements()) {
            var4_6 = (SqlStatementTable)var3_5.nextElement();
            var5_7 = null;
            try {
                var5_7 = new Table(var1_1, var4_6.getQualifiedName());
            }
            catch (Exception var6_9) {
                continue;
            }
            var6_8 = this.getParentSelectedColumns();
            var7_10 = new Vector<String>();
            if (var6_8 != null) {
                var8_12 = 0;
                while (var8_12 < var6_8.size()) {
                    var7_10.addElement(((String)var6_8.elementAt(var8_12)).toLowerCase());
                    ++var8_12;
                }
            }
            var8_11 = var5_7.getFullName();
            var10_13 = null;
            if (this.allowMoreThanTwoTables) {
                var10_13 = this.childSqlStatement.getTables();
            } else {
                var11_14 = new Vector<E>();
                var12_15 = this.childSqlStatement.getTables();
                while (var12_15.hasMoreElements()) {
                    var13_16 = (SqlStatementTable)var12_15.nextElement();
                    if (var13_16.getAlias() != this.childTable.getSelectedItem()) continue;
                    var11_14.addElement(var13_16);
                    break;
                }
                var10_13 = var11_14.elements();
            }
            while (var10_13.hasMoreElements()) {
                var11_14 = (SqlStatementTable)var10_13.nextElement();
                var12_15 = null;
                try {
                    var12_15 = new Table(var2_3, var11_14.getQualifiedName());
                }
                catch (Exception var13_17) {
                    continue;
                }
                var13_16 = var12_15.getFullName();
                var14_18 = var12_15.getForeignKeys().elements();
                while (var14_18.hasMoreElements()) {
                    var15_19 = (ColumnMap)var14_18.nextElement();
                    var16_20 = var15_19.getParentColumn().substring(0, var15_19.getParentColumn().lastIndexOf("."));
                    var17_21 = var15_19.getParentColumn().substring(var15_19.getParentColumn().lastIndexOf(".") + 1);
                    var18_22 = var15_19.getChildColumn().substring(var15_19.getChildColumn().lastIndexOf(".") + 1);
                    var19_23 = var4_6.getAlias() + "." + var17_21;
                    if (!var16_20.equalsIgnoreCase(var8_11)) continue;
                    if (!this.onlyUseParentSelectedColumns) {
                        this.addJoin(var19_23, var11_14.getAlias() + "." + var18_22);
                        continue;
                    }
                    if (var7_10.contains(var19_23.toLowerCase())) {
                        this.addJoin(var19_23, var11_14.getAlias() + "." + var18_22);
                        continue;
                    }
                    if (!var7_10.contains(var17_21.toLowerCase())) continue;
                    this.addJoin(var17_21, var11_14.getAlias() + "." + var18_22);
                }
                var15_19 = var5_7.getForeignKeys().elements();
                if (var15_19.hasMoreElements()) ** GOTO lbl107
                ErrorDialog.showWarning(this, LocaleBundle.string("No foreign keys"));
                return;
lbl-1000:
                // 1 sources

                {
                    var16_20 = (ColumnMap)var15_19.nextElement();
                    var17_21 = var16_20.getParentColumn().substring(0, var16_20.getParentColumn().lastIndexOf("."));
                    var18_22 = var16_20.getParentColumn().substring(var16_20.getParentColumn().lastIndexOf(".") + 1);
                    var19_23 = var16_20.getChildColumn().substring(var16_20.getChildColumn().lastIndexOf(".") + 1);
                    var20_24 = var4_6.getAlias() + "." + var19_23;
                    if (!var17_21.equalsIgnoreCase((String)var13_16)) continue;
                    if (!this.onlyUseParentSelectedColumns) {
                        this.addJoin(var20_24, var11_14.getAlias() + "." + var18_22);
                        continue;
                    }
                    if (var7_10.contains(var20_24.toLowerCase())) {
                        this.addJoin(var20_24, var11_14.getAlias() + "." + var18_22);
                        continue;
                    }
                    if (!var7_10.contains(var19_23.toLowerCase())) continue;
                    this.addJoin(var19_23, var11_14.getAlias() + "." + var18_22);
lbl107:
                    // 6 sources

                    ** while (var15_19.hasMoreElements())
                }
lbl108:
                // 1 sources

            }
        }
    }
}

