/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.customizer;

import com.klg.jclass.beans.EnumEditor;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.beans.JCDataEvent;
import com.klg.jclass.datasource.beans.NodeProperties;
import com.klg.jclass.datasource.customizer.CommitPolicyEditor;
import com.klg.jclass.datasource.customizer.CustomizeEnumEditor;
import com.klg.jclass.datasource.customizer.DataModelPage;
import com.klg.jclass.datasource.customizer.SingleLevelCommitPolicyEditor;
import com.klg.jclass.datasource.util.SqlParser;
import com.klg.jclass.datasource.util.SqlStatementTable;
import com.klg.jclass.util.swing.JCAlignLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DataAccessPage
extends DataModelPage
implements ItemListener,
ActionListener {
    JCheckBox insertAllowed;
    JCheckBox updateAllowed;
    JCheckBox deleteAllowed;
    JCheckBox showDeletedRows;
    JCheckBox cacheChildren;
    JButton btnAdd;
    JButton btnModify;
    JButton btnDelete;
    JList tableAccess;
    DefaultListModel listModel;
    JComboBox table;
    CustomizeEnumEditor commitPolicy;
    EnumEditor commitPolicyEditor;
    boolean useInHierarchy;
    static final String delimiter = ";";

    public DataAccessPage() {
        this(false);
    }

    public DataAccessPage(boolean bl) {
        super(LocaleBundle.string("Data Access"));
        this.useInHierarchy = bl;
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.cacheChildren = new JCheckBox(LocaleBundle.string("Cache Children"), false);
        JLabel jLabel = new JLabel(LocaleBundle.string("Commit Policy"));
        JLabel jLabel2 = new JLabel("");
        JLabel jLabel3 = new JLabel("");
        JLabel jLabel4 = new JLabel("");
        JLabel jLabel5 = new JLabel("");
        this.showDeletedRows = new JCheckBox(LocaleBundle.string("Show Deleted Rows"), true);
        JPanel jPanel2 = new JPanel();
        JLabel jLabel6 = new JLabel(LocaleBundle.string("Table"));
        this.insertAllowed = new JCheckBox(LocaleBundle.string("Insert Allowed"), true);
        this.updateAllowed = new JCheckBox(LocaleBundle.string("Update Allowed"), true);
        this.deleteAllowed = new JCheckBox(LocaleBundle.string("Delete Allowed"), true);
        JPanel jPanel3 = new JPanel();
        this.btnAdd = new JButton(LocaleBundle.string("Add"));
        this.btnModify = new JButton(LocaleBundle.string("Modify"));
        this.btnDelete = new JButton(LocaleBundle.string("Delete"));
        JPanel jPanel4 = new JPanel();
        this.listModel = new DefaultListModel();
        this.tableAccess = new JList(this.listModel);
        JPanel jPanel5 = new JPanel();
        this.table = new JComboBox();
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(new EtchedBorder());
        JPanel jPanel7 = new JPanel();
        jPanel7.setBorder(new TitledBorder(LocaleBundle.string("Table Access")));
        jPanel6.setLayout(new JCAlignLayout());
        jPanel6.add(jLabel);
        this.commitPolicyEditor = this.useInHierarchy ? new CommitPolicyEditor() : new SingleLevelCommitPolicyEditor();
        this.commitPolicy = new CustomizeEnumEditor(this.commitPolicyEditor);
        jPanel6.add(this.commitPolicy);
        this.commitPolicyEditor.setValue(new Integer(1));
        jPanel6.add(jLabel2);
        jPanel6.add(this.showDeletedRows);
        jPanel2.setLayout(new JCAlignLayout());
        jPanel2.add(jLabel6);
        jPanel2.add(this.table);
        jPanel2.add(jLabel3);
        jPanel2.add(this.insertAllowed);
        jPanel2.add(jLabel4);
        jPanel2.add(this.updateAllowed);
        jPanel2.add(jLabel5);
        jPanel2.add(this.deleteAllowed);
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        jPanel3.add((Component)this.btnAdd, gridBagConstraints);
        jPanel3.add((Component)this.btnModify, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 5.0;
        jPanel3.add((Component)this.btnDelete, gridBagConstraints);
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel2, "Center");
        jPanel4.add((Component)jPanel3, "South");
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)new JScrollPane(this.tableAccess), "Center");
        jPanel7.add((Component)jPanel4, "South");
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)jPanel6, "North");
        jPanel5.add((Component)jPanel7, "Center");
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 5.0;
        jPanel.add((Component)this.cacheChildren, gridBagConstraints);
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel5, "Center");
        this.cacheChildren.addItemListener(this);
        this.btnAdd.addActionListener(this);
        this.btnModify.addActionListener(this);
        this.btnDelete.addActionListener(this);
        this.showDeletedRows.addItemListener(this);
        this.commitPolicy.addItemListener(this);
        this.tableAccess.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (DataAccessPage.this.isInitializing()) {
                    return;
                }
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                DataAccessPage.this.showCurrentTableAccess();
            }
        });
    }

    public void setNodeProperties(NodeProperties nodeProperties) {
        this.showTableAccess();
        this.cacheChildren.setSelected(nodeProperties.getCacheChildren());
        this.showDeletedRows.setSelected(nodeProperties.getShowDeletedRows());
        this.commitPolicyEditor.setValue(new Integer(nodeProperties.getCommitPolicy()));
        this.commitPolicy.repaint();
        this.showDeletedRows.setEnabled(nodeProperties.getCommitPolicy() != 1);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.isInitializing()) {
            return;
        }
        NodeProperties nodeProperties = this.getNodeProperties();
        this.showDeletedRows.setEnabled(nodeProperties.getCommitPolicy() != 1);
        if (itemEvent.getSource() instanceof JList) {
            this.showCurrentTableAccess();
        } else {
            nodeProperties.setCacheChildren(this.cacheChildren.isSelected());
            nodeProperties.setShowDeletedRows(this.showDeletedRows.isSelected());
            nodeProperties.setCommitPolicy(((Integer)this.commitPolicyEditor.getValue()).intValue());
            nodeProperties.fireJCDataEvent(new JCDataEvent((Object)nodeProperties));
        }
        if (nodeProperties.getCommitPolicy() == 1) {
            nodeProperties.setShowDeletedRows(true);
            nodeProperties.fireJCDataEvent(new JCDataEvent((Object)nodeProperties));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isInitializing()) {
            return;
        }
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.equals(this.btnAdd)) {
                this.addTableAccess();
            } else if (jButton.equals(this.btnModify)) {
                this.modifyTableAccess();
            } else if (jButton.equals(this.btnDelete)) {
                this.removeTableAccess();
            }
        }
    }

    void addTableAccess() {
        if (this.getNodeProperties().getTableAccess().containsKey(this.table.getSelectedItem())) {
            return;
        }
        this.setTableAccess((String)this.table.getSelectedItem(), this.insertAllowed.isSelected(), this.updateAllowed.isSelected(), this.deleteAllowed.isSelected());
        this.getNodeProperties().fireJCDataEvent(new JCDataEvent((Object)this.getNodeProperties()));
    }

    String getSelectedTable() {
        String string = null;
        string = (String)this.tableAccess.getSelectedValue();
        String string2 = string.substring(0, string.indexOf(delimiter));
        return string2;
    }

    void modifyTableAccess() {
        if (this.tableAccess.getSelectedIndex() == -1) {
            return;
        }
        String string = this.getSelectedTable();
        this.getNodeProperties().removeTableAccess(string);
        this.setTableAccess((String)this.table.getSelectedItem(), this.insertAllowed.isSelected(), this.updateAllowed.isSelected(), this.deleteAllowed.isSelected());
        this.getNodeProperties().fireJCDataEvent(new JCDataEvent((Object)this.getNodeProperties()));
    }

    void removeTableAccess() {
        if (this.tableAccess.getSelectedIndex() == -1) {
            return;
        }
        String string = this.getSelectedTable();
        this.getNodeProperties().removeTableAccess(string);
        this.getNodeProperties().fireJCDataEvent(new JCDataEvent((Object)this.getNodeProperties()));
    }

    void setTableAccess(String string, boolean bl, boolean bl2, boolean bl3) {
        Boolean[] booleanArray = new Boolean[]{new Boolean(bl), new Boolean(bl2), new Boolean(bl3)};
        this.getNodeProperties().setTableAccess(string, booleanArray);
    }

    void showTableAccess() {
        String string;
        Boolean[] booleanArray;
        Object object;
        Object object2;
        this.table.setSelectedItem("");
        this.listModel.removeAllElements();
        this.insertAllowed.setSelected(true);
        this.updateAllowed.setSelected(true);
        this.deleteAllowed.setSelected(true);
        if (this.getNodeProperties().getDataSourceType() == 1) {
            object2 = new Vector();
            if (this.getNodeProperties().getStatement() != null && this.getNodeProperties().getStatement().length() > 0) {
                object = new SqlParser(this.getNodeProperties().getStatement());
                booleanArray = ((SqlParser)object).getTables().elements();
                while (booleanArray.hasMoreElements()) {
                    string = new String(((SqlStatementTable)booleanArray.nextElement()).getAlias());
                    ((Vector)object2).addElement(string);
                }
            }
            this.table.setModel(new DefaultComboBoxModel(object2));
        }
        if (this.getNodeProperties().getTableAccess().keys() == null) {
            return;
        }
        object2 = this.getNodeProperties().getTableAccess().keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            booleanArray = (Boolean[])this.getNodeProperties().getTableAccess().get(object);
            string = booleanArray[0] != false ? LocaleBundle.string("Insert Allowed") : LocaleBundle.string("Insert Not Allowed");
            String string2 = booleanArray[1] != false ? LocaleBundle.string("Update Allowed") : LocaleBundle.string("Update Not Allowed");
            String string3 = booleanArray[2] != false ? LocaleBundle.string("Delete Allowed") : LocaleBundle.string("Delete Not Allowed");
            this.listModel.addElement((String)object + delimiter + string + delimiter + string2 + delimiter + string3);
        }
        if (this.listModel.getSize() > 0) {
            this.tableAccess.setSelectedIndex(0);
            this.showCurrentTableAccess();
        }
    }

    void showCurrentTableAccess() {
        if (this.tableAccess.getSelectedIndex() == -1) {
            return;
        }
        String string = this.getSelectedTable();
        String string2 = (String)this.tableAccess.getSelectedValue();
        String string3 = string2.substring(string2.indexOf(delimiter) + 1);
        String string4 = string3.substring(0, string3.indexOf(delimiter));
        string3 = string3.substring(string3.indexOf(delimiter) + 1);
        String string5 = string3.substring(0, string3.indexOf(delimiter));
        String string6 = string3.substring(string3.indexOf(delimiter) + 1);
        this.table.setSelectedItem(string);
        this.insertAllowed.setSelected(string4.equals(LocaleBundle.string("Insert Allowed")));
        this.updateAllowed.setSelected(string5.equals(LocaleBundle.string("Update Allowed")));
        this.deleteAllowed.setSelected(string6.equals(LocaleBundle.string("Delete Allowed")));
    }
}

