/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource;

import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.datasource.TreeIteratorModel;
import java.util.NoSuchElementException;
import java.util.Vector;

public class TreeIterator
implements TreeIteratorModel {
    static final long serialVersionUID = 5111619483056735618L;
    protected int firstNode;
    protected int currentNode;
    protected Vector children;

    public TreeIterator(DataSourceTreeNode dataSourceTreeNode) {
        DataSourceTreeNode dataSourceTreeNode2 = dataSourceTreeNode == null ? null : (DataSourceTreeNode)dataSourceTreeNode.getParent();
        if (dataSourceTreeNode2 == null) {
            this.children = new Vector();
            this.firstNode = 0;
        } else {
            this.children = dataSourceTreeNode2.getChildren();
            this.firstNode = this.children.indexOf(dataSourceTreeNode);
        }
        this.currentNode = this.firstNode;
    }

    public Object nextElement() {
        Object object = this.get();
        this.advance();
        return object;
    }

    public boolean hasMoreElements() {
        return !this.atEnd();
    }

    public boolean atBegin() {
        return this.currentNode == this.firstNode;
    }

    public Object get() {
        if (!this.atEnd()) {
            return this.children.elementAt(this.currentNode);
        }
        throw new NoSuchElementException("TreeIterator");
    }

    public void advance(int n) {
        if (n >= this.firstNode && n < this.children.size()) {
            this.currentNode = n;
        }
    }

    public Object clone() {
        return null;
    }

    public boolean atEnd() {
        return true;
    }

    public void advance() {
    }
}

