/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.cell.renderers;

import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.JCLightCellRenderer;
import com.klg.jclass.cell.Utilities;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;

public class JCImageCellRenderer
implements JCLightCellRenderer,
ImageObserver {
    protected Utilities utilities = new Utilities();
    protected boolean drawClipArrowOutline = true;

    public void draw(Graphics graphics, JCCellInfo jCCellInfo, Object object, boolean bl) {
        if (object == null || !(object instanceof Image)) {
            return;
        }
        Rectangle rectangle = jCCellInfo.getDrawingArea();
        graphics.setFont(jCCellInfo.getFont());
        graphics.setColor(bl ? jCCellInfo.getSelectedForeground() : jCCellInfo.getForeground());
        Point point = this.getAlignmentOffset(jCCellInfo, object);
        graphics.drawImage((Image)object, point.x, point.y, this);
        Dimension dimension = this.getPreferredSize(graphics, jCCellInfo, object);
        if ((dimension.width > rectangle.width || dimension.height > rectangle.height) && jCCellInfo.getClipHints() != 0) {
            Utilities.drawClipArrows(graphics, jCCellInfo, dimension, 4, this.drawClipArrowOutline);
        }
    }

    public Point getAlignmentOffset(JCCellInfo jCCellInfo, Object object) {
        Point point = new Point(0, 0);
        int n = jCCellInfo.getHorizontalAlignment();
        if (n == 4) {
            point.x += jCCellInfo.getDrawingArea().width - ((Image)object).getWidth(this);
        } else if (n == 0) {
            point.x += (jCCellInfo.getDrawingArea().width - ((Image)object).getWidth(this)) / 2;
        }
        n = jCCellInfo.getVerticalAlignment();
        if (n == 0) {
            point.y += (jCCellInfo.getDrawingArea().height - ((Image)object).getHeight(this)) / 2;
        } else if (n == 3) {
            point.y += jCCellInfo.getDrawingArea().height - ((Image)object).getHeight(this);
        }
        return point;
    }

    public Dimension getPreferredSize(Graphics graphics, JCCellInfo jCCellInfo, Object object) {
        if (object == null || !(object instanceof Image)) {
            return null;
        }
        Image image = (Image)object;
        return new Dimension(image.getWidth(this), image.getHeight(this));
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 2: {
                break;
            }
        }
        return true;
    }
}

