/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.cell.editors;

import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellEditorEvent;
import com.klg.jclass.cell.JCCellEditorListener;
import com.klg.jclass.cell.JCCellEditorSupport;
import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.JCKeyModifier;
import com.klg.jclass.cell.Utilities;
import com.klg.jclass.util.swing.JCIconCreator;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.JComponent;

public class JCImageCellEditor
extends JComponent
implements JCCellEditor,
KeyListener,
MouseListener,
FocusListener {
    protected transient Image data;
    protected transient Image originalData;
    protected JCCellInfo cellInfo;
    protected JCCellEditorSupport support = new JCCellEditorSupport();
    protected boolean isFullSize = true;
    protected boolean modified = false;
    protected boolean inDialog = false;
    protected boolean initialEntry = false;
    protected boolean contextPending = false;
    protected JCKeyModifier[] keys = null;
    protected transient byte[] dataBytes = null;
    transient MediaTracker tracker = null;
    protected static final int BORDER_SIZE = 2;

    public JCImageCellEditor() {
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.tracker = new MediaTracker(this);
    }

    public void addNotify() {
        super.addNotify();
        this.getParent().addMouseListener(this);
    }

    public void removeNotify() {
        this.getParent().removeMouseListener(this);
        super.removeNotify();
    }

    public void initialize(AWTEvent aWTEvent, JCCellInfo jCCellInfo, Object object) {
        this.modified = false;
        this.isFullSize = true;
        this.cellInfo = jCCellInfo;
        this.readData(object);
        this.originalData = this.data;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getPreferredSize(this.getGraphics(), this.cellInfo, this.data);
        if (n3 < dimension.width + 4 || n4 < dimension.height + 4) {
            super.setBounds(n, n2, dimension.width + 4, dimension.height + 4);
        } else {
            super.setBounds(n, n2, n3, n4);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Rectangle rectangle = this.getBounds();
        graphics.setColor(this.cellInfo.isEditable() ? this.cellInfo.getBackground().brighter() : this.cellInfo.getBackground());
        if (this.data == null) {
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        } else if (this.isFullSize) {
            graphics.drawImage(this.data, 2, 2, graphics.getColor(), this);
        } else {
            Rectangle rectangle2 = this.cellInfo.getDrawingArea();
            graphics.drawImage(this.data, (rectangle.width - rectangle2.width) / 2, (rectangle.height - rectangle2.height) / 2, rectangle2.width, rectangle2.height, graphics.getColor(), this);
        }
        Utilities.drawBorder(graphics, 8, 2, 0, 0, rectangle.width, rectangle.height, Color.black, Color.white);
    }

    void readData(Object object) {
        this.data = null;
        if (object != null && !(object instanceof Image)) {
            if (!(object instanceof byte[])) {
                return;
            }
            this.data = JCIconCreator.getIcon((byte[])object).getImage();
        } else {
            this.data = (Image)object;
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Object getCellEditorValue() {
        if (this.isModified()) {
            return this.dataBytes;
        }
        return this.data;
    }

    public Component getComponent() {
        return this;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean stopCellEditing() {
        return true;
    }

    public void cancelCellEditing() {
        this.data = this.originalData;
        this.toggleSize(true);
        this.repaint();
        this.modified = false;
    }

    public Dimension getPreferredSize(Graphics graphics, JCCellInfo jCCellInfo, Object object) {
        if (this.data == null || !this.isFullSize) {
            if (jCCellInfo == null) {
                return new Dimension(0, 0);
            }
            Rectangle rectangle = jCCellInfo.getDrawingArea();
            return new Dimension(rectangle.width, rectangle.height);
        }
        this.waitForImage(this.data);
        return new Dimension(this.data.getWidth(null), this.data.getHeight(null));
    }

    public JCKeyModifier[] getReservedKeys() {
        return this.keys;
    }

    public void addCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.addCellEditorListener(jCCellEditorListener);
    }

    public void removeCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.removeCellEditorListener(jCCellEditorListener);
    }

    boolean waitForImage(Image image) {
        try {
            this.tracker.addImage(image, 0);
            this.tracker.waitForID(0);
        }
        catch (Exception exception) {
            return false;
        }
        return !this.tracker.isErrorAny();
    }

    protected void toggleSize() {
        this.isFullSize = !this.isFullSize;
        this.changeSize();
    }

    protected void toggleSize(boolean bl) {
        this.isFullSize = bl;
        this.changeSize();
    }

    protected void changeSize() {
        Rectangle rectangle = Utilities.getWholeCell(this.cellInfo, this.cellInfo.getDrawingArea());
        Rectangle rectangle2 = this.getBounds();
        this.setBounds(rectangle2.x, rectangle2.y, rectangle.width, rectangle.height);
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.toggleSize();
                this.support.fireStopEditing(new JCCellEditorEvent(keyEvent));
                break;
            }
            case 27: {
                this.toggleSize(false);
                this.support.fireCancelEditing(new JCCellEditorEvent(keyEvent));
                break;
            }
            case 32: {
                this.toggleSize();
                break;
            }
            case 76: 
            case 79: {
                this.loadNewImage();
                break;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!this.inDialog) {
            this.initialEntry = this.isFullSize;
            if (!this.isFullSize) {
                this.toggleSize(true);
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.inDialog) {
            this.toggleSize(false);
        }
    }

    static Frame getFrame(Component component) {
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Frame)) continue;
            return (Frame)component;
        }
        return null;
    }

    protected void loadNewImage() {
        FileDialog fileDialog = new FileDialog(JCImageCellEditor.getFrame(this));
        fileDialog.setMode(0);
        this.inDialog = true;
        fileDialog.show();
        this.requestFocus();
        this.inDialog = false;
        if (fileDialog.getFile() == null) {
            return;
        }
        String string = fileDialog.getDirectory() + fileDialog.getFile();
        this.dataBytes = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            int n = fileInputStream.available();
            if (n > 0) {
                this.dataBytes = new byte[n];
            }
            int n2 = fileInputStream.read(this.dataBytes);
            fileInputStream.close();
            if (n2 != n) {
                this.dataBytes = null;
            }
        }
        catch (Exception exception) {
            this.dataBytes = null;
            System.out.println(exception.toString());
        }
        if (this.dataBytes != null) {
            this.data = Toolkit.getDefaultToolkit().createImage(this.dataBytes);
            this.modified = true;
            this.readData(this.data);
            this.toggleSize(true);
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this) {
            if (mouseEvent.isPopupTrigger()) {
                this.contextPending = true;
            }
        } else {
            this.toggleSize(false);
            this.initialEntry = false;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.handleMouseContext(mouseEvent);
    }

    void handleMouseContext(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this) {
            if (this.contextPending || mouseEvent.isPopupTrigger()) {
                this.loadNewImage();
                this.contextPending = false;
            } else if (this.initialEntry) {
                this.initialEntry = false;
            } else {
                this.toggleSize();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

