/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.cell.editors;

import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellEditorEvent;
import com.klg.jclass.cell.JCCellEditorListener;
import com.klg.jclass.cell.JCCellEditorSupport;
import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.JCKeyModifier;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JCCheckBoxCellEditor
extends JCheckBox
implements JCCellEditor,
KeyListener,
MouseListener,
ChangeListener {
    protected Object data;
    protected JCCellInfo cellInfo;
    protected JCCellEditorSupport support = new JCCellEditorSupport();
    protected JCKeyModifier[] keys = null;
    protected static final int BORDER_SIZE = 2;

    public JCCheckBoxCellEditor() {
        this((String)null);
    }

    public JCCheckBoxCellEditor(String string) {
        super(string);
        this.setBorder(new EtchedBorder());
        this.addChangeListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
    }

    public void initialize(AWTEvent aWTEvent, JCCellInfo jCCellInfo, Object object) {
        this.data = object;
        this.initData();
        this.cellInfo = jCCellInfo;
        this.setBorderPainted(true);
        this.setMargin(jCCellInfo.getMarginInsets());
        this.setEnabled(jCCellInfo.isEditable());
        if (aWTEvent != null) {
            this.toggleValue(aWTEvent);
        }
        this.setBackground(jCCellInfo.getBackground());
        this.setForeground(jCCellInfo.getForeground());
    }

    public Object getCellEditorValue() {
        return new Boolean(this.isSelected());
    }

    public boolean getOriginalValue() {
        if (this.data == null) {
            return false;
        }
        return (Boolean)this.data;
    }

    public Component getComponent() {
        return this;
    }

    public boolean isModified() {
        if (this.data != null && !(this.data instanceof Boolean)) {
            return false;
        }
        boolean bl = (Boolean)this.getCellEditorValue();
        return this.getOriginalValue() != bl;
    }

    public boolean stopCellEditing() {
        return true;
    }

    public void cancelCellEditing() {
        this.initData();
        this.repaint();
    }

    public JCKeyModifier[] getReservedKeys() {
        return this.keys;
    }

    public void addCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.addCellEditorListener(jCCellEditorListener);
    }

    public void removeCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.removeCellEditorListener(jCCellEditorListener);
    }

    protected void initData() {
        if (this.data == null) {
            this.setSelected(false);
            return;
        }
        if (!(this.data instanceof Boolean)) {
            return;
        }
        boolean bl = this.getOriginalValue();
        if (this.isSelected() != bl) {
            this.setSelected(bl);
        }
    }

    protected void toggleValue(AWTEvent aWTEvent) {
        if (this.isEnabled()) {
            this.setSelected(!this.isSelected());
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        SwingUtilities.invokeLater(new EventInvoker(changeEvent));
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.support.fireStopEditing(new JCCellEditorEvent(keyEvent));
                break;
            }
            case 27: {
                this.support.fireCancelEditing(new JCCellEditorEvent(keyEvent));
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private class EventInvoker
    implements Runnable {
        private ChangeEvent e;

        EventInvoker(ChangeEvent changeEvent) {
            this.e = changeEvent;
        }

        public void run() {
            JCCellEditorEvent jCCellEditorEvent = new JCCellEditorEvent(this.e);
            JCCheckBoxCellEditor.this.support.fireStopEditing(jCCellEditorEvent);
        }
    }
}

