/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ChangeModuleID {
    private static final int COMPRESSION_FLAG = -1;
    private static final int COMPRESSION_MODE_GZIP = 1;

    private static MIBModule readModule(File file) throws IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        int n = objectInputStream.readInt();
        MIBModule mIBModule = null;
        if (n == -1) {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(objectInputStream);
            ObjectInputStream objectInputStream2 = new ObjectInputStream(gZIPInputStream);
            n = objectInputStream2.readInt();
            mIBModule = ChangeModuleID.readObjects(objectInputStream2, n);
        } else {
            mIBModule = ChangeModuleID.readObjects(objectInputStream, n);
        }
        try {
            objectInputStream.close();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mIBModule;
    }

    private static MIBModule readObjects(ObjectInputStream objectInputStream, int n) throws ClassNotFoundException, IOException {
        MIBModule mIBModule = (MIBModule)objectInputStream.readObject();
        mIBModule.reinit();
        for (int i = 0; i < n - 1; ++i) {
            MIBObject mIBObject = (MIBObject)objectInputStream.readObject();
            mIBModule.add(mIBObject);
        }
        return mIBModule;
    }

    protected static void saveModule(MIBModule mIBModule, File file, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        if (bl) {
            objectOutputStream.writeInt(-1);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(objectOutputStream);
            ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(gZIPOutputStream);
            ChangeModuleID.writeObjects(mIBModule, objectOutputStream2);
            objectOutputStream2.flush();
            objectOutputStream2.close();
        } else {
            ChangeModuleID.writeObjects(mIBModule, objectOutputStream);
        }
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    private static void writeObjects(MIBModule mIBModule, ObjectOutputStream objectOutputStream) throws IOException {
        int n = mIBModule.size();
        if (mIBModule.objectsByName().get(mIBModule.getName()) == null) {
            ++n;
        }
        objectOutputStream.writeInt(n);
        objectOutputStream.writeObject(mIBModule);
        Enumeration enumeration = mIBModule.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            if (mIBObject instanceof MIBModule) continue;
            try {
                objectOutputStream.writeObject(mIBObject);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: ChangeModuleID [-i <ModuleDir>] [-n <Compiled-MIB-File> <New-Module-ID> [<New-MIB-File>]]");
        }
        if ("-i".equals(stringArray[0])) {
            File[] fileArray = new File(stringArray[1]).listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    MIBModule mIBModule = ChangeModuleID.readModule(fileArray[i]);
                    Integer n = new Integer(-mIBModule.getModuleID().intValue());
                    System.out.println("Converting " + mIBModule.getModuleName() + " from " + mIBModule.getModuleID() + " to " + n);
                    Iterator iterator = mIBModule.objectsIterator();
                    while (iterator.hasNext()) {
                        MIBObject mIBObject = (MIBObject)iterator.next();
                        mIBObject.setModuleID(n);
                        System.out.println(mIBObject.getName() + "=" + mIBObject.getOid() + "|" + mIBObject.getClass() + "#" + n);
                    }
                    mIBModule.setModuleID(n);
                    ChangeModuleID.saveModule(mIBModule, fileArray[i], true);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println("Converted " + fileArray.length + " files.");
        } else if ("-n".equals(stringArray[0])) {
            Integer n = new Integer(stringArray[2]);
            try {
                MIBModule mIBModule = ChangeModuleID.readModule(new File(stringArray[1]));
                Object object = mIBModule.objectsIterator();
                while (object.hasNext()) {
                    MIBObject mIBObject = (MIBObject)object.next();
                    mIBObject.setModuleID(n);
                }
                mIBModule.setModuleID(n);
                object = stringArray.length > 2 ? stringArray[3] : stringArray[1];
                ChangeModuleID.saveModule(mIBModule, new File((String)object), true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

