/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.snmp;

import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OctetString;

public class Principal {
    private UsmUser user;
    private byte[] authoritativeEngineID;

    public Principal(UsmUser user, byte[] engineID) {
        if (user == null || engineID == null) {
            throw new NullPointerException();
        }
        this.user = user;
        this.authoritativeEngineID = engineID;
    }

    public UsmUser getUser() {
        return this.user;
    }

    public void setUser(UsmUser newUser) {
        this.user = newUser;
    }

    public void setAuthoritativeEngineID(byte[] newAuthoritativeEngineID) {
        this.authoritativeEngineID = newAuthoritativeEngineID;
    }

    public byte[] getAuthoritativeEngineID() {
        return this.authoritativeEngineID;
    }

    private boolean compareObjects(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return a.equals(b);
        }
        return false;
    }

    public boolean equals(Object other) {
        try {
            if (other instanceof Principal) {
                Principal p = (Principal)other;
                OctetString aid = new OctetString(p.authoritativeEngineID);
                OctetString bid = new OctetString(this.authoritativeEngineID);
                if (this.authoritativeEngineID.length != p.authoritativeEngineID.length) {
                    return false;
                }
                for (int i = 0; i < this.authoritativeEngineID.length; ++i) {
                    if (this.authoritativeEngineID[i] == p.authoritativeEngineID[i]) continue;
                    return false;
                }
                if (!p.user.getSecurityName().equals(this.user.getSecurityName())) {
                    return false;
                }
                if (p.user.getSecurityModel() != this.user.getSecurityModel()) {
                    return false;
                }
                return this.compareObjects(p.user.getAuthenticationProtocol(), this.user.getAuthenticationProtocol()) && this.compareObjects(p.user.getAuthenticationPassphrase(), this.user.getAuthenticationPassphrase()) && this.compareObjects(p.user.getPrivacyProtocol(), this.user.getPrivacyProtocol()) && this.compareObjects(p.user.getPrivacyPassphrase(), this.user.getPrivacyPassphrase());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public String toString() {
        return this.user.getSecurityName() + "-" + new OctetString(this.authoritativeEngineID).toHexString();
    }
}

