/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.snmp;

import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.NewRowException;
import com.agentpp.snmp.ReportException;
import com.agentpp.snmp.SetActiveFailedException;
import com.agentpp.snmp.SetAuthException;
import com.agentpp.snmp.SetPrivException;
import com.agentpp.snmp.SnmpErrorException;
import com.agentpp.snmp.TimeoutException;
import com.agentpp.snmp.UnderConstructionException;
import com.agentpp.snmp.UserProfile;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class Operations {
    public static final int SUCCESS = 0;
    public static final int ERROR_OFFLINE = 1;
    public static final int ERROR_INTERNAL = -1;
    public static final OID usmNoAuthProtocol = new OID("1.3.6.1.6.3.10.1.1.1");
    public static final OID usmNoPrivProtocol = new OID("1.3.6.1.6.3.10.1.2.1");
    public static final OID usmUserAuthProtocol = new OID("1.3.6.1.6.3.15.1.2.2.1.5");
    public static final OID usmUserPrivProtocol = new OID("1.3.6.1.6.3.15.1.2.2.1.8");
    public static final OID usmSpinLock = new OID("1.3.6.1.6.3.15.1.2.1.0");
    public static final OID usmUserPublic = new OID("1.3.6.1.6.3.15.1.2.2.1.11");
    public static final OID usmUserAuthKeyChange = new OID("1.3.6.1.6.3.15.1.2.2.1.6");
    public static final OID usmUserPrivKeyChange = new OID("1.3.6.1.6.3.15.1.2.2.1.9");
    public static final OID usmUserStatus = new OID("1.3.6.1.6.3.15.1.2.2.1.13");
    public static final OID usmUserCloneFrom = new OID("1.3.6.1.6.3.15.1.2.2.1.4");
    public static final OID usmUserSecurityName = new OID("1.3.6.1.6.3.15.1.2.2.1.3");

    public static boolean setAuthentication(Snmp session, GenTarget target, byte[] engineID, OID protocol, OID index, OctetString newPassword) throws SetAuthException, TimeoutException, ReportException, IOException {
        Target t = target.getTarget();
        if (target == null || engineID == null) {
            throw new SetAuthException("Cannot determine SNMP engine ID");
        }
        if (index == null) {
            index = Operations.getRowIndex(engineID, target.getUser().getUser().getSecurityName());
        }
        if (protocol == null) {
            PDU pdu = target.makePDU();
            pdu.setType(-93);
            VariableBinding vb = new VariableBinding();
            OID authProtocol = new OID(usmUserAuthProtocol.getValue());
            authProtocol.append(index);
            vb.setOid(authProtocol);
            vb.setVariable(usmNoAuthProtocol);
            ResponseEvent responseEvent = session.send(pdu, t);
            PDU response = responseEvent.getResponse();
            Operations.checkForReport(response);
            if (response.getErrorStatus() != 0) {
                throw new SetAuthException("Cannot set authentication protocol to 'no authentication': " + response.getErrorStatusText());
            }
            return true;
        }
        PDU spinPDU = target.makePDU();
        VariableBinding[] vbs = new VariableBinding[]{new VariableBinding(), new VariableBinding()};
        vbs[0].setOid(usmSpinLock);
        OID publicOID = new OID(usmUserPublic.getValue());
        publicOID.append(index);
        vbs[1].setOid(publicOID);
        spinPDU.addAll(vbs);
        spinPDU.setType(-96);
        ResponseEvent responseEvent = session.send(spinPDU, t);
        PDU response = responseEvent.getResponse();
        Operations.checkForReport(response);
        if (response.getErrorStatus() != 0 || response.size() != 2) {
            throw new SetAuthException("Cannot get usmSpinLock value: " + response.getErrorStatusText());
        }
        Variable lockVal = response.get(0).getVariable();
        Variable pubVal = response.get(1).getVariable();
        if (pubVal.getSyntax() != 4 || lockVal.getSyntax() < 0) {
            throw new SetAuthException("Set authentication failed: usmSpinLock.0 or usmUserPublic." + index.toString() + " does not exists.");
        }
        OctetString pub = (OctetString)pubVal;
        byte[] n = new byte[8];
        AuthenticationProtocol authProtocol = SecurityProtocols.getInstance().getAuthenticationProtocol(protocol);
        OctetString oldPassword = target.getUser().getUser().getAuthenticationPassphrase();
        OctetString deltaKey = Operations.computeDeltaKey(engineID, target.getEngineID().getValue(), authProtocol, oldPassword, newPassword, pub, n, authProtocol.getDigestLength());
        PDU pdu = target.makePDU();
        vbs = new VariableBinding[3];
        for (int i = 0; i < 3; ++i) {
            vbs[i] = new VariableBinding();
        }
        vbs[0].setOid(usmSpinLock);
        vbs[0].setVariable(lockVal);
        OID keyChange = new OID(usmUserAuthKeyChange.getValue());
        keyChange.append(index);
        vbs[1].setOid(keyChange);
        vbs[1].setVariable(deltaKey);
        vbs[2].setOid(publicOID);
        vbs[2].setVariable(new OctetString(n));
        pdu.addAll(vbs);
        pdu.setType(-93);
        responseEvent = session.send(pdu, t);
        response = responseEvent.getResponse();
        if (response == null) {
            pdu = target.makePDU();
            vbs[2].setVariable(new Null());
            pdu.add(vbs[2]);
            pdu.setType(-96);
            responseEvent = session.send(pdu, t);
            response = responseEvent.getResponse();
            if (response == null) {
                throw new SetAuthException("Timeout on getting usmPublic." + index.toString() + " after failed key change!");
            }
            if (response.getErrorStatus() != 0) {
                throw new SetAuthException("Cannot get usmPublic." + index.toString() + " after failed key change: " + response.getErrorStatusText());
            }
            OctetString cp = (OctetString)response.get(0).getVariable();
            if (!n.equals(cp.getValue())) {
                throw new SetAuthException("Key change failed, may be due to a simultaneous key update by another manager!");
            }
        } else {
            if (response.getErrorStatus() == 12) {
                return false;
            }
            if (response.getErrorStatus() != 0) {
                throw new SetAuthException("Setting new authentication password failed: " + response.getErrorStatusText());
            }
        }
        return true;
    }

    private static OctetString computeDeltaKey(byte[] engineID, byte[] targetEngineID, AuthenticationProtocol authProtocol, OctetString oldPassword, OctetString newPassword, OctetString pub, byte[] pubKey, int keyLength) {
        byte[] rand = new byte[keyLength];
        Random r = new Random();
        r.nextBytes(rand);
        byte[] newKey = authProtocol.passwordToKey(newPassword, engineID);
        byte[] oldKey = authProtocol.passwordToKey(oldPassword, targetEngineID);
        if (newKey.length > keyLength) {
            newKey = Operations.truncateKey(keyLength, newKey);
        }
        if (oldKey.length > keyLength) {
            oldKey = Operations.truncateKey(keyLength, oldKey);
        }
        byte[] delta = authProtocol.changeDelta(oldKey, newKey, rand);
        Random rn = new Random();
        do {
            rn.nextBytes(pubKey);
        } while (Arrays.equals(pubKey, pub.getValue()));
        return new OctetString(delta);
    }

    private static OctetString computeDeltaKey(byte[] engineID, byte[] targetEngineID, AuthenticationProtocol authProtocol, PrivacyProtocol privProtocol, OctetString oldPassword, OctetString newPassword, OctetString pub, byte[] pubKey, int maxKeyLength) {
        byte[] rand = new byte[maxKeyLength];
        Random r = new Random();
        r.nextBytes(rand);
        byte[] newKey = SecurityProtocols.getInstance().passwordToKey(privProtocol.getID(), authProtocol.getID(), newPassword, engineID);
        byte[] oldKey = SecurityProtocols.getInstance().passwordToKey(privProtocol.getID(), authProtocol.getID(), oldPassword, targetEngineID);
        if (newKey.length > maxKeyLength) {
            newKey = Operations.truncateKey(maxKeyLength, newKey);
        }
        if (oldKey.length > maxKeyLength) {
            oldKey = Operations.truncateKey(maxKeyLength, oldKey);
        }
        byte[] delta = authProtocol.changeDelta(oldKey, newKey, rand);
        Random rn = new Random();
        do {
            rn.nextBytes(pubKey);
        } while (Arrays.equals(pubKey, pub.getValue()));
        return new OctetString(delta);
    }

    private static byte[] truncateKey(int keyLength, byte[] newKey) {
        byte[] truncatedNewKey = new byte[keyLength];
        System.arraycopy(newKey, 0, truncatedNewKey, 0, keyLength);
        newKey = truncatedNewKey;
        return newKey;
    }

    public static boolean setPrivacy(Snmp session, GenTarget target, byte[] engineID, OID authProtocol, OID privProtocol, OID index, OctetString newPassword) throws SetPrivException, IOException {
        Target t = target.getTarget(session);
        if (target == null || engineID == null) {
            throw new SetPrivException("Cannot determine SNMP engine ID");
        }
        if (index == null) {
            index = Operations.getRowIndex(engineID, target.getUser().getUser().getSecurityName());
        }
        if (privProtocol == null) {
            PDU pdu = target.makePDU();
            pdu.setType(-93);
            VariableBinding vb = new VariableBinding();
            OID privOID = new OID(usmUserPrivProtocol.getValue());
            privOID.append(index);
            vb.setOid(privOID);
            vb.setVariable(usmNoPrivProtocol);
            ResponseEvent responseEvent = session.send(pdu, t);
            PDU response = responseEvent.getResponse();
            if (response.getErrorStatus() != 0) {
                throw new SetPrivException("Cannot set privacy protocol to 'no privacy': " + response.getErrorStatusText());
            }
            return true;
        }
        PDU spinPDU = target.makePDU();
        VariableBinding[] vbs = new VariableBinding[2];
        vbs[0] = new VariableBinding();
        vbs[0].setOid(usmSpinLock);
        OID publicOID = new OID(usmUserPublic.getValue());
        publicOID.append(index);
        vbs[1] = new VariableBinding();
        vbs[1].setOid(publicOID);
        spinPDU.addAll(vbs);
        spinPDU.setType(-96);
        ResponseEvent responseEvent = session.send(spinPDU, t);
        PDU response = responseEvent.getResponse();
        if (response.getErrorStatus() != 0 || response.size() != 2) {
            if (response.getType() == -88) {
                throw new SetPrivException("Cannot get usmSpinLock value - received REPORT PDU instead: " + response);
            }
            throw new SetPrivException("Cannot get usmSpinLock value: " + response.getErrorStatusText());
        }
        Variable lockVal = response.get(0).getVariable();
        Variable pubVal = response.get(1).getVariable();
        if (pubVal.getSyntax() != 4 || lockVal.getSyntax() < 0) {
            throw new SetPrivException("Set privacy failed: usmSpinLock.0 or usmUserPublic." + index.toString() + " does not exists.");
        }
        OctetString pub = (OctetString)pubVal;
        byte[] n = new byte[8];
        AuthenticationProtocol a = SecurityProtocols.getInstance().getAuthenticationProtocol(authProtocol);
        PrivacyProtocol p = SecurityProtocols.getInstance().getPrivacyProtocol(privProtocol);
        OctetString oldPassword = target.getUser().getUser().getPrivacyPassphrase();
        OctetString deltaKey = Operations.computeDeltaKey(engineID, target.getEngineID().getValue(), a, p, oldPassword, newPassword, pub, n, p.getMaxKeyLength());
        PDU pdu = target.makePDU();
        vbs = new VariableBinding[3];
        vbs[0] = new VariableBinding();
        vbs[0].setOid(usmSpinLock);
        vbs[0].setVariable(lockVal);
        OID keyChange = new OID(usmUserPrivKeyChange.getValue());
        keyChange.append(index);
        vbs[1] = new VariableBinding();
        vbs[1].setOid(keyChange);
        vbs[1].setVariable(deltaKey);
        vbs[2] = new VariableBinding();
        vbs[2].setOid(publicOID);
        vbs[2].setVariable(new OctetString(n));
        pdu.addAll(vbs);
        pdu.setType(-93);
        responseEvent = session.send(pdu, t);
        response = responseEvent.getResponse();
        if (response == null) {
            pdu = target.makePDU();
            vbs[2].setVariable(new Null());
            pdu.add(vbs[2]);
            pdu.setType(-96);
            responseEvent = session.send(pdu, t);
            response = responseEvent.getResponse();
            if (response == null) {
                throw new SetPrivException("Timeout on getting usmPublic." + index.toString() + " after failed privacy key change");
            }
            if (response.getErrorStatus() != 0) {
                throw new SetPrivException("Cannot get usmPublic." + index.toString() + " after failed privacy key change: " + response.getErrorStatusText());
            }
            OctetString cp = (OctetString)response.get(0).getVariable();
            if (!n.equals(cp.getValue())) {
                throw new SetPrivException("Privacy key change failed. May be due to a simultaneous key update by another manager!");
            }
        } else {
            if (response.getErrorStatus() == 12) {
                return false;
            }
            if (response.getErrorStatus() != 0) {
                throw new SetPrivException("Setting new privacy password failed: " + response.getErrorStatusText());
            }
        }
        return true;
    }

    public static void modifyUser(Snmp session, GenTarget target, UserProfile newUser, byte[] engineID, boolean userIsActive) throws SetAuthException, SetPrivException, ReportException, TimeoutException, IOException {
        OID index = Operations.getRowIndex(engineID, newUser.getUser().getSecurityName());
        boolean ok = false;
        Random r = new Random();
        int retriesLeft = 10;
        OID[] autPrivProtocols = new OID[2];
        try {
            autPrivProtocols = Operations.getAuthPrivProtocols(session, target, engineID, newUser);
        }
        catch (SnmpErrorException ex) {
            throw new SetAuthException("Failed to retrieve current authentication and privacy protocol with SNMP error: " + ex.getMessage());
        }
        if (autPrivProtocols[0] != null && !autPrivProtocols[0].equals(newUser.getUser().getAuthenticationProtocol()) || usmNoAuthProtocol.equals(autPrivProtocols[0]) && newUser.getUser().getAuthenticationProtocol() != null && !usmNoAuthProtocol.equals(newUser.getUser().getAuthenticationProtocol())) {
            throw new SetAuthException("Authentication protocol does not match with existing user's protocol");
        }
        if (autPrivProtocols[1] != null && !autPrivProtocols[1].equals(newUser.getUser().getPrivacyProtocol()) || usmNoPrivProtocol.equals(autPrivProtocols[1]) && newUser.getUser().getPrivacyProtocol() != null && !usmNoPrivProtocol.equals(newUser.getUser().getPrivacyProtocol())) {
            throw new SetPrivException("Privacy protocol does not match with existing user's protocol");
        }
        while (!ok && retriesLeft > 0) {
            --retriesLeft;
            ok = Operations.setAuthentication(session, target, engineID, newUser.getUser().getAuthenticationProtocol(), index, newUser.getUser().getAuthenticationPassphrase());
            if (ok) continue;
            try {
                Thread.sleep(r.nextInt(1000));
            }
            catch (InterruptedException iex) {}
        }
        if (!ok && retriesLeft <= 0) {
            throw new SetAuthException("Failed to set authentication after 10 tries");
        }
        if (ok) {
            UsmUser oldUser = target.getUser().getUser();
            target = new GenTarget(target);
            if (userIsActive) {
                session.getUSM().addUser(oldUser.getSecurityName(), new OctetString(engineID), new UsmUser(oldUser.getSecurityName(), newUser.getUser().getAuthenticationProtocol(), newUser.getUser().getAuthenticationPassphrase(), oldUser.getPrivacyProtocol(), oldUser.getPrivacyPassphrase()));
            }
        }
        ok = false;
        retriesLeft = 10;
        while (!ok && retriesLeft > 0) {
            ok = Operations.setPrivacy(session, target, engineID, newUser.getUser().getAuthenticationProtocol(), newUser.getUser().getPrivacyProtocol(), index, newUser.getUser().getPrivacyPassphrase());
            if (ok) continue;
            try {
                Thread.sleep(r.nextInt(1000));
            }
            catch (InterruptedException iex) {}
        }
        if (!ok && retriesLeft <= 0) {
            throw new SetAuthException("Failed to set privacy after 10 tries");
        }
    }

    public static void addNewUser(Snmp session, GenTarget target, byte[] engineID, UserProfile newUser, boolean useCreateAndGo) throws SetAuthException, SetPrivException, TimeoutException, UnderConstructionException, NewRowException, SetActiveFailedException, ReportException, IOException {
        Operations.addNewUser(session, target, engineID, newUser, useCreateAndGo, true);
    }

    public static void addNewUser(Snmp session, GenTarget target, byte[] engineID, UserProfile newUser, boolean useCreateAndGo, boolean modifyUser) throws SetAuthException, SetPrivException, TimeoutException, UnderConstructionException, NewRowException, SetActiveFailedException, ReportException, IOException {
        Target t = target.getTarget(session);
        OID index = Operations.getRowIndex(engineID, newUser.getUser().getSecurityName());
        PDU pdu = target.makePDU();
        VariableBinding vb = new VariableBinding();
        OID userStatus = new OID(usmUserStatus.getValue());
        userStatus.append(index);
        vb.setOid(userStatus);
        pdu.add(vb);
        pdu.setType(-96);
        ResponseEvent responseEvent = session.send(pdu, t);
        PDU response = responseEvent.getResponse();
        if (response == null) {
            throw new TimeoutException("Timeout on getting user status: " + vb.getOid());
        }
        Operations.checkForReport(response);
        if (response.getErrorStatus() == 0 && !response.get(0).isException()) {
            if (modifyUser) {
                int s = ((Integer32)response.get(0).getVariable()).getValue();
                if (s != 1) {
                    throw new UnderConstructionException("User is under construction");
                }
                Operations.modifyUser(session, target, newUser, engineID, true);
                return;
            }
            throw new UnderConstructionException("User exists");
        }
        pdu = target.makePDU();
        VariableBinding[] vbs = new VariableBinding[]{new VariableBinding(), new VariableBinding()};
        OID cloneFrom = new OID(usmUserCloneFrom.getValue());
        cloneFrom.append(index);
        vbs[1].setOid(cloneFrom);
        OID template = Operations.getRowIndex(target.getEngineID().getValue(), target.getUser().getUser().getSecurityName());
        OID templateOID = new OID(usmUserSecurityName.getValue());
        templateOID.append(template);
        vbs[1].setVariable(templateOID);
        vbs[0].setOid(userStatus);
        if (useCreateAndGo) {
            vbs[0].setVariable(new Integer32(4));
        } else {
            vbs[0].setVariable(new Integer32(5));
        }
        pdu.addAll(vbs);
        pdu.setType(-93);
        responseEvent = session.send(pdu, t);
        response = responseEvent.getResponse();
        if (response == null) {
            throw new TimeoutException("Timeout on creating new user");
        }
        if (response.getErrorStatus() != 0) {
            throw new NewRowException("Creating new row failed with error status " + response.getErrorStatusText());
        }
        if (!useCreateAndGo) {
            vb.setOid(userStatus);
            vb.setVariable(new Integer32(1));
            pdu = target.makePDU();
            pdu.add(vb);
            pdu.setType(-93);
            responseEvent = session.send(pdu, t);
            response = responseEvent.getResponse();
            if (response == null) {
                throw new TimeoutException("Timeout on activating new user");
            }
            if (response.getErrorStatus() != 0) {
                throw new SetActiveFailedException("Activating new row failed: " + response.getErrorStatusText());
            }
        }
        if (modifyUser) {
            Operations.modifyUser(session, target, newUser, engineID, false);
        }
    }

    public static OID[] getAuthPrivProtocols(Snmp session, GenTarget target, byte[] engineID, UserProfile user) throws IOException, TimeoutException, ReportException, SnmpErrorException {
        OID index = Operations.getRowIndex(engineID, user.getUser().getSecurityName());
        Target t = target.getTarget();
        PDU pdu = target.makePDU();
        VariableBinding[] vb = new VariableBinding[2];
        OID authProtocol = new OID(usmUserAuthProtocol.getValue());
        authProtocol.append(index);
        vb[0] = new VariableBinding(authProtocol);
        OID privProtocol = new OID(usmUserPrivProtocol.getValue());
        privProtocol.append(index);
        vb[1] = new VariableBinding(privProtocol);
        pdu.addAll(vb);
        ResponseEvent responseEvent = session.get(pdu, t);
        PDU response = responseEvent.getResponse();
        Operations.checkForReport(response);
        if (response.getErrorStatus() != 0) {
            throw new SnmpErrorException(response.getErrorStatus(), response.getErrorStatusText());
        }
        return new OID[]{(OID)pdu.get(0).getVariable(), (OID)pdu.get(1).getVariable()};
    }

    public static OID getRowIndex(byte[] engineID, OctetString userName) {
        int i;
        OID index = new OID();
        index.append(engineID.length);
        for (i = 0; i < engineID.length; ++i) {
            index.append(engineID[i] & 0xFF);
        }
        index.append(userName.length());
        for (i = 0; i < userName.length(); ++i) {
            index.append(userName.get(i) & 0xFF);
        }
        return index;
    }

    public static void checkForReport(PDU response) throws ReportException, TimeoutException {
        if (response == null) {
            throw new TimeoutException("Timeout occurred.");
        }
        if (response.getType() == -88) {
            String s = "";
            if (response.size() > 0) {
                String os = response.get(0).getOid().toString();
                s = os + " = " + ((Object)response.get(0).getVariable()).toString();
            }
            throw new ReportException("SNMPv3 report: " + s);
        }
    }
}

