/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.snmp;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.snmp.ValueConverter;
import java.util.Vector;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;

public class IndexConverter {
    public static Variable getIndexVariable(IndexStruct index, ObjectID indexValue) {
        try {
            switch (index.baseType) {
                case 1: {
                    if (index.impliedLength || index.minLength == index.maxLength) {
                        OctetString s = new OctetString(indexValue.asByteArray());
                        return s;
                    }
                    ObjectID suffix = indexValue.getSuffix(indexValue.size() - 1);
                    return new OctetString(suffix.asByteArray());
                }
                case 0: {
                    return new Integer32((int)indexValue.getLastSubID() & 0xFFFFFFFF);
                }
                case 9: {
                    return new TimeTicks(indexValue.getLastSubID());
                }
                case 5: {
                    return new IpAddress(indexValue.toString());
                }
                case 12: {
                    String id = indexValue.toString();
                    return new IpAddress(id.substring(id.indexOf(".") + 1));
                }
            }
            if (index.impliedLength || index.minLength == index.maxLength) {
                return new OID(indexValue.toString());
            }
            return new OID(indexValue.getSuffix(indexValue.size() - 1).toString());
        }
        catch (Exception e) {
            return new OID(indexValue.toString());
        }
    }

    public static Variable[] getIndexVariables(IndexStruct[] indexes, ObjectID[] indexValues) {
        int sz = Math.min(indexes.length, indexValues.length);
        Variable[] o = new Variable[sz];
        for (int i = 0; i < sz; ++i) {
            o[i] = IndexConverter.getIndexVariable(indexes[i], indexValues[i]);
        }
        return o;
    }

    public static String getIndexString(ValueConverter converter, IndexStruct index, ObjectID indexValue) {
        Object o = converter.toNative(IndexConverter.getIndexVariable(index, indexValue), true);
        if (o == null) {
            return "?";
        }
        return o.toString();
    }

    public static String getIndexString(ValueConverter[] converter, IndexStruct[] indexes, ObjectID[] indexValues) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < indexes.length && i < indexValues.length && i < converter.length; ++i) {
            buf.append(IndexConverter.getIndexString(converter[i], indexes[i], indexValues[i]));
            if (i + 1 >= indexes.length || i + 1 >= indexValues.length || i + 1 >= converter.length) continue;
            buf.append(".");
        }
        return buf.toString();
    }

    public static ValueConverter[] getIndexValueConverter(MIBRepository rep, MIBObjectType table) {
        if (!table.isTable()) {
            return null;
        }
        Vector v = rep.getColumnarObjectsOfTable(table, true, false);
        ValueConverter[] vc = new ValueConverter[v.size()];
        for (int i = 0; i < vc.length; ++i) {
            MIBObjectType ot = (MIBObjectType)v.elementAt(i);
            MIBTextualConvention tc = rep.getEffectiveSyntax(ot.getSyntax());
            vc[i] = new ValueConverter(ot, tc.getSyntax(), tc.getDisplayHint());
        }
        return vc;
    }
}

